/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.fcp.ERDEditorListener;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.model.ErrorDescriptor;
import oracle.dbtools.crest.model.IndexAndConstraintNameController;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.ImageObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.MeasurementSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKArcSet;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesignEstimates;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignFactory;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.design.undo.relational.ColumnRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKArcRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.FKRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.IndexRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableRemoveEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableViewCreateEdit;
import oracle.dbtools.crest.model.design.undo.relational.TableViewRemoveEdit;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ShowParentAndChildListener;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.RelationalModelDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.ide.Ide;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.wc.SVNStatus;

public class RelationalDesign
extends DesignPart
implements SetListener,
ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "RelationalModel";
    public static final String TABLE_SET_NAME = Messages.getString("RelationalDesign.Tables");
    public static final String SCHEMA_SET_NAME = Messages.getString("RelationalDesign.Schemas");
    public static final String FK_SET_NAME = Messages.getString("RelationalDesign.ForeignKeys");
    public static final String TYPE_SUBSTITUTION_NAME = Messages.getString("RelationalDesign.TypeSubstitutions");
    public static final String INDEX_SET_NAME = Messages.getString("RelationalDesign.Indexes");
    public static final String COLUMN_SET_NAME = Messages.getString("RelationalDesign.Columns");
    public static final String COLUMN_VIEW_SET_NAME = Messages.getString("RelationalDesign.ColumnViews");
    public static final String VIEW_SET_NAME = Messages.getString("RelationalDesign.Views");
    public static final String NOTE_SET_NAME = Messages.getString("RelationalDesign.Notes");
    public static final String IMAGE_SET_NAME = Messages.getString("RelationalDesign.Images");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("RelationalDesign.Measurement");
    public static final String ARC_SET_NAME = Messages.getString("RelationalDesign.Arcs");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    public static final String TEMPLATE_COL_PROP = "ctemplateID";
    private TableSet tableSet;
    private ColumnSet columnSet;
    private ColumnViewSet columnViewSet;
    private TableViewSet viewSet;
    private FKIndexAssociationSet fkAssociationSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private DesignObjectCollection indexOnlySet;
    private StorageDesignFactory storageDesignFactory = null;
    private String rdbms = "db2v7.0";
    private RDBMSSite selectedRDBMSSite = null;
    private NoteSet noteSet;
    private ImageObjectSet imageSet;
    private MeasurementSet measurementSet;
    private FKArcSet arcSet;
    private SchemaObjectSet schemaObjectSet;
    private RelationalDesign importTo = null;
    private List<DBConnectionStamp> importConnectionStamps = new ArrayList<DBConnectionStamp>();
    private int importConnectionStampIndex = -1;
    private List<DDLFileStamp> importDDLFileStamps = new ArrayList<DDLFileStamp>();
    private int importDDLFileStampIndex = -1;
    private DBConnectionStamp redirectConnectionStamp = null;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private List namingOptionsHolderList;
    private boolean subviewToNewDesign = false;
    private RMExtendedMap extendedMap;
    private RMDeletedMap deletedMap;
    private RelationalDesign relatedSyncModel;
    private boolean useTemplateTable = false;
    private Table templateTable;
    private String templateTableID;
    private IndexAndConstraintNameController indexAndConstraintNameController;
    private NameSpaceController tablesAndViewsNameController;
    private Set erdEditorListeners = new HashSet();
    private Map pluralsMap = null;
    private boolean useConnectionUser = false;
    private RelationalDesignEstimates relationalDesignEstimates = new RelationalDesignEstimates();

    public boolean isSubviewToNewDesign() {
        return this.subviewToNewDesign;
    }

    public void setSubviewToNewDesign(boolean subviewToNewDesign) {
        this.subviewToNewDesign = subviewToNewDesign;
    }

    public RelationalDesign(Design design) {
        this.setDesign(design);
        this.getStorageDesignFactory().getSorageDesigns().setParent(this);
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        return this.getConfiguration("namePhysDesign");
    }

    public TableSet getTableSet() {
        if (this.tableSet == null) {
            this.tableSet = new TableSet(this);
            this.tableSet.setDesign(this.getDesign());
            this.tableSet.setName(TABLE_SET_NAME);
            this.tableSet.addSetListener(this);
            this.tableSet.setParent(this);
        }
        return this.tableSet;
    }

    public SchemaObjectSet getSchemaObjectSet() {
        if (this.schemaObjectSet == null) {
            this.schemaObjectSet = new SchemaObjectSet(this);
            this.schemaObjectSet.setDesign(this.getDesign());
            this.schemaObjectSet.setName(SCHEMA_SET_NAME);
            this.schemaObjectSet.addSetListener(this);
            this.schemaObjectSet.setParent(this);
        }
        return this.schemaObjectSet;
    }

    public FKIndexAssociationSet getFKIndexAssociationSet() {
        if (this.fkAssociationSet == null) {
            this.fkAssociationSet = new FKIndexAssociationSet(this);
            this.fkAssociationSet.setDesign(this.getDesign());
            this.fkAssociationSet.setName(FK_SET_NAME);
            this.fkAssociationSet.setParent(this);
            this.fkAssociationSet.addSetListener(this);
        }
        return this.fkAssociationSet;
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new RelTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(TYPE_SUBSTITUTION_NAME);
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String id) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(id);
    }

    public GlobalIndexSet getGlobalIndexSet() {
        return this.getTableSet().getGlobalIndexSet();
    }

    public DesignObjectCollection getIndexOnlyPlaceHolderSet() {
        if (this.indexOnlySet == null) {
            this.indexOnlySet = new DesignObjectCollection();
            this.indexOnlySet.setDesign(this.getDesign());
            this.indexOnlySet.setName(INDEX_SET_NAME);
            this.indexOnlySet.setElementDescriptor(IndexSet.class);
            this.indexOnlySet.setParent(this);
        }
        return this.indexOnlySet;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet(this);
            this.columnSet.setDesign(this.getDesign());
            this.columnSet.setName(COLUMN_SET_NAME);
            this.columnSet.setParent(this);
            this.columnSet.addSetListener(this);
        }
        return this.columnSet;
    }

    public ColumnViewSet getColumnViewSet() {
        if (this.columnViewSet == null) {
            this.columnViewSet = new ColumnViewSet(this);
            this.columnViewSet.setDesign(this.getDesign());
            this.columnViewSet.setName(COLUMN_VIEW_SET_NAME);
            this.columnViewSet.setParent(this);
            this.columnViewSet.addSetListener(this);
        }
        return this.columnViewSet;
    }

    public TableViewSet getTableViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new TableViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event == SetEvent.OBJECT_ADDED) {
            this.fireAdded(event.getAffected());
        } else if (event == SetEvent.OBJECT_REMOVED) {
            this.fireRemoved(event.getAffected());
        }
    }

    @Override
    public ImageObjectSet getImageObjectSet() {
        if (this.imageSet == null) {
            this.imageSet = new ImageObjectSet(this);
            this.imageSet.setDesign(this.getDesign());
            this.imageSet.setName(IMAGE_SET_NAME);
            this.imageSet.setParent(this);
            this.imageSet.addSetListener(this);
        }
        return this.imageSet;
    }

    @Override
    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public MeasurementSet getMeasurementSet() {
        if (this.measurementSet == null) {
            this.measurementSet = new MeasurementSet(this);
            this.measurementSet.setDesign(this.getDesign());
            this.measurementSet.setName(MEASUREMENT_SET_NAME);
            this.measurementSet.setParent(this);
            this.measurementSet.addSetListener(this);
        }
        return this.measurementSet;
    }

    public FKArcSet getArcSet() {
        if (this.arcSet == null) {
            this.arcSet = new FKArcSet(this);
            this.arcSet.setDesign(this.getDesign());
            this.arcSet.setName(ARC_SET_NAME);
            this.arcSet.setParent(this);
            this.arcSet.addSetListener(this);
        }
        return this.arcSet;
    }

    public DesignObjectCollection getPlainIndexes() {
        DesignObjectCollection l = new DesignObjectCollection();
        for (Index idx : this.getTableSet().getGlobalIndexSet()) {
            if (idx.isFK() || idx.isUnique() || idx.isPK()) continue;
            l.add(idx);
        }
        return l;
    }

    public DesignObjectCollection getUKIndexes() {
        DesignObjectCollection l = new DesignObjectCollection();
        for (Index idx : this.getTableSet().getGlobalIndexSet()) {
            if (idx.isFK() || idx.isPK() || !idx.isUnique()) continue;
            l.add(idx);
        }
        return l;
    }

    public DesignObjectCollection getPKIndexes() {
        DesignObjectCollection l = new DesignObjectCollection();
        for (Index idx : this.getTableSet().getGlobalIndexSet()) {
            if (idx.isFK() || !idx.isPK() || idx.isUnique()) continue;
            l.add(idx);
        }
        return l;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.getType() == 1) {
            if (event.getAffected() instanceof DesignObject) {
                DesignObject object = (DesignObject)event.getAffected();
                this.fireAdded(object);
            }
        } else if (event.getType() == 0 && event.getAffected() instanceof DesignObject) {
            DesignObject object = (DesignObject)event.getAffected();
            this.fireRemoved(object);
        }
    }

    public Table createTable() {
        return this.getTableSet().createTable(null);
    }

    public Table createTable(String name) {
        Table table = this.createTable();
        table.setName(name);
        return table;
    }

    public FKIndexAssociation createForeignKey() {
        FKIndexAssociation fk = new FKIndexAssociation(this);
        return fk;
    }

    public TableView createTableView() {
        return this.getTableViewSet().createTableView(null);
    }

    public TableView createTableView(String name) {
        TableView tableView = this.createTableView();
        tableView.setName(name);
        return tableView;
    }

    public SchemaObject createSchemaObject() {
        return this.getSchemaObjectSet().createSchemaObject(null);
    }

    public SchemaObject createSchemaObject(String name) {
        SchemaObject schemaObject = this.createSchemaObject();
        schemaObject.setName(name);
        return schemaObject;
    }

    public Table recreateTable(String id) {
        return this.getTableSet().createTable(id);
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    @Override
    public Note recreateNote(String id) {
        return this.getNoteSet().createNote(id);
    }

    @Override
    public ImageObject createImage() {
        ImageObject image = this.getImageObjectSet().createImage(null);
        return image;
    }

    @Override
    public ImageObject recreateImage(String id) {
        return this.getImageObjectSet().createImage(id);
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getSchemaObjectSet().addAllElementsTo(collection);
        this.getTableSet().addAllElementsTo(collection);
        this.getTableViewSet().addAllElementsTo(collection);
        this.getFKIndexAssociationSet().addAllElementsTo(collection);
        this.getArcSet().addAllElementsTo(collection);
        this.getNoteSet().addAllElementsTo(collection);
        this.getImageObjectSet().addAllElementsTo(collection);
        this.getLabelSet().addAllElementsTo(collection);
        this.getDiagramViewSet().addAllElementsTo(collection);
        return collection;
    }

    public List getAllImportedObjects() {
        ArrayList list = new ArrayList();
        list.addAll(this.getImportedObjects(this.getSchemaObjectSet()));
        list.addAll(this.getImportedObjects(this.getTableSet()));
        list.addAll(this.getImportedObjects(this.getTableViewSet()));
        list.addAll(this.getImportedObjects(this.getFKIndexAssociationSet()));
        list.addAll(this.getImportedObjects(this.getArcSet()));
        list.addAll(this.getImportedObjects(this.getColumnSet()));
        list.addAll(this.getImportedObjects(this.getColumnViewSet()));
        list.addAll(this.getImportedObjects(this.getTypeSubstitutionSet()));
        list.addAll(this.getImportedObjects(this.getMeasurementSet()));
        list.addAll(this.getImportedObjects(this.getGlobalIndexSet()));
        return list;
    }

    private List getImportedObjects(DesignObjectSet set) {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        for (int i = 0; i < set.size(); ++i) {
            ModelObject obj = set.getElement(i);
            if (obj.getSourceConnName().equals("")) continue;
            list.add(obj);
        }
        return list;
    }

    private List getImportedObjects(ModelObjectSet set) {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        for (int i = 0; i < set.size(); ++i) {
            ModelObject obj = set.getElement(i);
            if (obj.getSourceConnName().equals("")) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public void clearAll() {
        StorageDesign[] sds = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < sds.length; ++i) {
            sds[i].close();
        }
        this.getTableViewSet().removeAll();
        this.getTypeSubstitutionSet().removeAll();
        this.getFKIndexAssociationSet().removeAll();
        this.getTableSet().removeAll();
        this.getColumnSet().removeAll();
        this.getColumnViewSet().removeAll();
        this.getIndexOnlyPlaceHolderSet().removeAll();
        this.getArcSet().removeAll();
        this.getNoteSet().removeAll();
        this.getImageObjectSet().removeAll();
        this.getLabelSet().removeAll();
        this.getDiagramViewSet().removeAll();
        this.getSchemaObjectSet().removeAll();
        this.clearMappings();
        this.clearDocuments();
        this.clearResponsibleParties();
        this.getIndexAndConstraintNameController().clear();
        this.setComment("");
        this.setNotes("");
        this.setRepositoryOID(null);
        this.setRepositoryOVID(null);
        this.getStorageDesignFactory().clearStorageDesigns();
        this.getAppView().removeDDLFileMakerEditorFor(this);
    }

    @Override
    public void sortCollections() {
        this.getTableSet().sort();
        this.getColumnSet().sort();
        this.getColumnViewSet().sort();
        this.getTableViewSet().sort();
        this.getFKIndexAssociationSet().sort();
        this.getSchemaObjectSet().sort();
        this.getPhysicalDesignSubviews().sort();
        Iterator it = this.getPhysicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvHolder = (DesignPartViewPlaceHolder)it.next();
            DesignPartView subView = dpvHolder.getDesignPartView();
            subView.sortCollections();
        }
    }

    @Override
    public int getNumberOfChildren() {
        if (this.isLoaded()) {
            if (this.getMainView().canCreateDisplays()) {
                return 7;
            }
            return 6;
        }
        return 0;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.getTableSet();
            }
            case 1: {
                return this.getTableViewSet();
            }
            case 2: {
                return this.getFKIndexAssociationSet();
            }
            case 3: {
                return this.getSchemaObjectSet();
            }
            case 4: {
                return this.subViews;
            }
            case 5: {
                return this.getStorageDesignFactory().getSorageDesigns();
            }
            case 6: {
                return this.getMainView().getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.getTableSet()) {
            return 0;
        }
        if (child == this.getTableViewSet()) {
            return 1;
        }
        if (child == this.getFKIndexAssociationSet()) {
            return 2;
        }
        if (child == this.getSchemaObjectSet()) {
            return 3;
        }
        if (child == this.subViews) {
            return 4;
        }
        if (child == this.getStorageDesignFactory().getSorageDesigns()) {
            return 5;
        }
        if (child == this.getMainView().getDisplays()) {
            return 6;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageDesignFactory getStorageDesignFactory() {
        if (this.storageDesignFactory == null) {
            this.storageDesignFactory = new StorageDesignFactory(this);
        }
        return this.storageDesignFactory;
    }

    public String getRDBMS() {
        return this.rdbms;
    }

    public void setRDBMS(String rdbms) {
        this.rdbms = rdbms;
    }

    public StorageDesign getStorageDesign(RDBMSSite site) {
        StorageDesign storageDesign = this.getStorageDesignFactory().getStorageDesign(site);
        return storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.getStorageDesign(this.getSelectedRDBMSSite());
    }

    public void setSelectedRDBMSSite(RDBMSSite site) {
        this.selectedRDBMSSite = site;
    }

    public void closeStorageDesigns() {
        StorageDesign[] sds = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < sds.length; ++i) {
            StorageDesign sd = sds[i];
            sd.close();
        }
        this.getDesign().getAppView().getPersistenceManager().readSystemInit(this.getDesign());
        System.gc();
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.selectedRDBMSSite == null) {
            this.selectedRDBMSSite = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(this.getDesign().getAppView().getSettings());
        }
        return this.selectedRDBMSSite;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVRelationalSubView dpv = new DPVRelationalSubView(this.getDesign().getAppView(), this);
        name = this.getNameVersion(this.subViews, name);
        dpv.setName(name);
        DesignPartViewPlaceHolder dpvPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        dpvPH.setParent(this.subViews);
        this.subViews.add(dpvPH);
        return dpv;
    }

    public SubViewObjectSet getPhysicalDesignSubviews() {
        return this.subViews;
    }

    public void clearPhysicalDesign() {
        this.clearDesignPart();
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVRelational(this.getDesign().getAppView(), this);
            this.mainView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    public String getObjectTypeName() {
        return OBJECT_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "RelDesign";
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getSchemaObjectSet());
        list.add(this.getTableSet());
        list.add(this.getTableViewSet());
        list.add(this.getFKIndexAssociationSet());
        list.add(this.getArcSet());
        return list;
    }

    @Override
    public void doAfterLoad() {
        this.getDesign().setRelationalDesign(this);
        int pers = this.getDesign().getLoadedModelPersistence();
        if (pers != Design.PERS_MODEL_IN_ONE_FILE) {
            this.createFilesMap();
        }
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.cleraDirtyForSubviews();
        this.setObjectListChanged(false);
        this.checkAndSetIDGenerator();
        boolean fixed = this.fixFKColums();
        this.setTableListeners();
        this.setViewListeners();
        this.resetRenamedIndexesToDirty();
        this.loadDocuments();
        this.loadResponsibleParties();
    }

    public void resetRenamedIndexesToDirty() {
        for (ErrorDescriptor err : this.getErrorDescriptionList()) {
            if (!(err.object instanceof Index) || !Index.INDEX_IS_RENAMED_IN_LOADING.equals(err.error)) continue;
            err.object.setDirty(true);
            try {
                Index ind = (Index)err.object;
                err.description = "Index " + ind.getLongName() + " in table " + ind.getTable().getLongName() + " cannot be set to name " + err.newName;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean fixFKColums() {
        boolean result = false;
        try {
            Iterator it = this.getColumnSet().iterator();
            while (it.hasNext()) {
                Column column = (Column)it.next();
                Object[] nodes = column.getRefColAndAssocIDs().toArray();
                for (int i = 0; i < nodes.length; ++i) {
                    DesignObject fk;
                    FKElement.FKColRefNode node = (FKElement.FKColRefNode)nodes[i];
                    if (node.fkAssocId == null || (fk = column.getDesign().getDesignObject(node.fkAssocId)) != null) continue;
                    column.removeFKAssociation(node.fkAssocId);
                    column.setDirty(true);
                    result = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void load() {
        this.getDesign().setRelationalDesign(this);
        XMLPersistenceManager pm = this.getDesign().getAppView().getPersistenceManager();
        AbstractXMLReader reader = pm.getDesignPartReader(this);
        if (reader != null) {
            if (this.getDesign().getLoadedVersion() < 3.2f) {
                reader.recreateDesign(this.getObjectID(), (DesignPart)this, false);
            } else {
                reader.recreateDesign(this.getPathIDString(), (DesignPart)this, false);
            }
        }
        this.createFilesMap();
        this.setLoaded(true);
        this.getMainDPVPlaceHolder().setDirty(false);
        this.getMainView().setDirty(false);
        this.setDirty(false);
        this.checkAndSetIDGenerator();
    }

    @Override
    public void doAfterSave() {
        super.doAfterSave();
        this.getDesign().addToLocalLoadedRemovableDesignParts(this);
    }

    public RelationalDesign getImportTo() {
        return this.importTo;
    }

    public void setImportTo(RelationalDesign importTo) {
        this.importTo = importTo;
    }

    public List<DBConnectionStamp> getImportConnectionStamps() {
        return this.importConnectionStamps;
    }

    public void setImportConnectionStamps(List<DBConnectionStamp> importConnectionStamps) {
        this.importConnectionStamps = importConnectionStamps;
    }

    public DBConnectionStamp createImportConnectionStamp() {
        DBConnectionStamp stamp = new DBConnectionStamp();
        this.importConnectionStamps.add(stamp);
        return stamp;
    }

    public DBConnectionStamp getImportConnectionStamp(int index) {
        if (!this.importConnectionStamps.isEmpty() && index != -1 && index < this.importConnectionStamps.size()) {
            return this.importConnectionStamps.get(index);
        }
        return null;
    }

    public void setImportConnectionStamp(DBConnectionStamp stamp, int index) {
        if (!this.importConnectionStamps.isEmpty() && index != -1 && index < this.importConnectionStamps.size()) {
            this.importConnectionStamps.set(index, stamp);
        }
    }

    public int findImportConnectionStamp(String importConnectionName) {
        if (importConnectionName != null) {
            for (int i = 0; i < this.importConnectionStamps.size(); ++i) {
                DBConnectionStamp stamp = this.importConnectionStamps.get(i);
                if (!importConnectionName.equals(stamp.getConnName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int addImportConnectionStamp(DBConnectionStamp importConnectionStamp) {
        int index = this.findImportConnectionStamp(importConnectionStamp.getConnName());
        if (index == -1) {
            this.importConnectionStamps.add(importConnectionStamp);
            index = this.importConnectionStamps.size() - 1;
            this.setDirty(true);
        }
        return index;
    }

    public int getImportConnectionStampIndex() {
        return this.importConnectionStampIndex;
    }

    public void setImportConnectionStampIndex(int index) {
        this.importConnectionStampIndex = index;
    }

    public DBConnectionStamp getRedirectConnectionStamp() {
        return this.redirectConnectionStamp;
    }

    public void setRedirectConnectionStamp(DBConnectionStamp stamp) {
        this.redirectConnectionStamp = stamp;
    }

    public DBConnectionStamp createRedirectConnectionStamp() {
        return new DBConnectionStamp();
    }

    public List<DDLFileStamp> getImportDDLFileStamps() {
        return this.importDDLFileStamps;
    }

    public void setImportDDLFileStamps(List<DDLFileStamp> importDDLFileStamps) {
        this.importDDLFileStamps = importDDLFileStamps;
    }

    public DDLFileStamp createImportDDLFileStamp() {
        DDLFileStamp stamp = new DDLFileStamp();
        this.importDDLFileStamps.add(stamp);
        return stamp;
    }

    public DDLFileStamp getImportDDLFileStamp(int index) {
        return this.importDDLFileStamps.get(index);
    }

    public int findImportDDLFileStamp(String importDDLFileName) {
        for (int i = 0; i < this.importDDLFileStamps.size(); ++i) {
            DDLFileStamp stamp = this.importDDLFileStamps.get(i);
            if (!importDDLFileName.equals(stamp.getFileName())) continue;
            return i;
        }
        return -1;
    }

    public int addImportDDLFileStamp(DDLFileStamp importDDLFileStamp) {
        int index = this.findImportDDLFileStamp(importDDLFileStamp.getFileName());
        if (index == -1) {
            this.importDDLFileStamps.add(importDDLFileStamp);
            index = this.importDDLFileStamps.size() - 1;
            this.setDirty(true);
        }
        return index;
    }

    public void removeImportDDLFileStamp(DDLFileStamp importDDLFileStamp) {
        int index = this.findImportDDLFileStamp(importDDLFileStamp.getFileName());
        if (index != -1) {
            this.importDDLFileStamps.remove(index);
            this.setDirty(true);
        }
    }

    public int getImportDDLFileStampIndex() {
        return this.importDDLFileStampIndex;
    }

    public void setImportDDLFileStampIndex(int index) {
        this.importDDLFileStampIndex = index;
    }

    public void stampModelObjectDDL(ModelObject obj) {
        if ("".equals(obj.getSourceDDLFile()) && this.importDDLFileStampIndex > -1) {
            DDLFileStamp stamp = this.getImportDDLFileStamp(this.importDDLFileStampIndex);
            obj.setSourceDDLFile(stamp.getFileName());
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getTableSet().size() != 0) {
            return false;
        }
        if (this.getColumnSet().size() != 0) {
            return false;
        }
        if (this.getColumnViewSet().size() != 0) {
            return false;
        }
        if (this.getTableViewSet().size() != 0) {
            return false;
        }
        if (this.getFKIndexAssociationSet().size() != 0) {
            return false;
        }
        if (this.getGlobalIndexSet().size() != 0) {
            return false;
        }
        if (this.getNoteSet().size() != 0) {
            return false;
        }
        if (this.getImageObjectSet().size() != 0) {
            return false;
        }
        if (this.getDiagramViewSet().size() != 0) {
            return false;
        }
        if (this.getStorageDesignFactory().getSorageDesigns().size() != 0) {
            return false;
        }
        return this.getSchemaObjectSet().size() == 0;
    }

    public void rearrangeTables() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        TableSet tableSet = this.getTableSet();
        if (tableSet.size() > 0) {
            Iterator it = tableSet.iterator();
            float square = (float)Math.sqrt(tableSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                Dimension dim;
                Table table = (Table)it.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    dim = this.getTableSize(table);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    dim = this.getTableSize(table);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
        }
    }

    public void rearrangeTables(List tables, Point p) {
        this.left = p.x;
        this.top = p.y;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (tables.size() > 0) {
            Iterator it = tables.iterator();
            float square = (float)Math.sqrt(tables.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                Table table = (Table)it.next();
                TopView topView = table.getFirstViewForDPV(this.getAppView().getCurrentDPV());
                if (topView == null) {
                    topView = table.getTopView();
                }
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    Dimension dim = this.getTableSize(table);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
                this.height = 25;
            }
            p.x = this.left;
            p.y = this.top;
        }
    }

    public Dimension getTableSize(Table table) {
        int w = 35;
        int h = 25;
        int colCount = 0;
        StructuredType st = null;
        if (table.isBST() && table.getTypeSubstitution() != null) {
            st = table.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = table.getElements().length;
        }
        h += colCount * 14;
        if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
            h += 4;
            for (int i = 0; i < table.getKeys().length; ++i) {
                if (table.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = table.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            int dtl;
            int cl;
            DesignObject element;
            if (st != null) {
                element = st.getElements()[i];
                cl = element.getName().length() * 7;
                dtl = ((TypeElement)element).getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            element = (ContainedObjectWithDomain)table.getElement(i);
            cl = ((ContainedObject)element).getName().length() * 7;
            dtl = ((ContainedObjectWithDomain)element).getDataType().toString().length() * 7 + 20;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = table.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.width = 35;
        this.height = 25;
        TableViewSet tableViewSet = this.getTableViewSet();
        if (tableViewSet.size() > 0) {
            Iterator it = tableViewSet.iterator();
            float square = (float)Math.sqrt(tableViewSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            while (it.hasNext()) {
                Dimension dim;
                TableView view = (TableView)it.next();
                TopView topView = view.getFirstViewForDPV(this.getAppView().getCurrentDPV());
                if (topView == null) {
                    topView = view.getTopView();
                }
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    dim = this.getTableViewSize(view);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    dim = this.getTableViewSize(view);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    public void rearrangeViews(List views, Point p) {
        this.left = p.x;
        this.top = p.y;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (views.size() > 0) {
            Iterator it = views.iterator();
            float square = (float)Math.sqrt(views.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            while (it.hasNext()) {
                TableView view = (TableView)it.next();
                TopView topView = view.getTopView();
                if (topView == null) continue;
                ++this.count;
                if (topView.getCellView() != null) {
                    Dimension dim = this.getTableViewSize(view);
                    this.width = dim.width;
                    this.height = Math.max(dim.height, this.height);
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 150;
            }
        }
    }

    public List getDropableSets() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getTableSet());
        list.add(this.getIndexOnlyPlaceHolderSet());
        list.add(this.getTableViewSet());
        list.add(this.getFKIndexAssociationSet());
        return list;
    }

    public Dimension getTableViewSize(TableView view) {
        int w = 60;
        int h = 40;
        int colCount = 0;
        StructuredType st = null;
        if (view.isBST() && view.getTypeSubstitution() != null) {
            st = view.getBasedOnStructuredType();
            if (st != null) {
                colCount = st.getElements().length;
            }
        } else {
            colCount = view.getElementsCollection().size();
        }
        h += colCount * 14;
        int colLength = view.getName().length() * 6;
        int dtLength = 1;
        ContainedObject[] elements = view.getColumns();
        for (int i = 0; i < colCount; ++i) {
            if (st != null) {
                TypeElement element = st.getElements()[i];
                int cl = element.getName().length() * 7;
                int dtl = element.getDataType().length() * 7;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            if (elements[i] instanceof ColumnView) {
                ColumnView element = (ColumnView)elements[i];
                String name = element.getAlias();
                if ("".equalsIgnoreCase(name)) {
                    name = element.getName();
                }
                int cl = name.length() * 7;
                int dtl = element.getDataTypeString().length() * 7 + 10;
                colLength = Math.max(cl, colLength);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            int cl = elements[i].getName().length() * 7;
            colLength = Math.max(cl, colLength);
        }
        if (colLength > 250) {
            colLength = 250;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    @Override
    public boolean canCreateDPSubview() {
        return true;
    }

    public void updateFKViews() {
        Iterator it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fkIndex = (FKIndexAssociation)it.next();
            for (TVFKRelation tv : fkIndex.getAllTVRelations()) {
                tv.resetEdgeParams(false);
            }
        }
    }

    public boolean hasUsageOfStructuredType(StructuredType st) {
        if (st != null) {
            Iterator it = this.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (table.getBasedOnStructuredType() != st) continue;
                return true;
            }
            it = this.getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView view = (TableView)it.next();
                if (view.getBasedOnStructuredType() != st) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTableColumnsToFile(String fileName) throws IOException {
        File file = new File(fileName);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("RelationalDesign.FileCanNotBeCreated"), fileName));
        }
        Writer fout = null;
        try {
            fout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            Iterator it = this.getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                Column[] cols = (Column[])table.getElements();
                for (int i = 0; i < cols.length; ++i) {
                    int ind;
                    Column col = cols[i];
                    String dataType = col.getDatatypeString("DB2/390 8");
                    String nullable = "N";
                    String size = col.getSize();
                    String precision = col.getPrecision();
                    String scale = col.getScale();
                    if (col.getNullsAllowed()) {
                        nullable = "Y";
                    }
                    if ((ind = dataType.indexOf(40)) > -1) {
                        dataType = dataType.substring(0, ind);
                    }
                    String row = table.getName().toUpperCase() + "|" + col.getName().toUpperCase() + "|" + dataType.toUpperCase() + "|" + size + "|" + precision + "|" + scale + "|" + nullable + "|" + i + "|\n";
                    fout.write(row);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RelationalModelDialogEx dialog = new RelationalModelDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public List getNamingOptionsHolderList() {
        if (this.namingOptionsHolderList == null) {
            int[] defaults = this.getDefaultMaxNameLengths();
            this.namingOptionsHolderList = new ArrayList();
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Table.class, defaults[0]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Column.class, defaults[1]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(TableView.class, defaults[2]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(TableLevelConstraint.class, defaults[3]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(FKIndexAssociation.class, defaults[3]));
            this.namingOptionsHolderList.add(new NamingOptionsHolder(Index.class, defaults[4]));
        }
        return this.namingOptionsHolderList;
    }

    private int[] getDefaultMaxNameLengths() {
        int[] defaults = new int[]{18, 18, 18, 18, 18};
        RDBMSType type = this.getSelectedRDBMSType();
        if (type != null) {
            if (type.equals(StorageDesignDB2v70.RDBMS_TYPE)) {
                defaults[0] = 18;
                defaults[1] = 18;
                defaults[2] = 18;
                defaults[3] = 18;
                defaults[4] = 18;
            } else if (type.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 30;
                defaults[2] = 128;
                defaults[3] = 30;
                defaults[4] = 30;
            } else if (type.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
                defaults[0] = 30;
                defaults[1] = 30;
                defaults[2] = 30;
                defaults[3] = 30;
                defaults[4] = 30;
            } else if (type.equals(StorageDesignOraclev10g.RDBMS_TYPE)) {
                defaults[0] = 30;
                defaults[1] = 30;
                defaults[2] = 30;
                defaults[3] = 30;
                defaults[4] = 30;
            } else if (type.equals(StorageDesignOraclev11g.RDBMS_TYPE) || type.equals(StorageDesignOraclev12c.RDBMS_TYPE)) {
                defaults[0] = 30;
                defaults[1] = 30;
                defaults[2] = 30;
                defaults[3] = 30;
                defaults[4] = 30;
            } else if (type.equals(StorageDesignOraclev12cR2.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignSqlServerv2k8.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignSqlServerv2k12.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignUDBv71.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 30;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignUDBv81.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            } else if (type.equals(StorageDesignUDBv9.RDBMS_TYPE)) {
                defaults[0] = 128;
                defaults[1] = 128;
                defaults[2] = 128;
                defaults[3] = 128;
                defaults[4] = 128;
            }
        }
        return defaults;
    }

    @Override
    public void clearDesignPart() {
        super.clearDesignPart();
        this.removeDesignPartListener(this.getMainView());
        this.getDesign().removeDesignPartView(this.getMainView());
        this.getRMExtendedMap().clearMappings();
        this.removeDesignPartListener(this.getRMExtendedMap());
    }

    private List getSelectedTables(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKContainer)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedFKeys(Object[] selectedObjects, FKContainer table) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            FKIndexAssociation fkey;
            Object object = selectedObjects[i];
            if (!(object instanceof FKIndexAssociation) || (fkey = (FKIndexAssociation)object).getContainerWithKeyObject() != table) continue;
            list.add(fkey);
        }
        return list;
    }

    private List getSelectedFKeys(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKIndexAssociation)) continue;
            list.add(object);
        }
        return list;
    }

    public boolean canCreateArc(Object[] selectedObjects) {
        FKContainer table;
        List fkeys;
        List tables = this.getSelectedTables(selectedObjects);
        List sel_fkeys = this.getSelectedFKeys(selectedObjects);
        if (tables.size() == 0 && sel_fkeys.size() > 0) {
            tables.add(((FKIndexAssociation)sel_fkeys.get(0)).getContainerWithKeyObject());
        }
        if (tables.size() == 1 && (fkeys = this.getSelectedFKeys(selectedObjects, table = (FKContainer)tables.get(0))).size() > 1 && fkeys.size() == sel_fkeys.size()) {
            for (FKIndexAssociation fkey : fkeys) {
                if (!table.inArc(fkey)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canCreatereverseArc(Object[] selectedObjects) {
        List tables = this.getSelectedTables(selectedObjects);
        List sel_fkeys = this.getSelectedFKeys(selectedObjects);
        if (tables.size() == 0 && sel_fkeys.size() > 0) {
            tables.add(((FKIndexAssociation)sel_fkeys.get(0)).getRemoteTable());
        }
        if (tables.size() == 1 && sel_fkeys.size() > 1) {
            ArrayList list = new ArrayList();
            list.add(tables.get(0));
            for (int i = 0; i < sel_fkeys.size(); ++i) {
                FKIndexAssociation fk = (FKIndexAssociation)sel_fkeys.get(i);
                if (fk.isInArc()) {
                    return false;
                }
                FKContainer table = fk.getRemoteTable();
                if (list.contains(table)) continue;
                list.add(table);
            }
            if (list.size() == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean canRemoveFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            FKArc arc = (FKArc)arcs.get(0);
            List fkeys = this.getSelectedFKeys(selectedObjects, arc.getTable());
            List sel_fkeys = this.getSelectedFKeys(selectedObjects);
            if (fkeys.size() == sel_fkeys.size()) {
                for (FKIndexAssociation fkey : fkeys) {
                    if (arc.containsFKey(fkey)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private List getSelectedArcs(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKArc)) continue;
            list.add(object);
        }
        return list;
    }

    public boolean canAddToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            FKArc arc = (FKArc)arcs.get(0);
            List fkeys = this.getSelectedFKeys(selectedObjects, arc.getTable());
            List sel_fkeys = this.getSelectedFKeys(selectedObjects);
            if (fkeys.size() == sel_fkeys.size()) {
                for (FKIndexAssociation fkey : fkeys) {
                    if (!arc.getTable().inArc(fkey)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public FKArc createArc() {
        return this.getArcSet().createArc(null);
    }

    public FKArc createArc(String name) {
        FKArc arc = this.getArcSet().createArc(null);
        arc.setName(name);
        return arc;
    }

    public FKArc recreateArc(String id) {
        return this.getArcSet().createArc(id);
    }

    public FKArc createArc(Object[] selectedObjects) {
        FKContainer table;
        List fkeys;
        ApplicationView.log(Messages.getString("RelationalDesign.CreateArc"));
        List tables = this.getSelectedTables(selectedObjects);
        List sel_fkeys = this.getSelectedFKeys(selectedObjects);
        if (tables.size() == 0 && sel_fkeys.size() > 0) {
            tables.add(((FKIndexAssociation)sel_fkeys.get(0)).getContainerWithKeyObject());
        }
        if (tables.size() == 1 && (fkeys = this.getSelectedFKeys(selectedObjects, table = (FKContainer)tables.get(0))).size() > 1 && fkeys.size() == sel_fkeys.size()) {
            FKArc arc = this.createArc();
            table.addArc(arc);
            for (FKIndexAssociation fkey : fkeys) {
                arc.addFkey(fkey);
            }
            arc.addToAllDPVs();
            return arc;
        }
        if (tables.size() == 1 && sel_fkeys.size() > 1) {
            ArrayList<FKContainer> list = new ArrayList<FKContainer>();
            for (int i = 0; i < sel_fkeys.size(); ++i) {
                FKIndexAssociation fk = (FKIndexAssociation)sel_fkeys.get(i);
                FKContainer table2 = fk.getRemoteTable();
                if (list.contains(table2)) continue;
                list.add(table2);
            }
            if (list.size() == 1) {
                FKArc arc = this.createArc();
                arc.setReverse(true);
                FKContainer table3 = (FKContainer)list.get(0);
                table3.addArc(arc);
                for (FKIndexAssociation fkey : sel_fkeys) {
                    arc.addFkey(fkey);
                }
                arc.addToAllDPVs();
                return arc;
            }
        }
        return null;
    }

    public void addToArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            FKArc arc = (FKArc)arcs.get(0);
            List fkeys = this.getSelectedFKeys(selectedObjects, arc.getTable());
            for (FKIndexAssociation fkey : fkeys) {
                if (arc.getTable().inArc(fkey)) continue;
                arc.addFkey(fkey);
            }
            arc.setDirty(true);
            this.getMainView().getWorkSpace().invalidate();
        }
    }

    public void removeFromArc(Object[] selectedObjects) {
        List arcs = this.getSelectedArcs(selectedObjects);
        if (arcs.size() == 1) {
            FKArc arc = (FKArc)arcs.get(0);
            List fkeys = this.getSelectedFKeys(selectedObjects, arc.getTable());
            for (FKIndexAssociation fkey : fkeys) {
                if (!arc.containsFKey(fkey)) continue;
                arc.removeFkey(fkey);
            }
            arc.setDirty(true);
            if (arc.getFkeys().size() <= 1) {
                arc.remove();
            }
            this.getMainView().getWorkSpace().invalidate();
        }
    }

    public void postTableCreateEdit(Table table) {
        TableCreateEdit edit = new TableCreateEdit(table);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postTableRemoveEdit(Table table) {
        TableRemoveEdit edit = new TableRemoveEdit(table);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postTableViewCreateEdit(TableView table) {
        TableViewCreateEdit edit = new TableViewCreateEdit(table);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postTableViewRemoveEdit(TableView tableView) {
        TableViewRemoveEdit edit = new TableViewRemoveEdit(tableView);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postFKRemoveEdit(FKIndexAssociation fk) {
        FKRemoveEdit edit = new FKRemoveEdit(fk);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postFKCreateEdit(FKIndexAssociation fk) {
        FKCreateEdit edit = new FKCreateEdit(fk);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postFKArcCreateEdit(FKArc arc) {
        FKArcCreateEdit edit = new FKArcCreateEdit(arc);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postFKArcRemoveEdit(FKArc arc) {
        FKArcRemoveEdit edit = new FKArcRemoveEdit(arc);
        edit.end();
        this.postUndoableEdit(edit);
    }

    @Override
    public void postUndoableRemoveEditForObject(DesignObject object) {
        super.postUndoableRemoveEditForObject(object);
        if (object instanceof Table) {
            this.postTableRemoveEdit((Table)object);
        } else if (object instanceof FKIndexAssociation) {
            this.postFKRemoveEdit((FKIndexAssociation)object);
        } else if (object instanceof FKArc) {
            this.postFKArcRemoveEdit((FKArc)object);
        } else if (object instanceof Column) {
            this.postColumnRemoveEdit((Column)object);
        } else if (object instanceof Index) {
            this.postIndexRemoveEdit((Index)object);
        } else if (object instanceof TableView) {
            this.postTableViewRemoveEdit((TableView)object);
        }
    }

    public void postColumnRemoveEdit(Column column) {
        ColumnRemoveEdit edit = new ColumnRemoveEdit(column);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void postIndexRemoveEdit(Index index) {
        IndexRemoveEdit edit = new IndexRemoveEdit(index);
        edit.end();
        this.postUndoableEdit(edit);
    }

    public void createSubviewsOnSchema(StorageDesign stdes) {
        List<DesignObject> list;
        String name;
        SchemaObject scho;
        List<DesignObject> list2;
        String name2;
        StorageObject so;
        RelationalObjectProxy tp;
        ArrayList<DesignObject> noschema = new ArrayList<DesignObject>();
        TreeMap map = new TreeMap();
        Iterator it = stdes.getTableProxySet().iterator();
        while (it.hasNext()) {
            tp = (TableProxy)it.next();
            so = ((TableProxy)tp).getUserSchema();
            if (so != null) {
                name2 = so.getName();
                list2 = (ArrayList<DesignObject>)map.get(name2);
                if (list2 == null) {
                    list2 = new ArrayList<DesignObject>();
                    map.put(name2, list2);
                }
                list2.add(tp.getObject());
                continue;
            }
            scho = ((Table)tp.getObject()).getSchemaObject();
            if (scho != null) {
                name = scho.getName();
                list = (ArrayList<DesignObject>)map.get(name);
                if (list == null) {
                    list = new ArrayList<DesignObject>();
                    map.put(name, list);
                }
                list.add(tp.getObject());
                continue;
            }
            noschema.add(tp.getObject());
        }
        it = stdes.getTableViewProxySet().iterator();
        while (it.hasNext()) {
            tp = (TableViewProxy)it.next();
            so = ((TableViewProxy)tp).getUserSchema();
            if (so != null) {
                name2 = so.getName();
                list2 = (List)map.get(name2);
                if (list2 == null) {
                    list2 = new ArrayList();
                    map.put(name2, list2);
                }
                list2.add(tp.getObject());
                continue;
            }
            scho = ((TableView)tp.getObject()).getSchemaObject();
            if (scho != null) {
                name = scho.getName();
                list = (List)map.get(name);
                if (list == null) {
                    list = new ArrayList();
                    map.put(name, list);
                }
                list.add(tp.getObject());
                continue;
            }
            noschema.add(tp.getObject());
        }
        if (noschema.size() > 0 && map.size() > 0 || map.size() > 1) {
            if (noschema.size() > 0) {
                this.createSubview("SV_noschema", noschema);
            }
            for (String name3 : map.keySet()) {
                List list3 = (List)map.get(name3);
                DesignPartView dpv = this.createSubview(name3, list3);
                SchemaObject so2 = (SchemaObject)this.getSchemaObjectSet().getByName(name3);
                if (so2 == null) continue;
                dpv.setSchemaObject(so2);
            }
        }
    }

    public DesignPartView createSubview(String name, List objects) {
        DesignPartView dpv = this.createDesignPartSubView();
        if (name != null) {
            dpv.setName(name);
        }
        dpv.setMustBeVisible(false);
        for (DesignObject obj : objects) {
            TopView tv = dpv.createTopViewFor(obj);
            if (tv instanceof TVTable) {
                ((TVTable)tv).addTVFKRelations();
                ((TVTable)tv).addTVTypeSubstitutions();
                continue;
            }
            if (!(tv instanceof TVView)) continue;
            ((TVView)tv).addTVFKRelations();
            ((TVView)tv).addTVTypeSubstitutions();
        }
        ((DPVRelationalSubView)dpv).rearrangeNewDiagram();
        return dpv;
    }

    public DesignPartView createSubview(List objects) {
        DesignPartView dpv = this.createDesignPartSubView();
        dpv.setMustBeVisible(false);
        for (DesignObject obj : objects) {
            TopView tv = dpv.createTopViewFor(obj);
            if (tv instanceof TVTable) {
                ((TVTable)tv).addTVFKRelations();
                ((TVTable)tv).addTVTypeSubstitutions();
                continue;
            }
            if (!(tv instanceof TVView)) continue;
            ((TVView)tv).addTVFKRelations();
            ((TVView)tv).addTVTypeSubstitutions();
        }
        ((DPVRelationalSubView)dpv).rearrangeNewDiagram();
        return dpv;
    }

    public DesignPartView createSubview(List objects, ShowParentAndChildListener listener) {
        DesignPartView dpv = this.createDesignPartSubView();
        dpv.setMustBeVisible(false);
        for (DesignObject obj : objects) {
            TopView tv = dpv.createTopViewFor(obj);
            if (tv instanceof TVTable) {
                ((TVTable)tv).addTVFKRelations();
                ((TVTable)tv).addTVTypeSubstitutions();
                if (listener == null) continue;
                tv.addShowParendAndChildListener(listener);
                continue;
            }
            if (!(tv instanceof TVView)) continue;
            ((TVView)tv).addTVFKRelations();
            ((TVView)tv).addTVTypeSubstitutions();
        }
        ((DPVRelationalSubView)dpv).rearrangeNewDiagram();
        return dpv;
    }

    public DesignPartView addObjectsToDPV(DesignPartView dpv, List objects) {
        for (DesignObject obj : objects) {
            TopView tv = dpv.createTopViewFor(obj);
            if (tv instanceof TVTable) {
                ((TVTable)tv).addTVFKRelations();
                ((TVTable)tv).addTVTypeSubstitutions();
                continue;
            }
            if (!(tv instanceof TVView)) continue;
            ((TVView)tv).addTVFKRelations();
            ((TVView)tv).addTVTypeSubstitutions();
        }
        ((DPVRelationalSubView)dpv).rearrangeNewDiagram();
        return dpv;
    }

    @Override
    protected List createTypeOrder() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("SchemaObject");
        list.add("Table");
        list.add("View");
        list.add("FKIndexAssociation");
        list.add("FKArc");
        list.add("Note");
        list.add("MainView");
        list.add("SubView");
        return list;
    }

    @Override
    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.getDesign().getRelationalDesigns().nextIndex();
        }
        return this.pathID;
    }

    public void showFkeysInSubviews() {
        Iterator it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            fk.addToAllDPVs();
        }
    }

    public void showFKArcs() {
        Iterator it = this.getArcSet().iterator();
        while (it.hasNext()) {
            FKArc fkArc = (FKArc)it.next();
            fkArc.showArcInAllDPVs();
        }
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                String relPath = this.getDesign().getLoadedVersion() < 3.2f ? "relational" : "rel";
                String relID = this.getDesign().getLoadedVersion() < 3.2f ? this.getObjectID() : (this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID());
                return new File(designPath, relPath + File.separatorChar + relID).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                String relPath = this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID();
                return new File(designPath, "rel" + File.separatorChar + relPath + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Table".equalsIgnoreCase(objectType)) {
            object = this.getTableSet().createTable(objectID);
        } else if ("View".equalsIgnoreCase(objectType)) {
            object = this.getTableViewSet().createTableView(objectID);
        } else if ("FKIndexAssociation".equalsIgnoreCase(objectType)) {
            FKIndexAssociation fk = new FKIndexAssociation(this);
            fk.setObjectID(objectID);
            object = fk;
        } else if ("FKArc".equalsIgnoreCase(objectType)) {
            object = this.getArcSet().createArc(objectID);
        } else if ("Note".equalsIgnoreCase(objectType)) {
            object = this.getNoteSet().createNote(objectID);
        } else if ("Image".equalsIgnoreCase(objectType)) {
            object = this.getImageObjectSet().createImage(objectID);
        } else if ("SchemaObject".equalsIgnoreCase(objectType)) {
            object = this.getSchemaObjectSet().createSchemaObject(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            ((DesignObject)object).setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("schema", "SchemaObject");
            this.f2tMap.put("table", "Table");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("foreignkey", "FKIndexAssociation");
            this.f2tMap.put("arc", "FKArc");
            this.f2tMap.put("note", "Note");
            this.f2tMap.put("image", "Image");
        }
        return this.f2tMap;
    }

    public static void initObjectDetails(Design design, File file, SVNUrl url, boolean remoteStatus, String path, StorableObjectStatusHelper sosHelper, String storableObjectID, String filePath, SVNStatus svnStatus) {
        Map<String, SVNObjectHelper> svnOHMap = design.getSVNObjectHelperMap();
        if ("phys".equalsIgnoreCase(path)) {
            String physDir = "/phys";
            String shortPath = filePath.substring(filePath.indexOf(physDir) + physDir.length() + 1);
            StringTokenizer st = new StringTokenizer(shortPath, "/");
            String rdbmsID = st.nextToken();
            RDBMSSite rdbmsSite = design.getRDBMSSiteSet().getByShortObjectIDString(rdbmsID);
            if (storableObjectID.equalsIgnoreCase(rdbmsID)) {
                File storageDesignFolder = file.getParentFile();
                File relationalDesignFolder = storageDesignFolder.getParentFile().getParentFile();
                RelationalDesign.addDesignPartPaths(sosHelper, storableObjectID, relationalDesignFolder, design);
                sosHelper.treePath.add(new TreePathHelper(StorageDesignFactory.getStorageDesignSetName(), storageDesignFolder.getParentFile(), StorageDesign.class));
                sosHelper.objectClass = StorageDesign.class;
                sosHelper.objectType = StorageDesign.TYPE_NAME;
                if (sosHelper.designPart != null && rdbmsSite != null && sosHelper.designPart != null) {
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getStorageDesign(rdbmsSite);
                }
            } else {
                File parentFolder = file.getParentFile();
                if (parentFolder.getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
                    parentFolder = parentFolder.getParentFile();
                }
                File storageDesignFolder = parentFolder.getParentFile();
                File relationalDesignFolder = storageDesignFolder.getParentFile().getParentFile();
                if (sosHelper.designPart == null) {
                    RelationalDesign rd = (RelationalDesign)design.getRelationalDesigns().getByShortId(relationalDesignFolder.getName());
                    if (rd != null) {
                        sosHelper.designPart = rd;
                    } else {
                        SVNObjectHelper relSVNOH = svnOHMap.get(relationalDesignFolder.getName());
                        if (relSVNOH != null) {
                            sosHelper.designPart = sosHelper.designPart;
                        }
                    }
                }
                RelationalDesign.addDesignPartPaths(sosHelper, storableObjectID, relationalDesignFolder, design);
                sosHelper.treePath.add(new TreePathHelper(StorageDesignFactory.getStorageDesignSetName(), storageDesignFolder.getParentFile(), StorageDesign.class));
                String objectType = st.nextToken();
                if (rdbmsSite != null) {
                    sosHelper.rdbmsSite = rdbmsSite;
                    StorageDesign.initObjectDetails(design, file, url, remoteStatus, objectType, sosHelper, storableObjectID, design.getStorageDesign(rdbmsSite), svnStatus);
                }
            }
        } else {
            File parentFolder = file.getParentFile();
            if (parentFolder.getName().startsWith(SegmentNameManager.NAME_PREFIX)) {
                parentFolder = parentFolder.getParentFile();
            }
            File designPartFolder = parentFolder.getParentFile();
            RelationalDesign.addDesignPartPaths(sosHelper, storableObjectID, designPartFolder, design);
            if ("schema".equalsIgnoreCase(path)) {
                sosHelper.objectClass = SchemaObject.class;
                sosHelper.objectType = "SchemaObject";
                sosHelper.treePath.add(new TreePathHelper(SCHEMA_SET_NAME, parentFolder, SchemaObjectSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = ((RelationalDesign)sosHelper.designPart).getSchemaObjectSet();
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getSchemaObjectSet().getObjectByID(storableObjectID);
                }
            } else if ("table".equalsIgnoreCase(path)) {
                sosHelper.objectClass = Table.class;
                sosHelper.objectType = "Table";
                sosHelper.treePath.add(new TreePathHelper(TABLE_SET_NAME, parentFolder, TableSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = ((RelationalDesign)sosHelper.designPart).getTableSet();
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getTableSet().getObjectByID(storableObjectID);
                }
            } else if ("view".equalsIgnoreCase(path)) {
                sosHelper.objectClass = TableView.class;
                sosHelper.objectType = "View";
                sosHelper.treePath.add(new TreePathHelper(VIEW_SET_NAME, parentFolder, TableViewSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = ((RelationalDesign)sosHelper.designPart).getTableViewSet();
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getTableViewSet().getObjectByID(storableObjectID);
                }
            } else if ("foreignkey".equalsIgnoreCase(path)) {
                sosHelper.objectClass = FKIndexAssociation.class;
                sosHelper.objectType = "FKIndexAssociation";
                sosHelper.treePath.add(new TreePathHelper(FK_SET_NAME, parentFolder, FKIndexAssociationSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = ((RelationalDesign)sosHelper.designPart).getFKIndexAssociationSet();
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getFKIndexAssociationSet().getObjectByID(storableObjectID);
                }
            } else if ("arc".equalsIgnoreCase(path)) {
                sosHelper.objectClass = FKArc.class;
                sosHelper.objectType = "FKArc";
                sosHelper.treePath.add(new TreePathHelper(ARC_SET_NAME, parentFolder, FKArcSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = ((RelationalDesign)sosHelper.designPart).getArcSet();
                    sosHelper.storableObject = ((RelationalDesign)sosHelper.designPart).getArcSet().getObjectByID(storableObjectID);
                }
            } else if ("note".equalsIgnoreCase(path)) {
                sosHelper.objectClass = Note.class;
                sosHelper.objectType = "Note";
                sosHelper.treePath.add(new TreePathHelper(NOTE_SET_NAME, parentFolder, NoteSet.class));
                if (sosHelper.designPart != null) {
                    sosHelper.objectSet = sosHelper.designPart.getNoteSet();
                    sosHelper.storableObject = sosHelper.designPart.getNoteSet().getObjectByID(storableObjectID);
                }
            } else if ("subviews".equalsIgnoreCase(path)) {
                sosHelper.objectClass = DPVRelationalSubView.class;
                sosHelper.treePath.add(new TreePathHelper(DIAGRAM_SET_NAME, parentFolder, DPVRelationalSubView.class));
                if (sosHelper.designPart != null) {
                    RelationalDesign model = (RelationalDesign)sosHelper.designPart;
                    sosHelper.storableObject = model.getMainView().getDPVId().equals(storableObjectID) ? model.getMainView() : model.getSubViewByID(storableObjectID);
                }
            }
        }
    }

    private static void addDesignPartPaths(StorableObjectStatusHelper sosHelper, String storableObjectID, File designPartFolder, Design design) {
        Map<String, SVNObjectHelper> svnOHMap = design.getSVNObjectHelperMap();
        sosHelper.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), designPartFolder.getParentFile(), RelationalDesignSet.class));
        if (sosHelper.designPart != null) {
            sosHelper.treePath.add(new TreePathHelper(sosHelper.designPart.getName(), new File(sosHelper.designPart.getStorageName()), RelationalDesign.class));
        } else {
            SVNObjectHelper relSVNOH = svnOHMap.get(designPartFolder.getName());
            if (relSVNOH != null) {
                sosHelper.treePath.add(new TreePathHelper(relSVNOH.propName, new File(relSVNOH.fileName), RelationalDesign.class));
            } else {
                SVNObjectHelper parentSVNOH;
                SVNObjectHelper svnOH = svnOHMap.get(storableObjectID);
                if (svnOH != null && (parentSVNOH = svnOHMap.get(svnOH.parentID)) != null) {
                    sosHelper.treePath.add(new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), RelationalDesign.class));
                }
            }
        }
    }

    public List<StorableObject> getNotMarkedGenerateObjects() {
        ArrayList<StorableObject> notMarkedGenerateObjects = new ArrayList<StorableObject>();
        this.addMarkedGenerateTables(notMarkedGenerateObjects, false);
        this.addMarkedGenerateTableViews(notMarkedGenerateObjects, false);
        return notMarkedGenerateObjects;
    }

    public List<StorableObject> getMarkedGenerateObjects() {
        ArrayList<StorableObject> markedGenerateObjects = new ArrayList<StorableObject>();
        this.addMarkedGenerateTables(markedGenerateObjects, true);
        this.addMarkedGenerateTables(markedGenerateObjects, false);
        this.addMarkedGenerateTableViews(markedGenerateObjects, true);
        this.addMarkedGenerateTableViews(markedGenerateObjects, false);
        return markedGenerateObjects;
    }

    private void addMarkedGenerateTables(List<StorableObject> markedGenerateObjects, boolean markedGenerate) {
        Iterator tablesIterator = this.getTableSet().iterator();
        while (tablesIterator.hasNext()) {
            Table table = (Table)tablesIterator.next();
            KeyObject[] indexes = table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                DesignObject object;
                KeyObject index = indexes[i];
                DesignObject designObject = object = index.isFK() ? index.getFKAssociation() : index;
                if (object.isMarkedGenerate() != markedGenerate) continue;
                markedGenerateObjects.add(object);
            }
            for (FKArc arc : table.getArcs()) {
                if (arc.isMarkedGenerate() != markedGenerate) continue;
                markedGenerateObjects.add(arc);
            }
            if (table.isMarkedGenerate() != markedGenerate) continue;
            markedGenerateObjects.add(table);
        }
    }

    private void addMarkedGenerateTableViews(List<StorableObject> markedGenerateObjects, boolean markedGenerate) {
        Iterator setIterator = this.getTableViewSet().iterator();
        while (setIterator.hasNext()) {
            TableView tableView = (TableView)setIterator.next();
            if (tableView.isMarkedGenerate() != markedGenerate) continue;
            markedGenerateObjects.add(tableView);
        }
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if ("selectedRDBMSSite".equalsIgnoreCase(propertyName)) {
            RDBMSSite site = this.getDesign().getRDBMSSiteSet().getByObjectID(id);
            if (site == null) {
                site = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(this.getDesign().getAppView().getSettings());
            }
            return site;
        }
        return super.translateIdToObject(propertyName, id);
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        if ("selectedRDBMSSite".equalsIgnoreCase(propertyName) && object instanceof RDBMSSite) {
            return ((RDBMSSite)object).getObjectID();
        }
        return super.translateObjectToID(propertyName, object);
    }

    @Override
    public void doAfterExternalLoad() {
        this.doAfterLoad();
        if (this.getMainView() != null) {
            this.getMainView().getWorkSpace().updateSettings();
        }
        this.sortCollections();
    }

    public void openRelationalModel() {
        if (!this.isLoaded()) {
            this.getAppView().getXMLTransformationManager().openDesignPart(this);
            this.setLoaded(true);
        }
    }

    public StorageDesignSet getSorageDesigns() {
        return this.getStorageDesignFactory().getSorageDesigns();
    }

    @Override
    public List getObjectsWithMeasurements() {
        ArrayList<DesignObject> objects = new ArrayList<DesignObject>();
        Iterator it = this.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (table.getMeasurements().size() > 0) {
                objects.add(table);
            }
            for (Column column : Arrays.asList(table.getElements())) {
                if (column.getMeasurements().size() <= 0) continue;
                objects.add(column);
            }
        }
        it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            if (tableView.getMeasurements().size() > 0) {
                objects.add(tableView);
            }
            for (ColumnView columnView : Arrays.asList(tableView.getElements())) {
                if (columnView.getMeasurements().size() <= 0) continue;
                objects.add(columnView);
            }
        }
        it = this.getSchemaObjectSet().iterator();
        while (it.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)it.next();
            if (schemaObject.getMeasurements().size() <= 0) continue;
            objects.add(schemaObject);
        }
        it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fkIndexAssociation = (FKIndexAssociation)it.next();
            if (fkIndexAssociation.getMeasurements().size() <= 0) continue;
            objects.add(fkIndexAssociation);
        }
        it = this.getArcSet().iterator();
        while (it.hasNext()) {
            FKArc fkArc = (FKArc)it.next();
            if (fkArc.getMeasurements().size() <= 0) continue;
            objects.add(fkArc);
        }
        for (Index index : this.getGlobalIndexSet()) {
            if (index.getMeasurements().size() <= 0) continue;
            objects.add(index);
        }
        it = this.getTypeSubstitutionSet().iterator();
        while (it.hasNext()) {
            TypeSubstitution typeSubstitution = (TypeSubstitution)it.next();
            if (typeSubstitution.getMeasurements().size() <= 0) continue;
            objects.add(typeSubstitution);
        }
        it = this.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            if (note.getMeasurements().size() <= 0) continue;
            objects.add(note);
        }
        it = this.getImageObjectSet().iterator();
        while (it.hasNext()) {
            ImageObject image = (ImageObject)it.next();
            if (image.getMeasurements().size() <= 0) continue;
            objects.add(image);
        }
        return objects;
    }

    private void setTableListeners() {
        Iterator it = this.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            table.addQueryObjectListeners();
        }
    }

    private void setViewListeners() {
        Iterator it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            if (!view.isParsed()) continue;
            for (SQLNameHelper helper : view.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null) continue;
                desObj.addObjectListener(view);
            }
        }
    }

    public static void collectNeighbors(Table table, List list, int zones, boolean unlimited, int type) {
        int moreZones = --zones;
        Iterator it = type == 1 ? ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getParentTables(table).iterator() : (type == 2 ? ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getChildTables(table).iterator() : ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getRelatedTablesTo(table).iterator());
        while (it.hasNext()) {
            FKContainer other = (FKContainer)it.next();
            if (list.contains(other)) continue;
            list.add(other);
            if (!unlimited && moreZones <= 0 || !(other instanceof Table)) continue;
            RelationalDesign.collectNeighbors((Table)other, list, moreZones, unlimited, type);
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        if (this.extendedMap == null) {
            this.extendedMap = new RMExtendedMap(this.getDesign(), this);
            this.getDesign().getLogicalDesign().addDesignPartListener(this.extendedMap);
            this.addDesignPartListener(this.extendedMap);
        }
        return this.extendedMap;
    }

    public RMDeletedMap getRMDeletedMap() {
        if (this.deletedMap == null) {
            this.deletedMap = new RMDeletedMap(this.getRMExtendedMap(), this);
        }
        return this.deletedMap;
    }

    public RelationalDesign getRelatedSyncModel() {
        return this.relatedSyncModel;
    }

    public void setRelatedSyncModel(RelationalDesign relatedSyncModel) {
        this.relatedSyncModel = relatedSyncModel;
    }

    public void clearMappings() {
        this.getRMExtendedMap().clearMappings();
    }

    @Override
    public ArrayList<SearchDockable> getAllSearchDockables() {
        if (this.allSearchDockables == null) {
            this.allSearchDockables = new ArrayList();
        }
        return this.allSearchDockables;
    }

    @Override
    public void addSearchDockable(SearchDockable sd) {
        ArrayList<SearchDockable> list = this.getAllSearchDockables();
        if (!list.contains((Object)sd)) {
            list.add(sd);
        }
    }

    @Override
    public SearchDockable getLastNonPinnedSearchDockable() {
        SearchDockable lastOne = null;
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (((SearchPanel)sd.getGUI()).isPinned() || sd.getViewSequence() < currentSeq) continue;
            lastOne = sd;
        }
        return lastOne;
    }

    @Override
    public int getSearchDockableIdSequence() {
        int currentSeq = 0;
        for (SearchDockable sd : this.getAllSearchDockables()) {
            if (sd.getViewSequence() <= currentSeq) continue;
            currentSeq = sd.getViewSequence();
        }
        return currentSeq + 1;
    }

    @Override
    public void closeAllSearchDockables() {
        for (SearchDockable sd : this.getAllSearchDockables()) {
            sd.closeView(sd);
        }
        this.getAllSearchDockables().clear();
    }

    private RelationalDesign getOrCreateRelationalModel(String name, List newModels) {
        int result;
        RelationalDesign relModel = (RelationalDesign)this.getDesign().getRelationalDesigns().getByName(name);
        if (relModel != null && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("RelationalDesign.UseExistingModel"), name), Messages.getString("Design.Warning"), 0, 3)) == 1) {
            return null;
        }
        if (relModel == null) {
            relModel = this.getDesign().addRelationalDesign(name);
            relModel.setSelectedRDBMSSite(this.getSelectedRDBMSSite());
            newModels.add(relModel);
        }
        return relModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeRemoteObjects() {
        boolean old = ApplicationView.loading;
        try {
            DesignObject desObj;
            ApplicationView.loading = true;
            Iterator doIt = this.getSchemaObjectSet().iterator();
            while (doIt.hasNext()) {
                desObj = (DesignObject)doIt.next();
                desObj.updateFromRemoteObject(true);
            }
            doIt = this.getTableSet().iterator();
            while (doIt.hasNext()) {
                desObj = (DesignObject)doIt.next();
                try {
                    desObj.updateFromRemoteObject(true);
                }
                catch (Exception exception) {}
            }
            doIt = this.getTableViewSet().iterator();
            while (doIt.hasNext()) {
                desObj = (DesignObject)doIt.next();
                desObj.updateFromRemoteObject(true);
            }
            doIt = this.getFKIndexAssociationSet().iterator();
            while (doIt.hasNext()) {
                desObj = (FKIndexAssociation)doIt.next();
                desObj.updateFromRemoteObject(true);
            }
            this.executeTasks();
        }
        finally {
            ApplicationView.loading = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewModelsBasedOnSchemaNames(List schemas) {
        FKContainer newTable;
        FKContainer table;
        SchemaObject newSchema;
        HashMap<String, DesignObject> copiedMap;
        RelationalDesign relModel;
        String schemaName;
        SchemaObject schema;
        HashMap<String, RelationalDesign> relModels = new HashMap<String, RelationalDesign>();
        ArrayList newModels = new ArrayList();
        HashMap<String, String> ignoreRelModels = new HashMap<String, String>();
        ArrayList<FKContainer> origins = new ArrayList<FKContainer>();
        HashMap copiedMapsByRelModel = new HashMap();
        Iterator<Object> it = this.getTableSet().iterator();
        while (it.hasNext()) {
            Table table2 = (Table)it.next();
            schema = table2.getSchemaObject();
            if (schema == null || !schemas.contains(schema) || ignoreRelModels.get(schemaName = schema.getName()) != null) continue;
            relModel = (RelationalDesign)relModels.get(schemaName);
            if (relModel == null) {
                relModel = this.getOrCreateRelationalModel(schemaName, newModels);
                if (relModel == null) {
                    ignoreRelModels.put(schemaName, schemaName);
                    continue;
                }
                relModels.put(schemaName, relModel);
            }
            if ((copiedMap = (HashMap)copiedMapsByRelModel.get(relModel.getObjectID())) == null) {
                copiedMap = new HashMap<String, DesignObject>();
                copiedMapsByRelModel.put(relModel.getObjectID(), copiedMap);
            }
            if (relModel.getTableSet().getBySchemaAndName(schemaName, table2.getName()) != null) continue;
            Table newTable2 = relModel.createTable(table2.getName());
            origins.add(table2);
            copiedMap.put(table2.getObjectID(), newTable2);
            newSchema = (SchemaObject)relModel.getSchemaObjectSet().getByName(schemaName);
            table2.copy(null, newTable2, copiedMap, false, true);
            if (newSchema == null) {
                newSchema = newTable2.getSchemaObject();
                copiedMap.put(schema.getObjectID(), newSchema);
                if (!schema.isRemoteObject()) {
                    schema.setAllRemoteObjectIDsAndPath(newSchema);
                }
            }
            newTable2.setSchemaObject(newSchema);
            table2.setAllRemoteObjectIDsAndPath(newTable2);
            newTable2.addRemoteObjectListener(table2);
            table2.setDirty(true);
        }
        it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            schema = tableView.getSchemaObject();
            if (schema == null || !schemas.contains(schema) || ignoreRelModels.get(schemaName = schema.getName()) != null) continue;
            relModel = (RelationalDesign)relModels.get(schemaName);
            if (relModel == null) {
                relModel = this.getOrCreateRelationalModel(schemaName, newModels);
                if (relModel == null) {
                    ignoreRelModels.put(schemaName, schemaName);
                    continue;
                }
                relModels.put(schemaName, relModel);
            }
            if ((copiedMap = (HashMap<String, DesignObject>)copiedMapsByRelModel.get(relModel.getObjectID())) == null) {
                copiedMap = new HashMap<String, DesignObject>();
                copiedMapsByRelModel.put(relModel.getObjectID(), copiedMap);
            }
            if (relModel.getTableViewSet().getBySchemaAndName(schemaName, tableView.getName()) != null) continue;
            TableView newView = relModel.createTableView(tableView.getName());
            origins.add(tableView);
            copiedMap.put(tableView.getObjectID(), newView);
            tableView.copy(newView, copiedMap, false, true);
            newSchema = (SchemaObject)relModel.getSchemaObjectSet().getByName(schemaName);
            if (newSchema == null) {
                newSchema = relModel.createSchemaObject(schemaName);
                copiedMap.put(schema.getObjectID(), newSchema);
            }
            newView.setSchemaObject(newSchema);
            tableView.setRemoteObjectID(newView.getObjectID());
            tableView.setRemoteModelID(newView.getDesignPartId());
            tableView.setRemoteObjectRelativeStorageName(newView.getRelativeStorageName());
            newView.setUsedAsRemoteObject(true);
            newView.addRemoteObjectListener(tableView);
            tableView.setDirty(true);
        }
        for (Object e : origins) {
            if (!(e instanceof FKContainer) || (copiedMap = (HashMap<String, DesignObject>)copiedMapsByRelModel.get((table = (FKContainer)e).getRemoteModelID())) == null || (newTable = (FKContainer)copiedMap.get(table.getObjectID())) == null) continue;
            FKIndexAssociation[] fkeys = table.getFKAssociations();
            for (int i = 0; i < fkeys.length; ++i) {
                FKIndexAssociation oldFK = fkeys[i];
                FKContainer refTable = oldFK.getRemoteTable();
                FKContainer newRefTable = (FKContainer)copiedMap.get(refTable.getObjectID());
                FKContainer newRefOrigin = null;
                FKIndexAssociation newFK = null;
                if (newRefTable != null) {
                    if (table instanceof Table) {
                        newFK = ((Table)table).copyForeignKey((Table)newTable, oldFK, copiedMap);
                    } else if (table instanceof TableView) {
                        newFK = ((TableView)table).copyForeignKey((TableView)newTable, oldFK, copiedMap);
                    }
                } else {
                    if (refTable.isRemoteObject()) {
                        RelationalDesign rd = (RelationalDesign)this.getDesign().getRelationalDesigns().getObjectByID(refTable.getRemoteModelID());
                        if (rd != null && rd.isLoaded()) {
                            newRefOrigin = (FKContainer)this.getDesign().getDesignObject(refTable.getRemoteObjectID());
                        }
                    } else {
                        newRefOrigin = refTable;
                    }
                    if (newRefOrigin != null && newRefOrigin.getRelationalModel() != newTable.getRelationalModel()) {
                        SchemaObject sch;
                        FKContainer newRefCopy = null;
                        if (newRefOrigin instanceof TableView) {
                            newRefCopy = (TableView)newTable.getRelationalModel().getTableViewSet().getByRemoteObjectId(newRefOrigin.getObjectID());
                            if (newRefCopy == null) {
                                newRefCopy = newTable.getRelationalModel().createTableView(newRefOrigin.getName());
                            }
                        } else {
                            newRefCopy = (Table)newTable.getRelationalModel().getTableSet().getByRemoteObjectId(newRefOrigin.getObjectID());
                            if (newRefCopy == null) {
                                newRefCopy = newTable.getRelationalModel().createTable(newRefOrigin.getName());
                            }
                        }
                        if ((sch = refTable.getSchemaObject()) != null) {
                            SchemaObject newSchema2 = null;
                            if (sch.isRemoteObject()) {
                                newSchema2 = (SchemaObject)newTable.getRelationalModel().getSchemaObjectSet().getObjectByID(sch.getRemoteObjectID());
                                if (newSchema2 == null) {
                                    newSchema2 = (SchemaObject)newTable.getRelationalModel().getSchemaObjectSet().getObjectByRemoteObjectID(sch.getRemoteObjectID());
                                }
                            } else {
                                newSchema2 = (SchemaObject)newTable.getRelationalModel().getSchemaObjectSet().getObjectByRemoteObjectID(sch.getRemoteObjectID());
                            }
                            String schemaName2 = sch.getName();
                            if (newSchema2 == null) {
                                newSchema2 = (SchemaObject)newTable.getRelationalModel().getSchemaObjectSet().getByName(schemaName2);
                            }
                            if (newSchema2 == null) {
                                newSchema2 = newTable.getRelationalModel().createSchemaObject(schemaName2);
                                copiedMap.put(sch.getObjectID(), newSchema2);
                                if (sch.isRemoteObject()) {
                                    SchemaObject rsch = (SchemaObject)newTable.getDesign().getDesignObject(sch.getRemoteObjectID());
                                    if (rsch == null) {
                                        newSchema2.setRemoteObjectID(sch.getRemoteObjectID());
                                        newSchema2.setRemoteModelID(sch.getRemoteModelID());
                                        newSchema2.setRemoteDesignID(sch.getRemoteDesignID());
                                        newSchema2.setRemoteObjectRelativeStorageName(sch.getRemoteObjectRelativeStorageName());
                                    } else {
                                        newSchema2.setAllRemoteObjectIDsAndPath(rsch);
                                    }
                                } else {
                                    newSchema2.setAllRemoteObjectIDsAndPath(sch);
                                }
                            }
                            newRefCopy.setSchemaObject(newSchema2);
                        }
                        newRefCopy.setAllRemoteObjectIDsAndPath(newRefOrigin);
                        newRefOrigin.addRemoteObjectListener(newRefCopy);
                        copiedMap.put(newRefOrigin.getObjectID(), newRefCopy);
                        newRefOrigin.copy(newRefCopy, copiedMap, true);
                        if (table instanceof Table) {
                            newFK = ((Table)table).copyForeignKey((Table)newTable, oldFK, copiedMap);
                        } else if (table instanceof TableView) {
                            newFK = ((TableView)table).copyForeignKey((TableView)newTable, oldFK, copiedMap);
                        }
                    } else if (newRefOrigin == null || newRefOrigin.getRelationalModel() == newTable.getRelationalModel()) {
                        // empty if block
                    }
                }
                if (newFK == null) continue;
                copiedMap.put(oldFK.getObjectID(), newFK);
                oldFK.setAllRemoteObjectIDsAndPath(newFK);
                if (newFK.getSourceObject() == newFK.getTargetObject()) {
                    // empty if block
                }
                newFK.resetEdgeParams();
            }
        }
        for (Object e : origins) {
            if (!(e instanceof FKContainer) || (copiedMap = (HashMap)copiedMapsByRelModel.get((table = (FKContainer)e).getRemoteModelID())) == null || (newTable = (FKContainer)copiedMap.get(table.getObjectID())) == null) continue;
            for (FKArc oldArc : table.getArcs()) {
                ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
                for (FKIndexAssociation oldfk : oldArc.getFkeys()) {
                    FKIndexAssociation newfk = (FKIndexAssociation)copiedMap.get(oldfk.getObjectID());
                    if (newfk == null) continue;
                    list.add(newfk);
                }
                if (list.size() <= 1) continue;
                FKArc newArc = null;
                if (newArc == null) {
                    newArc = newTable.getRelationalModel().createArc();
                }
                int fkeys = newArc.getFkeys().size();
                newArc.setTable(newTable);
                oldArc.copy(newArc, null, false);
                for (FKIndexAssociation newfk : list) {
                    newArc.addFkey(newfk);
                }
                newTable.addArc(newArc);
                oldArc.setAllRemoteObjectIDsAndPath(newArc);
            }
        }
        it = relModels.keySet().iterator();
        while (it.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)relModels.get(it.next());
            relationalDesign.getUndoManager().setLocked(true);
            try {
                ((DPVRelational)relationalDesign.getMainView()).rearrangeNewDiagram();
                relationalDesign.createDefaultSelfReferencePoints();
                relationalDesign.setDirty(true);
            }
            finally {
                relationalDesign.getUndoManager().setLocked(false);
            }
        }
        this.getMainView().repaint();
        StorageDesign storageDesign = this.getStorageDesign();
        if (!storageDesign.isOpen()) {
            storageDesign.openStorageDesign();
            this.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(storageDesign);
        }
        for (String schema2 : relModels.keySet()) {
            RelationalDesign rd = (RelationalDesign)relModels.get(schema2);
            if (!newModels.contains(rd)) continue;
            StorageDesign targetSD = rd.getStorageDesign();
            if (!targetSD.isOpen()) {
                targetSD.openStorageDesign();
                targetSD.setTempModel(false);
            }
            Map copied = (Map)copiedMapsByRelModel.get(rd.getObjectID());
            try {
                this.getDesign().setCorrespondenceMap(copied);
                XMLToObjectTransformer.checkShouldMerge = true;
                storageDesign.cloneFromMemoryToAnotherSD_MD(targetSD, copied, false, schema2);
            }
            finally {
                XMLToObjectTransformer.checkShouldMerge = false;
                this.getDesign().setCorrespondenceMap(null);
                this.getAppView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(targetSD);
            }
        }
    }

    @Override
    public List getSearchableSets() {
        return this.getSearchableSets(false);
    }

    public List getSearchableSets(boolean global) {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Table.class), Table.class, this, this.getTableSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Column.class), Column.class, this, this.getColumnSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(ColumnView.class), ColumnView.class, this, this.getColumnViewSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(TableView.class), TableView.class, this, this.getTableViewSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(FKIndexAssociation.class), FKIndexAssociation.class, this, this.getFKIndexAssociationSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Index.class), Index.class, this, this.getPlainIndexes()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(PKProxyOraclev10g.class), Index.class, this, this.getPKIndexes()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(UniqueOraclev10g.class), Index.class, this, this.getUKIndexes()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(SchemaObject.class), SchemaObject.class, this, this.getSchemaObjectSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(FKArc.class), FKArc.class, this, this.getArcSet()));
        if (!global) {
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(LogicalDatatype.class), LogicalDatatype.class, this, this.design.getLogicalDatatypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(Domain.class), Domain.class, this, this.getDesign().getDomainSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(StructuredType.class), StructuredType.class, this, this.getDesign().getDataTypesDesign().getStructuredTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(CollectionType.class), CollectionType.class, this, this.getDesign().getDataTypesDesign().getCollectionTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(DistinctType.class), DistinctType.class, this, this.getDesign().getDataTypesDesign().getDistinctTypeSet()));
        }
        StorageDesign[] storageDesigns = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < storageDesigns.length; ++i) {
            StorageDesign sdo;
            StorageDesign sd = storageDesigns[i];
            if (!sd.isOpen()) continue;
            if (sd instanceof StorageDesignOraclev9i) {
                sdo = (StorageDesignOraclev9i)sd;
                sets.addAll(((StorageDesignOraclev9i)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignOraclev10g) {
                sdo = (StorageDesignOraclev10g)sd;
                sets.addAll(((StorageDesignOraclev10g)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignOraclev11g) {
                sdo = (StorageDesignOraclev11g)sd;
                sets.addAll(((StorageDesignOraclev11g)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignSqlServerv2k) {
                sdo = (StorageDesignSqlServerv2k)sd;
                sets.addAll(((StorageDesignSqlServerv2k)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignSqlServerv2k5) {
                sdo = (StorageDesignSqlServerv2k5)sd;
                sets.addAll(((StorageDesignSqlServerv2k5)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignDB2v70) {
                sdo = (StorageDesignDB2v70)sd;
                sets.addAll(((StorageDesignDB2v70)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignDB2v80) {
                sdo = (StorageDesignDB2v80)sd;
                sets.addAll(((StorageDesignDB2v80)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignUDBv71) {
                sdo = (StorageDesignUDBv71)sd;
                sets.addAll(((StorageDesignUDBv71)sdo).getSearchableSets());
                continue;
            }
            if (!(sd instanceof StorageDesignUDBv81)) continue;
            sdo = (StorageDesignUDBv81)sd;
            sets.addAll(((StorageDesignUDBv81)sdo).getSearchableSets());
        }
        return sets;
    }

    @Override
    protected List getObjectWichAllowClassificationTypes() {
        ArrayList list = new ArrayList();
        this.getTableSet().addAllElementsTo(list);
        return list;
    }

    public void createDefaultSelfReferencePoints() {
        Iterator it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (fk.getSourceObject() != fk.getTargetObject()) continue;
            fk.createDefaultSelfReferencePoints();
        }
    }

    public boolean isUseTemplateTable() {
        return this.useTemplateTable;
    }

    public void setUseTemplateTable(boolean useTemplateTable) {
        if (this.useTemplateTable != useTemplateTable) {
            this.setDirty(true);
        }
        this.useTemplateTable = useTemplateTable;
    }

    public Table getTemplateTable() {
        if (this.templateTable == null && this.templateTableID != null && !"".equals(this.templateTableID)) {
            this.templateTable = (Table)this.getTableSet().getObjectByID(this.templateTableID);
        }
        return this.templateTable;
    }

    public void setTemplateTable(Table templateTable) {
        if (this.templateTable != templateTable) {
            this.setDirty(true);
        }
        this.templateTable = templateTable;
        this.templateTableID = null;
    }

    public String getTemplateTableID() {
        if (this.templateTable != null) {
            return this.templateTable.getObjectID();
        }
        return this.templateTableID;
    }

    public void setTemplateTableID(String templateTableID) {
        this.templateTableID = templateTableID;
    }

    public void copyTemplateTable(Table templ, Table target) {
        for (Column scol : templ.getElementsCollection()) {
            Column tcol = (Column)target.getElementByName(scol.getName());
            if (tcol == null) {
                tcol = target.getColumnByProperty(TEMPLATE_COL_PROP, scol.getObjectID());
            }
            if (tcol == null) {
                tcol = target.createColumn();
            }
            scol.copy(tcol);
            tcol.setProperty(TEMPLATE_COL_PROP, scol.getObjectID());
        }
    }

    public KeyObject getViewIndexByMatchingColumns(String schema, String table, List<String> columns) {
        if (schema != null && table != null && !columns.isEmpty()) {
            Object[] keys = this.getPKUK(schema, table);
            for (int i = 0; i < keys.length; ++i) {
                FKElement[] keyColumns = (FKElement[])((KeyObject)keys[i]).getColumns();
                if (keyColumns.length != columns.size()) continue;
                boolean mismatch = false;
                for (int j = 0; j < columns.size(); ++j) {
                    if (columns.get(j).equalsIgnoreCase(keyColumns[j].getName())) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) continue;
                return (KeyObject)keys[i];
            }
        }
        return null;
    }

    public Object[] getPKUK(String schema, String tableName) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        FKContainer fkc = this.getTableSet().getBySchemaAndName(schema, tableName);
        if (fkc == null) {
            fkc = (FKContainer)this.getTableViewSet().getBySchemaAndName(schema, tableName);
        }
        if (fkc != null) {
            KeyObject[] keys = fkc.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].isPK() && !keys[i].isUnique()) continue;
                list.add(keys[i]);
            }
        }
        return list.toArray();
    }

    public Object[] getAllViewsPKUK() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            KeyObject[] keys = view.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].isPK() && !keys[i].isUnique()) continue;
                list.add(keys[i]);
            }
        }
        return list.toArray();
    }

    public void addERDEditorListener(ERDEditorListener listener) {
        this.erdEditorListeners.add(listener);
    }

    public void removeERDEditorListener(ERDEditorListener listener) {
        this.erdEditorListeners.remove(listener);
    }

    public void clearERDEditorListeners() {
        this.erdEditorListeners.clear();
    }

    public void updateERDEditors() {
        Object[] array = this.erdEditorListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                ((ERDEditorListener)array[i]).updateEditor();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IndexAndConstraintNameController getIndexAndConstraintNameController() {
        if (this.indexAndConstraintNameController == null) {
            this.indexAndConstraintNameController = new IndexAndConstraintNameController();
        }
        return this.indexAndConstraintNameController;
    }

    public void setIndexAndConstraintNameController(IndexAndConstraintNameController indexAndConstraintNameController) {
        this.indexAndConstraintNameController = indexAndConstraintNameController;
    }

    public NameSpaceController getTablesAndViewsNameController() {
        if (this.tablesAndViewsNameController == null) {
            this.tablesAndViewsNameController = new NameSpaceController();
        }
        return this.tablesAndViewsNameController;
    }

    public RelationalDesignEstimates getRelationalDesignEstimates() {
        return this.relationalDesignEstimates;
    }

    public void createArcsFromTableCheckConstraints() {
        Iterator it = this.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            ArrayList oldArcs = new ArrayList();
            oldArcs.addAll(table.getArcs());
            Object[] tchecks = table.getCheckConstraints().toArray();
            for (int i = 0; i < tchecks.length; ++i) {
                TableLevelConstraint tch = (TableLevelConstraint)tchecks[i];
                FKArc arc = tch.createArcFromConstraint();
                if (arc == null) continue;
                tch.remove();
                table.setDirty(true);
                if (!oldArcs.contains(arc)) {
                    arc.setName(tch.getName());
                    continue;
                }
                arc.setDirty(true);
            }
        }
    }

    public List getContainersWithPK_UK_Constraints() {
        FKContainer cont;
        ArrayList<FKContainer> list = new ArrayList<FKContainer>();
        Iterator it = this.getTableSet().iterator();
        while (it.hasNext()) {
            cont = (FKContainer)it.next();
            if (!cont.hasPKorUK_Constraint()) continue;
            list.add(cont);
        }
        it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            cont = (FKContainer)it.next();
            if (!cont.hasPKorUK_Constraint()) continue;
            list.add(cont);
        }
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        return list;
    }

    public Map getPluralsMap() {
        if (this.pluralsMap == null) {
            try {
                String filePath = ApplicationView.basePath + "/templates/plurals.csv";
                this.pluralsMap = new TreeMap();
                File file = new File(filePath);
                if (file.exists()) {
                    LogicalDesign.loadPlurals(this.pluralsMap, file, true);
                }
            }
            catch (Exception e) {
                this.pluralsMap = new TreeMap();
            }
        }
        return this.pluralsMap;
    }

    public String getSingularName(String plural) {
        String pl = plural.toUpperCase();
        NamingStandardRule namingRule = this.getDesign().getNamingStandardRule();
        try {
            for (Glossary glossary : namingRule.getGlossaries()) {
                String singular = glossary.getNameByPlural(pl);
                if (singular == null) continue;
                return singular;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)this.getPluralsMap().get(pl);
    }

    public Map getContainersMap() {
        DesignObject dob;
        HashMap<String, DesignObject> map = new HashMap<String, DesignObject>(this.getTableSet().size() + this.getTableViewSet().size());
        Iterator it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            dob = (DesignObject)it.next();
            map.put(dob.getLongName().toUpperCase(), dob);
        }
        it = this.getTableSet().iterator();
        while (it.hasNext()) {
            dob = (DesignObject)it.next();
            map.put(dob.getLongName().toUpperCase(), dob);
        }
        return map;
    }

    public void parseSQLInViewsAndTables() {
        ArrayList list = new ArrayList();
        this.getTableSet().addAllElementsTo(list);
        this.getTableViewSet().addAllElementsTo(list);
        this.parseSQLInObjects(list);
    }

    public void parseSQLInObjects(List objects) {
        Map containers = this.getContainersMap();
        System.out.println(System.currentTimeMillis());
        TimeLog.log("begin parsing of ");
        for (Object obj : objects) {
            DesignObject dobj;
            String schema;
            List<SQLAnalyzer.PDescriptor> list;
            String sel;
            int size;
            int c;
            if (obj instanceof TableView) {
                TableView view = (TableView)obj;
                c = 0;
                size = view.getElementsCollection().size();
                sel = view.getSelectDef();
                if (sel == null || sel.isEmpty()) {
                    sel = view.getUserDefinedSQL();
                }
                list = SQLAnalyzer.getTablesAndColumns(sel, view.getSchema(), containers);
                for (SQLAnalyzer.PDescriptor pd : list) {
                    schema = pd.schema;
                    if (schema == null || schema.isEmpty()) {
                        schema = view.getSchema();
                    }
                    if (schema != null && schema.isEmpty()) {
                        schema = null;
                    }
                    if (schema != null) {
                        schema = schema.toUpperCase();
                    }
                    if (!"DUAL".equalsIgnoreCase(pd.name) && "table".equalsIgnoreCase(pd.type)) {
                        view.addToSQLNames(schema, pd.name.toUpperCase(), null, containers);
                        continue;
                    }
                    if (!"column".equalsIgnoreCase(pd.type) || (dobj = view.addToSQLNames(schema, pd.table.toUpperCase(), pd.name.toUpperCase(), containers)) == null || !"11".equals(pd.query_block_id) || c >= size) continue;
                    AbstractViewElement co = (AbstractViewElement)view.getElement(c);
                    ++c;
                    if (dobj instanceof Column) {
                        co.setReferencedColumn((ContainedObjectWithDomain)dobj);
                        continue;
                    }
                    if (!(dobj instanceof ColumnView)) continue;
                    co.setReferencedColumnView((FKElement)dobj);
                }
                view.setParsed(true);
                continue;
            }
            if (!(obj instanceof Table)) continue;
            Table table = (Table)obj;
            c = 0;
            size = table.getElementsCollection().size();
            sel = table.getUserDefinedSQL();
            if (!table.isMaterializedQueryTable() || sel == null || sel.isEmpty()) continue;
            list = SQLAnalyzer.getTablesAndColumns(sel, table.getSchema(), containers);
            for (SQLAnalyzer.PDescriptor pd : list) {
                schema = pd.schema;
                if (schema == null || schema.isEmpty()) {
                    schema = table.getSchema();
                }
                if (schema != null && schema.isEmpty()) {
                    schema = null;
                }
                if (schema != null) {
                    schema = schema.toUpperCase();
                }
                if (!"DUAL".equalsIgnoreCase(pd.name) && "table".equalsIgnoreCase(pd.type)) {
                    table.addToSQLNames(schema, pd.name.toUpperCase(), null, containers);
                    continue;
                }
                if (!"column".equalsIgnoreCase(pd.type) || (dobj = table.addToSQLNames(schema, pd.table.toUpperCase(), pd.name.toUpperCase(), containers)) == null || !"11".equals(pd.query_block_id) || c >= size) continue;
                ContainedObject contObj = table.getElement(c);
                ++c;
                if (!(contObj instanceof AbstractViewElement)) continue;
                AbstractViewElement co = (AbstractViewElement)contObj;
                if (dobj instanceof Column) {
                    co.setReferencedColumn((ContainedObjectWithDomain)dobj);
                    continue;
                }
                if (!(dobj instanceof ColumnView)) continue;
                co.setReferencedColumnView((FKElement)dobj);
            }
            table.setParsed(true);
        }
        TimeLog.log("end parsing ");
        System.out.println(System.currentTimeMillis());
    }

    public void resolveFKs() {
        Iterator it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            String[] cs;
            KeyObject key;
            String cols;
            String lname;
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (fk.getRemoteTable() != null || (lname = fk.getReferredTableLongName()) == null || lname.isEmpty()) continue;
            FKContainer table = (FKContainer)this.getTableSet().getByLongName(lname);
            if (table == null) {
                table = (FKContainer)this.getTableViewSet().getByLongName(lname);
            }
            if (table == null || (cols = fk.getReferredColumnNames()) == null || cols.isEmpty() || (key = table.getPk_UK_forColumns(cs = cols.split(","))) == null) continue;
            fk.setKeyObject(key);
            if (fk.getLocalFKIndex() != null && fk.getLocalFKIndex().getElementsCollection().size() > 0) {
                FKElement[] elems = fk.getLocalFKIndex().getElementsCollection().toArray(new FKElement[0]);
                fk.swapFKColumnsWith(elems);
            }
            fk.setDirty(true);
            fk.addToAllDPVs();
        }
    }

    public boolean isUseConnectionUser() {
        return this.useConnectionUser;
    }

    public void setUseConnectionUser(boolean useConnectionUser) {
        if (this.useConnectionUser != useConnectionUser && !this.getDesign().isLoading()) {
            this.setDirty(true);
        }
        this.useConnectionUser = useConnectionUser;
    }

    @Override
    public void clearAdditiveCollections() {
        this.getImportConnectionStamps().clear();
    }

    public boolean removeDuplicatedConnections() {
        DBConnectionStamp[] conns = this.importConnectionStamps.toArray(new DBConnectionStamp[0]);
        int size = this.importConnectionStamps.size();
        this.importConnectionStamps.clear();
        for (DBConnectionStamp st : conns) {
            if (this.hasWithSamePersitence(this.importConnectionStamps, st)) continue;
            this.importConnectionStamps.add(st);
        }
        return size != this.importConnectionStamps.size();
    }

    private boolean hasWithSamePersitence(List<DBConnectionStamp> list, DBConnectionStamp obj) {
        for (DBConnectionStamp st : list) {
            if (!obj.hasEqualPersistence(st)) continue;
            return true;
        }
        return false;
    }

    public class ColumnPlaceHolder
    extends DesignObjectPlaceHolder {
        public ColumnPlaceHolder(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getLongName();
        }
    }
}

