/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.storage.AbstractRDBMSObject;
import oracle.dbtools.crest.model.design.storage.ConstraintType;

public class RDBMSType
extends AbstractRDBMSObject
implements ConstraintType {
    private String[] acceptableDatatypeEncodings = null;
    private String manufacturerName;
    private String productName;
    private String versionName;
    private String storageDesignClassName;
    private String longName;
    private RDBMSType parentType;
    private int type = 0;

    public RDBMSType(String manufacturerName, String productName, String versionName, String storageDesignClassName, int type, boolean separateVersion) {
        this.manufacturerName = manufacturerName;
        this.productName = productName;
        this.versionName = versionName;
        this.storageDesignClassName = storageDesignClassName;
        StringBuffer buffer = new StringBuffer();
        buffer.append(productName);
        if (separateVersion) {
            buffer.append(" ");
        }
        buffer.append(versionName);
        this.longName = buffer.toString();
        this.type = type;
    }

    public RDBMSType(String manufacturerName, String productName, String versionName, String storageDesignClassName, int type) {
        this(manufacturerName, productName, versionName, storageDesignClassName, type, true);
    }

    public void setAcceptableDatatypeEncodings(String[] array) {
        this.acceptableDatatypeEncodings = array;
    }

    public String[] getAcceptableDatatypeEncodings() {
        return this.acceptableDatatypeEncodings;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getStorageDesignClassName() {
        return this.storageDesignClassName;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getName() {
        return this.getLongName();
    }

    public String toString() {
        return this.getLongName();
    }

    @Override
    public String getTypeName() {
        return this.getLongName();
    }

    @Override
    public RDBMSType getParentType() {
        return this.parentType;
    }

    @Override
    public void setParentType(RDBMSType type) {
        this.parentType = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isOfType(RDBMSType dbType) {
        if (this == dbType) {
            return true;
        }
        if (this.parentType != null) {
            return this.parentType.isOfType(dbType);
        }
        return false;
    }
}

