/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.MethodProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TypeElementProxy;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class StructuredTypeProxy
extends RelationalObjectProxy
implements RelationalObjectProxySetListener {
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection elements;
    protected StorageObjectCollection methods;
    public static final String TYPE_NAME = "SType";

    public StructuredTypeProxy(StructuredType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
        this.initElementsAndMethods(storageDesign);
    }

    public StructuredTypeProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initElementsAndMethods(storageDesign);
    }

    private void initElementsAndMethods(StorageDesign storageDesign) {
        this.elements = new StorageObjectCollection();
        this.elements.setParent(this);
        this.elements.setName(Messages.getString("StructuredTypeProxy.Attributes"));
        this.elements.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.methods = new StorageObjectCollection();
        this.methods.setParent(this);
        this.methods.setName(Messages.getString("StructuredTypeProxy.Methods"));
        this.methods.setIcon(GUIConfiguration.getInstance().getIcon("METHOD_ICON", 16));
        storageDesign.getTypeElementProxySet();
        storageDesign.getMethodProxySet();
        this.addTypeElementProxiesFromDesign();
        this.addMethodProxiesFromDesign();
        storageDesign.getTypeElementProxySet().addSetListener(this);
        storageDesign.getMethodProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return "Structure Type";
    }

    public StructuredType getStructuredType() {
        return (StructuredType)this.getObject();
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    @Override
    public String getComment() {
        if (this.isCommentChanged()) {
            return super.getComment();
        }
        return this.getObject().getComment();
    }

    @Override
    public void setComment(String comment) {
        if (!comment.equals(this.getObject().getComment())) {
            super.setComment(comment);
            this.setCommentChanged(true);
        } else {
            this.setCommentChanged(false);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.elements;
            }
            case 1: {
                return this.methods;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.elements) {
            return 0;
        }
        if (child == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.elements) {
            return 0;
        }
        if (child == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TypeElementProxy) {
                TypeElementProxy tep = (TypeElementProxy)event.getAffected();
                if (this.getObject() == tep.getStructuredType()) {
                    tep.setParent(this.elements);
                    this.elements.add(event.getAffected());
                }
            } else if (event.getAffected() instanceof MethodProxy) {
                MethodProxy mp = (MethodProxy)event.getAffected();
                if (this.getObject() == mp.getStructuredType()) {
                    mp.setParent(this.methods);
                    this.methods.add(event.getAffected());
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TypeElementProxy) {
                TypeElementProxy tep = (TypeElementProxy)event.getAffected();
                this.elements.remove(tep.getObject().getObjectID());
            } else if (event.getAffected() instanceof MethodProxy) {
                MethodProxy mp = (MethodProxy)event.getAffected();
                this.methods.remove(mp.getObject().getObjectID());
            }
        }
    }

    private void addTypeElementProxiesFromDesign() {
        for (TypeElement typeElement : this.getStructuredType().getAttributesList()) {
            TypeElementProxy typeElementProxy = (TypeElementProxy)this.getStorageDesign().getStorageObject(typeElement.getObjectID());
            if (typeElementProxy == null) continue;
            typeElementProxy.setParent(this.elements);
            this.elements.addWithoutCheck(typeElementProxy);
        }
    }

    private void addMethodProxiesFromDesign() {
        for (Method method : this.getStructuredType().getMethodsList()) {
            MethodProxy methodProxy = (MethodProxy)this.getStorageDesign().getStorageObject(method.getObjectID());
            if (methodProxy == null) continue;
            methodProxy.setParent(this.methods);
            this.methods.addWithoutCheck(methodProxy);
        }
    }

    public StorageObjectCollection getElements() {
        return this.elements;
    }

    public StorageObjectCollection getMethods() {
        return this.methods;
    }

    public boolean hasParentType() {
        return this.getStructuredType().getParentType() != null;
    }

    public StructuredTypeProxy getParentType() {
        if (this.hasParentType()) {
            return (StructuredTypeProxy)this.getStorageDesign().getProxy(this.getStructuredType().getParentType());
        }
        return null;
    }

    public TypeElementProxy getElementByDesignObject(DesignObject object) {
        for (TypeElementProxy pr : this.elements) {
            if (pr.getObject() != object) continue;
            return pr;
        }
        return null;
    }

    public StorageObject getSchemaOrUser() {
        return null;
    }
}

