/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class TableProxy
extends RelationalContainerProxy
implements RelationalObjectProxySetListener,
StorageObjectListener {
    public static final ObjectChangeEvent TABLESPACE_CHANGED = new ObjectChangeEvent("Tablespace changed");
    private boolean generatePK = true;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection columns;
    protected StorageObjectCollection indexes;
    protected StorageObjectCollection integrityIndexes;
    public static String NONE = "None";
    public static String BACKUP_RENAME = "Rename";
    public static String BACKUP_UNLOAD = "Unload";
    public static String BACKUP_UNLOAD_PARTITION = "Unload per partition";
    public static String RESTORE = "Restore";
    private String restoreOption = RESTORE;
    private String backupOption = BACKUP_RENAME;
    public static final String NAME_SUBSTITUTION_TYPE = "Table";

    public TableProxy(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.integrityIndexes = new StorageObjectCollection();
        this.integrityIndexes.setParent(this);
        this.integrityIndexes.setName(Messages.getString("TableProxy.IntegrityIndexes"));
        this.columns = new StorageObjectCollection();
        this.columns.setParent(this);
        this.columns.setName(Messages.getString("TableProxy.Columns"));
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.indexes = new StorageObjectCollection();
        this.indexes.setParent(this);
        this.indexes.setName(Messages.getString("TableProxy.Indexes"));
        this.indexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addColumnProxyFromDesign(storageDesign.getColumnProxySet());
        this.addIndexProxyFromDesign(storageDesign.getIndexProxySet());
        storageDesign.getIndexProxySet().addSetListener(this);
    }

    public TableProxy(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.integrityIndexes = new StorageObjectCollection();
        this.integrityIndexes.setParent(this);
        this.integrityIndexes.setName("Integrity Indexes");
        this.columns = new StorageObjectCollection();
        this.columns.setParent(this);
        this.columns.setName("Columns");
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.indexes = new StorageObjectCollection();
        this.indexes.setParent(this);
        this.indexes.setName("Indexes");
        this.indexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addColumnProxyFromDesign(storageDesign.getColumnProxySet());
        this.addIndexProxyFromDesign(storageDesign.getIndexProxySet());
        storageDesign.getIndexProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    public String getPKName() {
        KeyObject pk;
        Table table = (Table)this.getObject();
        if (table != null && (pk = table.getPK()) != null) {
            IndexProxy pkProxy;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign instanceof StorageDesignOracle && (pkProxy = (IndexProxy)((StorageDesignOracle)storageDesign).getPKProxySet().getProxy(pk.getObjectID())) != null) {
                return pkProxy.getName();
            }
            return pk.getName();
        }
        return "";
    }

    public void setPKName(String name) {
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public IndexProxy[] getIndexProxies() {
        KeyObject[] keys = ((Table)this.getObject()).getKeys();
        ArrayList<IndexProxy> list = new ArrayList<IndexProxy>();
        for (int i = 0; i < keys.length; ++i) {
            IndexProxy ip = (IndexProxy)this.getStorageDesign().getIndexProxySet().getProxy(keys[i].getObjectID());
            if (ip == null) continue;
            list.add(ip);
        }
        return list.toArray(new IndexProxy[0]);
    }

    @Override
    public ColumnProxy[] getColumnProxies() {
        return super.getColumnProxies();
    }

    @Override
    public ColumnProxy getColumnProxy(String id) {
        return super.getColumnProxy(id.trim());
    }

    public ColumnProxy[] getColumnAndNestedColumnProxies() {
        ContainedObject[] columns = ((ContainerObject)this.getObject()).getElementsAndNestedElements();
        ColumnProxy[] array = new ColumnProxy[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            array[i] = super.getColumnProxy(columns[i].getObjectID());
        }
        return array;
    }

    public void setGeneratePK(boolean value) {
        this.generatePK = value;
    }

    public boolean getGeneratePK() {
        return this.generatePK;
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        IndexProxy ip;
        if (event.isType(1)) {
            IndexProxy ip2;
            if (event.getAffected() instanceof IndexProxy && !((Index)(ip2 = (IndexProxy)event.getAffected()).getObject()).isFK() && this.getObject() == ((Index)ip2.getObject()).getContainerWithKeyObject()) {
                ip2.setParent(this.indexes);
                this.indexes.add(ip2);
            }
        } else if (event.isType(0) && event.getAffected() instanceof IndexProxy && this.indexes.contains(ip = (IndexProxy)event.getAffected())) {
            this.indexes.remove(event.getAffected());
        }
    }

    protected void addColumnProxyFromDesign(RelationalObjectProxySet set) {
        ColumnProxy cp;
        StorageObject obj;
        Table table = (Table)this.getObject();
        StorageDesign storageDesign = set.getStorageDesign();
        for (Column column : table.getElementsCollection()) {
            obj = storageDesign.getStorageObject(column.getObjectID());
            if (!(obj instanceof ColumnProxy)) continue;
            cp = (ColumnProxy)obj;
            cp.setParent(this.columns);
            this.columns.addWithoutCheck(cp);
            if (cp.getTableProxyR() != null) continue;
            cp.setTableProxyW(this);
        }
        for (Column column : table.getNestedElements()) {
            obj = storageDesign.getStorageObject(column.getObjectID());
            if (!(obj instanceof ColumnProxy)) continue;
            cp = (ColumnProxy)obj;
            cp.setParent(this.columns);
            this.columns.addWithoutCheck(cp);
            if (cp.getTableProxyR() != null) continue;
            cp.setTableProxyW(this);
        }
    }

    ColumnProxy getAndRemoveColumnProxy(List columns, Column column) {
        for (int i = columns.size() - 1; i > -1; --i) {
            ColumnProxy cp = (ColumnProxy)columns.get(i);
            if (cp.getObject() != column) continue;
            columns.remove(i);
            return cp;
        }
        return null;
    }

    protected void addIndexProxyFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexProxy ip = (IndexProxy)it.next();
            Index index = (Index)ip.getObject();
            Table table = (Table)this.getObject();
            if (index.isFK() || index.isPK() || index.isUnique() || table != index.getContainerWithKeyObject()) continue;
            ip.addObjectListener(this);
            ip.setParent(this.indexes);
            this.indexes.addWithoutCheck(ip);
        }
    }

    protected void addIndexProxyWithoutCheck(IndexProxy ind) {
        ind.setParent(this.indexes);
        this.indexes.addWithoutCheck(ind);
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.columns;
            }
            case 1: {
                return this.indexes;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.columns) {
            return 0;
        }
        if (child == this.indexes) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.columns) {
            return 0;
        }
        if (child == this.indexes) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean commentChanged) {
        this.commentChanged = commentChanged;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean commentInRDBMSChanged) {
        this.commentInRDBMSChanged = commentInRDBMSChanged;
    }

    public ColumnProxy getColumnProxyByName(String name) {
        ColumnProxy[] columns = name.indexOf(46) > -1 ? this.getColumnAndNestedColumnProxies() : this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxy cpo = columns[i];
            if (!name.equalsIgnoreCase(cpo.getName())) continue;
            return cpo;
        }
        return null;
    }

    public StorageObject getUserSchema() {
        return null;
    }

    public void setUserSchema(String schema) {
    }

    public StorageObjectCollection getIndexes() {
        return this.indexes;
    }

    public boolean isUnload() {
        return false;
    }

    public boolean isUnloadPerPartition() {
        return false;
    }

    public String getRestoreOption() {
        return this.restoreOption;
    }

    public void setRestoreOption(String restoreOption) {
        this.restoreOption = restoreOption;
    }

    public String getBackupOption() {
        return this.backupOption;
    }

    public void setBackupOption(String backupOption) {
        this.backupOption = backupOption;
    }

    public void addObject(StorageObject sto) {
        if (sto instanceof ColumnProxy) {
            ColumnProxy cp = (ColumnProxy)sto;
            if (this.getObject() == ((Column)cp.getObject()).getContainerWithKeyObject()) {
                cp.setParent(this.columns);
                this.columns.add(sto);
            }
        }
    }

    public void removeObject(StorageObject sto) {
        if (sto instanceof ColumnProxy) {
            this.columns.remove(sto);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16);
    }

    public List getSAC_StorageObjects() {
        return Collections.EMPTY_LIST;
    }

    public List getColumnsSortedByID() {
        if (this.columns.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList();
        this.columns.addAllElementsTo(list);
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public StorageObjectCollection getColumns() {
        return this.columns;
    }

    public StorageObjectCollection getTriggers() {
        return null;
    }

    public String getSchemaImplementationName() {
        if (this.getStorageDesign().isOpen()) {
            SchemaObject schemaObject;
            StorageObject so = this.getUserSchema();
            if (so != null && !"[Implicit]".equalsIgnoreCase(so.getName())) {
                return so.getName();
            }
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null && (schemaObject = co.getSchemaObject()) != null) {
                return this.getStorageDesign().getSchemaImplementationNane(schemaObject);
            }
        } else {
            SchemaObject schemaObject;
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null && (schemaObject = co.getSchemaObject()) != null) {
                return schemaObject.getName();
            }
        }
        return "";
    }

    public ModelIDObject getSchemaImplementingObject() {
        if (this.getStorageDesign().isOpen() || this.getStorageDesign().isLoading()) {
            SchemaObject schemaObject;
            StorageObject so = this.getUserSchema();
            if (so != null) {
                return so;
            }
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null && (schemaObject = co.getSchemaObject()) != null) {
                return this.getStorageDesign().getUserSchemaSet().getBySchemaObject(schemaObject);
            }
        } else {
            ContainerObject co = (ContainerObject)this.getObject();
            if (co != null) {
                return co.getSchemaObject();
            }
        }
        return null;
    }

    public static void clearEvents() {
        TABLESPACE_CHANGED.setAffected(null);
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    public Table getTable() {
        DesignObject table = this.getObject();
        if (table != null && table instanceof Table) {
            return (Table)table;
        }
        return null;
    }
}

