/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlSourceURLStreamHandlerFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StoredProcedurePropertyDialogOraclev9i;

public class StoredProcedureOracle
extends PlSqlSourceStorageObjectOracle
implements IStoredProcedure {
    protected String body;
    protected StorageObjectCollection synonyms;

    public StoredProcedureOracle(StorageDesign storageDesign, String id, String name) {
        super(storageDesign, id, name);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    private void initStorageObjects(StorageDesignOracle storageDesign) {
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(storageDesign.getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(StoredProcedureOracle.class);
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        this.addSynonymsFromDesign(storageDesign.getSynonymSet());
    }

    @Override
    protected DefaultPropertyDialogOracle createPropertyDialog() {
        return new StoredProcedurePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PROCEDURE_ICON", 16);
    }

    @Override
    public String getObjectTypeName() {
        return "StProc";
    }

    @Override
    public String getOldObjectTypeName() {
        return "StoredProcedure";
    }

    @Override
    public String getIDPrefix() {
        return "Proc";
    }

    @Override
    public String getBody() {
        return this.getSource();
    }

    @Override
    public void setBody(String body) {
        this.setSource(body);
    }

    @Override
    protected URL getUrl() {
        return PlSqlSourceURLStreamHandlerFactory.generateUrl("file", this);
    }

    @Override
    public String getTypeName() {
        return "PROCEDURE";
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.remove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        int size = this.synonyms.size();
        this.synonyms.add(syn);
        if (this.synonyms.size() > size) {
            this.setDirty(true);
        }
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            syn.setParent(this.synonyms);
            this.synonyms.add(syn);
        }
    }
}

