/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.TemporaryTablespacePropertyDialogOracle;

public class TemporaryTablespaceOracle
extends AbstractStorageObjectOracle {
    private static final String[] SWITCH_STATES = new String[]{"ON", "OFF"};
    public static final String UNLIMITED = "UNLIMITED";
    private String filename = "";
    private long size = 0L;
    private String measureUnitSize = ConstantsOracle.UNITS_CHOICES[1];
    private String measureUnitUniformSize = ConstantsOracle.UNITS_CHOICES[1];
    private String reuse = "NO";
    private static Set switchSet = null;
    private String autoextend = SWITCH_STATES[0];
    private int nextBlockSize = 1;
    private String maxSize = "UNLIMITED";
    private long uniformSize = 0L;
    public static final String TYPE_NAME = "TmpTSpace";
    public static final String OLD_TYPE_NAME = "TemporaryTablespace";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TemporaryTablespacePropertyDialogOracle dialog = new TemporaryTablespacePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "TempTS";
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setReuse(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.reuse = value;
            this.fireDataFieldChange();
        }
    }

    public String getReuse() {
        return this.reuse;
    }

    public static String[] getSwitchChoices() {
        return SWITCH_STATES;
    }

    protected boolean checkSwitch(String value) {
        if (switchSet == null) {
            switchSet = new HashSet();
            switchSet.addAll(Arrays.asList(TemporaryTablespaceOracle.getSwitchChoices()));
        }
        return switchSet.contains(value);
    }

    public void setMeasureUnitSize(String value) {
        if (ConstantsOracle.checkUnit(value)) {
            this.measureUnitSize = value;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnitSize() {
        return this.measureUnitSize;
    }

    public String getMeasureUnitUniformSize() {
        return this.measureUnitUniformSize;
    }

    public void setMeasureUnitUniformSize(String measureUnitUniformSize) {
        if (ConstantsOracle.checkUnit(measureUnitUniformSize)) {
            this.measureUnitUniformSize = measureUnitUniformSize;
            this.fireDataFieldChange();
        }
    }

    public void setAutoextend(String value) {
        if (this.checkSwitch(value)) {
            this.autoextend = value;
            this.fireDataFieldChange();
        }
    }

    public String getAutoextend() {
        return this.autoextend;
    }

    public int getNextBlockSize() {
        return this.nextBlockSize;
    }

    public void setNextBlockSize(int nextBlockSize) {
        this.nextBlockSize = nextBlockSize;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String value) {
        try {
            this.maxSize = Integer.parseInt(value) > 0 ? value : UNLIMITED;
        }
        catch (NumberFormatException E) {
            this.maxSize = UNLIMITED;
        }
    }

    public static List getMeasureUnitValues() {
        return Arrays.asList(ConstantsOracle.UNITS_CHOICES);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getUniformSize() {
        return this.uniformSize;
    }

    public void setUniformSize(long uniformSize) {
        this.uniformSize = uniformSize;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }
}

