/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;

public class IndexColumnPreserver {
    private Column column;
    private String id;
    private String ind_id;
    private Table table;
    private int position;
    private RelationalDesign phdes;
    private List fk_col_preservers = new ArrayList();
    private Index index;
    private String sortOrder;

    public IndexColumnPreserver(Index index, Column oldColumn) {
        this.phdes = (RelationalDesign)oldColumn.getDesignPart();
        this.index = index;
        this.ind_id = index.getObjectID();
        this.table = (Table)index.getContainerWithKeyObject();
        this.preserve(oldColumn);
    }

    private void preserve(Column oldColumn) {
        this.column = oldColumn;
        this.id = this.column.getObjectID();
        this.position = this.index.getIndexOf(oldColumn);
        this.sortOrder = this.index.getColumnSortOrder(oldColumn);
        if (this.index.isPK() || this.index.isUnique()) {
            Collection fkeys = this.phdes.getFKIndexAssociationSet().getAssociationsWith(this.index);
            for (FKIndexAssociation fk : fkeys) {
                Column fk_colum = (Column)fk.getColumnForDelegate(oldColumn);
                if (fk_colum == null) continue;
                FKColumnPreserver fpres = new FKColumnPreserver();
                fpres.preserve(fk_colum);
                this.fk_col_preservers.add(fpres);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Index nindex = (Index)this.table.getKeySet().getObjectByID(this.ind_id);
        if (nindex == null) {
            throw new RuntimeException("IndexColumnPreserver.restore() - Index " + this.index.getName() + " cannot be found in Table " + this.table.getName());
        }
        this.index = nindex;
        Column newColumn = (Column)this.table.getElementByID(this.id);
        if (newColumn == null) {
            throw new RuntimeException("IndexColumnPreserver.restore() - Column " + this.column.getLongName() + " cannot be restored in Index " + this.index.getName());
        }
        Column col = (Column)this.index.getElementByID(this.id);
        if (col == null) {
            try {
                this.index.getDesign().setPropagatePKChahges(false);
                this.index.add(newColumn);
            }
            finally {
                this.index.getDesign().setPropagatePKChahges(true);
            }
            col = newColumn;
        }
        this.index.moveToIndex(col, this.position);
        this.index.setColumnSortOrder(col, this.sortOrder);
        for (FKColumnPreserver fpres : this.fk_col_preservers) {
            fpres.restore();
        }
    }
}

