/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRFlowWithoutInfoStructures
extends DesignRule {
    private final String RULE_ID = "8FE3C2EB-5E76-AD60-1B3D-0D4927A42B7F";

    public DRFlowWithoutInfoStructures() {
        this.setName(Messages.getString("DRFlowWithoutInfoStructures.IdentifyFlowsWithoutInformationStructures"));
        this.setDescription(Messages.getString("DRFlowWithoutInfoStructures.FlowFromToPrimitiveProcessShouldHaveInformationStructures"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Flow flow = (Flow)object;
        if (!flow.isConnecedTotCompositeProc() && !flow.isConnectedToExternaAgent() && flow.getInfoStructures().size() < 1) {
            return CheckResult.createFailed(object, this, Messages.getString("DRFlowWithoutInfoStructures.FlowDoesntHaveInformationStructures"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRFlowWithoutInfoStructures.FlowHasInformationStructures"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "8FE3C2EB-5E76-AD60-1B3D-0D4927A42B7F";
    }
}

