/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRClusterIndexOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C996DE42-B809-6D74-3610-6CBAC481359C";

    public DRClusterIndexOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRClusterIndexOracle.SetClusterIndex"));
        this.setDescription(Messages.getString("DRClusterIndexOracle.ThereMustBeOneCorrespondingIndex"));
    }

    private int getClusterIndex(ClusterOracle cluster) {
        ClusterIndexSetOracle indexSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterIndexSet();
        Iterator setIt = indexSet.iterator();
        int result = 0;
        while (setIt.hasNext()) {
            ClusterIndexOracle index = (ClusterIndexOracle)setIt.next();
            if (index.getCluster() != cluster) continue;
            ++result;
        }
        return result;
    }

    @Override
    public CheckResult doCheck(Object object) {
        ClusterOracle cluster = (ClusterOracle)object;
        if ("Yes".equalsIgnoreCase(cluster.getIndexed())) {
            int index = this.getClusterIndex(cluster);
            if (index == 0) {
                return CheckResult.createFailed(object, this, Messages.getString("DRClusterIndexOracle.ThereIsNoIndexForTheCluster"));
            }
            if (index == 1) {
                return CheckResult.createOk(object, this, this.getDescription());
            }
            return CheckResult.createFailed(object, this, Messages.getString("DRClusterIndexOracle.ClusterMustHave1CorrespondingIndexDefined"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRClusterIndexOracle.ClusterNotIndexed"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "C996DE42-B809-6D74-3610-6CBAC481359C";
    }
}

