/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetaDataManager
implements MDXMLConstants {
    HashMap<String, ClassDescription> classesMap = new HashMap();
    public static final String MODEL_ID_OBJECT = "oracle.dbtools.crest.model.ModelObject";
    public static final String TV_DIAGRAM = "oracle.dbtools.crest.swingui.TVDiagramView";
    public static final String RECTANGLE = "java.awt.Rectangle";
    public static final String COLOR = "java.awt.Color";
    public static final String STRING = "java.lang.String";
    public static boolean useCodedTags = false;
    static final String SHORT = "short";
    static final String INT = "int";
    static final String BOOLEAN = "boolean";
    static final String LONG = "long";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    private static PropertyTranslator[] sharedTranslators = new PropertyTranslator[]{new PropertyMapWrapper.StringPropertyTranslator(), new PropertyMapWrapper.ShortPropertyTranslator(), new PropertyMapWrapper.IntegerPropertyTranslator(), new PropertyMapWrapper.LongPropertyTranslator(), new PropertyMapWrapper.FloatPropertyTranslator(), new PropertyMapWrapper.DoublePropertyTranslator(), new PropertyMapWrapper.BooleanPropertyTranslator(), new PropertyMapWrapper.ColorPropertyTranslator()};
    private Map map = new TreeMap();
    private static Map tagToCodeMap = new HashMap(1600);
    private static Map codeToTagMap = new HashMap(1600);
    private List sortedObjects = new ArrayList();
    private List tracedObjects = new ArrayList();
    boolean cyclicRef = false;
    boolean error = false;
    boolean valid = false;

    public static void main(String[] args) {
        PrintWriter pr = null;
        try {
            pr = new PrintWriter("d:/refs_DM_4.csv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        boolean propDefaultsOnly = false;
        MetaFileLoader.standalone = true;
        MetaDataManager md = new MetaDataManager();
        MetaDataManager.loadClassesinXMLMetaDir(md);
        for (ClassDescription cd : md.classesMap.values()) {
            Class<?> cdclass = null;
            try {
                cdclass = Class.forName(cd.getClassName());
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (cdclass != null) {
                Method[] methods;
                for (Method m : methods = cdclass.getDeclaredMethods()) {
                    list.add(m.getName());
                }
            }
            Iterator<ClassDescription.PropertyDescription> itp = cd.getPropertiesList().iterator();
            if (!propDefaultsOnly) {
                while (itp.hasNext()) {
                    ClassDescription.PropertyDescription pd = itp.next();
                    if ((pd.getter == null || pd.setter == null && pd.createProperty == null) && !pd.className.equals("java.util.Map")) {
                        System.out.println(cd.toString() + "---prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null) + " -- null setter  " + String.valueOf(pd.setter == null));
                    }
                    if (pd.isSimpleClass() || !pd.isReferred()) continue;
                    Class<?> cls = null;
                    try {
                        cls = Class.forName(pd.className);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    if (cls == null || cdclass == null || !ModelObject.class.isAssignableFrom(cls) || !list.contains(pd.getterName)) continue;
                    pr.println(cd.toString() + ",prop=" + pd.name + ", getter  " + pd.getterName + ",setter  " + pd.setterName + ",dataType =" + pd.className);
                }
                for (ClassDescription.PropertyDescription pd : cd.getROPropertiesList()) {
                    if (!pd.isSearch() || pd.getter != null) continue;
                    System.out.println(cd.toString() + "+++Search - prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null));
                }
                for (ClassDescription.CollectionDescription pd : cd.getCollectionsList()) {
                    if (pd.getter != null && (pd.isExternalCollection || pd.isProxyitem || pd.createItem != null || pd.applyList != null || pd.itemIsRef || pd.isTVConnectorItem || pd.isObjectViewItem || pd.isTVDiagramItem)) continue;
                    System.out.println(cd.toString() + "---collect=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null) + " -- null setter  " + String.valueOf(pd.createItem == null));
                }
                continue;
            }
            if (cd.getClassName().indexOf("storage.") <= -1) continue;
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (BOOLEAN.equalsIgnoreCase(pd.className) || STRING.equalsIgnoreCase(pd.className) || LONG.equalsIgnoreCase(pd.className) || "java.lang.Integer".equalsIgnoreCase(pd.className) || FLOAT.equalsIgnoreCase(pd.className) || SHORT.equalsIgnoreCase(pd.className) || pd.className.indexOf("storage.") > -1 || pd.className.indexOf("SchemaObject") > -1 || pd.className.indexOf("Proxy") > -1 || INT.equalsIgnoreCase(pd.className)) continue;
                System.out.println(cd.toString() + "---prop=" + pd.name + " -- prop class  " + pd.className);
            }
        }
        pr.flush();
        pr.close();
    }

    public ClassDescription getClassDescription(String className) {
        ClassDescription cd = this.classesMap.get(className);
        if (cd == null) {
            return this.addClassDescription(className);
        }
        return cd;
    }

    private ClassDescription addClassDescription(String className) {
        ClassDescription cd = null;
        Document doc = MetaFileLoader.loadFile(className);
        Class<?> curClass = null;
        if (doc == null) {
            Class<?> tclass = null;
            try {
                tclass = curClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (tclass != null && !tclass.equals(Object.class)) {
                while (doc == null && !(tclass = tclass.getSuperclass()).equals(Object.class)) {
                    doc = MetaFileLoader.loadFile(tclass.getName());
                }
            }
        }
        if (doc != null) {
            int i;
            Class<?> cl;
            int count;
            NodeList propList;
            Element root;
            block45: {
                String xmlName;
                String value;
                ClassDescription parCD;
                String parentClass;
                root = doc.getDocumentElement();
                String tag = root.getTagName();
                if (!tag.equalsIgnoreCase(className)) {
                    // empty if block
                }
                if ((parentClass = root.getAttribute("parentClass")) != null && !"".equals(parentClass) && (parCD = this.getClassDescription(parentClass)) != null) {
                    try {
                        cd = (ClassDescription)parCD.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                ArrayList<ClassDescription.PropertyDescription> list = new ArrayList<ClassDescription.PropertyDescription>();
                if (cd == null) {
                    cd = new ClassDescription();
                }
                if ((value = root.getAttribute("isPropertyMap")) != null && "true".equals(value)) {
                    cd.isPropertyMap = true;
                }
                cd.setClassName(className);
                Class<?> clc = null;
                try {
                    clc = Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                cd.objectClass = clc;
                if (parentClass != null && !"".equals(parentClass)) {
                    cd.setParentClassName(parentClass);
                }
                if ((xmlName = root.getAttribute("xmlName")) != null && !"".equals(xmlName)) {
                    cd.setXmlName(xmlName);
                }
                String beforeTransformName = null;
                String beforeTransformExtName = null;
                String afterInitName = null;
                String afterInitExtName = null;
                propList = root.getElementsByTagName("processing");
                count = propList.getLength();
                if (count > 0) {
                    Element el = (Element)propList.item(0);
                    beforeTransformName = el.getAttribute("beforeTransform");
                    if (beforeTransformName != null && !"".equals(beforeTransformName)) {
                        cd.beforeTransformName = beforeTransformName;
                    }
                    if ((beforeTransformExtName = el.getAttribute("beforeTransformExt")) != null && !"".equals(beforeTransformExtName)) {
                        cd.beforeTransformExtName = beforeTransformExtName;
                    }
                    if ((afterInitName = el.getAttribute("afterInit")) != null && !"".equals(afterInitName)) {
                        cd.afterInitName = afterInitName;
                    }
                    if ((afterInitExtName = el.getAttribute("afterInitExt")) != null && !"".equals(afterInitExtName)) {
                        cd.afterInitExtName = afterInitExtName;
                    }
                    if ((value = el.getAttribute("createAllExtItemsFirst")) != null && "true".equals(value)) {
                        cd.isCreateAllExtItemsFirst = true;
                    }
                }
                propList = root.getElementsByTagName("property");
                count = propList.getLength();
                for (int i2 = 0; i2 < count; ++i2) {
                    Element el = (Element)propList.item(i2);
                    this.processProperty(el, cd, list);
                }
                for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                    ClassDescription.PropertyDescription rpd;
                    if (pd.relatedPropertyName == null || pd.relatedValue == null || (rpd = cd.getPropertyDescriptionByName(pd.relatedPropertyName)) == null) continue;
                    pd.relatedProperty = rpd;
                }
                cl = null;
                try {
                    Method m;
                    cl = Class.forName(className);
                    Method[] cm = cl.getMethods();
                    if (list.size() > 0) {
                        this.processMethods(cd, list, cm);
                    }
                    if (beforeTransformName != null && !"".equals(beforeTransformName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!beforeTransformName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.beforeTransform = m;
                            break;
                        }
                    }
                    if (beforeTransformExtName != null && !"".equals(beforeTransformExtName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!beforeTransformExtName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.beforeTransformExt = m;
                            break;
                        }
                    }
                    if (afterInitName != null && !"".equals(afterInitName)) {
                        for (i = 0; i < cm.length; ++i) {
                            m = cm[i];
                            if (!afterInitName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                            cd.afterInit = m;
                            break;
                        }
                    }
                    if (afterInitExtName == null || "".equals(afterInitExtName)) break block45;
                    for (i = 0; i < cm.length; ++i) {
                        m = cm[i];
                        if (!afterInitExtName.equals(m.getName()) || !this.hasNoArgument(m)) continue;
                        cd.afterInitExt = m;
                        break;
                    }
                }
                catch (ClassNotFoundException cm) {
                    // empty catch block
                }
            }
            ArrayList<ClassDescription.CollectionDescription> clist = new ArrayList<ClassDescription.CollectionDescription>();
            propList = root.getElementsByTagName("collection");
            count = propList.getLength();
            for (i = 0; i < count; ++i) {
                Element el = (Element)propList.item(i);
                this.processCollection(el, cd, clist);
            }
            this.processCollectionsOrder(root, cd);
            this.orderCollections(cd);
            if (clist.size() > 0) {
                cl = null;
                try {
                    cl = Class.forName(className);
                    Method[] cm = cl.getMethods();
                    this.processMethodsForCollections(clist, cm);
                }
                catch (ClassNotFoundException cm) {
                    // empty catch block
                }
            }
            propList = root.getElementsByTagName("propertyDependency");
            count = propList.getLength();
            for (int i3 = 0; i3 < count; ++i3) {
                Element dep = (Element)propList.item(i3);
                this.processPropertyDependency(dep, cd);
            }
            if (cd.propertiesDependency.size() > 0) {
                this.sortObjects(cd.getPropertiesList(), cd.propertiesDependency);
            }
            cd.resetElementsAndCollectionsFlag();
            ArrayList<ClassDescription.PropertyDescription> roPropertieslist = new ArrayList<ClassDescription.PropertyDescription>();
            propList = root.getElementsByTagName("roproperty");
            count = propList.getLength();
            for (int i4 = 0; i4 < count; ++i4) {
                Element el = (Element)propList.item(i4);
                this.processRO_SearchableProperty(el, cd, roPropertieslist);
            }
            try {
                cl = Class.forName(className);
                Method[] cm = cl.getMethods();
                if (roPropertieslist.size() > 0) {
                    this.processMethodsForROProperties(roPropertieslist, cm, cd);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (cd != null) {
            this.classesMap.put(className, cd);
        }
        return cd;
    }

    private void processPropertyDependency(Element propd, ClassDescription cd) {
        String depOnProp;
        ClassDescription.PropertyDescription dprop;
        String propName = propd.getAttribute("propDef");
        ClassDescription.PropertyDescription pd = cd.getPropertyDescriptionByName(propName);
        if (pd != null && (dprop = cd.getPropertyDescriptionByName(depOnProp = propd.getAttribute("dependOnProperty"))) != null) {
            ObjectDependence od = this.getObjectDependence(pd, cd.propertiesDependency);
            if (od == null) {
                od = new ObjectDependence(pd);
                cd.propertiesDependency.add(od);
            }
            od.dependOn.add(dprop);
        }
    }

    private void processProperty(Element prop, ClassDescription cd, List<ClassDescription.PropertyDescription> localList) {
        String search;
        String ddlrel;
        String reffer;
        int ind;
        String value;
        String name = prop.getAttribute("name");
        ClassDescription.PropertyDescription pd = cd.getPropertyDescriptionByName(name);
        if (pd != null) {
            cd.removePropertyDescription(pd);
            ClassDescription.PropertyDescription newPD = (ClassDescription.PropertyDescription)pd.clone();
            if (newPD != null) {
                cd.updatePropertyDependencies(pd, newPD);
                pd = newPD;
            }
            cd.getPropertiesList().add(pd);
        } else {
            pd = new ClassDescription.PropertyDescription();
            cd.getPropertiesList().add(pd);
        }
        pd.name = name;
        pd.className = prop.getAttribute("dataType");
        pd.itemClassName = prop.getAttribute("itemClass");
        Class<?> cl = null;
        try {
            cl = Class.forName(pd.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cl != null && Map.class.isAssignableFrom(cl)) {
            pd.isMap = true;
        }
        if (RECTANGLE.equals(pd.className)) {
            pd.isRectangle = true;
        }
        if (!STRING.equals(pd.className)) {
            pd.stringClass = false;
        }
        if ((value = prop.getAttribute("isPropertyMap")) != null && "true".equals(value)) {
            pd.isPropertyMap = true;
        }
        if ((value = prop.getAttribute("colorProperty")) != null && "true".equals(value)) {
            pd.isColorProperty = true;
        }
        if ((value = prop.getAttribute("processing")) != null && "afterColletions".equals(value)) {
            pd.isAfterCollectionProcessing = true;
        }
        if ((value = prop.getAttribute("external")) != null && "true".equals(value)) {
            pd.isExternalProperty = true;
        }
        if ((value = prop.getAttribute("loggingProp")) != null && "true".equals(value)) {
            pd.isLoggingProp = true;
        }
        if ((value = prop.getAttribute("relatedProperty")) != null && !"".equals(value)) {
            pd.relatedPropertyName = value;
        }
        if ((value = prop.getAttribute("relatedValue")) != null && !"".equals(value)) {
            pd.relatedValue = value;
        }
        if ((value = prop.getAttribute("createdTimeProp")) != null && "true".equals(value)) {
            pd.isCreatedTimeProp = true;
        }
        if ((value = prop.getAttribute("mergeCompare")) != null && "true".equals(value)) {
            pd.isMergeCompare = true;
        }
        if ((value = prop.getAttribute("listOfRefs")) != null && "true".equals(value)) {
            pd.isListOfRefs = true;
        }
        if ((value = prop.getAttribute("itemXmlName")) != null && !"".equals(value)) {
            pd.pmItemName = value;
        }
        if ((value = prop.getAttribute("keyXmlName")) != null && !"".equals(value)) {
            pd.pmKeyName = value;
        }
        if ((value = prop.getAttribute("valueXmlName")) != null && !"".equals(value)) {
            pd.pmValueName = value;
        }
        if ((value = prop.getAttribute("createItem")) != null && !"".equals(value)) {
            pd.createPropertyName = value;
        }
        if ((value = prop.getAttribute("removeItem")) != null && !"".equals(value)) {
            pd.removePropertyName = value;
        }
        if ((value = prop.getAttribute("createPMap")) != null && !"".equals(value)) {
            pd.createPMapName = value;
        }
        if ((value = prop.getAttribute("beforeCollection")) != null && !"".equals(value)) {
            pd.beforeCollection = value;
        }
        if ((value = prop.getAttribute("afterCollection")) != null && !"".equals(value)) {
            pd.afterCollection = value;
        }
        if ((ind = pd.className.lastIndexOf(32)) > -1) {
            pd.className = pd.className.substring(ind + 1);
        }
        pd.xmlName = prop.getAttribute("xmlName");
        if ("id".equalsIgnoreCase(pd.xmlName)) {
            pd.isID = true;
        }
        pd.oldXmlName = prop.getAttribute("oldXmlName");
        if ("".equals(pd.oldXmlName)) {
            pd.oldXmlName = null;
        }
        pd.presentationName = (value = prop.getAttribute("presentationName")) != null && !"".equals(value) ? value : pd.xmlName;
        String xmlType = prop.getAttribute("xmlType");
        if (!xmlType.equals("element")) {
            pd.propType = 1;
        }
        if ("true".equals(reffer = prop.getAttribute("reffered"))) {
            pd.referred = true;
        }
        pd.getterName = prop.getAttribute("getter");
        pd.setterName = prop.getAttribute("setter");
        String defv = prop.getAttribute("defaultValue");
        if (defv != null) {
            pd.defaultValue = defv;
        }
        if ((ddlrel = prop.getAttribute("ddlRelated")) != null && "true".equals(ddlrel)) {
            pd.ddlRelated = true;
        }
        if ((search = prop.getAttribute("search")) != null && "true".equals(search)) {
            pd.search = true;
        }
        if ((value = prop.getAttribute("useInReport")) != null && "true".equals(value)) {
            pd.useInReport = true;
        }
        if ((value = prop.getAttribute("skipClassName")) != null && "true".equals(value)) {
            pd.skipClassName = true;
        }
        if ((value = prop.getAttribute("dateTime")) != null && "true".equals(value)) {
            pd.dateTime = true;
        }
        this.processCodedEnum(prop, pd);
        localList.add(pd);
    }

    private void processRO_SearchableProperty(Element prop, ClassDescription cd, List<ClassDescription.PropertyDescription> localList) {
        String name = prop.getAttribute("name");
        ClassDescription.PropertyDescription roPd = cd.getROPropertyDescriptionByName(name);
        if (roPd != null) {
            cd.removeROPropertyDescription(roPd);
        }
        roPd = new ClassDescription.PropertyDescription();
        roPd.name = name;
        roPd.className = prop.getAttribute("dataType");
        roPd.itemClassName = prop.getAttribute("itemClass");
        String search = prop.getAttribute("search");
        if (search != null && "true".equals(search)) {
            roPd.search = true;
        }
        roPd.getterName = prop.getAttribute("getter");
        if (roPd.search) {
            cd.getSearchableROPropertiesList().add(roPd);
            localList.add(roPd);
        }
        cd.getROPropertiesList().add(roPd);
        String value = prop.getAttribute("useInReport");
        if (value != null && "true".equals(value)) {
            roPd.useInReport = true;
            if (!roPd.search) {
                localList.add(roPd);
            }
        }
    }

    private void checkpropertyClass(ClassDescription cd, ClassDescription.PropertyDescription pd) {
        if (pd.className.indexOf("java.util.List") > -1 || pd.className.indexOf("java.util.Collection") > -1) {
            System.out.println(cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
        }
        if (pd.isContainedClass()) {
            if (pd.isPropertyMap) {
                if (pd.createPMapName != null && pd.removePropertyName == null || pd.createPMapName == null) {
                    System.out.println("no removeProperty for PropMap -- " + cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
                } else if (pd.createPMapName != null && pd.removePropertyName != null) {
                    // empty if block
                }
            } else if (pd.createPropertyName != null && pd.removePropertyName == null || pd.createPropertyName == null) {
                if (!pd.className.equals(RECTANGLE)) {
                    System.out.println("no removeProperty -- " + cd.getClassName() + " ||  pname=" + pd.name + "  --  " + pd.className);
                }
            } else if (pd.createPropertyName == null || pd.removePropertyName != null) {
                // empty if block
            }
        }
    }

    private void processCodedEnum(Element prop, ClassDescription.PropertyDescription pd) {
        NodeList codeList = prop.getElementsByTagName("codedEnum");
        int count = codeList.getLength();
        count = Math.min(1, count);
        for (int i = 0; i < count; ++i) {
            Element el = (Element)codeList.item(i);
            NodeList items = el.getElementsByTagName("item");
            int icount = items.getLength();
            for (int k = 0; k < icount; ++k) {
                Element item = (Element)items.item(k);
                String code = item.getAttribute("code");
                if (code == null || "".equals(code)) continue;
                String value = item.getAttribute("value");
                pd.getCoddedEnumMap().put(code, value);
            }
        }
    }

    private void processMethods(ClassDescription cd, List<ClassDescription.PropertyDescription> list, Method[] methods) {
        Class<?> idObject = null;
        try {
            idObject = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (ClassDescription.PropertyDescription pd : list) {
            String createPMapName = pd.createPMapName;
            if (pd.isPropertyMap) {
                for (int i = 0; i < methods.length; ++i) {
                    Class<?> returnType;
                    Method cm = methods[i];
                    if (!createPMapName.equals(cm.getName()) || !this.hasNoArgument(cm) || !PropertyMap.class.isAssignableFrom(returnType = cm.getReturnType())) continue;
                    pd.createPMap = cm;
                    break;
                }
            }
            if (pd.isMap) {
                // empty if block
            }
            String setter = pd.setterName;
            String getter = pd.getterName;
            Class paramClass = this.getClass(pd.className);
            Method getMethod = null;
            Method setMethod = null;
            if (!(paramClass == null || getter == null || setter == null && pd.isReferred())) {
                int c;
                Method cm;
                Class<?> returnType;
                int i;
                for (i = 0; i < methods.length; ++i) {
                    Method gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    getMethod = gm;
                    break;
                }
                if (!pd.isReferred() && pd.createPropertyName != null && !"".equals(pd.createPropertyName)) {
                    for (i = 0; i < methods.length; ++i) {
                        cm = methods[i];
                        if (!pd.createPropertyName.equals(cm.getName()) || !this.hasNoArgument(cm) || !paramClass.isAssignableFrom(returnType = cm.getReturnType())) continue;
                        pd.createProperty = cm;
                        pd.stringClass = false;
                        pd.getter = getMethod;
                        break;
                    }
                }
                if (!pd.isReferred() && pd.removePropertyName != null && !"".equals(pd.removePropertyName)) {
                    for (i = 0; i < methods.length; ++i) {
                        cm = methods[i];
                        if (!pd.removePropertyName.equals(cm.getName()) || !this.hasNoArgument(cm) || !paramClass.isAssignableFrom(returnType = cm.getReturnType())) continue;
                        pd.removeProperty = cm;
                        pd.stringClass = false;
                        pd.getter = getMethod;
                        break;
                    }
                }
                if (pd.isPropertyMap || pd.isMap) {
                    pd.getter = getMethod;
                }
                if (getMethod != null) {
                    Class<?> singleArgument;
                    Method sm;
                    for (i = 0; i < methods.length; ++i) {
                        sm = methods[i];
                        if (!setter.equals(sm.getName()) || !this.hasSingleArgument(sm) || !this.hasVoidOrBooleanReturn(sm) || !(singleArgument = sm.getParameterTypes()[0]).equals(paramClass)) continue;
                        setMethod = sm;
                        break;
                    }
                    if (setMethod == null) {
                        for (i = 0; i < methods.length; ++i) {
                            sm = methods[i];
                            if (!setter.equals(sm.getName()) || !this.hasSingleArgument(sm) || !this.hasVoidOrBooleanReturn(sm) || !paramClass.isAssignableFrom(singleArgument = sm.getParameterTypes()[0])) continue;
                            setMethod = sm;
                            break;
                        }
                    }
                } else {
                    c = 0;
                    ++c;
                }
                if (getMethod != null && setMethod != null) {
                    pd.setter = setMethod;
                    pd.getter = getMethod;
                    pd.simpleClass = this.isSimpleClas(paramClass);
                    pd.stringClass = this.isStringClas(paramClass);
                    PropertyTranslator translator = this.getPropertyTranslatorFor(paramClass);
                    if (translator == null) {
                        if (idObject != null && idObject.isAssignableFrom(paramClass)) {
                            pd.idObjecttranslator = true;
                        }
                    } else {
                        pd.propertyTranslator = translator;
                    }
                } else {
                    c = 0;
                    ++c;
                }
            } else {
                int c = 0;
                ++c;
            }
            if (!MetaFileLoader.standalone && !ApplicationView.debugMode) continue;
            this.checkpropertyClass(cd, pd);
        }
    }

    private void processMethodsForROProperties(List<ClassDescription.PropertyDescription> list, Method[] methods, ClassDescription cd) {
        Object[] props = list.toArray();
        for (int k = 0; k < props.length; ++k) {
            ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)props[k];
            String getter = pd.getterName;
            Class paramClass = this.getClass(pd.className);
            if (paramClass != null && getter != null) {
                Class<?> returnType;
                Method gm;
                int i;
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    pd.getter = gm;
                    break;
                }
                if (pd.getter == null) {
                    for (i = 0; i < methods.length; ++i) {
                        gm = methods[i];
                        if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).isAssignableFrom(paramClass)) continue;
                        pd.getter = gm;
                        break;
                    }
                }
            }
            if (pd.getter != null) continue;
            cd.removeROPropertyDescription(pd);
        }
    }

    private void processCollection(Element prop, ClassDescription cd, List<ClassDescription.CollectionDescription> localList) {
        String name = prop.getAttribute("name");
        int colInd = -1;
        ClassDescription.CollectionDescription cold = cd.getCollectionDescriptionByName(name);
        if (cold != null) {
            colInd = cd.getCollectionsList().indexOf(cold);
            cd.removeCollectionDescription(cold);
        }
        cold = new ClassDescription.CollectionDescription();
        cold.name = name;
        cold.className = prop.getAttribute("dataType");
        int ind = cold.className.lastIndexOf(32);
        if (ind > -1) {
            cold.className = cold.className.substring(ind + 1);
        }
        cold.xmlName = prop.getAttribute("xmlName");
        cold.itemXmlName = prop.getAttribute("itemXmlName");
        cold.itemClassName = prop.getAttribute("itemClass");
        String xmlType = prop.getAttribute("xmlType");
        String reffer = prop.getAttribute("reffered");
        String value = prop.getAttribute("external");
        if (value != null && "true".equals(value)) {
            cold.isExternalCollection = true;
        }
        if ((value = prop.getAttribute("itemIsRef")) != null && "true".equals(value)) {
            cold.itemIsRef = true;
        }
        if ((value = prop.getAttribute("createAllItemsFirst")) != null && "true".equals(value)) {
            cold.createAllItemsFirst = true;
        }
        if ((value = prop.getAttribute("objectViewItem")) != null && "true".equals(value)) {
            cold.isObjectViewItem = true;
        }
        if ((value = prop.getAttribute("physicalModelItem")) != null && "true".equals(value)) {
            cold.isPhysicalModelItem = true;
        }
        if ((value = prop.getAttribute("diagramViewItem")) != null && "true".equals(value)) {
            cold.isTVDiagramItem = true;
        }
        if ((value = prop.getAttribute("orderImportant")) != null && "false".equals(value)) {
            cold.isOrderImportant = false;
        }
        if ((value = prop.getAttribute("tvConnectorItem")) != null && "true".equals(value)) {
            cold.isTVConnectorItem = true;
        }
        if ((value = prop.getAttribute("proxyItem")) != null && "true".equals(value)) {
            cold.isProxyitem = true;
        }
        if ((value = prop.getAttribute("listOfRefs")) != null && "true".equals(value)) {
            cold.listOfRefs = true;
        }
        if ((value = prop.getAttribute("nativeList")) != null && "true".equals(value)) {
            cold.nativeList = true;
        }
        if ((value = prop.getAttribute("orderTheList")) != null && "true".equals(value)) {
            cold.orderTheList = true;
        }
        if ((value = prop.getAttribute("refsXMLName")) != null && !"".equals(value)) {
            cold.refsXMLName = value;
        }
        cold.getterName = prop.getAttribute("getter");
        cold.setterName = prop.getAttribute("setter");
        String mapItem = prop.getAttribute("isMapItem");
        if (mapItem != null && "true".equalsIgnoreCase(mapItem)) {
            cold.isMapItem = true;
        }
        if ((mapItem = prop.getAttribute("isEngPropertyHolderItem")) != null && "true".equalsIgnoreCase(mapItem)) {
            cold.isEngPropertyHolderItem = true;
        }
        if ((value = prop.getAttribute("useInReport")) != null && "true".equals(value)) {
            cold.useInReport = true;
        }
        cold.createItemName = prop.getAttribute("createItem");
        cold.addItemName = prop.getAttribute("addItem");
        cold.removeItemName = prop.getAttribute("removeItem");
        cold.applyListName = prop.getAttribute("applyList");
        cold.getItemByIDName = prop.getAttribute("getItemByID");
        cold.moveMethodName = prop.getAttribute("moveMethod");
        cold.preProcessName = prop.getAttribute("preProcessMethod");
        if (colInd > -1) {
            cd.getCollectionsList().add(colInd, cold);
        } else {
            cd.getCollectionsList().add(cold);
        }
        localList.add(cold);
    }

    private void processMethodsForCollections(List<ClassDescription.CollectionDescription> list, Method[] methods) {
        Class<?> idObject = null;
        try {
            idObject = Class.forName(MODEL_ID_OBJECT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        block2: for (ClassDescription.CollectionDescription cold : list) {
            Method gm;
            int i;
            String setter = cold.setterName;
            String getter = cold.getterName;
            Class paramClass = this.getClass(cold.className);
            if (paramClass != null && ModelIDObjectSet.class.isAssignableFrom(paramClass)) {
                cold.isIDObjectSet = true;
            }
            Method getMethod = null;
            Object setMethod = null;
            if (paramClass != null && getter != null) {
                Class<?> returnType;
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).equals(paramClass)) continue;
                    getMethod = gm;
                    break;
                }
                if (getMethod == null) {
                    for (i = 0; i < methods.length; ++i) {
                        gm = methods[i];
                        if (!getter.equals(gm.getName()) || !this.hasNoArgument(gm) || !(returnType = gm.getReturnType()).isAssignableFrom(paramClass)) continue;
                        getMethod = gm;
                        break;
                    }
                }
                cold.getter = getMethod;
            } else {
                int c = 0;
                ++c;
            }
            if (cold.createItemName != null && !"".equals(cold.createItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.createItemName.equals(gm.getName()) || !this.hasNoArgument(gm) || this.hasVoidReturn(gm)) continue;
                    cold.createItem = gm;
                    break;
                }
            }
            if (cold.removeItemName != null && !"".equals(cold.removeItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.removeItemName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.removeItem = gm;
                    break;
                }
            }
            if (cold.addItemName != null && !"".equals(cold.addItemName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.addItemName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.addItem = gm;
                    break;
                }
            }
            if (cold.applyListName != null && !"".equals(cold.applyListName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.applyListName.equals(gm.getName()) || !this.hasSingleArgument(gm) || !this.hasVoidReturn(gm)) continue;
                    cold.applyList = gm;
                    break;
                }
            }
            if (cold.getItemByIDName != null && !"".equals(cold.getItemByIDName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.getItemByIDName.equals(gm.getName()) || !this.hasSingleArgument(gm)) continue;
                    cold.getItemByID = gm;
                    break;
                }
            }
            if (cold.moveMethodName != null && !"".equals(cold.moveMethodName)) {
                for (i = 0; i < methods.length; ++i) {
                    gm = methods[i];
                    if (!cold.moveMethodName.equals(gm.getName()) || !this.hasTwoArguments(gm)) continue;
                    cold.moveMethod = gm;
                    break;
                }
            }
            if (cold.preProcessName == null || "".equals(cold.preProcessName)) continue;
            for (i = 0; i < methods.length; ++i) {
                gm = methods[i];
                if (!cold.preProcessName.equals(gm.getName()) || !this.hasNoArgument(gm)) continue;
                cold.preProcess = gm;
                continue block2;
            }
        }
    }

    private boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean hasTwoArguments(Method method) {
        return method.getParameterTypes().length == 2;
    }

    private boolean hasVoidOrBooleanReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType()) || Boolean.TYPE.equals(method.getReturnType());
    }

    private boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private PropertyTranslator getPropertyTranslatorFor(Class cls) {
        for (int i = 0; i < sharedTranslators.length; ++i) {
            if (!sharedTranslators[i].canHandleClass(cls)) continue;
            return sharedTranslators[i];
        }
        return null;
    }

    private Class getClass(String className) {
        if (SHORT.equals(className)) {
            return Short.TYPE;
        }
        if (INT.equals(className)) {
            return Integer.TYPE;
        }
        if (BOOLEAN.equals(className)) {
            return Boolean.TYPE;
        }
        if (DOUBLE.equals(className)) {
            return Double.TYPE;
        }
        if (FLOAT.equals(className)) {
            return Float.TYPE;
        }
        if (LONG.equals(className)) {
            return Long.TYPE;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private boolean isSimpleClas(Class checked) {
        return checked.equals(Integer.TYPE) || checked.equals(Integer.class) || checked.equals(Short.TYPE) || checked.equals(Short.class) || checked.equals(Double.TYPE) || checked.equals(Double.class) || checked.equals(Float.TYPE) || checked.equals(Float.class) || checked.equals(Long.TYPE) || checked.equals(Long.class) || checked.equals(Boolean.TYPE) || checked.equals(Boolean.class) || checked.equals(Color.class);
    }

    private boolean isStringClas(Class checked) {
        return checked.equals(String.class);
    }

    private void sortObjects(List objects, List objectDependencies) {
        this.sortedObjects.clear();
        this.tracedObjects.clear();
        this.cyclicRef = false;
        ArrayList havingDependencies = new ArrayList();
        for (Object object : objects) {
            ObjectDependence od = this.getObjectDependence(object, objectDependencies);
            if (od == null || od.dependOn.size() == 0) {
                this.sortedObjects.add(object);
                this.tracedObjects.add(object);
                continue;
            }
            havingDependencies.add(object);
        }
        for (Object object : havingDependencies) {
            this.addToSorted(object, objectDependencies);
            if (!this.cyclicRef) continue;
            return;
        }
        if (this.sortedObjects.size() == objects.size()) {
            objects.clear();
            objects.addAll(this.sortedObjects);
        } else {
            int k = 0;
            ++k;
        }
    }

    private void addToSorted(Object object, List objectDependencies) {
        if (this.sortedObjects.contains(object)) {
            return;
        }
        ObjectDependence od = this.getObjectDependence(object, objectDependencies);
        if (od == null) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        if (od.dependOn.size() == 0) {
            this.sortedObjects.add(object);
            this.tracedObjects.add(object);
            return;
        }
        this.tracedObjects.add(object);
        for (Object obj : od.dependOn) {
            if (this.tracedObjects.contains(obj) && !this.sortedObjects.contains(obj)) {
                this.cyclicRef = true;
                this.error = true;
                this.valid = false;
                return;
            }
            if (this.sortedObjects.contains(obj)) continue;
            this.addToSorted(obj, objectDependencies);
            if (!this.cyclicRef) continue;
            return;
        }
        this.sortedObjects.add(object);
    }

    private ObjectDependence getObjectDependence(Object object, List objectDependencies) {
        for (ObjectDependence od : objectDependencies) {
            if (od.object != object) continue;
            return od;
        }
        return null;
    }

    private void processCollectionsOrder(Element root, ClassDescription cd) {
        NodeList propList = root.getElementsByTagName("collectionOrder");
        int count = propList.getLength();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                NodeList items;
                int icount;
                Element el = (Element)propList.item(i);
                String context = el.getAttribute("context");
                if (!cd.getContexts().contains(context)) {
                    cd.getContexts().add(context);
                }
                if ((icount = (items = el.getElementsByTagName("collectionOrd")).getLength()) > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int k = 0; k < icount; ++k) {
                        Element item = (Element)items.item(k);
                        String name = item.getAttribute("name");
                        if (name == null || "".equals(name)) continue;
                        list.add(name);
                    }
                    if (list.size() > 0) {
                        cd.getContextMap().put(context + "collectionOrderNames", list);
                        continue;
                    }
                    cd.getContextMap().remove(context + "collectionOrderNames");
                    continue;
                }
                cd.getContextMap().remove(context + "collectionOrderNames");
            }
        }
    }

    private void orderCollections(ClassDescription cd) {
        for (String context : cd.getContexts()) {
            List list = (List)cd.getContextMap().get(context + "collectionOrderNames");
            ArrayList<ClassDescription.CollectionDescription> olist = new ArrayList<ClassDescription.CollectionDescription>();
            if (list != null) {
                for (String name : list) {
                    ClassDescription.CollectionDescription cold = cd.getCollectionDescriptionByName(name);
                    if (cold == null) continue;
                    olist.add(cold);
                }
            }
            for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
                if (olist.contains(cold)) continue;
                olist.add(cold);
            }
            cd.getContextMap().put(context + "collectionOrder", olist);
        }
    }

    public static void loadClassesinXMLMetaDir(MetaDataManager md) {
        File dir = new File(new File(MetaFileLoader.standaloneBaseDir), "xmlmetadata");
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                int ind;
                if (file.isDirectory()) continue;
                Document doc = null;
                try {
                    doc = MetaFileLoader.loadDocForFile(file.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (doc == null) continue;
                Element root = doc.getDocumentElement();
                String className = root.getTagName();
                String inner = root.getAttribute("innerClass");
                if (inner != null && "true".equalsIgnoreCase(inner) && (ind = className.lastIndexOf(46)) > -1 && ind + 1 < className.length()) {
                    className = className.substring(0, ind) + '$' + className.substring(ind + 1);
                }
                ClassDescription classDescription = md.getClassDescription(className);
            }
        }
    }

    public void createXMLDefInDataTypesModel(DataTypesDesign dtModel) {
        MetaFileLoader.standalone = true;
        HashMap<String, StructuredType> map = new HashMap<String, StructuredType>();
        MetaDataManager md = this;
        MetaDataManager.loadClassesinXMLMetaDir(md);
        for (ClassDescription cd : md.classesMap.values()) {
            StructuredType st = dtModel.createStructuredType();
            st.setName(cd.getXmlName());
            st.setClassName(cd.getClassName());
            map.put(cd.getClassName(), st);
        }
        StructuredType st1 = dtModel.createStructuredType();
        st1.setName("Color");
        st1.setClassName(COLOR);
        map.put(COLOR, st1);
        st1 = dtModel.createStructuredType();
        st1.setName("SchemaObject");
        st1.setClassName(SchemaObject.class.getName());
        StructuredType p = (StructuredType)map.get(SchemaObject.class.getSuperclass().getName());
        if (p != null) {
            st1.setParentType(p);
        }
        map.put(st1.getClassName(), st1);
        for (ClassDescription cd : md.classesMap.values()) {
            StructuredType st = (StructuredType)map.get(cd.getClassName());
            if (st == null) continue;
            StructuredType stpar = (StructuredType)map.get(cd.getParentClassName());
            if (stpar != null) {
                st.setParentType(stpar);
            }
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                ClassDescription.PropertyDescription pdt;
                ClassDescription cdpar;
                boolean add = true;
                if (stpar != null && (cdpar = this.getClassDescription(cd.getParentClassName())) != null && (pdt = cdpar.getPropertyDescriptionByName(pd.name)) != null) {
                    add = false;
                }
                if (add) {
                    TypeElement te = st.createTypeElement(pd.name);
                    te.setGetterName(pd.getterName);
                    te.setSetterName(pd.setterName);
                    StructuredType str = (StructuredType)map.get(pd.className);
                    if (str != null) {
                        te.setType(str);
                        if (pd.referred) {
                            te.setReference(true);
                        }
                        te.updateReferenceNew();
                    } else {
                        LogicalDatatype ldt = null;
                        ldt = pd.className.startsWith(INT) || pd.className.startsWith(SHORT) || pd.className.indexOf(Integer.class.getName()) > -1 ? (LogicalDatatype)dtModel.getDesign().getLogicalDatatypeSet().getByName("Integer") : (pd.className.startsWith(LONG) ? (LogicalDatatype)dtModel.getDesign().getLogicalDatatypeSet().getByName("BIGINT") : (pd.className.indexOf(STRING) > -1 ? (LogicalDatatype)dtModel.getDesign().getLogicalDatatypeSet().getByName("Varchar") : (pd.className.indexOf(Boolean.class.getName()) > -1 || pd.className.startsWith(BOOLEAN) ? (LogicalDatatype)dtModel.getDesign().getLogicalDatatypeSet().getByName("Boolean") : (LogicalDatatype)dtModel.getDesign().getLogicalDatatypeSet().getByName(pd.className))));
                        if (ldt != null) {
                            te.setType(ldt);
                        }
                    }
                }
                if (pd.getter != null && (pd.setter != null || pd.createProperty != null) || pd.className.equals("java.util.Map")) continue;
                System.out.println(cd.toString() + "---prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null) + " -- null setter  " + String.valueOf(pd.setter == null));
            }
            for (ClassDescription.PropertyDescription pd : cd.getROPropertiesList()) {
                if (!pd.isSearch() || pd.getter != null) continue;
                System.out.println(cd.toString() + "+++Search - prop=" + pd.name + " -- null getter  " + String.valueOf(pd.getter == null));
            }
            for (ClassDescription.CollectionDescription col : cd.getCollectionsList()) {
                StructuredType source;
                ClassDescription.CollectionDescription pdt;
                ClassDescription cdpar;
                boolean add = true;
                if (stpar != null && (cdpar = this.getClassDescription(cd.getParentClassName())) != null && (pdt = cdpar.getCollectionDescriptionByName(col.name)) != null) {
                    add = false;
                }
                if (!add || (source = (StructuredType)map.get(col.itemClassName)) == null) continue;
                dtModel.setDefaultCollectionType_Kind(CollectionType.TYPE_COLLECTION);
                dtModel.setDefaultCollectionType_Suffix("_Collection");
                CollectionType ct = dtModel.getOrCreateCollectionFor(source, col.itemIsRef);
                TypeElement te = st.createTypeElement(col.name);
                te.setGetterName(col.getterName);
                te.setType(ct);
                te.updateReference();
            }
        }
        dtModel.sortCollections();
        ((DPVDataTypes)dtModel.getMainView()).resizeStructuredTypes();
        ((DPVDataTypes)dtModel.getMainView()).rearrangeNewDiagram();
        this.createSVforRelational(dtModel, map);
        this.createSVforLogical(dtModel, map);
    }

    void createSVforRelational(DataTypesDesign dt, Map map) {
        DPVDataTypes dpv = (DPVDataTypes)dt.createDesignPartSubView();
        ArrayList list = new ArrayList();
        dpv.setName("Objects in Relational model");
        this.addViewForClassAndParents(Table.class, dpv, list, map);
        this.addViewForClassAndParents(TableView.class, dpv, list, map);
        this.addViewForClassAndParents(Index.class, dpv, list, map);
        this.addViewForClassAndParents(Column.class, dpv, list, map);
        this.addViewForClassAndParents(ColumnView.class, dpv, list, map);
        this.addViewForClassAndParents(FKIndexAssociation.class, dpv, list, map);
        for (StructuredType st : list) {
            TVStructuredType tv = (TVStructuredType)st.getFirstViewForDPV(dpv);
            tv.addTVInheritances();
            tv.addTVRelations();
        }
        dpv.resizeStructuredTypes();
        dpv.rearrangeNewDiagram();
    }

    void createSVforLogical(DataTypesDesign dt, Map map) {
        DPVDataTypes dpv = (DPVDataTypes)dt.createDesignPartSubView();
        ArrayList list = new ArrayList();
        dpv.setName("Objects in Logical model");
        this.addViewForClassAndParents(Entity.class, dpv, list, map);
        this.addViewForClassAndParents(EntityView.class, dpv, list, map);
        this.addViewForClassAndParents(CandidateKey.class, dpv, list, map);
        this.addViewForClassAndParents(Attribute.class, dpv, list, map);
        this.addViewForClassAndParents(AttributeView.class, dpv, list, map);
        this.addViewForClassAndParents(Relation.class, dpv, list, map);
        for (StructuredType st : list) {
            TVStructuredType tv = (TVStructuredType)st.getFirstViewForDPV(dpv);
            tv.addTVInheritances();
            tv.addTVRelations();
        }
        dpv.resizeStructuredTypes();
        dpv.rearrangeNewDiagram();
    }

    void addViewForClassAndParents(Class cl, DPVDataTypes dpv, List list, Map map) {
        Class par;
        StructuredType st = (StructuredType)map.get(cl.getName());
        if (st != null && !list.contains(st)) {
            dpv.addViewFor(st, true);
            list.add(st);
        }
        if (!cl.equals(ModelObject.class) && (par = cl.getSuperclass()) != null) {
            this.addViewForClassAndParents(par, dpv, list, map);
        }
    }

    public void addToMap(String tag) {
        String code = (String)tagToCodeMap.get(tag);
        if (code == null) {
            Long count = (Long)this.map.get(tag);
            if (count == null) {
                count = new Long(0L);
            }
            count = count + 1L;
            this.map.put(tag, count);
        }
    }

    public void printTagMap() {
        PrintWriter pr = null;
        try {
            pr = new PrintWriter("d:/statistic22.csv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (pr != null) {
            float total = 0.0f;
            pr.println("Tag, Tag length, Count, KBytes");
            for (String key : this.map.keySet()) {
                Long count = (Long)this.map.get(key);
                float f = count * (long)key.length() / 1024L;
                total += f;
                pr.println(key + ",  " + key.length() + ",   " + count + ",   " + f);
            }
            pr.println("Total,  ,  , " + total);
            pr.flush();
            pr.close();
        }
    }

    public static String getTagForCode(String code) {
        String tag;
        if (useCodedTags && (tag = (String)codeToTagMap.get(code)) != null) {
            return tag;
        }
        return code;
    }

    public static String getCodeForTag(String tag) {
        String code;
        if (useCodedTags && (code = (String)tagToCodeMap.get(tag)) != null) {
            return code;
        }
        return tag;
    }

    public static boolean isUseCodedTags() {
        return useCodedTags;
    }

    public static void setUseCodedTags(boolean useCodedTags) {
        MetaDataManager.useCodedTags = useCodedTags;
    }

    private static void initTagCodeMaps() {
        tagToCodeMap.put("ownerDesignName", "A");
        codeToTagMap.put("A", "ownerDesignName");
        tagToCodeMap.put("createdTime", "B");
        codeToTagMap.put("B", "createdTime");
        tagToCodeMap.put("createdBy", "C");
        codeToTagMap.put("C", "createdBy");
        tagToCodeMap.put("sourceObjSchema", "D");
        codeToTagMap.put("D", "sourceObjSchema");
        tagToCodeMap.put("sourceConnName", "E");
        codeToTagMap.put("E", "sourceConnName");
        tagToCodeMap.put("nullsAllowed", "F");
        codeToTagMap.put("F", "nullsAllowed");
        tagToCodeMap.put("sourceObjName", "G");
        codeToTagMap.put("G", "sourceObjName");
        tagToCodeMap.put("reference", "H");
        codeToTagMap.put("H", "reference");
        tagToCodeMap.put("viewElement", "I");
        codeToTagMap.put("I", "viewElement");
        tagToCodeMap.put("useDomainConstraints", "J");
        codeToTagMap.put("J", "useDomainConstraints");
        tagToCodeMap.put("autoIncrementCycle", "K");
        codeToTagMap.put("K", "autoIncrementCycle");
        tagToCodeMap.put("dataType", "L");
        codeToTagMap.put("L", "dataType");
        tagToCodeMap.put("directorySegmentName", "M");
        codeToTagMap.put("M", "directorySegmentName");
        tagToCodeMap.put("hideElementsInCurrentOnly", "N");
        codeToTagMap.put("N", "hideElementsInCurrentOnly");
        tagToCodeMap.put("logicalDatatype", "O");
        codeToTagMap.put("O", "logicalDatatype");
        tagToCodeMap.put("name", "P");
        codeToTagMap.put("P", "name");
        tagToCodeMap.put("class", "Q");
        codeToTagMap.put("Q", "class");
        tagToCodeMap.put("ColumnProxy", "R");
        codeToTagMap.put("R", "ColumnProxy");
        tagToCodeMap.put("alias", "S");
        codeToTagMap.put("S", "alias");
        tagToCodeMap.put("dataTypeSize", "T");
        codeToTagMap.put("T", "dataTypeSize");
        tagToCodeMap.put("OracleSynonym", "U");
        codeToTagMap.put("U", "OracleSynonym");
        tagToCodeMap.put("schemaObject", "V");
        codeToTagMap.put("V", "schemaObject");
        tagToCodeMap.put("objectUser", "W");
        codeToTagMap.put("W", "objectUser");
        tagToCodeMap.put("id", "X");
        codeToTagMap.put("X", "id");
        tagToCodeMap.put("Column", "Y");
        codeToTagMap.put("Y", "Column");
        tagToCodeMap.put("Attribute", "Z");
        codeToTagMap.put("Z", "Attribute");
        tagToCodeMap.put("object", "a");
        codeToTagMap.put("a", "object");
        tagToCodeMap.put("public", "b");
        codeToTagMap.put("b", "public");
        tagToCodeMap.put("precision", "c");
        codeToTagMap.put("c", "precision");
        tagToCodeMap.put("bounds", "d");
        codeToTagMap.put("d", "bounds");
        tagToCodeMap.put("Parameter", "e");
        codeToTagMap.put("e", "Parameter");
        tagToCodeMap.put("use", "f");
        codeToTagMap.put("f", "use");
        tagToCodeMap.put("indexColumnUsage", "g");
        codeToTagMap.put("g", "indexColumnUsage");
        tagToCodeMap.put("OView", "h");
        codeToTagMap.put("h", "OView");
        tagToCodeMap.put("mandatory", "i");
        codeToTagMap.put("i", "mandatory");
        tagToCodeMap.put("colUsage", "j");
        codeToTagMap.put("j", "colUsage");
        tagToCodeMap.put("scale", "k");
        codeToTagMap.put("k", "scale");
        tagToCodeMap.put("userDefinedSQL", "l");
        codeToTagMap.put("l", "userDefinedSQL");
        tagToCodeMap.put("defaultValue", "m");
        codeToTagMap.put("m", "defaultValue");
        tagToCodeMap.put("directionType", "n");
        codeToTagMap.put("n", "directionType");
        tagToCodeMap.put("size", "o");
        codeToTagMap.put("o", "size");
        tagToCodeMap.put("viewElements", "p");
        codeToTagMap.put("p", "viewElements");
        tagToCodeMap.put("partitionedRowMovement", "q");
        codeToTagMap.put("q", "partitionedRowMovement");
        tagToCodeMap.put("structAttributeID", "r");
        codeToTagMap.put("r", "structAttributeID");
        tagToCodeMap.put("dataTypePrecision", "s");
        codeToTagMap.put("s", "dataTypePrecision");
        tagToCodeMap.put("userDefined", "t");
        codeToTagMap.put("t", "userDefined");
        tagToCodeMap.put("tableSpace", "u");
        codeToTagMap.put("u", "tableSpace");
        tagToCodeMap.put("OracleView", "v");
        codeToTagMap.put("v", "OracleView");
        tagToCodeMap.put("height", "w");
        codeToTagMap.put("w", "height");
        tagToCodeMap.put("ind_PK_UK", "x");
        codeToTagMap.put("x", "ind_PK_UK");
        tagToCodeMap.put("otype", "y");
        codeToTagMap.put("y", "otype");
        tagToCodeMap.put("itemClass", "z");
        codeToTagMap.put("z", "itemClass");
        tagToCodeMap.put("TableView", "AA");
        codeToTagMap.put("AA", "TableView");
        tagToCodeMap.put("width", "AB");
        codeToTagMap.put("AB", "width");
        tagToCodeMap.put("columnID", "AC");
        codeToTagMap.put("AC", "columnID");
        tagToCodeMap.put("type", "AD");
        codeToTagMap.put("AD", "type");
        tagToCodeMap.put("segment", "AE");
        codeToTagMap.put("AE", "segment");
        tagToCodeMap.put("typeID", "AF");
        codeToTagMap.put("AF", "typeID");
        tagToCodeMap.put("owner", "AG");
        codeToTagMap.put("AG", "owner");
        tagToCodeMap.put("indexState", "AH");
        codeToTagMap.put("AH", "indexState");
        tagToCodeMap.put("columnDependencyConstraintGenerateInDDL", "AI");
        codeToTagMap.put("AI", "columnDependencyConstraintGenerateInDDL");
        tagToCodeMap.put("columnProxies", "AJ");
        codeToTagMap.put("AJ", "columnProxies");
        tagToCodeMap.put("parameters", "AK");
        codeToTagMap.put("AK", "parameters");
        tagToCodeMap.put("commentInRDBMS", "AL");
        codeToTagMap.put("AL", "commentInRDBMS");
        tagToCodeMap.put("OracleTable", "AM");
        codeToTagMap.put("AM", "OracleTable");
        tagToCodeMap.put("oid", "AN");
        codeToTagMap.put("AN", "oid");
        tagToCodeMap.put("Method", "AO");
        codeToTagMap.put("AO", "Method");
        tagToCodeMap.put("IndexProxy", "AP");
        codeToTagMap.put("AP", "IndexProxy");
        tagToCodeMap.put("vid", "AQ");
        codeToTagMap.put("AQ", "vid");
        tagToCodeMap.put("OracleStructuredType", "AR");
        codeToTagMap.put("AR", "OracleStructuredType");
        tagToCodeMap.put("source", "AS");
        codeToTagMap.put("AS", "source");
        tagToCodeMap.put("Permission", "AT");
        codeToTagMap.put("AT", "Permission");
        tagToCodeMap.put("Connector", "AU");
        codeToTagMap.put("AU", "Connector");
        tagToCodeMap.put("attributes", "AV");
        codeToTagMap.put("AV", "attributes");
        tagToCodeMap.put("bodyChanged", "AW");
        codeToTagMap.put("AW", "bodyChanged");
        tagToCodeMap.put("lineWidth", "AX");
        codeToTagMap.put("AX", "lineWidth");
        tagToCodeMap.put("logging", "AY");
        codeToTagMap.put("AY", "logging");
        tagToCodeMap.put("OraclePackage", "AZ");
        codeToTagMap.put("AZ", "OraclePackage");
        tagToCodeMap.put("columns", "Aa");
        codeToTagMap.put("Aa", "columns");
        tagToCodeMap.put("containerWithKeyObject", "Ab");
        codeToTagMap.put("Ab", "containerWithKeyObject");
        tagToCodeMap.put("predefined", "Ac");
        codeToTagMap.put("Ac", "predefined");
        tagToCodeMap.put("privileges", "Ad");
        codeToTagMap.put("Ad", "privileges");
        tagToCodeMap.put("indexSort", "Ae");
        codeToTagMap.put("Ae", "indexSort");
        tagToCodeMap.put("ForeignKey", "Af");
        codeToTagMap.put("Af", "ForeignKey");
        tagToCodeMap.put("colAssociation", "Ag");
        codeToTagMap.put("Ag", "colAssociation");
        tagToCodeMap.put("StructuredType", "Ah");
        codeToTagMap.put("Ah", "StructuredType");
        tagToCodeMap.put("primaryKeys", "Ai");
        codeToTagMap.put("Ai", "primaryKeys");
        tagToCodeMap.put("OracleTrigger", "Aj");
        codeToTagMap.put("Aj", "OracleTrigger");
        tagToCodeMap.put("OracleCollectionType", "Ak");
        codeToTagMap.put("Ak", "OracleCollectionType");
        tagToCodeMap.put("indexes", "Al");
        codeToTagMap.put("Al", "indexes");
        tagToCodeMap.put("returnValue", "Am");
        codeToTagMap.put("Am", "returnValue");
        tagToCodeMap.put("PrimaryKey", "An");
        codeToTagMap.put("An", "PrimaryKey");
        tagToCodeMap.put("indexProxies", "Ao");
        codeToTagMap.put("Ao", "indexProxies");
        tagToCodeMap.put("associations", "Ap");
        codeToTagMap.put("Ap", "associations");
        tagToCodeMap.put("instantiable", "Aq");
        codeToTagMap.put("Aq", "instantiable");
        tagToCodeMap.put("triggerTime", "Ar");
        codeToTagMap.put("Ar", "triggerTime");
        tagToCodeMap.put("Table", "As");
        codeToTagMap.put("As", "Table");
        tagToCodeMap.put("vid_source", "At");
        codeToTagMap.put("At", "vid_source");
        tagToCodeMap.put("vid_target", "Au");
        codeToTagMap.put("Au", "vid_target");
        tagToCodeMap.put("number", "Av");
        codeToTagMap.put("Av", "number");
        tagToCodeMap.put("body", "Aw");
        codeToTagMap.put("Aw", "body");
        tagToCodeMap.put("referencerelation", "Ax");
        codeToTagMap.put("Ax", "referencerelation");
        tagToCodeMap.put("CollectionType", "Ay");
        codeToTagMap.put("Ay", "CollectionType");
        tagToCodeMap.put("OracleFunction", "Az");
        codeToTagMap.put("Az", "OracleFunction");
        tagToCodeMap.put("localFKIndex", "BA");
        codeToTagMap.put("BA", "localFKIndex");
        tagToCodeMap.put("transferable", "BB");
        codeToTagMap.put("BB", "transferable");
        tagToCodeMap.put("dataTypeDescr", "BC");
        codeToTagMap.put("BC", "dataTypeDescr");
        tagToCodeMap.put("delegate", "BD");
        codeToTagMap.put("BD", "delegate");
        tagToCodeMap.put("point", "BE");
        codeToTagMap.put("BE", "point");
        tagToCodeMap.put("actions", "BF");
        codeToTagMap.put("BF", "actions");
        tagToCodeMap.put("deleteRule", "BG");
        codeToTagMap.put("BG", "deleteRule");
        tagToCodeMap.put("referredColumn", "BH");
        codeToTagMap.put("BH", "referredColumn");
        tagToCodeMap.put("x", "BI");
        codeToTagMap.put("BI", "x");
        tagToCodeMap.put("y", "BJ");
        codeToTagMap.put("BJ", "y");
        tagToCodeMap.put("isreference", "BK");
        codeToTagMap.put("BK", "isreference");
        tagToCodeMap.put("fkAssociation", "BL");
        codeToTagMap.put("BL", "fkAssociation");
        tagToCodeMap.put("keyObject", "BM");
        codeToTagMap.put("BM", "keyObject");
        tagToCodeMap.put("maxElement", "BN");
        codeToTagMap.put("BN", "maxElement");
        tagToCodeMap.put("table", "BO");
        codeToTagMap.put("BO", "table");
        tagToCodeMap.put("foreignKeys", "BP");
        codeToTagMap.put("BP", "foreignKeys");
        tagToCodeMap.put("referenceID", "BQ");
        codeToTagMap.put("BQ", "referenceID");
        tagToCodeMap.put("implementationDef", "BR");
        codeToTagMap.put("BR", "implementationDef");
        tagToCodeMap.put("checkConstraint", "BS");
        codeToTagMap.put("BS", "checkConstraint");
        tagToCodeMap.put("basedOnStructuredType", "BT");
        codeToTagMap.put("BT", "basedOnStructuredType");
        tagToCodeMap.put("constraintName", "BU");
        codeToTagMap.put("BU", "constraintName");
        tagToCodeMap.put("final", "BV");
        codeToTagMap.put("BV", "final");
        tagToCodeMap.put("structuredType", "BW");
        codeToTagMap.put("BW", "structuredType");
        tagToCodeMap.put("points", "BX");
        codeToTagMap.put("BX", "points");
        tagToCodeMap.put("UniqueKey", "BY");
        codeToTagMap.put("BY", "UniqueKey");
        tagToCodeMap.put("package", "BZ");
        codeToTagMap.put("BZ", "package");
        tagToCodeMap.put("checkOption", "Ba");
        codeToTagMap.put("Ba", "checkOption");
        tagToCodeMap.put("uniqueKeys", "Bb");
        codeToTagMap.put("Bb", "uniqueKeys");
        tagToCodeMap.put("readOnly", "Bc");
        codeToTagMap.put("Bc", "readOnly");
        tagToCodeMap.put("view", "Bd");
        codeToTagMap.put("Bd", "view");
        tagToCodeMap.put("dataSegmentCompression", "Be");
        codeToTagMap.put("Be", "dataSegmentCompression");
        tagToCodeMap.put("deferrable", "Bf");
        codeToTagMap.put("Bf", "deferrable");
        tagToCodeMap.put("methods", "Bg");
        codeToTagMap.put("Bg", "methods");
        tagToCodeMap.put("pk", "Bh");
        codeToTagMap.put("Bh", "pk");
        tagToCodeMap.put("OracleSequence", "Bi");
        codeToTagMap.put("Bi", "OracleSequence");
        tagToCodeMap.put("initially", "Bj");
        codeToTagMap.put("Bj", "initially");
        tagToCodeMap.put("LobStorage", "Bk");
        codeToTagMap.put("Bk", "LobStorage");
        tagToCodeMap.put("OracleStoredProcedure", "Bl");
        codeToTagMap.put("Bl", "OracleStoredProcedure");
        tagToCodeMap.put("existingIndex", "Bm");
        codeToTagMap.put("Bm", "existingIndex");
        tagToCodeMap.put("incrementBy", "Bn");
        codeToTagMap.put("Bn", "incrementBy");
        tagToCodeMap.put("overriding", "Bo");
        codeToTagMap.put("Bo", "overriding");
        tagToCodeMap.put("cache", "Bp");
        codeToTagMap.put("Bp", "cache");
        tagToCodeMap.put("constructor", "Bq");
        codeToTagMap.put("Bq", "constructor");
        tagToCodeMap.put("dataTypeScale", "Br");
        codeToTagMap.put("Br", "dataTypeScale");
        tagToCodeMap.put("definition", "Bs");
        codeToTagMap.put("Bs", "definition");
        tagToCodeMap.put("inheritanceRelation", "Bt");
        codeToTagMap.put("Bt", "inheritanceRelation");
        tagToCodeMap.put("lobStorages", "Bu");
        codeToTagMap.put("Bu", "lobStorages");
        tagToCodeMap.put("privilegesWithGrantOption", "Bv");
        codeToTagMap.put("Bv", "privilegesWithGrantOption");
        tagToCodeMap.put("usingIndex", "Bw");
        codeToTagMap.put("Bw", "usingIndex");
        tagToCodeMap.put("Partition", "Bx");
        codeToTagMap.put("Bx", "Partition");
        tagToCodeMap.put("column", "By");
        codeToTagMap.put("By", "column");
        tagToCodeMap.put("maxValue", "Bz");
        codeToTagMap.put("Bz", "maxValue");
        tagToCodeMap.put("minValue", "CA");
        codeToTagMap.put("CA", "minValue");
        tagToCodeMap.put("oidText", "CB");
        codeToTagMap.put("CB", "oidText");
        tagToCodeMap.put("organization", "CC");
        codeToTagMap.put("CC", "organization");
        tagToCodeMap.put("position", "CD");
        codeToTagMap.put("CD", "position");
        tagToCodeMap.put("user", "CE");
        codeToTagMap.put("CE", "user");
        tagToCodeMap.put("valueList", "CF");
        codeToTagMap.put("CF", "valueList");
        tagToCodeMap.put("allowSubtypeSubstitution", "CG");
        codeToTagMap.put("CG", "allowSubtypeSubstitution");
        tagToCodeMap.put("chunk", "CH");
        codeToTagMap.put("CH", "chunk");
        tagToCodeMap.put("collectionType", "CI");
        codeToTagMap.put("CI", "collectionType");
        tagToCodeMap.put("dbType", "CJ");
        codeToTagMap.put("CJ", "dbType");
        tagToCodeMap.put("isFinal", "CK");
        codeToTagMap.put("CK", "isFinal");
        tagToCodeMap.put("parentTypeID", "CL");
        codeToTagMap.put("CL", "parentTypeID");
        tagToCodeMap.put("partitioned", "CM");
        codeToTagMap.put("CM", "partitioned");
        tagToCodeMap.put("plSQLBody", "CN");
        codeToTagMap.put("CN", "plSQLBody");
        tagToCodeMap.put("OracleSegment", "CO");
        codeToTagMap.put("CO", "OracleSegment");
        tagToCodeMap.put("clusterColumns", "CP");
        codeToTagMap.put("CP", "clusterColumns");
        tagToCodeMap.put("columnIDs", "CQ");
        codeToTagMap.put("CQ", "columnIDs");
        tagToCodeMap.put("indexExpression", "CR");
        codeToTagMap.put("CR", "indexExpression");
        tagToCodeMap.put("indexPartitioned", "CS");
        codeToTagMap.put("CS", "indexPartitioned");
        tagToCodeMap.put("isStatic", "CT");
        codeToTagMap.put("CT", "isStatic");
        tagToCodeMap.put("notNullConstraintName", "CU");
        codeToTagMap.put("CU", "notNullConstraintName");
        tagToCodeMap.put("partitionList", "CV");
        codeToTagMap.put("CV", "partitionList");
        tagToCodeMap.put("partitions", "CW");
        codeToTagMap.put("CW", "partitions");
        tagToCodeMap.put("scInitialExtent", "CX");
        codeToTagMap.put("CX", "scInitialExtent");
        tagToCodeMap.put("scMaxExtents", "CY");
        codeToTagMap.put("CY", "scMaxExtents");
        tagToCodeMap.put("tempPreserveRows", "CZ");
        codeToTagMap.put("CZ", "tempPreserveRows");
        tagToCodeMap.put("temporary", "Ca");
        codeToTagMap.put("Ca", "temporary");
        tagToCodeMap.put("temptableSpace", "Cb");
        codeToTagMap.put("Cb", "temptableSpace");
        tagToCodeMap.put("xmlSchemaElement", "Cc");
        codeToTagMap.put("Cc", "xmlSchemaElement");
        tagToCodeMap.put("BusinessInfoModel", "Cd");
        codeToTagMap.put("Cd", "BusinessInfoModel");
        tagToCodeMap.put("CollectionTypes", "Ce");
        codeToTagMap.put("Ce", "CollectionTypes");
        tagToCodeMap.put("DBSite", "Cf");
        codeToTagMap.put("Cf", "DBSite");
        tagToCodeMap.put("DataFile", "Cg");
        codeToTagMap.put("Cg", "DataFile");
        tagToCodeMap.put("DataTypesModel", "Ch");
        codeToTagMap.put("Ch", "DataTypesModel");
        tagToCodeMap.put("Diagram", "Ci");
        codeToTagMap.put("Ci", "Diagram");
        tagToCodeMap.put("Diagrams", "Cj");
        codeToTagMap.put("Cj", "Diagrams");
        tagToCodeMap.put("Domain", "Ck");
        codeToTagMap.put("Ck", "Domain");
        tagToCodeMap.put("ForeignKeys", "Cl");
        codeToTagMap.put("Cl", "ForeignKeys");
        tagToCodeMap.put("Hierarchy", "Cm");
        codeToTagMap.put("Cm", "Hierarchy");
        tagToCodeMap.put("Index", "Cn");
        codeToTagMap.put("Cn", "Index");
        tagToCodeMap.put("Level", "Co");
        codeToTagMap.put("Co", "Level");
        tagToCodeMap.put("LogicalModel", "Cp");
        codeToTagMap.put("Cp", "LogicalModel");
        tagToCodeMap.put("MaskTemplate", "Cq");
        codeToTagMap.put("Cq", "MaskTemplate");
        tagToCodeMap.put("MaskTemplateFile", "Cr");
        codeToTagMap.put("Cr", "MaskTemplateFile");
        tagToCodeMap.put("OSDM_Design", "Cs");
        codeToTagMap.put("Cs", "OSDM_Design");
        tagToCodeMap.put("OracleCluster", "Ct");
        codeToTagMap.put("Ct", "OracleCluster");
        tagToCodeMap.put("OracleClusters", "Cu");
        codeToTagMap.put("Cu", "OracleClusters");
        tagToCodeMap.put("OracleCollectionTypes", "Cv");
        codeToTagMap.put("Cv", "OracleCollectionTypes");
        tagToCodeMap.put("OracleContext", "Cw");
        codeToTagMap.put("Cw", "OracleContext");
        tagToCodeMap.put("OracleContexts", "Cx");
        codeToTagMap.put("Cx", "OracleContexts");
        tagToCodeMap.put("OracleDimension", "Cy");
        codeToTagMap.put("Cy", "OracleDimension");
        tagToCodeMap.put("OracleDimensions", "Cz");
        codeToTagMap.put("Cz", "OracleDimensions");
        tagToCodeMap.put("OracleDirectories", "DA");
        codeToTagMap.put("DA", "OracleDirectories");
        tagToCodeMap.put("OracleDirectory", "DB");
        codeToTagMap.put("DB", "OracleDirectory");
        tagToCodeMap.put("OracleExternalTable", "DC");
        codeToTagMap.put("DC", "OracleExternalTable");
        tagToCodeMap.put("OracleExternalTables", "DD");
        codeToTagMap.put("DD", "OracleExternalTables");
        tagToCodeMap.put("OracleFunctions", "DE");
        codeToTagMap.put("DE", "OracleFunctions");
        tagToCodeMap.put("OraclePackages", "DF");
        codeToTagMap.put("DF", "OraclePackages");
        tagToCodeMap.put("OracleRole", "DG");
        codeToTagMap.put("DG", "OracleRole");
        tagToCodeMap.put("OracleRoles", "DH");
        codeToTagMap.put("DH", "OracleRoles");
        tagToCodeMap.put("OracleSegments", "DI");
        codeToTagMap.put("DI", "OracleSegments");
        tagToCodeMap.put("OracleSequences", "DJ");
        codeToTagMap.put("DJ", "OracleSequences");
        tagToCodeMap.put("OracleSnapshot", "DK");
        codeToTagMap.put("DK", "OracleSnapshot");
        tagToCodeMap.put("OracleSnapshots", "DL");
        codeToTagMap.put("DL", "OracleSnapshots");
        tagToCodeMap.put("OracleStoredProcedures", "DM");
        codeToTagMap.put("DM", "OracleStoredProcedures");
        tagToCodeMap.put("OracleStructuredTypes", "DN");
        codeToTagMap.put("DN", "OracleStructuredTypes");
        tagToCodeMap.put("OracleSynonyms", "DO");
        codeToTagMap.put("DO", "OracleSynonyms");
        tagToCodeMap.put("OracleTableSpace", "DP");
        codeToTagMap.put("DP", "OracleTableSpace");
        tagToCodeMap.put("OracleTableSpaces", "DQ");
        codeToTagMap.put("DQ", "OracleTableSpaces");
        tagToCodeMap.put("OracleTables", "DR");
        codeToTagMap.put("DR", "OracleTables");
        tagToCodeMap.put("OracleTemporaryTableSpace", "DS");
        codeToTagMap.put("DS", "OracleTemporaryTableSpace");
        tagToCodeMap.put("OracleTemporaryTableSpaces", "DT");
        codeToTagMap.put("DT", "OracleTemporaryTableSpaces");
        tagToCodeMap.put("OracleTriggers", "DU");
        codeToTagMap.put("DU", "OracleTriggers");
        tagToCodeMap.put("OracleUndoTableSpace", "DV");
        codeToTagMap.put("DV", "OracleUndoTableSpace");
        tagToCodeMap.put("OracleUndoTableSpaces", "DW");
        codeToTagMap.put("DW", "OracleUndoTableSpaces");
        tagToCodeMap.put("OracleUser", "DX");
        codeToTagMap.put("DX", "OracleUser");
        tagToCodeMap.put("OracleUsers", "DY");
        codeToTagMap.put("DY", "OracleUsers");
        tagToCodeMap.put("OracleViews", "DZ");
        codeToTagMap.put("DZ", "OracleViews");
        tagToCodeMap.put("ProcessModel", "Da");
        codeToTagMap.put("Da", "ProcessModel");
        tagToCodeMap.put("RelationalModel", "Db");
        codeToTagMap.put("Db", "RelationalModel");
        tagToCodeMap.put("RelationalModels", "Dc");
        codeToTagMap.put("Dc", "RelationalModels");
        tagToCodeMap.put("Schema", "Dd");
        codeToTagMap.put("Dd", "Schema");
        tagToCodeMap.put("Schemas", "De");
        codeToTagMap.put("De", "Schemas");
        tagToCodeMap.put("SensitiveType", "Df");
        codeToTagMap.put("Df", "SensitiveType");
        tagToCodeMap.put("SensitiveTypeFileWrapper", "Dg");
        codeToTagMap.put("Dg", "SensitiveTypeFileWrapper");
        tagToCodeMap.put("StorageDesign", "Dh");
        codeToTagMap.put("Dh", "StorageDesign");
        tagToCodeMap.put("StorageDesigns", "Di");
        codeToTagMap.put("Di", "StorageDesigns");
        tagToCodeMap.put("StructuredTypes", "Dj");
        codeToTagMap.put("Dj", "StructuredTypes");
        tagToCodeMap.put("TSDPPolicy", "Dk");
        codeToTagMap.put("Dk", "TSDPPolicy");
        tagToCodeMap.put("TSDPPolicyFileWrapper", "Dl");
        codeToTagMap.put("Dl", "TSDPPolicyFileWrapper");
        tagToCodeMap.put("TableCheckConstraint", "Dm");
        codeToTagMap.put("Dm", "TableCheckConstraint");
        tagToCodeMap.put("TableViews", "Dn");
        codeToTagMap.put("Dn", "TableViews");
        tagToCodeMap.put("Tables", "Do");
        codeToTagMap.put("Do", "Tables");
        tagToCodeMap.put("action", "Dp");
        codeToTagMap.put("Dp", "action");
        tagToCodeMap.put("allowAnySchema", "Dq");
        codeToTagMap.put("Dq", "allowAnySchema");
        tagToCodeMap.put("allowNonSchema", "Dr");
        codeToTagMap.put("Dr", "allowNonSchema");
        tagToCodeMap.put("autoRoute", "Ds");
        codeToTagMap.put("Ds", "autoRoute");
        tagToCodeMap.put("autoextend", "Dt");
        codeToTagMap.put("Dt", "autoextend");
        tagToCodeMap.put("avTSortOrder", "Du");
        codeToTagMap.put("Du", "avTSortOrder");
        tagToCodeMap.put("bitmapIndex", "Dv");
        codeToTagMap.put("Dv", "bitmapIndex");
        tagToCodeMap.put("boxInbox", "Dw");
        codeToTagMap.put("Dw", "boxInbox");
        tagToCodeMap.put("build", "Dx");
        codeToTagMap.put("Dx", "build");
        tagToCodeMap.put("capitalNames", "Dy");
        codeToTagMap.put("Dy", "capitalNames");
        tagToCodeMap.put("cluster", "Dz");
        codeToTagMap.put("Dz", "cluster");
        tagToCodeMap.put("collectionOfRefsPrefix", "EA");
        codeToTagMap.put("EA", "collectionOfRefsPrefix");
        tagToCodeMap.put("collectionPrefix", "EB");
        codeToTagMap.put("EB", "collectionPrefix");
        tagToCodeMap.put("collectionTypeOracle", "EC");
        codeToTagMap.put("EC", "collectionTypeOracle");
        tagToCodeMap.put("columnExpression", "ED");
        codeToTagMap.put("ED", "columnExpression");
        tagToCodeMap.put("columnList", "EE");
        codeToTagMap.put("EE", "columnList");
        tagToCodeMap.put("columnsCollection", "EF");
        codeToTagMap.put("EF", "columnsCollection");
        tagToCodeMap.put("comment", "EG");
        codeToTagMap.put("EG", "comment");
        tagToCodeMap.put("compress", "EH");
        codeToTagMap.put("EH", "compress");
        tagToCodeMap.put("computed", "EI");
        codeToTagMap.put("EI", "computed");
        tagToCodeMap.put("condition", "EJ");
        codeToTagMap.put("EJ", "condition");
        tagToCodeMap.put("connName", "EK");
        codeToTagMap.put("EK", "connName");
        tagToCodeMap.put("connType", "EL");
        codeToTagMap.put("EL", "connType");
        tagToCodeMap.put("connUrl", "EM");
        codeToTagMap.put("EM", "connUrl");
        tagToCodeMap.put("connUser", "EN");
        codeToTagMap.put("EN", "connUser");
        tagToCodeMap.put("connectors", "EO");
        codeToTagMap.put("EO", "connectors");
        tagToCodeMap.put("container", "EP");
        codeToTagMap.put("EP", "container");
        tagToCodeMap.put("copySelf", "EQ");
        codeToTagMap.put("EQ", "copySelf");
        tagToCodeMap.put("cycle", "ER");
        codeToTagMap.put("ER", "cycle");
        tagToCodeMap.put("dataFiles", "ES");
        codeToTagMap.put("ES", "dataFiles");
        tagToCodeMap.put("datatype", "ET");
        codeToTagMap.put("ET", "datatype");
        tagToCodeMap.put("day", "EU");
        codeToTagMap.put("EU", "day");
        tagToCodeMap.put("defTableSpace", "EV");
        codeToTagMap.put("EV", "defTableSpace");
        tagToCodeMap.put("defaultArrayLimit", "EW");
        codeToTagMap.put("EW", "defaultArrayLimit");
        tagToCodeMap.put("defaultCollectionType_Kind", "EX");
        codeToTagMap.put("EX", "defaultCollectionType_Kind");
        tagToCodeMap.put("defaultCollectionType_Suffix", "EY");
        codeToTagMap.put("EY", "defaultCollectionType_Suffix");
        tagToCodeMap.put("defaultDBSites", "EZ");
        codeToTagMap.put("EZ", "defaultDBSites");
        tagToCodeMap.put("defaultDomains", "Ea");
        codeToTagMap.put("Ea", "defaultDomains");
        tagToCodeMap.put("defaultSegment", "Eb");
        codeToTagMap.put("Eb", "defaultSegment");
        tagToCodeMap.put("defaultdir", "Ec");
        codeToTagMap.put("Ec", "defaultdir");
        tagToCodeMap.put("description", "Ed");
        codeToTagMap.put("Ed", "description");
        tagToCodeMap.put("designId", "Ee");
        codeToTagMap.put("Ee", "designId");
        tagToCodeMap.put("diagramColor", "Ef");
        codeToTagMap.put("Ef", "diagramColor");
        tagToCodeMap.put("dirPath", "Eg");
        codeToTagMap.put("Eg", "dirPath");
        tagToCodeMap.put("directoryOracle", "Eh");
        codeToTagMap.put("Eh", "directoryOracle");
        tagToCodeMap.put("display", "Ei");
        codeToTagMap.put("Ei", "display");
        tagToCodeMap.put("dsCompression", "Ej");
        codeToTagMap.put("Ej", "dsCompression");
        tagToCodeMap.put("dsInitialExtent", "Ek");
        codeToTagMap.put("Ek", "dsInitialExtent");
        tagToCodeMap.put("dsMaxExtents", "El");
        codeToTagMap.put("El", "dsMaxExtents");
        tagToCodeMap.put("emUniformSize", "Em");
        codeToTagMap.put("Em", "emUniformSize");
        tagToCodeMap.put("embeddedStructuredTypePrefix", "En");
        codeToTagMap.put("En", "embeddedStructuredTypePrefix");
        tagToCodeMap.put("enable", "Eo");
        codeToTagMap.put("Eo", "enable");
        tagToCodeMap.put("expression", "Ep");
        codeToTagMap.put("Ep", "expression");
        tagToCodeMap.put("extendedMap", "Eq");
        codeToTagMap.put("Eq", "extendedMap");
        tagToCodeMap.put("extentManagement", "Er");
        codeToTagMap.put("Er", "extentManagement");
        tagToCodeMap.put("fileName", "Es");
        codeToTagMap.put("Es", "fileName");
        tagToCodeMap.put("fileType", "Et");
        codeToTagMap.put("Et", "fileType");
        tagToCodeMap.put("formulaDesc", "Eu");
        codeToTagMap.put("Eu", "formulaDesc");
        tagToCodeMap.put("function", "Ev");
        codeToTagMap.put("Ev", "function");
        tagToCodeMap.put("functionType", "Ew");
        codeToTagMap.put("Ew", "functionType");
        tagToCodeMap.put("hierarchies", "Ex");
        codeToTagMap.put("Ex", "hierarchies");
        tagToCodeMap.put("hour", "Ey");
        codeToTagMap.put("Ey", "hour");
        tagToCodeMap.put("identified", "Ez");
        codeToTagMap.put("Ez", "identified");
        tagToCodeMap.put("importConnectionStamp", "FA");
        codeToTagMap.put("FA", "importConnectionStamp");
        tagToCodeMap.put("importConnectionStamps", "FB");
        codeToTagMap.put("FB", "importConnectionStamps");
        tagToCodeMap.put("indexDomainParameters", "FC");
        codeToTagMap.put("FC", "indexDomainParameters");
        tagToCodeMap.put("indexSegment", "FD");
        codeToTagMap.put("FD", "indexSegment");
        tagToCodeMap.put("indexType", "FE");
        codeToTagMap.put("FE", "indexType");
        tagToCodeMap.put("indexesCollection", "FF");
        codeToTagMap.put("FF", "indexesCollection");
        tagToCodeMap.put("initrans", "FG");
        codeToTagMap.put("FG", "initrans");
        tagToCodeMap.put("inputFormat", "FH");
        codeToTagMap.put("FH", "inputFormat");
        tagToCodeMap.put("joins", "FI");
        codeToTagMap.put("FI", "joins");
        tagToCodeMap.put("lengthPrecision", "FJ");
        codeToTagMap.put("FJ", "lengthPrecision");
        tagToCodeMap.put("level", "FK");
        codeToTagMap.put("FK", "level");
        tagToCodeMap.put("levelTable", "FL");
        codeToTagMap.put("FL", "levelTable");
        tagToCodeMap.put("levels", "FM");
        codeToTagMap.put("FM", "levels");
        tagToCodeMap.put("lobSegmentName", "FN");
        codeToTagMap.put("FN", "lobSegmentName");
        tagToCodeMap.put("lobStorageType", "FO");
        codeToTagMap.put("FO", "lobStorageType");
        tagToCodeMap.put("location", "FP");
        codeToTagMap.put("FP", "location");
        tagToCodeMap.put("mainView", "FQ");
        codeToTagMap.put("FQ", "mainView");
        tagToCodeMap.put("mainViewID", "FR");
        codeToTagMap.put("FR", "mainViewID");
        tagToCodeMap.put("mapOrderFunction", "FS");
        codeToTagMap.put("FS", "mapOrderFunction");
        tagToCodeMap.put("maskChar", "FT");
        codeToTagMap.put("FT", "maskChar");
        tagToCodeMap.put("maskFrom", "FU");
        codeToTagMap.put("FU", "maskFrom");
        tagToCodeMap.put("maskTemplate", "FV");
        codeToTagMap.put("FV", "maskTemplate");
        tagToCodeMap.put("maskTemplates", "FW");
        codeToTagMap.put("FW", "maskTemplates");
        tagToCodeMap.put("maskTo", "FX");
        codeToTagMap.put("FX", "maskTo");
        tagToCodeMap.put("maskType", "FY");
        codeToTagMap.put("FY", "maskType");
        tagToCodeMap.put("materializedView", "FZ");
        codeToTagMap.put("FZ", "materializedView");
        tagToCodeMap.put("maxTrans", "Fa");
        codeToTagMap.put("Fa", "maxTrans");
        tagToCodeMap.put("minExtLen", "Fb");
        codeToTagMap.put("Fb", "minExtLen");
        tagToCodeMap.put("minute", "Fc");
        codeToTagMap.put("Fc", "minute");
        tagToCodeMap.put("month", "Fd");
        codeToTagMap.put("Fd", "month");
        tagToCodeMap.put("namespace", "Fe");
        codeToTagMap.put("Fe", "namespace");
        tagToCodeMap.put("nextBlockSize", "Ff");
        codeToTagMap.put("Ff", "nextBlockSize");
        tagToCodeMap.put("noCache", "Fg");
        codeToTagMap.put("Fg", "noCache");
        tagToCodeMap.put("notation", "Fh");
        codeToTagMap.put("Fh", "notation");
        tagToCodeMap.put("notes", "Fi");
        codeToTagMap.put("Fi", "notes");
        tagToCodeMap.put("objectViews", "Fj");
        codeToTagMap.put("Fj", "objectViews");
        tagToCodeMap.put("occurrence", "Fk");
        codeToTagMap.put("Fk", "occurrence");
        tagToCodeMap.put("oidKey", "Fl");
        codeToTagMap.put("Fl", "oidKey");
        tagToCodeMap.put("opaqueFormatSpec", "Fm");
        codeToTagMap.put("Fm", "opaqueFormatSpec");
        tagToCodeMap.put("order", "Fn");
        codeToTagMap.put("Fn", "order");
        tagToCodeMap.put("outputFormat", "Fo");
        codeToTagMap.put("Fo", "outputFormat");
        tagToCodeMap.put("parallel", "Fp");
        codeToTagMap.put("Fp", "parallel");
        tagToCodeMap.put("partitionType", "Fq");
        codeToTagMap.put("Fq", "partitionType");
        tagToCodeMap.put("pathID", "Fr");
        codeToTagMap.put("Fr", "pathID");
        tagToCodeMap.put("pattern", "Fs");
        codeToTagMap.put("Fs", "pattern");
        tagToCodeMap.put("pcTFree", "Ft");
        codeToTagMap.put("Ft", "pcTFree");
        tagToCodeMap.put("pcTUsed", "Fu");
        codeToTagMap.put("Fu", "pcTUsed");
        tagToCodeMap.put("pcTVersion", "Fv");
        codeToTagMap.put("Fv", "pcTVersion");
        tagToCodeMap.put("permissions", "Fw");
        codeToTagMap.put("Fw", "permissions");
        tagToCodeMap.put("privilegesWithAdminOption", "Fx");
        codeToTagMap.put("Fx", "privilegesWithAdminOption");
        tagToCodeMap.put("proc", "Fy");
        codeToTagMap.put("Fy", "proc");
        tagToCodeMap.put("profile", "Fz");
        codeToTagMap.put("Fz", "profile");
        tagToCodeMap.put("propertyDatatype", "GA");
        codeToTagMap.put("GA", "propertyDatatype");
        tagToCodeMap.put("propertyLenght", "GB");
        codeToTagMap.put("GB", "propertyLenght");
        tagToCodeMap.put("propertyparentTable", "GC");
        codeToTagMap.put("GC", "propertyparentTable");
        tagToCodeMap.put("queryRewrite", "GD");
        codeToTagMap.put("GD", "queryRewrite");
        tagToCodeMap.put("ref_NEW_AS", "GE");
        codeToTagMap.put("GE", "ref_NEW_AS");
        tagToCodeMap.put("ref_OLD_AS", "GF");
        codeToTagMap.put("GF", "ref_OLD_AS");
        tagToCodeMap.put("referencePrefix", "GG");
        codeToTagMap.put("GG", "referencePrefix");
        tagToCodeMap.put("refresh", "GH");
        codeToTagMap.put("GH", "refresh");
        tagToCodeMap.put("refreshType", "GI");
        codeToTagMap.put("GI", "refreshType");
        tagToCodeMap.put("rejectLimit", "GJ");
        codeToTagMap.put("GJ", "rejectLimit");
        tagToCodeMap.put("replaceString", "GK");
        codeToTagMap.put("GK", "replaceString");
        tagToCodeMap.put("rmExtendedMap", "GL");
        codeToTagMap.put("GL", "rmExtendedMap");
        tagToCodeMap.put("roles", "GM");
        codeToTagMap.put("GM", "roles");
        tagToCodeMap.put("rolesWithAdminOption", "GN");
        codeToTagMap.put("GN", "rolesWithAdminOption");
        tagToCodeMap.put("rule", "GO");
        codeToTagMap.put("GO", "rule");
        tagToCodeMap.put("second", "GP");
        codeToTagMap.put("GP", "second");
        tagToCodeMap.put("selectedRDBMSSite", "GQ");
        codeToTagMap.put("GQ", "selectedRDBMSSite");
        tagToCodeMap.put("sensitiveTypes", "GR");
        codeToTagMap.put("GR", "sensitiveTypes");
        tagToCodeMap.put("sequence", "GS");
        codeToTagMap.put("GS", "sequence");
        tagToCodeMap.put("shouldBeOpen", "GT");
        codeToTagMap.put("GT", "shouldBeOpen");
        tagToCodeMap.put("showGrid", "GU");
        codeToTagMap.put("GU", "showGrid");
        tagToCodeMap.put("showLabels", "GV");
        codeToTagMap.put("GV", "showLabels");
        tagToCodeMap.put("showLegend", "GW");
        codeToTagMap.put("GW", "showLegend");
        tagToCodeMap.put("showRelAttributes", "GX");
        codeToTagMap.put("GX", "showRelAttributes");
        tagToCodeMap.put("siteID", "GY");
        codeToTagMap.put("GY", "siteID");
        tagToCodeMap.put("siteName", "GZ");
        codeToTagMap.put("GZ", "siteName");
        tagToCodeMap.put("siteType", "Ga");
        codeToTagMap.put("Ga", "siteType");
        tagToCodeMap.put("sortOrder", "Gb");
        codeToTagMap.put("Gb", "sortOrder");
        tagToCodeMap.put("storageInRow", "Gc");
        codeToTagMap.put("Gc", "storageInRow");
        tagToCodeMap.put("storeAs", "Gd");
        codeToTagMap.put("Gd", "storeAs");
        tagToCodeMap.put("structuredTypeOracle", "Ge");
        codeToTagMap.put("Ge", "structuredTypeOracle");
        tagToCodeMap.put("subPolicies", "Gf");
        codeToTagMap.put("Gf", "subPolicies");
        tagToCodeMap.put("subPolicy", "Gg");
        codeToTagMap.put("Gg", "subPolicy");
        tagToCodeMap.put("subquery", "Gh");
        codeToTagMap.put("Gh", "subquery");
        tagToCodeMap.put("tableCheckConstraint", "Gi");
        codeToTagMap.put("Gi", "tableCheckConstraint");
        tagToCodeMap.put("tableCheckConstraints", "Gj");
        codeToTagMap.put("Gj", "tableCheckConstraints");
        tagToCodeMap.put("tablespace", "Gk");
        codeToTagMap.put("Gk", "tablespace");
        tagToCodeMap.put("tsdpPolicies", "Gl");
        codeToTagMap.put("Gl", "tsdpPolicies");
        tagToCodeMap.put("typeSubstitution", "Gm");
        codeToTagMap.put("Gm", "typeSubstitution");
        tagToCodeMap.put("typeSubstitutionID", "Gn");
        codeToTagMap.put("Gn", "typeSubstitutionID");
        tagToCodeMap.put("typeSubstitutionParentID", "Go");
        codeToTagMap.put("Go", "typeSubstitutionParentID");
        tagToCodeMap.put("uniformSize", "Gp");
        codeToTagMap.put("Gp", "uniformSize");
        tagToCodeMap.put("useIndex", "Gq");
        codeToTagMap.put("Gq", "useIndex");
        tagToCodeMap.put("useRoleInAssociationEndAsName", "Gr");
        codeToTagMap.put("Gr", "useRoleInAssociationEndAsName");
        tagToCodeMap.put("validate", "Gs");
        codeToTagMap.put("Gs", "validate");
        tagToCodeMap.put("version", "Gt");
        codeToTagMap.put("Gt", "version");
        tagToCodeMap.put("visible", "Gu");
        codeToTagMap.put("Gu", "visible");
        tagToCodeMap.put("with", "Gv");
        codeToTagMap.put("Gv", "with");
        tagToCodeMap.put("xmlSchemaUrl", "Gw");
        codeToTagMap.put("Gw", "xmlSchemaUrl");
        tagToCodeMap.put("year", "Gx");
        codeToTagMap.put("Gx", "year");
        tagToCodeMap.put("ChangeRequest", "HA");
        codeToTagMap.put("HA", "ChangeRequest");
        tagToCodeMap.put("ChangeRequests", "HB");
        codeToTagMap.put("HB", "ChangeRequests");
        tagToCodeMap.put("Display", "HC");
        codeToTagMap.put("HC", "Display");
        tagToCodeMap.put("DistinctType", "HD");
        codeToTagMap.put("HD", "DistinctType");
        tagToCodeMap.put("DistinctTypes", "HE");
        codeToTagMap.put("HE", "DistinctTypes");
        tagToCodeMap.put("Entities", "HF");
        codeToTagMap.put("HF", "Entities");
        tagToCodeMap.put("Entity", "HG");
        codeToTagMap.put("HG", "Entity");
        tagToCodeMap.put("EntityView", "HH");
        codeToTagMap.put("HH", "EntityView");
        tagToCodeMap.put("EntityViews", "HI");
        codeToTagMap.put("HI", "EntityViews");
        tagToCodeMap.put("Measurement", "HJ");
        codeToTagMap.put("HJ", "Measurement");
        tagToCodeMap.put("Relationship", "HK");
        codeToTagMap.put("HK", "Relationship");
        tagToCodeMap.put("Relationships", "HL");
        codeToTagMap.put("HL", "Relationships");
        tagToCodeMap.put("UsedObject", "HM");
        codeToTagMap.put("HM", "UsedObject");
        tagToCodeMap.put("additionalClassificationTypes", "HN");
        codeToTagMap.put("HN", "additionalClassificationTypes");
        tagToCodeMap.put("adequatelyNormalized", "HO");
        codeToTagMap.put("HO", "adequatelyNormalized");
        tagToCodeMap.put("allowColumnReorder", "HP");
        codeToTagMap.put("HP", "allowColumnReorder");
        tagToCodeMap.put("attributeRef", "HQ");
        codeToTagMap.put("HQ", "attributeRef");
        tagToCodeMap.put("autoIncrementColumn", "HR");
        codeToTagMap.put("HR", "autoIncrementColumn");
        tagToCodeMap.put("beginValue", "HS");
        codeToTagMap.put("HS", "beginValue");
        tagToCodeMap.put("columnName", "HT");
        codeToTagMap.put("HT", "columnName");
        tagToCodeMap.put("containerID", "HU");
        codeToTagMap.put("HU", "containerID");
        tagToCodeMap.put("containsSensitiveInformation", "HV");
        codeToTagMap.put("HV", "containsSensitiveInformation");
        tagToCodeMap.put("creationDate", "HW");
        codeToTagMap.put("HW", "creationDate");
        tagToCodeMap.put("deprecated", "HX");
        codeToTagMap.put("HX", "deprecated");
        tagToCodeMap.put("displays", "HY");
        codeToTagMap.put("HY", "displays");
        tagToCodeMap.put("distinctType", "HZ");
        codeToTagMap.put("HZ", "distinctType");
        tagToCodeMap.put("effectiveDate", "Ha");
        codeToTagMap.put("Ha", "effectiveDate");
        tagToCodeMap.put("endTimeColumn", "Hb");
        codeToTagMap.put("Hb", "endTimeColumn");
        tagToCodeMap.put("endValue", "Hc");
        codeToTagMap.put("Hc", "endValue");
        tagToCodeMap.put("engineerTo", "Hd");
        codeToTagMap.put("Hd", "engineerTo");
        tagToCodeMap.put("existDependencyGenerateInDDl", "He");
        codeToTagMap.put("He", "existDependencyGenerateInDDl");
        tagToCodeMap.put("expectedVolumes", "Hf");
        codeToTagMap.put("Hf", "expectedVolumes");
        tagToCodeMap.put("fwdEngineeringStrategyName", "Hg");
        codeToTagMap.put("Hg", "fwdEngineeringStrategyName");
        tagToCodeMap.put("generatorID", "Hh");
        codeToTagMap.put("Hh", "generatorID");
        tagToCodeMap.put("generatorId", "Hi");
        codeToTagMap.put("Hi", "generatorId");
        tagToCodeMap.put("growthPercent", "Hj");
        codeToTagMap.put("Hj", "growthPercent");
        tagToCodeMap.put("growthType", "Hk");
        codeToTagMap.put("Hk", "growthType");
        tagToCodeMap.put("headerAlias", "Hl");
        codeToTagMap.put("Hl", "headerAlias");
        tagToCodeMap.put("identifier", "Hm");
        codeToTagMap.put("Hm", "identifier");
        tagToCodeMap.put("identifiers", "Hn");
        codeToTagMap.put("Hn", "identifiers");
        tagToCodeMap.put("identifying", "Ho");
        codeToTagMap.put("Ho", "identifying");
        tagToCodeMap.put("identityColumn", "Hp");
        codeToTagMap.put("Hp", "identityColumn");
        tagToCodeMap.put("implDescription", "Hq");
        codeToTagMap.put("Hq", "implDescription");
        tagToCodeMap.put("importedID", "Hr");
        codeToTagMap.put("Hr", "importedID");
        tagToCodeMap.put("isSurrogateKey", "Hs");
        codeToTagMap.put("Hs", "isSurrogateKey");
        tagToCodeMap.put("item", "Ht");
        codeToTagMap.put("Ht", "item");
        tagToCodeMap.put("key", "Hu");
        codeToTagMap.put("Hu", "key");
        tagToCodeMap.put("layoutSQL", "Hv");
        codeToTagMap.put("Hv", "layoutSQL");
        tagToCodeMap.put("listOfRanges", "Hw");
        codeToTagMap.put("Hw", "listOfRanges");
        tagToCodeMap.put("listOfValues", "Hx");
        codeToTagMap.put("Hx", "listOfValues");
        tagToCodeMap.put("logicalDataType", "Hy");
        codeToTagMap.put("Hy", "logicalDataType");
        tagToCodeMap.put("maskingType", "Hz");
        codeToTagMap.put("Hz", "maskingType");
        tagToCodeMap.put("maxVolumes", "IA");
        codeToTagMap.put("IA", "maxVolumes");
        tagToCodeMap.put("measurements", "IB");
        codeToTagMap.put("IB", "measurements");
        tagToCodeMap.put("minVolumes", "IC");
        codeToTagMap.put("IC", "minVolumes");
        tagToCodeMap.put("newElementsIDs", "ID");
        codeToTagMap.put("ID", "newElementsIDs");
        tagToCodeMap.put("normalForm", "IE");
        codeToTagMap.put("IE", "normalForm");
        tagToCodeMap.put("optionalSource", "IF");
        codeToTagMap.put("IF", "optionalSource");
        tagToCodeMap.put("optionalTarget", "IG");
        codeToTagMap.put("IG", "optionalTarget");
        tagToCodeMap.put("parsed", "IH");
        codeToTagMap.put("IH", "parsed");
        tagToCodeMap.put("previousColumn", "II");
        codeToTagMap.put("II", "previousColumn");
        tagToCodeMap.put("property", "IJ");
        codeToTagMap.put("IJ", "property");
        tagToCodeMap.put("propertyMap", "IK");
        codeToTagMap.put("IK", "propertyMap");
        tagToCodeMap.put("rangeDef", "IL");
        codeToTagMap.put("IL", "rangeDef");
        tagToCodeMap.put("reason", "IM");
        codeToTagMap.put("IM", "reason");
        tagToCodeMap.put("redactionPolicyDefaultExpression", "IN");
        codeToTagMap.put("IN", "redactionPolicyDefaultExpression");
        tagToCodeMap.put("redactionPolicyEnabled", "IO");
        codeToTagMap.put("IO", "redactionPolicyEnabled");
        tagToCodeMap.put("redactionPolicyGenerateInDDL", "IP");
        codeToTagMap.put("IP", "redactionPolicyGenerateInDDL");
        tagToCodeMap.put("redactionPolicyName", "IQ");
        codeToTagMap.put("IQ", "redactionPolicyName");
        tagToCodeMap.put("referedAttribute", "IR");
        codeToTagMap.put("IR", "referedAttribute");
        tagToCodeMap.put("referencedColumn", "IS");
        codeToTagMap.put("IS", "referencedColumn");
        tagToCodeMap.put("referredKeyID", "IT");
        codeToTagMap.put("IT", "referredKeyID");
        tagToCodeMap.put("referredTableID", "IU");
        codeToTagMap.put("IU", "referredTableID");
        tagToCodeMap.put("requestDate", "IV");
        codeToTagMap.put("IV", "requestDate");
        tagToCodeMap.put("schema", "IW");
        codeToTagMap.put("IW", "schema");
        tagToCodeMap.put("sensitiveType", "IX");
        codeToTagMap.put("IX", "sensitiveType");
        tagToCodeMap.put("sensitiveTypeDescription", "IY");
        codeToTagMap.put("IY", "sensitiveTypeDescription");
        tagToCodeMap.put("showAllDetails", "IZ");
        codeToTagMap.put("IZ", "showAllDetails");
        tagToCodeMap.put("showClassificationTypes", "Ia");
        codeToTagMap.put("Ia", "showClassificationTypes");
        tagToCodeMap.put("showComments", "Ib");
        codeToTagMap.put("Ib", "showComments");
        tagToCodeMap.put("showElements", "Ic");
        codeToTagMap.put("Ic", "showElements");
        tagToCodeMap.put("showNamesOnly", "Id");
        codeToTagMap.put("Id", "showNamesOnly");
        tagToCodeMap.put("sourceCardinality", "Ie");
        codeToTagMap.put("Ie", "sourceCardinality");
        tagToCodeMap.put("sourceEntity", "If");
        codeToTagMap.put("If", "sourceEntity");
        tagToCodeMap.put("sourcePk", "Ig");
        codeToTagMap.put("Ig", "sourcePk");
        tagToCodeMap.put("startTimeColumn", "Ih");
        codeToTagMap.put("Ih", "startTimeColumn");
        tagToCodeMap.put("status", "Ii");
        codeToTagMap.put("Ii", "status");
        tagToCodeMap.put("syncSelected", "Ij");
        codeToTagMap.put("Ij", "syncSelected");
        tagToCodeMap.put("tableAlias", "Ik");
        codeToTagMap.put("Ik", "tableAlias");
        tagToCodeMap.put("tableName", "Il");
        codeToTagMap.put("Il", "tableName");
        tagToCodeMap.put("targetCardinalityString", "Im");
        codeToTagMap.put("Im", "targetCardinalityString");
        tagToCodeMap.put("targetEntity", "In");
        codeToTagMap.put("In", "targetEntity");
        tagToCodeMap.put("targetPk", "Io");
        codeToTagMap.put("Io", "targetPk");
        tagToCodeMap.put("templateTableID", "Ip");
        codeToTagMap.put("Ip", "templateTableID");
        tagToCodeMap.put("unit", "Iq");
        codeToTagMap.put("Iq", "unit");
        tagToCodeMap.put("useSurrogateKey", "Ir");
        codeToTagMap.put("Ir", "useSurrogateKey");
        tagToCodeMap.put("useTemplateTable", "Is");
        codeToTagMap.put("Is", "useTemplateTable");
        tagToCodeMap.put("usedAttributes", "It");
        codeToTagMap.put("It", "usedAttributes");
        tagToCodeMap.put("usedContainers", "Iu");
        codeToTagMap.put("Iu", "usedContainers");
        tagToCodeMap.put("usedObjects", "Iv");
        codeToTagMap.put("Iv", "usedObjects");
        tagToCodeMap.put("validSQL", "Iw");
        codeToTagMap.put("Iw", "validSQL");
        tagToCodeMap.put("validTimeDimension", "Ix");
        codeToTagMap.put("Ix", "validTimeDimension");
        tagToCodeMap.put("validTimeDimensions", "Iy");
        codeToTagMap.put("Iy", "validTimeDimensions");
        tagToCodeMap.put("value", "Iz");
        codeToTagMap.put("Iz", "value");
        tagToCodeMap.put("valueDef", "JA");
        codeToTagMap.put("JA", "valueDef");
        tagToCodeMap.put("viewID", "JB");
        codeToTagMap.put("JB", "viewID");
        tagToCodeMap.put("viewType", "JC");
        codeToTagMap.put("JC", "viewType");
    }

    public HashMap<String, ClassDescription> getClassesMap() {
        return this.classesMap;
    }

    static {
        MetaDataManager.initTagCodeMaps();
    }

    public class ObjectDependence {
        Object object;
        List dependOn = new ArrayList();

        ObjectDependence(Object object) {
            this.object = object;
        }
    }
}

