/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.compare.MetaPropertiesComparator;
import oracle.dbtools.crest.swingui.ApplicationView;

public class MetaMapSelection
extends ModelIdObjectSelection {
    static final String NONAME = "NONAME";
    public static MetaPropertiesComparator EMPTY_COMPARATOR = new MetaPropertiesComparator();
    static final String NO_ID = "NO_ID";
    private Map map;
    private MetaPropertiesComparator propertiesComparator;
    private MetaMapSelection correspondentNode;
    private EngFilter filter;
    private List filterChilds = new ArrayList();
    private static Integer NO_FILTER_STATUS = new Integer(-1);
    private boolean editable = true;
    private Class childClass;
    private int itemPosition = -1;
    private boolean itemPositionImportant = true;
    private ClassDescription.CollectionDescription collectionDescription;
    private List listFromMap;
    private String referenceID;
    private boolean complexPropertiesList = false;
    private String complexPropertyXMLName;
    Class oclass = null;

    public MetaMapSelection(Map map) {
        super("");
        this.setName(this.getName(map));
        this.setCollection(false);
        this.map = map;
    }

    public MetaMapSelection(ModelIDObject object) {
        super(object);
    }

    public MetaMapSelection(ModelIDObject object, boolean applySelectionImmediate) {
        super(object, applySelectionImmediate);
    }

    public MetaMapSelection(String name) {
        super(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map getMap() {
        return this.map;
    }

    public MetaPropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(MetaPropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    public MetaMapSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    @Override
    public ModelIdObjectSelection getCorrespondentObjectSelection() {
        return this.getCorrespondentNode();
    }

    public void setCorrespondentNode(MetaMapSelection correspondentNode) {
        this.correspondentNode = correspondentNode;
    }

    public String getName(Map metaMap) {
        String name = null;
        if (metaMap != null) {
            name = (String)metaMap.get("name");
        }
        if (name == null) {
            name = NONAME;
        }
        return name;
    }

    public static String getID(Map metaMap) {
        String id = null;
        if (metaMap != null) {
            id = (String)metaMap.get("id");
            if (id != null) {
                return id;
            }
            id = (String)metaMap.get("objectID");
            if (id == null) {
                id = (String)metaMap.get("oid");
            }
            if (id == null) {
                id = (String)metaMap.get("vid");
            }
            if (id == null) {
                id = (String)metaMap.get("columnID");
            }
            if (id == null) {
                id = (String)metaMap.get("fkAssociation");
            }
            if (id == null) {
                id = (String)metaMap.get("referredColumn");
            }
        }
        if (id == null) {
            id = NO_ID;
        }
        return id;
    }

    public String getObjectClassName(Map metaMap) {
        if (metaMap == null) {
            return null;
        }
        return (String)metaMap.get("class");
    }

    public ClassDescription getClassDecription(Map metaMap) {
        String className = this.getObjectClassName(metaMap);
        if (className != null && !"".equals(className)) {
            return ApplicationView.getInstance().getXMLTransformationManager().getMetaDataManager().getClassDescription(className);
        }
        return null;
    }

    public String getObjectClassName() {
        if (this.map != null) {
            return this.getObjectClassName(this.map);
        }
        return "";
    }

    public Class getObjectClass(Map metaMap) {
        String name = this.getObjectClassName(metaMap);
        Class<?> objectClass = null;
        if (name != null && !"".equals(name)) {
            try {
                objectClass = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return objectClass;
    }

    public Class getObjectClass() {
        if (this.oclass == null && this.map != null) {
            this.oclass = this.getObjectClass(this.map);
        }
        if (this.oclass == null) {
            return this.getChildClass();
        }
        return this.oclass;
    }

    public void setObjectClass(Class oclass) {
        this.oclass = oclass;
    }

    public void setEmptyComparator() {
        this.propertiesComparator = EMPTY_COMPARATOR;
    }

    @Override
    public int getNumberOfChildren() {
        if (this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) {
            return this.childs.size();
        }
        return this.filterChilds.size();
    }

    @Override
    public ModelObject getChild(int index) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return (ModelObject)this.childs.get(index);
        }
        if (this.filterChilds.size() > 0) {
            return (ModelObject)this.filterChilds.get(index);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(child);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(child);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(child);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() == 0;
    }

    public void setFilter(EngFilter filter) {
        this.filterChilds = new ArrayList();
        this.filter = filter;
        if (filter != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                MetaMapSelection object = (MetaMapSelection)this.childs.get(i);
                object.setFilter(filter);
                if (!object.isFiltered(filter.getFilterList()) && !object.hasFilteredChilds(filter.getFilterList())) continue;
                this.filterChilds.add(object);
            }
        }
    }

    public void setStatus(int status) {
        if (status == 1) {
            if (this.status != 2 && this.status != 3) {
                this.status = status;
            }
        } else {
            this.status = status;
        }
    }

    @Override
    public boolean isModified() {
        boolean mod = false;
        if (this.propertiesComparator != null) {
            mod = this.propertiesComparator.isModified();
        }
        return mod;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean hasChildsWithChangeStatus() {
        for (MetaMapSelection selob : this.childs) {
            if (selob.getStatus() == 0) continue;
            return true;
        }
        for (MetaMapSelection selob : this.childs) {
            if (!selob.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        boolean mod;
        for (MetaMapSelection selob : this.childs) {
            selob.resetModifiedStatus();
        }
        boolean bl = mod = this.isModified() || this.hasChildsWithChangeStatus() || this.isItemPositionImportant() && this.hasChildsWithChangedPosition();
        if (mod && this.getStatus() == 0) {
            this.setStatus(1);
        } else if (!mod && this.getStatus() == 1) {
            this.setStatus(0);
        }
    }

    public Class getChildClass() {
        return this.childClass;
    }

    public void setChildClass(Class childClass) {
        this.childClass = childClass;
    }

    public int getItemPosition() {
        return this.itemPosition;
    }

    public void setItemPosition(int itemPosition) {
        this.itemPosition = itemPosition;
    }

    public boolean isItemPositionModified() {
        return this.itemPosition > -1 && this.getCorrespondentNode() != null && this.getCorrespondentNode().getItemPosition() != this.itemPosition;
    }

    public boolean hasItemPosition() {
        return this.itemPosition > -1;
    }

    public boolean hasChildsWithChangedPosition() {
        for (MetaMapSelection selob : this.childs) {
            if (!selob.isItemPositionModified()) continue;
            return true;
        }
        return false;
    }

    public ClassDescription.CollectionDescription getCollectionDescription() {
        return this.collectionDescription;
    }

    public void setCollectionDescription(ClassDescription.CollectionDescription collectionDescription) {
        this.collectionDescription = collectionDescription;
    }

    public boolean isMetaCollection() {
        return this.collectionDescription != null;
    }

    public List getListFromMap() {
        return this.listFromMap;
    }

    public void setListFromMap(List listFromMap) {
        this.listFromMap = listFromMap;
    }

    public String getReferenceID() {
        return this.referenceID;
    }

    public void setReferenceID(String referenceID) {
        this.referenceID = referenceID;
    }

    public boolean isRefID() {
        return this.referenceID != null && !"".equals(this.referenceID);
    }

    public boolean isComplexPropertiesList() {
        return this.complexPropertiesList;
    }

    public void setComplexPropertiesList(boolean complexPropertiesList) {
        this.complexPropertiesList = complexPropertiesList;
    }

    public String getComplexPropertyXMLName() {
        return this.complexPropertyXMLName;
    }

    public void setComplexPropertyXMLName(String complexPropertyXMLName) {
        this.complexPropertyXMLName = complexPropertyXMLName;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public boolean isItemPositionImportant() {
        return this.itemPositionImportant;
    }

    public void setItemPositionImportant(boolean itemPositionImportant) {
        this.itemPositionImportant = itemPositionImportant;
    }
}

