/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class DB_RDBMSSitesObjWriter
extends AbstractDBWriter {
    public DB_RDBMSSitesObjWriter(OracleRepositoryManager repManager) {
        super(repManager);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RDBMSSiteSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectToDB(Object object) throws SQLException {
        String xmlData = this.repositoryManager.getXML(object);
        String name = "null";
        if (object instanceof RDBMSSiteSet) {
            OraclePreparedStatement stmt = null;
            PreparedStatement ustmt = null;
            try {
                String ovid;
                RDBMSSiteSet cob = (RDBMSSiteSet)object;
                name = cob.getName();
                Connection conn = this.getConnection();
                String tableName = this.getTableName(object);
                String oid = cob.getRepositoryOID();
                boolean newObject = false;
                if (oid == null) {
                    oid = new GUID().toString();
                    newObject = true;
                }
                if ((ovid = cob.getRepositoryOVID()) == null) {
                    ovid = new GUID().toString();
                }
                BLOB blob = DB_RDBMSSitesObjWriter.getBLOB(xmlData, conn);
                if (newObject) {
                    String query = "insert into " + tableName + " ( name, OID, OVID, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + oid + "', '" + ovid + "', user, sysdate,1,? )";
                    stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                    stmt.setObject(1, (Object)blob);
                    int res = stmt.executeUpdate();
                    if (res == 1) {
                        if (cob.getRepositoryOID() == null) {
                            cob.setRepositoryOID(oid);
                        }
                        if (cob.getRepositoryOVID() == null) {
                            cob.setRepositoryOVID(ovid);
                        }
                        WriteManager.registerObject(oid, ovid, conn, false);
                        cob.setDirty(false);
                    }
                } else {
                    String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                    ustmt = conn.prepareStatement(updateQuery);
                    ustmt.setString(1, cob.getName());
                    ustmt.setObject(2, blob);
                    ustmt.setString(3, ovid);
                    ustmt.executeUpdate();
                }
                cob.setDirty(false);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(stmt);
                JDBCUtils.close(ustmt);
                throw throwable;
            }
            JDBCUtils.close((Statement)stmt);
            JDBCUtils.close(ustmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectsToDB(List objects) throws SQLException {
        int res = 0;
        if (objects.size() > 0) {
            Statement stmt = null;
            Statement ustmt = null;
            PreparedStatement regstmt = WriteManager.prepareRegisterStatement(this.getConnection(), false);
            try {
                Object object = objects.get(0);
                Connection conn = this.getConnection();
                String tableName = this.getTableName(object);
                String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                String query = "insert into " + tableName + " ( name, OID, OVID, created_by,date_created,v_sequence,xml_content) values (?,?,?, user, sysdate,1,? )";
                stmt = conn.prepareStatement(query);
                for (Object obj : objects) {
                    if (!(object instanceof RDBMSSiteSet)) continue;
                    RDBMSSiteSet rdbms = (RDBMSSiteSet)obj;
                    String oid = rdbms.getRepositoryOID();
                    String ovid = rdbms.getRepositoryOVID();
                    boolean newObject = false;
                    if (AbstractRepositoryManager.INITIAL_WRITE_TODB) {
                        newObject = true;
                    } else {
                        if (oid == null) {
                            oid = new GUID().toString();
                            newObject = true;
                        }
                        if (ovid == null) {
                            ovid = new GUID().toString();
                        }
                    }
                    String xmlData = this.repositoryManager.getXML(rdbms);
                    BLOB blob = DB_RDBMSSitesObjWriter.getBLOB(xmlData, conn);
                    if (newObject) {
                        stmt.setString(1, rdbms.getName());
                        stmt.setString(2, oid);
                        stmt.setString(3, ovid);
                        stmt.setObject(4, blob);
                        res = stmt.executeUpdate();
                        if (res == 1) {
                            if (rdbms.getRepositoryOID() == null) {
                                rdbms.setRepositoryOID(oid);
                            }
                            if (rdbms.getRepositoryOVID() == null) {
                                rdbms.setRepositoryOVID(ovid);
                            }
                            WriteManager.registerObject(oid, ovid, regstmt);
                        }
                    } else {
                        if (ustmt == null) {
                            ustmt = conn.prepareStatement(updateQuery);
                        }
                        ustmt.setString(1, rdbms.getName());
                        ustmt.setObject(2, blob);
                        ustmt.setString(3, ovid);
                        res = ustmt.executeUpdate();
                    }
                    rdbms.setDirty(false);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (ustmt != null) {
                    ustmt.close();
                }
                if (regstmt != null) {
                    regstmt.close();
                }
            }
        }
    }
}

