/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.db.oracle.AbstractDBWriter;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.WriteManager;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;

public class DB_XMappingWriter
extends AbstractDBWriter {
    public DB_XMappingWriter(OracleRepositoryManager repManager) {
        super(repManager);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof XtdMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObjectToDB(Object object) throws SQLException {
        String xmlData = this.repositoryManager.getXML(object);
        String name = "null";
        if (object instanceof ConnectionInterface) {
            OraclePreparedStatement stmt = null;
            PreparedStatement ustmt = null;
            try {
                String ovid;
                DesignObject cob = (DesignObject)object;
                name = cob.getName();
                Connection conn = this.getConnection();
                String tableName = this.getTableName(object);
                boolean newObject = false;
                String oid = cob.getRepositoryOID();
                if (oid == null) {
                    oid = new GUID().toString();
                    newObject = true;
                }
                if ((ovid = cob.getRepositoryOVID()) == null) {
                    ovid = new GUID().toString();
                }
                ConnectionInterface ci = (ConnectionInterface)object;
                String soid = ci.getSourceObject().getRepositoryOID();
                String toid = ci.getTargetObject().getRepositoryOID();
                BLOB blob = DB_XMappingWriter.getBLOB(xmlData, conn);
                if (newObject) {
                    String query = "insert into " + tableName + " ( name, OID, OVID,source,target, created_by,date_created,v_sequence,xml_content) values ('" + name + "' ,'" + oid + "', '" + ovid + "','" + soid + "','" + toid + "', user, sysdate,1,? )";
                    stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                    stmt.setObject(1, (Object)blob);
                    int res = stmt.executeUpdate();
                    if (res == 1) {
                        this.assignRepositoryIDs(cob, oid, ovid);
                        WriteManager.registerObject(oid, ovid, conn, false);
                    }
                } else {
                    String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                    ustmt = conn.prepareStatement(updateQuery);
                    ustmt.setString(1, cob.getName());
                    ustmt.setObject(2, blob);
                    ustmt.setString(3, ovid);
                    ustmt.executeUpdate();
                }
                this.clearDirtyFlag(cob);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(stmt);
                JDBCUtils.close(ustmt);
                throw throwable;
            }
            JDBCUtils.close((Statement)stmt);
            JDBCUtils.close(ustmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectsToDB(List objects) throws SQLException {
        if (objects.size() > 0) {
            int res = 0;
            Statement stmt = null;
            Statement ustmt = null;
            PreparedStatement regstmt = WriteManager.prepareRegisterStatement(this.getConnection(), false);
            try {
                Object object = objects.get(0);
                Connection conn = this.getConnection();
                String tableName = this.getTableName(object);
                String updateQuery = "update " + tableName + " set name = ?, changed_by = user, date_changed = sysdate, xml_content = ?  where ovid = ?";
                String query = "insert into " + tableName + " ( name, OID, OVID,source,target, created_by,date_created,v_sequence,xml_content) values (?,?,?,?,?, user, sysdate,1,? )";
                stmt = (OraclePreparedStatement)conn.prepareStatement(query);
                for (Object obj : objects) {
                    String ovid;
                    if (!(object instanceof XtdMapping)) continue;
                    XtdMapping cob = (XtdMapping)obj;
                    String oid = cob.getRepositoryOID();
                    boolean newObject = false;
                    if (oid == null) {
                        oid = new GUID().toString();
                        newObject = true;
                    }
                    if ((ovid = cob.getRepositoryOVID()) == null) {
                        ovid = new GUID().toString();
                    }
                    String soid = cob.getOwnerRepOID();
                    String toid = cob.getTargetRepOID();
                    String xmlData = this.repositoryManager.getXML(cob);
                    BLOB blob = DB_XMappingWriter.getBLOB(xmlData, conn);
                    if (newObject) {
                        stmt.setString(1, cob.getName());
                        stmt.setString(2, oid);
                        stmt.setString(3, ovid);
                        stmt.setString(4, soid);
                        stmt.setString(5, toid);
                        stmt.setObject(6, blob);
                        res = stmt.executeUpdate();
                        if (res != 1) continue;
                        this.assignRepositoryIDs(cob, oid, ovid);
                        WriteManager.registerObject(oid, ovid, regstmt);
                        this.clearDirtyFlag(cob);
                        continue;
                    }
                    if (ustmt == null) {
                        ustmt = conn.prepareStatement(updateQuery);
                    }
                    ustmt.setString(1, cob.getName());
                    ustmt.setObject(2, blob);
                    ustmt.setString(3, ovid);
                    res = ustmt.executeUpdate();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (ustmt != null) {
                    ustmt.close();
                }
                if (regstmt != null) {
                    regstmt.close();
                }
            }
        }
    }
}

