/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLHandler;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractXMLReader
extends AbstractXMLHandler {
    private AbstractXMLReader successor;
    private static final Logger LOGGER = new Logger(AbstractXMLReader.class);

    public AbstractXMLReader(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public final boolean canWrite(Object object) {
        return false;
    }

    @Override
    public boolean canRead(String objectID) {
        return this.getPersistenceManager().exists(this.getRelativePath(objectID), objectID);
    }

    public abstract Object recreateObject(Document var1, Design var2, boolean var3);

    public abstract Object recreateDesign(Document var1, DesignPart var2, boolean var3);

    public Object recreateObject(Document doc, Design design, ProgressDialog monitor) {
        return null;
    }

    public final Object handleRecreateObject(Object name, Design design, boolean tryReadWriteLocking) {
        design.getAppView().setCurrentDesign(design);
        AbstractXMLReader reader = this.getReaderFor(name);
        if (reader != null) {
            return reader.recreateObject(name, design, tryReadWriteLocking);
        }
        return null;
    }

    public final Object handleRecreateObject(Object name, Design design, ProgressDialog monitor) {
        design.getAppView().setCurrentDesign(design);
        AbstractXMLReader reader = this.getReaderFor(name);
        if (reader != null) {
            return reader.recreateObject(name, design, monitor);
        }
        return null;
    }

    public final Object handleRecreateDesign(Object name, DesignPart dp, boolean tryReadWriteLocking) {
        AbstractXMLReader reader;
        if (dp != null) {
            dp.getAppView().setCurrentDesign(dp.getDesign());
        }
        if ((reader = this.getReaderFor(name)) != null) {
            return reader.recreateDesign(name, dp, tryReadWriteLocking);
        }
        return null;
    }

    public Object recreateObject(Object name, Design design, boolean tryReadWriteLocking) {
        design.getAppView().setCurrentDesign(design);
        InputStream is = this.getInputStreamFor(name);
        if (is != null) {
            try {
                Document doc = AbstractXMLReader.parse(is, this.getFilename(name), design);
                return this.recreateObject(doc, design, tryReadWriteLocking);
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("Error recreating object from XML: " + name + " \n" + th.toString());
                return null;
            }
        }
        this.handleNoFile(design);
        return null;
    }

    protected void handleNoFile(Design design) {
    }

    public Object recreateObject(Object name, Design design, ProgressDialog monitor) {
        design.getAppView().setCurrentDesign(design);
        InputStream is = this.getInputStreamFor(name);
        if (is != null) {
            try {
                Document doc = AbstractXMLReader.parse(is, this.getFilename(name), design);
                return this.recreateObject(doc, design, monitor);
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("Error recreating object from XML: " + name);
                return null;
            }
        }
        return null;
    }

    public Object recreateDesign(Object name, DesignPart dp, boolean tryReadWriteLocking) {
        InputStream is;
        if (dp != null) {
            dp.getAppView().setCurrentDesign(dp.getDesign());
        }
        if ((is = this.getInputStreamFor(name)) != null) {
            try {
                Design design = dp != null ? dp.getDesign() : null;
                Document doc = AbstractXMLReader.parse(is, this.getFilename(name), design);
                boolean hasLock = false;
                return this.recreateDesign(doc, dp, hasLock);
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("Error recreating Design from XML: " + name + "\n" + th.toString());
                return null;
            }
        }
        return null;
    }

    public InputStream getInputStreamFor(Object name) {
        String location = this.getRelativePath(name);
        InputStream is = this.getPersistenceManager().getInputStreamFor(location, this.getFilename(name));
        if (is == null && !"defaultdomains".equals(name)) {
            LOGGER.error("Data inputstream is null (path: " + location + " name: " + this.getFilename(name) + ")");
        }
        return is;
    }

    public static Document parse(InputStream data, String description, Design design) {
        if (data == null) {
            LOGGER.error("InputStream is null, Can not parse XML for: " + description);
        } else {
            try {
                InputStreamReader reader = design != null && design.getLoadedVersion() <= 2.2f ? new InputStreamReader(data) : new InputStreamReader(data, "UTF-8");
                InputSource inputSource = new InputSource(reader);
                Document doc = DOCUMENT_BUILDER.parse(inputSource);
                reader.close();
                return doc;
            }
            catch (Exception e) {
                Design.openFailed();
                LOGGER.error("problem parsing document for:" + description + "\n AbstractXMLReader.parse: ", e);
            }
        }
        return null;
    }

    public void setSuccessor(AbstractXMLReader reader) {
        this.successor = reader;
    }

    public AbstractXMLReader getSuccessor() {
        return this.successor;
    }

    public AbstractXMLReader getLast() {
        if (this.getSuccessor() == null) {
            return this;
        }
        return this.getSuccessor().getLast();
    }

    public AbstractXMLReader getReaderFor(Object object) {
        if (this.canRead(object)) {
            return this;
        }
        AbstractXMLReader reader = this.getSuccessor();
        if (reader != null) {
            return reader.getReaderFor(object);
        }
        String label = String.valueOf(object);
        if (label.equals("")) {
            label = object.getClass().getName();
        }
        if (!"defaultdomains".equals(object)) {
            LOGGER.error("No reader for: " + label);
        }
        return null;
    }

    public AbstractXMLReader getReaderFor(Class type) {
        if (this.isReaderForClass(type)) {
            return this;
        }
        AbstractXMLReader reader = this.getSuccessor();
        if (reader != null) {
            return reader.getReaderFor(type);
        }
        String label = String.valueOf(type);
        if (label.equals("")) {
            label = type.getName();
        }
        LOGGER.error("No reader for: " + label);
        return null;
    }

    public String getIdStartSequence() {
        return "";
    }

    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = AbstractXMLReader.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), AbstractXMLReader.decodeAttributeValue(param.getAttribute("value")));
            }
        }
        return map;
    }

    protected void readSubViews(Element parentNode, DesignPart design) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadSubViewsFor"), design.getName()));
        Element subviews = AbstractXMLReader.getFirstChildByTagName(parentNode, "sub_views_collection");
        if (subviews != null) {
            NodeList objectElements = subviews.getElementsByTagName("sub_view");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element subview_elm = (Element)objectElements.item(i);
                if (subview_elm.getParentNode() != subviews) continue;
                String dpvName = subview_elm.getAttribute("subview_name");
                String dpvId = subview_elm.getAttribute("id");
                String generatorId = subview_elm.getAttribute("generator");
                DesignPartView dpv = design.createDesignPartSubView();
                dpv.setName(StringUtilities.decodeAttributeValue(dpvName));
                this.readDisplayProperties(subview_elm, dpv);
                dpv.setVisible(false);
                String visible = subview_elm.getAttribute("visible");
                if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
                    dpv.setDPVId(dpvId);
                }
                if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
                    dpv.setGeneratorId(generatorId);
                }
                this.readMainDisplay(subview_elm, dpv);
                this.readSubordinateDisplays(subview_elm, dpv);
                dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
                String comment = subview_elm.getAttribute("comment");
                dpv.getPlaceHolder().setComment(StringUtilities.decodeAttributeValue(comment));
                String notes = subview_elm.getAttribute("notes");
                dpv.getPlaceHolder().setNotes(StringUtilities.decodeAttributeValue(notes));
                dpv.getTabbedPane().setName(dpv.getName());
                dpv.getWorkSpace().updateSettings();
                dpv.getTabbedPane().setSelectedComponent(dpv);
            }
        }
    }

    protected void readSubordinateDisplays(Element root, DesignPartView dpv) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadSubordinateDispalysFor"), dpv.getName()));
        Element displays = AbstractXMLReader.getFirstChildByTagName(root, "subordinate_displays");
        if (displays != null) {
            NodeList objectElements = displays.getElementsByTagName("subordinate_display");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element display_elm = (Element)objectElements.item(i);
                if (display_elm.getParentNode() != displays) continue;
                String name = display_elm.getAttribute("name");
                String id = display_elm.getAttribute("objectid");
                DesignPartView display = dpv.addSubordinateView();
                display.setName(StringUtilities.decodeAttributeValue(name));
                if (id != null && !"".equalsIgnoreCase(id) && !"null".equalsIgnoreCase(id)) {
                    display.setDPVId(id);
                }
                this.readSubordinateDisplay(display_elm, display, false);
                this.readDisplayProperties(display_elm, display);
                display.getWorkSpace().updateSettings();
            }
        }
        this.readDisplayProperties(root, dpv);
    }

    protected void readMainDisplay(Element parent, DesignPartView dpv) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadMainDispalyFor"), dpv.getName()));
        Element display_elm = AbstractXMLReader.getFirstChildByTagName(parent, "main_display");
        if (display_elm != null) {
            this.readSubordinateDisplay(display_elm, dpv, true);
            this.readDisplayProperties(display_elm, dpv);
            dpv.getWorkSpace().updateSettings();
        }
    }

    protected void readSubordinateDisplay(Element display_elm, DesignPartView dpv, boolean mainDisplay) {
        ApplicationView.log(MessageFormat.format(Messages.getString("AbstractXMLReader.ReadDisplay"), dpv.getName()));
        NodeList objectElements = display_elm.getElementsByTagName("objectid");
        Design design = dpv.getDesignPart().getDesign();
        ArrayList<Element> tvconnectors = new ArrayList<Element>();
        int length = objectElements.getLength();
        for (int i = 0; i < length; ++i) {
            DesignObject object;
            Element elm = (Element)objectElements.item(i);
            String v_source = elm.getAttribute("viewid_source");
            if (v_source != null && !"".equals(v_source)) {
                tvconnectors.add(elm);
                continue;
            }
            String oid = StringUtilities.decodeAttributeValue(elm.getAttribute("oid"));
            String vid = StringUtilities.decodeAttributeValue(elm.getAttribute("viewid"));
            String tvgenId = StringUtilities.decodeAttributeValue(elm.getAttribute("tv_generator_id"));
            String type = StringUtilities.decodeAttributeValue(elm.getAttribute("type"));
            String vnbr = elm.getAttribute("viewnumber");
            int vn = 0;
            if (!"".equalsIgnoreCase(vnbr)) {
                try {
                    vn = Integer.parseInt(vnbr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mainDisplay && type.equalsIgnoreCase("Note")) {
                Note note = null;
                note = !this.getPersistenceManager().isXML_FromDataBase() ? (Note)this.getPersistenceManager().read((Object)oid, design.getDesign(), true) : (Note)design.getDesignObject(oid);
                if (note != null && !dpv.isMainDiagram()) {
                    ((TVNote)note.getTopView()).remove(false);
                }
            }
            if ((object = design.getDesignObject(oid)) == null) continue;
            TopView cv = object.getTopViewByID(dpv, vid, vn);
            if (cv == null) {
                cv = dpv.createTopViewFor(object);
            }
            if (cv == null) continue;
            cv.setViewID(vid);
            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                cv.setGeneratorID(tvgenId);
            }
            this.readGraphInfo(elm, cv);
        }
        for (Element elm : tvconnectors) {
            this.readTVConnector(elm, dpv);
        }
        DesignPart dp = dpv.getDesignPart();
        NodeList diagramViews = display_elm.getElementsByTagName("diagram_view");
        int l = diagramViews.getLength();
        for (int m = 0; m < l; ++m) {
            Element dvElm = (Element)diagramViews.item(m);
            String dvID = StringUtilities.decodeAttributeValue(dvElm.getAttribute("objectid"));
            String dpvID = StringUtilities.decodeAttributeValue(dvElm.getAttribute("dpv_id"));
            String name = StringUtilities.decodeAttributeValue(dvElm.getAttribute("dpv_name"));
            String composite = dvElm.getAttribute("composite");
            DiagramView dv = dp.recreateDiagramView(dvID);
            dv.setDpvID(dpvID);
            dv.setDpvName(name);
            dv.setCompositeView(Boolean.valueOf(composite));
            TVDiagramView tvt = dp.getMainView() == dpv ? (TVDiagramView)dv.getFirstViewForDPV(dpv) : (TVDiagramView)dpv.createTopViewFor(dv);
            this.readGraphInfo(dvElm, tvt);
        }
    }

    protected void readGraphInfo(Element objInfo, TopView tv) {
        DesignObject object = tv.getModel();
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    private void readTVConnector(Element elm, DesignPartView dpv) {
        ConnectionInterface connector;
        DesignObject dobj;
        String tvid;
        String svid;
        String type;
        DTRelation rel;
        Design design = dpv.getDesignPart().getDesign();
        DesignPart dp = dpv.getDesignPart();
        String oid = elm.getAttribute("oid");
        if (dp instanceof DataTypesDesign && dp.getMainView() == dpv && (rel = (type = StringUtilities.decodeAttributeValue(elm.getAttribute("type"))).equalsIgnoreCase("DTInheritance") ? ((DataTypesDesign)dp).createDTInheritance() : ((DataTypesDesign)dp).createDTReference()) != null) {
            StructuredType st;
            String targetID;
            if (rel instanceof DTReference) {
                TypeElement te;
                String teID = elm.getAttribute("stelement");
                if (!teID.equals("null") && (te = (TypeElement)((DataTypesDesign)dp).getTypeElementSet().getObjectByID(teID)) != null) {
                    ((DTReference)rel).setTypeElement(te);
                    te.setReferenceRelation((DTReference)rel);
                }
            } else if (rel instanceof DTInheritance && (targetID = elm.getAttribute("target")) != null && !targetID.equals("null") && (st = (StructuredType)design.getDesign().getDesignObject(targetID)) != null) {
                st.setInheritanceRelation((DTInheritance)rel);
            }
            svid = elm.getAttribute("source");
            tvid = elm.getAttribute("target");
            if (!svid.equals("null") && !tvid.equals("null")) {
                AbstractDTObject source = (AbstractDTObject)design.getDesign().getDesignObject(svid);
                AbstractDTObject target = (AbstractDTObject)design.getDesign().getDesignObject(tvid);
                if (source != null && target != null) {
                    rel.setSourceDTObject(source);
                    rel.setTargetDTObject(target);
                }
            }
            rel.setObjectID(oid);
            design.getDesign().addDesignObject(rel);
        }
        if ((dobj = design.getDesignObject(oid)) != null && dobj instanceof ConnectionInterface && (connector = (ConnectionInterface)((Object)dobj)) != null) {
            TopView ttv;
            TopView stv;
            svid = elm.getAttribute("viewid_source");
            tvid = elm.getAttribute("viewid_target");
            if (!svid.equals("null") && (stv = connector.getSourceObject().getTopViewByID(dpv, svid)) != null) {
                connector.setSourceTopView(stv);
            }
            if (!tvid.equals("null") && (ttv = connector.getTargetObject().getTopViewByID(dpv, tvid)) != null) {
                connector.setTargetTopView(ttv);
            }
            Element points = AbstractXMLReader.getFirstChildByTagName(elm, "points");
            NodeList plist = points.getElementsByTagName("point");
            int plLength = plist.getLength();
            connector.getSourceTopView(dpv);
            connector.getTargetTopView(dpv);
            TVConnector tv = (TVConnector)connector.getViewFor(dpv);
            if (tv != null) {
                Element graphical;
                String y;
                String x;
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                Element labels = AbstractXMLReader.getFirstChildByTagName(elm, "labels");
                if (labels != null) {
                    Label label;
                    String h;
                    String w;
                    Element lbl = AbstractXMLReader.getFirstChildByTagName(labels, "source");
                    if (lbl != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        w = lbl.getAttribute("width");
                        h = lbl.getAttribute("height");
                        if (w == null || "".equalsIgnoreCase(w)) {
                            w = "-1";
                        }
                        if (h == null || "".equalsIgnoreCase(h)) {
                            h = "-1";
                        }
                        tv.setSourceLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                        label = tv.getTempSourceLabel();
                        if (label != null) {
                            this.readColorInfo(lbl, label);
                            this.readFontsInfo(lbl, label);
                        }
                    }
                    if ((lbl = AbstractXMLReader.getFirstChildByTagName(labels, "target")) != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        w = lbl.getAttribute("width");
                        h = lbl.getAttribute("height");
                        if (w == null || "".equalsIgnoreCase(w)) {
                            w = "-1";
                        }
                        if (h == null || "".equalsIgnoreCase(h)) {
                            h = "-1";
                        }
                        tv.setTargetLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                        label = tv.getTempTargetLabel();
                        if (label != null) {
                            this.readColorInfo(lbl, label);
                            this.readFontsInfo(lbl, label);
                        }
                    }
                    if ((lbl = AbstractXMLReader.getFirstChildByTagName(labels, "main_label")) != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        w = lbl.getAttribute("width");
                        h = lbl.getAttribute("height");
                        if (x != null && !"".equals(x)) {
                            if (w == null || "".equalsIgnoreCase(w)) {
                                w = "-1";
                            }
                            if (h == null || "".equalsIgnoreCase(h)) {
                                h = "-1";
                            }
                            tv.setLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                            label = tv.getTempCenterLabel();
                            if (label != null) {
                                this.readColorInfo(lbl, label);
                                this.readFontsInfo(lbl, label);
                            }
                        }
                    }
                }
                if ((graphical = AbstractXMLReader.getFirstChildByTagName(elm, "graphical")) != null) {
                    NodeList paramList = graphical.getElementsByTagName("parameter");
                    HashMap<String, String> map = new HashMap<String, String>();
                    int plength = paramList.getLength();
                    for (int l = 0; l < plength; ++l) {
                        Element param = (Element)paramList.item(l);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    String useDefault = (String)map.get("use_default_color");
                    boolean useDef = true;
                    if (useDefault != null) {
                        useDef = Boolean.valueOf(useDefault);
                    }
                    tv.setUseDefaultColor(useDef);
                    if (!useDef) {
                        String width;
                        String color = (String)map.get("color");
                        if (color != null && !"null".equalsIgnoreCase(color)) {
                            Color backgroundColor = new Color(Integer.parseInt(color));
                            tv.setBackgroundColor(backgroundColor);
                        }
                        if ((width = (String)map.get("width")) != null && !"null".equalsIgnoreCase(width)) {
                            int lineWidth = Integer.parseInt(width);
                            tv.setLineWidth(lineWidth);
                        }
                    }
                }
            }
        }
    }

    protected void readDisplayProperties(Element objInfo, DesignPartView dpv) {
        PlaceHolder dpvPH;
        String showKeys;
        String showDatatype;
        String showElements;
        String namesOnly;
        String allDetails;
        String box_in_box;
        String auto_route;
        String notation = objInfo.getAttribute("notation");
        if (notation != null && !"".equals(notation)) {
            dpv.setNotation(Integer.decode(notation));
        }
        if ((auto_route = objInfo.getAttribute("auto_route")) != null && !"".equals(auto_route)) {
            dpv.setAutoRoute(Boolean.valueOf(auto_route));
        }
        if ((box_in_box = objInfo.getAttribute("box_in_box")) != null && !"".equals(box_in_box)) {
            dpv.setBoxInBox(Boolean.valueOf(box_in_box));
        }
        if ((allDetails = objInfo.getAttribute("show_all_details")) != null && !"".equals(allDetails)) {
            dpv.setShowAllDetails(Boolean.valueOf(allDetails));
        }
        if ((namesOnly = objInfo.getAttribute("show_names_only")) != null && !"".equals(namesOnly)) {
            dpv.setShowNamesOnly(Boolean.valueOf(namesOnly));
        }
        if ((showElements = objInfo.getAttribute("show_elements")) != null && !"".equals(showElements)) {
            dpv.setShowElements(Boolean.valueOf(showElements));
        }
        if ((showDatatype = objInfo.getAttribute("show_datatype")) != null && !"".equals(showDatatype)) {
            dpv.setShowDatatype(Boolean.valueOf(showDatatype));
        }
        if ((showKeys = objInfo.getAttribute("show_keys")) != null && !"".equals(showKeys)) {
            dpv.setShowKeys(Boolean.valueOf(showKeys));
        }
        if ((dpvPH = dpv.getPlaceHolder()) != null) {
            String comment = objInfo.getAttribute("comment");
            dpvPH.setComment(StringUtilities.decodeAttributeValue(comment));
            String notes = objInfo.getAttribute("notes");
            dpvPH.setNotes(StringUtilities.decodeAttributeValue(notes));
            this.updateCreateChange(objInfo, dpvPH);
        }
    }

    public void readDiagramViews(Element objInfo, DesignPart designPart) {
        Element dvs = AbstractXMLReader.getFirstChildByTagName(objInfo, "diagram_views");
        if (dvs != null) {
            NodeList objectElements = dvs.getElementsByTagName("diagram_view");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String dvID = elm.getAttribute("objectid");
                String dpvID = elm.getAttribute("dpv_id");
                String dpvName = elm.getAttribute("dpv_name");
                String composite = elm.getAttribute("composite");
                DiagramView dv = designPart.recreateDiagramView(dvID);
                dv.setDpvID(dpvID);
                dv.setDpvName(dpvName);
                dv.setCompositeView(Boolean.valueOf(composite));
                designPart.getDesign().addDiagramView(dv);
                TopView tv = dv.getFirstViewForDPV(designPart.getMainView());
                if (tv == null) continue;
                this.readGraphInfo(elm, tv);
            }
        }
    }

    public void readDiagramViews(Element objInfo, DesignPartView dpv) {
        DesignPart designPart = dpv.getDesignPart();
        Element dvs = AbstractXMLReader.getFirstChildByTagName(objInfo, "diagram_views");
        if (dvs != null) {
            NodeList objectElements = dvs.getElementsByTagName("diagram_view");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String dvID = StringUtilities.decodeAttributeValue(elm.getAttribute("objectid"));
                String dpvID = StringUtilities.decodeAttributeValue(elm.getAttribute("dpv_id"));
                String dpvName = StringUtilities.decodeAttributeValue(elm.getAttribute("dpv_name"));
                String composite = elm.getAttribute("composite");
                DiagramView dv = designPart.recreateDiagramView(dvID);
                dv.setDpvID(dpvID);
                dv.setDpvName(dpvName);
                dv.setCompositeView(Boolean.valueOf(composite));
                TopView tv = dv.getFirstViewForDPV(dpv);
                if (tv == null) continue;
                this.readGraphInfo(elm, tv);
            }
        }
    }

    public void readNamingOptions(Element objInfo, DesignPart designPart) {
        Element noElem = AbstractXMLReader.getFirstChildByTagName(objInfo, "naming_options");
        if (noElem != null) {
            NodeList objectElements = noElem.getElementsByTagName("naming_option");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                String className = elm.getAttribute("class_name");
                String maxNameLength = elm.getAttribute("max_name_length");
                String charCase = elm.getAttribute("case_type");
                String validChars = elm.getAttribute("valid_characters");
                String allValid = elm.getAttribute("all_valid");
                NamingOptionsHolder noHolder = designPart.getNamingOptionsHolderFor(className);
                noHolder.setMaxNameLength(Integer.valueOf(maxNameLength));
                noHolder.setCaseType(Integer.valueOf(charCase));
                noHolder.setValidChars(validChars);
                noHolder.setIsValid(Boolean.valueOf(allValid));
            }
        }
    }

    protected void readColorInfo(Element objInfo, DesignObject designObject) {
        String foregroundColor;
        String backgroundColor;
        String useDefaultColor = objInfo.getAttribute("use_default_color");
        if (useDefaultColor != null && !"".equals(useDefaultColor) && !"null".equalsIgnoreCase(useDefaultColor)) {
            designObject.setUseDefaultColor(Boolean.valueOf(useDefaultColor));
        }
        if ((backgroundColor = objInfo.getAttribute("background_color")) != null && !"".equals(backgroundColor) && !"null".equalsIgnoreCase(backgroundColor)) {
            Color bColor = new Color(Integer.parseInt(backgroundColor));
            designObject.setBackgroundColor(bColor);
        }
        if ((foregroundColor = objInfo.getAttribute("foreground_color")) != null && !"".equals(foregroundColor) && !"null".equalsIgnoreCase(foregroundColor)) {
            Color fColor = new Color(Integer.parseInt(foregroundColor));
            designObject.setForegroundColor(fColor);
        }
    }

    protected void readFontsInfo(Element objInfo, DesignObject designObject) {
        if (designObject instanceof EditableFonts) {
            TopView ef = designObject.getTopView();
            ef.setUseCustomFormat(true);
            Element fontsElm = AbstractXMLReader.getFirstChildByTagName(objInfo, "fonts");
            if (fontsElm != null) {
                NodeList nodeList = fontsElm.getElementsByTagName("font_object");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element foElm = (Element)nodeList.item(i);
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    NodeList propList = foElm.getElementsByTagName("parameter");
                    int length = propList.getLength();
                    for (int j = 0; j < length; ++j) {
                        Element param = (Element)propList.item(j);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    String type = (String)map.get("fo_type");
                    String fontName = (String)map.get("font_name");
                    String fontStyle = (String)map.get("font_style");
                    String fontSize = (String)map.get("font_size");
                    String fontColor = (String)map.get("font_color");
                    Font font = new Font(fontName, Integer.parseInt(fontStyle), Integer.parseInt(fontSize));
                    FontObject fo = new FontObject(type, font, new Color(Integer.parseInt(fontColor)));
                    FontObject oldFO = ef.getFontObject(type);
                    if (oldFO != null) {
                        int index = ef.getEditableFonts().indexOf(oldFO);
                        ef.getEditableFonts().remove(oldFO);
                        ef.getEditableFonts().add(index, fo);
                        continue;
                    }
                    ef.getEditableFonts().add(fo);
                }
            }
        }
    }

    public boolean isReaderForClass(Class type) {
        return false;
    }

    protected void updateCreateChange(Element changeNode, ModelIDObject desObject) {
        NodeList changes = changeNode.getElementsByTagName("alter");
        int length = changes.getLength();
        for (int i = 0; i < length; ++i) {
            Element changeElm = (Element)changes.item(i);
            if (!changeElm.getParentNode().equals(changeNode)) continue;
            String label = changeElm.getAttribute("type");
            this.readChange(changeElm, desObject, label);
        }
    }

    protected void readChange(Element changeNode, ModelIDObject desObject, String label) {
        ObjectChange change = null;
        if ("created".equals(label)) {
            change = desObject.getCreation();
        } else if ("changed".equals(label)) {
            change = desObject.getChange();
        } else {
            return;
        }
        Element userElm = AbstractXMLReader.getFirstChildByTagName(changeNode, "user");
        change.setUser(MDUserFactory.getInstance().getUser(userElm.getFirstChild().getNodeValue()));
        Element timeElm = AbstractXMLReader.getFirstChildByTagName(changeNode, "timestamp");
        change.setTimeString(timeElm.getFirstChild().getNodeValue());
    }

    protected boolean isOldDesign() {
        if (this.getPersistenceManager().getAppView() != null) {
            return this.getPersistenceManager().getAppView().getCurrentDesign().getLoadedVersion() < 3.2f;
        }
        return false;
    }
}

