/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLDomain
extends AbstractWXMLDesignObject {
    public WXMLDomain(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    public void appendDomainInfo(Element parent, Domain domain) {
        Document doc = parent.getOwnerDocument();
        this.appendDesignObjectInfo(doc, parent, domain);
    }

    @Override
    public String getDocumentAsString(Object object) {
        Document doc = this.createDocument("domain");
        Element element = doc.getDocumentElement();
        Domain domain = (Domain)object;
        this.appendDomainInfo(element, domain);
        StringBuffer buffer = new StringBuffer();
        String data = this.prettyPrint(doc, buffer);
        return data;
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Domain) {
            Domain domain = (Domain)object;
            LogicalDatatype logType = domain.getLogicalDatatype();
            Element logicalTypeElm = objectInfoNode.getOwnerDocument().createElement("logicaltype");
            logicalTypeElm.setAttribute("oid", StringUtilities.encodeAttributeValue(logType.getObjectID()));
            logicalTypeElm.setAttribute("name", StringUtilities.encodeAttributeValue(logType.getName()));
            this.appendAVT(objectInfoNode, domain);
            this.appendDataTypeParameters(objectInfoNode, domain);
            if (domain.getCheck() != null) {
                this.appendConstraint(objectInfoNode, domain.getCheck());
            }
            if (domain.getValueList() != null) {
                this.appendConstraint(objectInfoNode, domain.getValueList());
            }
            objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(domain.getSynonym()));
            objectInfoNode.setAttribute("dimension", StringUtilities.encodeAttributeValue(domain.getDimension()));
            objectInfoNode.setAttribute("file", domain.getFileName());
            objectInfoNode.appendChild(logicalTypeElm);
        }
    }

    protected void appendDataTypeParameters(Element parent, Domain domain) {
        Iterator it = domain.getDataTypeParameterNames();
        if (it.hasNext()) {
            Element parameterElm = parent.getOwnerDocument().createElement("parameters");
            this.appendComment(parameterElm, "Default values for named parameters, passed on to logical datatypes");
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = domain.getDataTypeParameter(key);
                if (value == null || "".equals(value)) continue;
                Element param = parent.getOwnerDocument().createElement("parameter");
                parameterElm.appendChild(param);
                param.setAttribute("name", key);
                param.setAttribute("value", StringUtilities.encodeAttributeValue(value));
            }
            parent.appendChild(parameterElm);
        }
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof Domain;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        String designName = this.getPersistenceManager().getAppView().getDesignName();
        buffer.append(designName).append('/').append(this.getConfiguration().get("domainPath"));
        return buffer.toString();
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((Domain)object).getFileName();
    }

    @Override
    public Document writeDocument(Object object) {
        return null;
    }

    @Override
    protected void appendConstraint(Element parent, Constraint constraint) {
        Element constraintElm = this.createElement(parent, "constraint");
        constraintElm.setAttribute("type", WXMLDomain.encodeAttributeValue(constraint.getType()));
        this.appendConstraintInfo(constraintElm, constraint);
        if (constraint instanceof ConstraintEnumeration) {
            this.appendConstraintEnumeration(constraintElm, (ConstraintEnumeration)constraint);
        }
    }

    private void appendConstraintEnumeration(Element parent, ConstraintEnumeration object) {
        Element propertiesList = parent.getOwnerDocument().createElement("properties");
        Iterator it = object.getPropertyNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = object.getProperty(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = parent.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
            String description = "";
            if (object.getValuesDescriptionMap().containsKey(value)) {
                description = (String)object.getValuesDescriptionMap().get(value);
            }
            param.setAttribute("desc", WXMLDomain.encodeAttributeValue(description));
        }
        parent.appendChild(propertiesList);
    }

    @Override
    protected void appendConstraintInfo(Element constraintElm, Constraint constraint) {
    }

    protected void appendAVT(Element parent, Domain domain) {
        parent.setAttribute("avt_sort_order", String.valueOf(domain.getAVTSortOrder()));
        Set avts = domain.getAVTs();
        Iterator it = avts.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                AVT avt = (AVT)it.next();
                Element constraintElm = this.createElement(parent, "avt");
                Element child = constraintElm.getOwnerDocument().createElement("beginvalue");
                Text content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getBeginValue()));
                child.appendChild(content);
                constraintElm.appendChild(child);
                child = constraintElm.getOwnerDocument().createElement("endvalue");
                content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getEndValue()));
                child.appendChild(content);
                constraintElm.appendChild(child);
                child = constraintElm.getOwnerDocument().createElement("description");
                content = constraintElm.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(avt.getDescription()));
                child.appendChild(content);
                constraintElm.appendChild(child);
            }
        } else {
            Element constraintElm = this.createElement(parent, "avt");
            Element child = constraintElm.getOwnerDocument().createElement("beginvalue");
            Text content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
            child = constraintElm.getOwnerDocument().createElement("endvalue");
            content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
            child = constraintElm.getOwnerDocument().createElement("description");
            content = constraintElm.getOwnerDocument().createTextNode("");
            child.appendChild(content);
            constraintElm.appendChild(child);
        }
    }
}

