/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLPhone
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIPhone phone = null;

    public WXMLPhone(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BIPhone;
        if (result) {
            this.phone = (BIPhone)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.phone != null) {
            String designName = this.phone.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("phonePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BIPhone) {
            BIPhone phone = (BIPhone)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("number", StringUtilities.encodeAttributeValue(String.valueOf(phone.getPhoneNumber())));
            map.put("type", StringUtilities.encodeAttributeValue(String.valueOf(phone.getPhoneType())));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

