/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDataTypesDesign
extends AbstractXMLReader {
    private static Logger LOGGER;
    private static float NFS;
    private float loadedVersion = NFS;
    private boolean xmlFromDB = false;

    public RXMLDataTypesDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        this.loadedVersion = design.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        DesignPartView dpv = null;
        if (this.loadedVersion < NFS) {
            dpv = design.getMainView();
            int ind = dpv.getTabbedPane().indexOfComponent(dpv);
            if (ind < 0) {
                dpv.getTabbedPane().setName(dpv.getName());
                dpv.getTabbedPane().add(dpv);
            }
            this.readDisplayProperties(root, dpv);
            dpv.getWorkSpace().updateSettings();
        }
        NodeList objectElements = RXMLDataTypesDesign.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element elm = (Element)objectElements.item(i2);
            String role = elm.getAttribute("role");
            String oid = elm.getAttribute("oid");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object = null;
            object = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object != null) {
                object.setTemporaryWriteable(true);
                if (!object.belongsToDesign(design.getDesign())) {
                    object.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo(elm, object);
                }
                object.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("RXMLDataTypesDesign: Read object returns null (objectID: " + oid);
        }
        Map objMap = this.getProperties(root, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(root, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addResponsibleParty((BIResponsibleParty)object);
        }
        if (this.loadedVersion < NFS) {
            this.readRelations(root, (DataTypesDesign)design);
            this.readDTSubViews(root, (DataTypesDesign)design);
            int ind = dpv.getTabbedPane().indexOfComponent(dpv);
            if (ind < 0) {
                dpv.getTabbedPane().setName(dpv.getName());
                dpv.getTabbedPane().add(dpv);
            }
            this.readSubordinateDisplays(root, dpv);
            dpv.getTabbedPane().setSelectedComponent(dpv);
            this.readDiagramViews(root, design);
        } else if (!this.xmlFromDB) {
            RXMLSubview rsv = this.getPersistenceManager().getDesignPartViewReader();
            rsv.readExtSubViews(root, design);
        }
        design.setLoaded(true);
        return design;
    }

    @Override
    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = RXMLDataTypesDesign.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
        }
        return map;
    }

    private void readRelations(Element root, DataTypesDesign design) {
        ApplicationView.log(Messages.getString("RXMLDataTypesDesign.ReadDatatypeRelations"));
        Element fklist = RXMLDataTypesDesign.getFirstChildByTagName(root, "view_relations");
        if (fklist != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                String width;
                Element graphical;
                Element lbl;
                StructuredType st;
                String targetID;
                Element elm = (Element)objectElements.item(i);
                String oid = StringUtilities.decodeAttributeValue(elm.getAttribute("oid"));
                String type = StringUtilities.decodeAttributeValue(elm.getAttribute("type"));
                DTRelation rel = type.equalsIgnoreCase("DTInheritance") ? design.createDTInheritance() : design.createDTReference();
                if (rel == null) continue;
                if (rel instanceof DTReference) {
                    TypeElement te;
                    String teID = elm.getAttribute("stelement");
                    if (!teID.equals("null") && (te = (TypeElement)design.getTypeElementSet().getObjectByID(teID)) != null) {
                        ((DTReference)rel).setTypeElement(te);
                        te.setReferenceRelation((DTReference)rel);
                    }
                } else if (rel instanceof DTInheritance && !(targetID = StringUtilities.decodeAttributeValue(elm.getAttribute("viewid_target"))).equals("null") && (st = (StructuredType)design.getDesign().getDesignObject(targetID)) != null) {
                    st.setInheritanceRelation((DTInheritance)rel);
                }
                String svid = StringUtilities.decodeAttributeValue(elm.getAttribute("viewid_source"));
                String tvid = StringUtilities.decodeAttributeValue(elm.getAttribute("viewid_target"));
                if (!svid.equals("null") && !tvid.equals("null")) {
                    AbstractDTObject source = (AbstractDTObject)design.getDesign().getDesignObject(svid);
                    AbstractDTObject target = (AbstractDTObject)design.getDesign().getDesignObject(tvid);
                    if (source != null && target != null) {
                        rel.setSourceDTObject(source);
                        rel.setTargetDTObject(target);
                    }
                }
                rel.setObjectID(StringUtilities.decodeAttributeValue(oid));
                design.getDesign().addDesignObject(rel);
                Element points = RXMLDataTypesDesign.getFirstChildByTagName(elm, "points");
                NodeList plist = points.getElementsByTagName("point");
                int plLength = plist.getLength();
                TVDTRelation tv = (TVDTRelation)rel.getTopView();
                if (tv == null) continue;
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    String x = point.getAttribute("x_coordinate");
                    String y = point.getAttribute("y_coordinate");
                    tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                Element labels = RXMLDataTypesDesign.getFirstChildByTagName(elm, "labels");
                if (labels == null || (lbl = RXMLDataTypesDesign.getFirstChildByTagName(labels, "main_label")) != null) {
                    // empty if block
                }
                if ((graphical = RXMLDataTypesDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                NodeList paramList = graphical.getElementsByTagName("parameter");
                HashMap<String, String> map = new HashMap<String, String>();
                int plength = paramList.getLength();
                for (int l = 0; l < plength; ++l) {
                    Element param = (Element)paramList.item(l);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                String useDefault = (String)map.get("use_default_color");
                boolean useDef = true;
                if (useDefault != null) {
                    useDef = Boolean.valueOf(useDefault);
                }
                tv.setUseDefaultColor(useDef);
                if (useDef) continue;
                String color = (String)map.get("color");
                if (color != null && !"null".equalsIgnoreCase(color)) {
                    Color backgroundColor = new Color(Integer.parseInt(color));
                    tv.setBackgroundColor(backgroundColor);
                }
                if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                int lineWidth = Integer.parseInt(width);
                tv.setLineWidth(lineWidth);
            }
        }
    }

    private void readDTSubViews(Element root, DataTypesDesign design) {
        ApplicationView.log(Messages.getString("RXMLDataTypesDesign.ReadDataTypesSubViews"));
        if (design.getAppView() != null) {
            StructuredTypeSet sts = design.getStructuredTypeSet();
            Element dpvlist = RXMLDataTypesDesign.getFirstChildByTagName(root, "datatype_sub_views_collection");
            if (dpvlist != null) {
                NodeList objectElements = dpvlist.getElementsByTagName("datatype_sub_view");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    Element elm = (Element)objectElements.item(i);
                    String dpvName = elm.getAttribute("subview_name");
                    String dpvId = elm.getAttribute("id");
                    String generatorId = elm.getAttribute("generator");
                    DesignPartView dpv = design.createDesignPartSubView();
                    dpv.setName(StringUtilities.decodeAttributeValue(dpvName));
                    dpv.setVisible(false);
                    if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
                        dpv.setDPVId(dpvId);
                    }
                    if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
                        dpv.setGeneratorId(generatorId);
                    }
                    String visible = elm.getAttribute("visible");
                    NodeList elements = elm.getElementsByTagName("objectid");
                    int ln = elements.getLength();
                    for (int k = 0; k < ln; ++k) {
                        String y;
                        String x;
                        Element point;
                        int kk;
                        TVDTRelation tvfk;
                        int plLength;
                        NodeList plist;
                        Element points;
                        String tvid;
                        String svid;
                        DTRelation rel;
                        String vid;
                        ContainerView tvt;
                        Element tv = (Element)elements.item(k);
                        if (tv.getParentNode() != elm) continue;
                        String type = tv.getAttribute("type");
                        String oid = tv.getAttribute("oid");
                        if (type.equalsIgnoreCase("StructuredType")) {
                            StructuredType st = (StructuredType)sts.getObjectByID(oid);
                            tvt = (TVStructuredType)((TVStructuredType)st.getTopView()).createViewSynonim(dpv);
                            vid = tv.getAttribute("viewid");
                            String tvgenId = tv.getAttribute("tv_generator_id");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("Note")) {
                            Note note = (Note)this.getPersistenceManager().read((Object)oid, design.getDesign(), true);
                            tvt = (TVNote)((TVNote)note.getTopView()).createViewSynonim(dpv);
                            ((TVNote)note.getTopView()).remove(false);
                            vid = tv.getAttribute("viewid");
                            ((TVNote)tvt).setViewID(vid);
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("DTReference") && (rel = (DTReference)design.getDTReferenceSet().getObjectByID(oid)) != null) {
                            svid = StringUtilities.decodeAttributeValue(tv.getAttribute("viewid_source"));
                            tvid = StringUtilities.decodeAttributeValue(tv.getAttribute("viewid_target"));
                            if (!svid.equals("null")) {
                                rel.setSourceTV((TVStructuredType)rel.getSourceDTObject().getTopViewByID(dpv, svid));
                            }
                            if (!tvid.equals("null")) {
                                rel.setTargetTV((TVStructuredType)rel.getTargetDTObject().getTopViewByID(dpv, tvid));
                            }
                            if ((points = RXMLDataTypesDesign.getFirstChildByTagName(tv, "points")) != null) {
                                plist = points.getElementsByTagName("point");
                                plLength = plist.getLength();
                                tvfk = (TVDTRelation)rel.getViewFor(dpv);
                                if (tvfk != null) {
                                    for (kk = 0; kk < plLength; ++kk) {
                                        point = (Element)plist.item(kk);
                                        x = point.getAttribute("x_coordinate");
                                        y = point.getAttribute("y_coordinate");
                                        tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                                    }
                                }
                            }
                        }
                        if (!type.equalsIgnoreCase("DTInheritance") || (rel = (DTInheritance)design.getDTInheritanceSet().getObjectByID(oid)) == null) continue;
                        svid = StringUtilities.decodeAttributeValue(tv.getAttribute("viewid_source"));
                        tvid = StringUtilities.decodeAttributeValue(tv.getAttribute("viewid_target"));
                        if (!svid.equals("null")) {
                            rel.setSourceTV((TVStructuredType)rel.getSourceDTObject().getTopViewByID(dpv, svid));
                        }
                        if (!tvid.equals("null")) {
                            rel.setTargetTV((TVStructuredType)rel.getTargetDTObject().getTopViewByID(dpv, tvid));
                        }
                        if ((points = RXMLDataTypesDesign.getFirstChildByTagName(tv, "points")) == null) continue;
                        plist = points.getElementsByTagName("point");
                        plLength = plist.getLength();
                        tvfk = (TVDTRelation)rel.getViewFor(dpv);
                        if (tvfk == null) continue;
                        for (kk = 0; kk < plLength; ++kk) {
                            point = (Element)plist.item(kk);
                            x = point.getAttribute("x_coordinate");
                            y = point.getAttribute("y_coordinate");
                            tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                        }
                    }
                    dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
                    String comment = elm.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(comment));
                    String notes = elm.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(notes));
                    dpv.getTabbedPane().setName(dpv.getName());
                    this.readSubordinateDisplays(elm, dpv);
                    dpv.getTabbedPane().setSelectedComponent(dpv);
                    dpv.setDirty(false);
                }
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject object = tv.getModel();
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("datatypes");
            return buffer.toString();
        }
        return "datatypes";
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLDataTypesDesign.class);
    }
}

