/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLInfoStructure
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLInfoStructure(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getInfoStructureSet().createInfoStructure(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        int value2;
        InfoStructure structure = (InfoStructure)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            structure.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        Map map = this.getProperties(objInfo, "attributes");
        try {
            value2 = Integer.parseInt((String)map.get("volume"));
            structure.setVolume(value2);
        }
        catch (Exception value2) {
            // empty catch block
        }
        try {
            value2 = Integer.parseInt((String)map.get("growthRatePercent"));
            structure.setGrowthRatePercent(value2);
        }
        catch (Exception value3) {
            // empty catch block
        }
        structure.setGrowthRateUnit((String)map.get("growthRateUnit"));
        Element propertiesElm = RXMLInfoStructure.getFirstChildByTagName(objInfo, "isattributes");
        if (propertiesElm != null) {
            Map objMap = this.getProperties(objInfo, "isattributes");
            Object[] objects = objMap.keySet().toArray();
            for (int i = 0; i < objects.length; ++i) {
                String aID = (String)objMap.get(objects[i]);
                Attribute attribute = (Attribute)structure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
                if (attribute == null) continue;
                structure.addAttribute(attribute);
            }
        } else {
            String infostr = (String)map.get("isattributes");
            if (infostr != null) {
                String[] str = infostr.split(",");
                for (int i = 0; i < str.length; ++i) {
                    String aID = str[i];
                    Attribute attribute = (Attribute)structure.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
                    if (attribute == null) continue;
                    structure.addAttribute(attribute);
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(structure.getObjectID())).append(".dmd");
        structure.setFilePath(buffer.toString());
        return structure;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                buffer.append(designName).append('/').append("processmodel").append('/');
            } else {
                buffer.append(designName).append('/').append("pm").append('/');
            }
        }
        buffer.append(this.getConfiguration().get("infoStructurePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == InfoStructure.class;
    }
}

