/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLFlow
extends AbstractWXMLDesignObject
implements DFConstants {
    private Flow flow = null;

    public WXMLFlow(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = Flow.class == object.getClass();
        if (result) {
            this.flow = (Flow)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.flow != null) {
            String designName = this.flow.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append(DATAFLOW_PATH).append('/').append(StringUtilities.encodeAttributeValue(this.flow.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("flowPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof Flow) {
            Flow flow = (Flow)object;
            if (flow.getSynonym() != null && !"".equalsIgnoreCase(flow.getSynonym())) {
                parentNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(flow.getSynonym()));
            }
            this.appendConnectionInfo(parentNode, flow.getSourceConnection(), "source");
            this.appendConnectionInfo(parentNode, flow.getTargetConnection(), "target");
            this.appendParentInfo(parentNode, flow.getParentObject(), "parent");
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("event", flow.getEvent() != null ? StringUtilities.encodeAttributeValue(flow.getEvent().getObjectID()) : "null");
            map.put("loggingflow", String.valueOf(flow.isLogging()));
            map.put("systemobjective", flow.getSystemObjective());
            map.put("opCreate", String.valueOf(flow.isOpCreate()));
            map.put("opRead", String.valueOf(flow.isOpRead()));
            map.put("opUpdate", String.valueOf(flow.isOpUpdate()));
            map.put("opDelete", String.valueOf(flow.isOpDelete()));
            this.appendProperties(parentNode, "attributes", map);
            this.appendObjects(parentNode, flow.getInfoStructures().toArray(), "infostructures");
        }
    }

    private void appendConnectionInfo(Element parentNode, Flow.Connection connection, String label) {
        Element connectionNode = parentNode.getOwnerDocument().createElement("connection");
        parentNode.appendChild(connectionNode);
        connectionNode.setAttribute("endpoint", label);
        connectionNode.setAttribute("dfobject", connection.getProcessObject() != null ? StringUtilities.encodeAttributeValue(connection.getProcessObject().getObjectID()) : "null");
    }

    private void appendParentInfo(Element parentNode, AbstractProcessObject parent, String label) {
        Element connectionNode = parentNode.getOwnerDocument().createElement("connection");
        parentNode.appendChild(connectionNode);
        connectionNode.setAttribute("endpoint", label);
        connectionNode.setAttribute("dfobject", parent != null ? StringUtilities.encodeAttributeValue(parent.getObjectID()) : "null");
    }
}

