/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RMDeletedMap
implements StorableObject {
    public static final String NAME = "DeletedMap_RM";
    private RMExtendedMap xmap;
    private RelationalDesign relationalModel;
    private boolean dirty;
    private boolean loadedCompletely = false;

    public RMDeletedMap(RMExtendedMap xmap, RelationalDesign relationalModel) {
        this.xmap = xmap;
        this.relationalModel = relationalModel;
    }

    public RMExtendedMap getXmap() {
        return this.xmap;
    }

    public void setXmap(RMExtendedMap xmap) {
        this.xmap = xmap;
    }

    public List getDeletedMappingsNF() {
        if (this.xmap != null) {
            return this.xmap.getDeletedMappings();
        }
        return Collections.EMPTY_LIST;
    }

    public List getDeletedMappings() {
        if (this.xmap != null) {
            return this.getFilteredDeletedMappings(this.xmap.getDeletedMappings());
        }
        return Collections.EMPTY_LIST;
    }

    public List getFilteredDeletedMappings(List list) {
        ArrayList<XtdMapping> res = new ArrayList<XtdMapping>();
        HashMap<String, XtdMapping> map = new HashMap<String, XtdMapping>();
        for (XtdMapping m : list) {
            if (m.getTargetType() != 4) continue;
            map.put(m.getTargetID() + m.getOwnerID(), m);
        }
        for (XtdMapping m : list) {
            if (m.getTargetType() == 5 || m.getTargetType() == 7 || m.getTargetType() == 6) {
                Object obj = null;
                try {
                    obj = map.get(m.getTargetContainerID() + m.getOwnerContainerID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (obj != null) continue;
            }
            res.add(m);
        }
        return res;
    }

    public XtdMapping getDeltedMappingByID(String id) {
        return this.xmap.getDeletedMappingByID(id);
    }

    public XtdMapping createMapping() {
        return this.xmap.createMapping();
    }

    public void addDeletedMapping(XtdMapping mapping) {
        if (mapping.getDeletedID() != null && !"".equals(mapping.getDeletedID())) {
            this.xmap.addMapping(mapping.getOwnerID(), mapping.getTargetID(), mapping.getDeletedID(), mapping);
        }
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "mapping" + File.separatorChar + NAME + this.relationalModel.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Design getDesign() {
        return this.relationalModel.getDesign();
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "mapping").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.relationalModel.getRMExtendedMap().isDeletedMappingsGeneratedDuringLoad();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isLoadedCompletely() {
        return this.loadedCompletely;
    }

    @Override
    public void setLoadedCompletely(boolean loadedCompletely) {
        this.loadedCompletely = loadedCompletely;
    }

    public RelationalDesign getRelationalModel() {
        return this.relationalModel;
    }
}

