/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GUIConfiguration {
    private static GUIConfiguration instance;
    private Map imageNamesMap = new TreeMap();
    private Map imageCacheMap = new TreeMap();
    private static final Dimension WORKSPACESIZE;
    public static final String APPLICATION_ICON = "APPLICATION_ICON";
    public static final String DELETE_ICON = "DELETE_ICON";
    public static final String PROPERTIES_ICON = "PROPERTIES_ICON";
    public static final String DESIGN_ICON = "DESIGN_ICON";
    public static final String OPEN_STORAGE_ICON = "OPEN_STORAGE_ICON";
    public static final String CLOSE_STORAGE_ICON = "CLOSE_STORAGE_ICON";
    public static final String ENTITY_ICON = "ENTITY_ICON";
    public static final String ENTITY_FOLDER_ICON = "ENTITY_FOLDER_ICON";
    public static final String NEW_REFERENCE_ICON = "NEW_REFERENCE_ICON";
    public static final String NEW_COMPOSITION_ICON = "NEW_COMPOSITION_ICON";
    public static final String NEW_COL_REFS_ICON = "NEW_COL_REFS_ICON";
    public static final String NEW_COL_COMPOSITIONS_ICON = "NEW_COL_COMPOSITIONS_ICON";
    public static final String M_TO_N_RELATION_ICON = "M_TO_N_RELATION_ICON";
    public static final String ONE_TO_N_RELATION_ICON = "ONE_TO_N_RELATION_ICON";
    public static final String ONE_TO_N_I_RELATION_ICON = "ONE_TO_N_I_RELATION_ICON";
    public static final String ONE_TO_N_LINE_ICON = "ONE_TO_N_LINE_ICON";
    public static final String N_TO_ONE_LINE_ICON = "N_TO_ONE_LINE_ICON";
    public static final String ONE_TO_ONE_LINE_ICON = "ONE_TO_ONE_LINE_ICON";
    public static final String ONE_TO_1_I_RELATION_ICON = "ONE_TO_1_I_RELATION_ICON";
    public static final String ONE_TO_1_RELATION_ICON = "ONE_TO_1_RELATION_ICON";
    public static final String LINK_ICON = "LINK_ICON";
    public static final String FLOW_ICON = "FLOW_ICON";
    public static final String NEW_ARC_ICON = "NEW_ARC_ICON";
    public static final String ADD_TO_ARC_ICON = "ADD_TO_ARC_ICON";
    public static final String REMOVE_FROM_ARC_ICON = "REMOVE_FROM_ARC_ICON";
    public static final String FKEY_SMALL_ICON = "FKEY_SMALL_ICON";
    public static final String FK_ICON = "FK_ICON";
    public static final String PK_ICON = "PK_ICON";
    public static final String TABLE_ICON = "TABLE_ICON";
    public static final String REMOTE_TABLE_ICON = "REMOTE_TABLE_ICON";
    public static final String REMOTE_VIEW_ICON = "REMOTE_VIEW_ICON";
    public static final String REMOTE_ENTITY_ICON = "REMOTE_ENTITY_ICON";
    public static final String REMOTE_ENTITY_VIEW_ICON = "REMOTE_ENTITY_VIEW_ICON";
    public static final String REMOTE_TABLE_LINK_ICON = "REMOTE_TABLE_LINK_ICON";
    public static final String PARTITIONED_TABLE_ICON = "PARTITIONED_TABLE_ICON";
    public static final String TEMPORARY_TABLE_ICON = "TEMPORARY_TABLE_ICON";
    public static final String TABLE_FOLDER_ICON = "TABLE_FOLDER_ICON";
    public static final String DELETE_TABLE_ICON = "DELETE_TABLE_ICON";
    public static final String SPLIT_TABLE_ICON = "SPLIT_TABLE_ICON";
    public static final String MERGE_TABLE_ICON = "MERGE_TABLE_ICON";
    public static final String COLUMN_ICON = "COLUMN_ICON";
    public static final String COLUMN_FOLDER_ICON = "COLUMN_FOLDER_ICON";
    public static final String ATTRIBUTE_ICON = "ATTRIBUTE_ICON";
    public static final String ATTRIBUTE_FOLDER_ICON = "ATTRIBUTE_FOLDER_ICON";
    public static final String INDEX_ICON = "INDEX_ICON";
    public static final String INDEX_FOLDER_ICON = "INDEX_FOLDER_ICON";
    public static final String DELETE_INDEX_ICON = "DELETE_INDEX_ICON";
    public static final String NEW_INDEX_WITH_SELECTED_ICON = "NEW_INDEX_WITH_SELECTED_ICON";
    public static final String REMOVE_FROM_INDEX_ICON = "REMOVE_FROM_INDEX_ICON";
    public static final String NEW_PK_ICON = "NEW_PK_ICON";
    public static final String DELETE_PK_ICON = "DELETE_PK_ICON";
    public static final String DOMAIN_ICON = "DOMAIN_ICON";
    public static final String REMOTE_DOMAIN_ICON = "REMOTE_DOMAIN_ICON";
    public static final String VERSIONED_LOCKED_ICON = "VERSIONED_LOCKED_ICON";
    public static final String VERSIONED_ICON = "VERSIONED_ICON";
    public static final String VERSIONED_NORMAL_ICON = "VERSIONED_NORMAL_ICON";
    public static final String VERSIONED_MODIFIED_ICON = "VERSIONED_MODIFIED_ICON";
    public static final String VERSIONED_ADDED_ICON = "VERSIONED_ADDED_ICON";
    public static final String MASK_TEMPLATE_ICON = "MASK_TEMPLATE_ICON";
    public static final String BROWSER_ICON = "BROWSER_ICON";
    public static final String LOG_ICON = "LOG_ICON";
    public static final String NAVIGATOR_ICON = "NAVIGATOR_ICON";
    public static final String EDIT_ICON = "EDIT_ICON";
    public static final String KEY_LOGICAL_ICON = "KEY_LOGICAL_ICON";
    public static final String KEY_PHYSICAL_ICON = "KEY_PHYSICAL_ICON";
    public static final String DDL_EDITOR_ICON = "DDL_EDITOR_ICON";
    public static final String DDL_PREVIEW_ICON = "DDL_PREVIEW_ICON";
    public static final String SAVE_ICON = "SAVE_ICON";
    public static final String SAVE_AS_ICON = "SAVE_AS_ICON";
    public static final String ALLOW_NULL_TRUE = "ALLOW_NULL_TRUE";
    public static final String ALLOW_NULL_FALSE = "ALLOW_NULL_FALSE";
    public static final String FORWARD_ENGINEER_ICON = "FORWARD_ENGINEER_ICON";
    public static final String REVERSE_ENGINEER_ICON = "REVERSE_ENGINEER_ICON";
    public static final String BACKDROP_ICON = "BACKDROP_ICON";
    public static final String PRINT_ICON = "PRINT_ICON";
    public static final String PAGE_SETUP_ICON = "PAGE_SETUP_ICON";
    public static final String ABOUT_ICON = "ABOUT_ICON";
    public static final String CALCULATE_ICON = "CALCULATE_ICON";
    public static final String HELP_ICON = "HELP_ICON";
    public static final String EXIT_ICON = "EXIT_ICON";
    public static final String VIEW_ICON = "VIEW_ICON";
    public static final String ENTITY_VIEW_ICON = "ENTITY_VIEW_ICON";
    public static final String VIEW_FOLDER_ICON = "VIEW_FOLDER_ICON";
    public static final String DELETE_VIEW_ICON = "DELETE_VIEW_ICON";
    public static final String COMPARE_ICON = "COMPARE_ICON";
    public static final String CLOSE_ICON = "CLOSE_ICON";
    public static final String DESIGN_RULES_ICON = "DESIGN_RULES_ICON";
    public static final String DESIGN_RULE_ICON = "DESIGN_RULE_ICON";
    public static final String CUSTOM_DESIGN_RULE_ICON = "CUSTOM_DESIGN_RULE_ICON";
    public static final String TRANSFORMATION_SCRIPT_LIBRARIES_ICON = "TRANSFORMATION_SCRIPT_LIBRARIES_ICON";
    public static final String TRANSFORMATION_SCRIPT_ICON = "TRANSFORMATION_SCRIPT_ICON";
    public static final String OPEN_ICON = "OPEN_ICON";
    public static final String DATABASE_ICON = "DATABASE_ICON";
    public static final String STORAGE_OBJECT_ICON = "STORAGE_OBJECT_ICON";
    public static final String VAR_FILE_ICON = "VAR_FILE_ICON";
    public static final String DDL_FILE_ICON = "DDL_FILE_ICON";
    public static final String XMI_FILE_ICON = "XMI_FILE_ICON";
    public static final String XMLA_FILE_ICON = "XMLA_FILE_ICON";
    public static final String XML_FILE_ICON = "XML_FILE_ICON";
    public static final String OMB_FILE_ICON = "OMB_FILE_ICON";
    public static final String CSV_FILE = "CSV_FILE";
    public static final String REPORTS_ICON = "REPORTS_ICON";
    public static final String DBM_ICON = "DBM_ICON";
    public static final String OD_ICON = "OD_ICON";
    public static final String ZOOM_IN_ICON = "ZOOM_IN_ICON";
    public static final String ZOOM_OUT_ICON = "ZOOM_OUT_ICON";
    public static final String FIT_SCREEN_ICON = "FIT_SCREEN_ICON";
    public static final String ACTUAL_SIZE_ICON = "ACTUAL_SIZE_ICON";
    public static final String REFRESH_ICON = "REFRESH_ICON";
    public static final String ABOUT_LOGO = "ABOUT_LOGO";
    public static final String SEARCH_ICON = "SEARCH_ICON";
    public static final String CANDIDATE_KEY_ICON = "CANDIDATE_KEY_ICON";
    public static final String CANDIDATE_KEY_FOLDER_ICON = "CANDIDATE_KEY_FOLDER_ICON";
    public static final String HIERARCHY_ICON = "HIERARCHY_ICON";
    public static final String BROWSER_OPEN_ICON = "BROWSER_OPEN_ICON";
    public static final String BROWSER_CLOSED_ICON = "BROWSER_CLOSED_ICON";
    public static final String INFO_STORE_ICON = "INFO_STORE_ICON";
    public static final String SLICE_ICON = "SLICE_ICON";
    public static final String MEASURE_ICON = "MEASURE_ICON";
    public static final String NEW_ASSOCIATION_A2B = "NEW_ASSOCIATION_A2B";
    public static final String NEW_ASSOCIATION_B2A = "NEW_ASSOCIATION_B2A";
    public static final String NEW_ASSOCIATION_A_B = "NEW_ASSOCIATION_A_B";
    public static final String STRUCTURED_TYPE_ICON = "STRUCTURED_TYPE_ICON";
    public static final String TYPE_ELEMENT_ICON = "TYPE_ELEMENT_ICON";
    public static final String COLLECTION_TYPE_ICON = "COLLECTION_TYPE_ICON";
    public static final String DISTINCT_TYPE_ICON = "DISTINCT_TYPE_ICON";
    public static final String METHOD_ICON = "METHOD_ICON";
    public static final String MODULE_ICON = "MODULE_ICON";
    public static final String CHECKOUT_ICON = "CHECKOUT_ICON";
    public static final String CHECKOUT_ICON_RED = "CHECKOUT_ICON_RED";
    public static final String SYNC_MODEL_WITH_DICT = "SYNC_MODEL_WITH_DICT";
    public static final String SYNC_DICT_WITH_MODEL = "SYNC_DICT_WITH_MODEL";
    public static final String UNDO_ICON = "UNDO_ICON";
    public static final String REDO_ICON = "REDO_ICON";
    public static final String CUT_ICON = "CUT_ICON";
    public static final String COPY_ICON = "COPY_ICON";
    public static final String PASTE_ICON = "PASTE_ICON";
    public static final String ERROR_ICON = "ERROR_ICON";
    public static final String WARNING_ICON = "WARNING_ICON";
    public static final String EXPORT_TO_IMAGE = "EXPORT_TO_IMAGE";
    public static final String NAMES_ICON = "NAMES_ICON";
    public static final String INFO_ICON = "INFO_ICON";
    public static final String PROGRESS_ICON = "PROGRESS_ICON";
    public static final String KEY_ICON = "KEY_ICON";
    public static final String PKEY_ICON = "PKEY_ICON";
    public static final String SELECT_ICON = "SELECT_ICON";
    public static final String GENERAL_OPTIONS_ICON = "GENERAL_OPTIONS_ICON";
    public static final String ENG_STATUS_ICON = "ENG_STATUS_ICON";
    public static final String TYPES_ADMIN_ICON = "TYPES_ADMIN_ICON";
    public static final String ADD_ICON = "ADD_ICON";
    public static final String ADD_NEW_ICON = "CREATE_NEW_ICON";
    public static final String REMOVE_ICON = "REMOVE_ICON";
    public static final String MOVE_UP_ICON = "MOVE_UP_ICON";
    public static final String MOVE_DOWN_ICON = "MOVE_DOWN_ICON";
    public static final String MOVE_LEFT_ICON = "MOVE_LEFT_ICON";
    public static final String MOVE_RIGHT_ICON = "MOVE_RIGHT_ICON";
    public static final String MOVE_LEFT_S_ICON = "MOVE_LEFT_S_ICON";
    public static final String MOVE_RIGHT_S_ICON = "MOVE_RIGHT_S_ICON";
    public static final String MOVE_LEFT_ALL_S_ICON = "MOVE_LEFT_ALL_S_ICON";
    public static final String MOVE_RIGHT_ALL_S_ICON = "MOVE_RIGHT_ALL_S_ICON";
    public static final String CR_DELETE = "CR_DELETE";
    public static final String CR_LINE = "CR_LINE";
    public static final String CR_MERGE = "CR_MERGE";
    public static final String CR_DRAG_NO = "CR_DRAG_NO";
    public static final String CR_DRAG_YES = "CR_DRAG_YES";
    public static final String PERMISSIONS_ICON = "PERMISSIONS_ICON";
    public static final String RDBMS_ICON = "RDBMS_ICON";
    public static final String PROCESS_ICON = "PROCESS_ICON";
    public static final String AGENT_ICON = "AGENT_ICON";
    public static final String EVENT_ICON = "EVENT_ICON";
    public static final String ROLE_ICON = "ROLE_ICON";
    public static final String ALIGN_LEFT_ICON = "ALIGN_LEFT_ICON";
    public static final String ALIGN_TOP_ICON = "ALIGN_TOP_ICON";
    public static final String EQUAL_WIDTH_ICON = "EQUAL_WIDTH_ICON";
    public static final String EQUAL_HEIGHT_ICON = "EQUAL_HEIGHT_ICON";
    public static final String CUBE_ICON = "CUBE_ICON";
    public static final String LEVEL_ICON = "LEVEL_ICON";
    public static final String DIMENSION_ICON = "DIMENSION_ICON";
    public static final String RAGGED_LINK_ICON = "RAGGED_LINK_ICON";
    public static final String CLASS_ICON = "CLASS_ICON";
    public static final String CLASS_FOLDER_ICON = "CLASS_FOLDER_ICON";
    public static final String BI_DOCUMENT_ICON = "BI_DOCUMENT_ICON";
    public static final String BI_RES_PARTY_ICON = "BI_RES_PARTY_ICON";
    public static final String BI_CONTACT_ICON = "BI_CONTACT_ICON";
    public static final String BI_EMAIL_ICON = "BI_EMAIL_ICON";
    public static final String BI_LOCATION_ICON = "BI_LOCATION_ICON";
    public static final String BI_PHONE_ICON = "BI_PHONE_ICON";
    public static final String BI_URL_ICON = "BI_URL_ICON";
    public static final String DBM_WIZARD_BANNER = "DBM_WIZARD_BANNER";
    public static final String OBJECT_ADDED = "OBJECT_ADDED";
    public static final String OBJECT_DELETED = "OBJECT_DELETED";
    public static final String SELECT_ALL = "SELECT_ALL";
    public static final String DESELECT_ALL = "DESELECT_ALL";
    public static final String PROPS_PROPAGATION = "PROPS_PROPAGATION";
    public static final String NOTATION_BACHMAN = "NOTATION_BACHMAN";
    public static final String NOTATION_BARKER = "NOTATION_BARKER";
    public static final String DIAGRAM_ICON = "DIAGRAM_ICON";
    public static final String CHANGE_REQUEST_ICON = "CHANGE_REQUEST_ICON";
    private static final Image ICON_OBJECT_ADDED;
    private static final Image ICON_OBJECT_DELETED;
    private static final Image ICON_OBJECT_MODIFIED;
    private static final Image ICON_OBJECT_MISSING;
    private static final Image ICON_OBJECT_CHECKOUT;
    private static final Image ICON_OBJECT_CHECKOUT_RED;
    public static final String NOTE_ICON = "NOTE_ICON";
    public static final String IMAGE_ICON = "IMAGE_ICON";
    public static final String COMMENT_ICON = "COMMENT_ICON";
    public static final String RECENT_ICON = "RECENT_ICON";
    public static final String EXPORT_TO_DB_ICON = "EXPORT_TO_DB_ICON";
    public static final String SUBVIEW_ICON = "SUBVIEW_ICON";
    public static final String DISPLAY_ICON = "DISPLAY_ICON";
    public static final String PACKAGE_ICON = "PACKAGE_ICON";
    public static final String PACKAGE_GROUP_ICON = "PACKAGE_GROUP_ICON";
    public static final String TRANSFORMATION_ICON = "TRANSFORMATION_ICON";
    public static final String TASK_ICON = "TASK_ICON";
    public static final String STRUCTURE_ICON = "STRUCTURE_ICON";
    public static final String RECORD_STRUCTURE_ICON = "RECORD_STRUCTURE_ICON";
    public static final String TABLE_2_VIEW_WIZARD_ICON = "TABLE_2_VIEW_WIZARD_ICON";
    public static final String VIEW_2_TABLE_WIZARD_ICON = "VIEW_2_TABLE_WIZARD_ICON";
    public static final String DATAFILE_ICON = "DATAFILE_ICON";
    public static final String GROUP_ICON = "GROUP_ICON";
    public static final String DISK_ICON = "DISK_ICON";
    public static final String EXTERNAL_TABLE_ICON = "EXTERNAL_TABLE_ICON";
    public static final String MATERIALIZED_VIEW_ICON = "MATERIALIZED_VIEW_ICON";
    public static final String MATERIALIZED_VIEW_FOLDER_ICON = "MATERIALIZED_VIEW_FOLDER_ICON";
    public static final String MATERIALIZED_VIEW_LOG_ICON = "MATERIALIZED_VIEW_LOG_ICON";
    public static final String MATERIALIZED_VIEW_LOG_FOLDER_ICON = "MATERIALIZED_VIEW_LOG_FOLDER_ICON";
    public static final String SEQUENCE_ICON = "SEQUENCE_ICON";
    public static final String SEQUENCE_FOLDER_ICON = "SEQUENCE_FOLDER_ICON";
    public static final String CLUSTER_ICON = "CLUSTER_ICON";
    public static final String PARTITION_ICON = "PARTITION_ICON";
    public static final String PROCEDURE_ICON = "PROCEDURE_ICON";
    public static final String PROCEDURE_FOLDER_ICON = "PROCEDURE_FOLDER_ICON";
    public static final String DIRECTORIES_ICON = "DIRECTORIES_ICON";
    public static final String SYNONYM_ICON = "SYNONYM_ICON";
    public static final String SYNONYM_FOLDER_ICON = "SYNONYM_FOLDER_ICON";
    public static final String TRIGGER_ICON = "TRIGGER_ICON";
    public static final String TRIGGER_FOLDER_ICON = "TRIGGER_FOLDER_ICON";
    public static final String CONSTRAINT_ICON = "CONSTRAINT_ICON";
    public static final String USER_ICON = "USER_ICON";
    public static final String USER_FOLDER_ICON = "USER_FOLDER_ICON";
    public static final String ALIAS_ICON = "ALIAS_ICON";
    public static final String TEMPLATE_ICON = "TEMPLATE_ICON";
    public static final String CATALOG_ICON = "CATALOG_ICON";
    public static final String RULE_ICON = "RULE_ICON";
    public static final String SCHEMA_ICON = "SCHEMA_ICON";
    public static final String SCHEMA_FOLDER_ICON = "SCHEMA_FOLDER_ICON";
    public static final String FUNCTION_ICON = "FUNCTION_ICON";
    public static final String FUNCTION_FOLDER_ICON = "FUNCTION_FOLDER_ICON";
    public static final String PACKAGE_FOLDER_ICON = "PACKAGE_FOLDER_ICON";
    public static final String CONTAINER_ICON = "CONTAINER_ICON";
    public static final String CONTEXT_ICON = "CONTEXT_ICON";
    public static final String SEGMENT_ICON = "SEGMENT_ICON";
    public static final String DEFAULT_ICON = "DEFAULT_ICON";
    public static final String QUOTA_ITEM_ICON = "QUOTA_ITEM_ICON";
    public static final String TABLESPACE_ICON = "TABLESPACE_ICON";
    public static final String DB_CONNECT_ICON = "DB_CONNECT_ICON";
    public static final String DB_DISCONNECT_ICON = "DB_DISCONNECT_ICON";
    public static final String TYPES_TO_DOMAINS_WIZARD_ICON = "TYPES_TO_DOMAINS_WIZARD_ICON";
    public static final String WARNING_RED_ICON = "WARNING_RED_ICON";
    public static final String WARNING_YELLOW_ICON = "WARNING_YELLOW_ICON";
    public static final String FILES_ICON = "FILES_ICON";
    public static final String CONNECTIONS_FOLDER_ICON = "CONNECTIONS_FOLDER_ICON";
    public static final String TYPE_FOLDER_ICON = "TYPE_FOLDER_ICON";
    public static final String NO_SCHEMA_FOLDER_ICON = "NO_SCHEMA_FOLDER_ICON";
    public static final String NOT_ASSIGNED_TO_DB_ICON = "NOT_ASSIGNED_TO_DB_ICON";
    public static final String SENSITIVE_TYPE_ICON = "SENSITIVE_TYPE_ICON";
    public static final String TSDP_POLICY_ICON = "TSDP_POLICY_ICON";
    public static final String SORT_ASC_ICON = "SORT_ASC_ICON";
    public static final String SORT_DESC_ICON = "SORT_DESC_ICON";
    public static final String CANCEL_ICON = "CANCEL_ICON";
    public static final String PARAMETER_ICON = "PARAMETER_ICON";
    public static final String SHOW_PAGE_GRID_ICON = "SHOW_PAGE_GRID_ICON";
    public static final String SHOW_GRID_ICON = "SHOW_GRID_ICON";
    public static final String COLOR_ICON = "COLOR_ICON";
    public static final String CALENDAR_ICON = "CALENDAR_ICON";
    public static final String PREFERENCES_ICON = "PREFERENCES_ICON";
    public static final String DL_SETTINGS_ICON = "DL_SETTINGS_ICON";
    public static final String FEATURE_ICON = "FEATURE_ICON";
    public static final String FILTER_ICON = "FILTER_ICON";
    public static final String START_FILTER_ICON = "START_FILTER_ICON";
    public static final String STOP_FILTER_ICON = "STOP_FILTER_ICON";

    private GUIConfiguration() {
        this.initCursors();
        this.initImages();
    }

    public static GUIConfiguration getInstance() {
        if (instance == null) {
            instance = new GUIConfiguration();
        }
        return instance;
    }

    private void initCursors() {
        this.imageNamesMap.put(CR_DELETE, "/oracle/javatools/cursors/CR_Delete.gif");
        this.imageNamesMap.put(CR_LINE, "/oracle/javatools/cursors/CR_Line.gif");
        this.imageNamesMap.put(CR_MERGE, "/oracle/javatools/cursors/CR_Merge.gif");
        this.imageNamesMap.put(CR_DRAG_YES, "/oracle/javatools/cursors/Drag_Yes.gif");
        this.imageNamesMap.put(CR_DRAG_NO, "/oracle/javatools/cursors/Drag_No.gif");
    }

    private void initImages() {
        this.imageNamesMap.put(SELECT_ICON, "/oracle/javatools/images/select.png");
        this.imageNamesMap.put(ZOOM_IN_ICON, "/oracle/javatools/images/zoomin.png");
        this.imageNamesMap.put(ZOOM_OUT_ICON, "/oracle/javatools/images/zoomout.png");
        this.imageNamesMap.put(FIT_SCREEN_ICON, "/oracle/javatools/images/fitscreen.png");
        this.imageNamesMap.put(ACTUAL_SIZE_ICON, "/oracle/javatools/images/defaultsize.png");
        this.imageNamesMap.put(SEARCH_ICON, "/oracle/javatools/images/find.png");
        this.imageNamesMap.put(FORWARD_ENGINEER_ICON, "/oracle/javatools/images/forward.png");
        this.imageNamesMap.put(REVERSE_ENGINEER_ICON, "/oracle/javatools/images/reverse.png");
        this.imageNamesMap.put(REFRESH_ICON, "/oracle/javatools/images/refresh.png");
        this.imageNamesMap.put(NOTE_ICON, "/oracle/javatools/images/note.png");
        this.imageNamesMap.put(IMAGE_ICON, "/oracle/javatools/images/image.png");
        this.imageNamesMap.put(COMMENT_ICON, "/oracle/javatools/images/comment.png");
        this.imageNamesMap.put(OPEN_ICON, "/oracle/javatools/images/open.png");
        this.imageNamesMap.put(CLOSE_ICON, "/oracle/javatools/images/close.png");
        this.imageNamesMap.put(SAVE_ICON, "/oracle/javatools/images/save.png");
        this.imageNamesMap.put(SAVE_AS_ICON, "/oracle/javatools/images/saveas.png");
        this.imageNamesMap.put(DDL_FILE_ICON, "/oracle/javatools/images/ddlfile.png");
        this.imageNamesMap.put(VAR_FILE_ICON, "/oracle/javatools/images/varfile.png");
        this.imageNamesMap.put(XMLA_FILE_ICON, "/oracle/javatools/images/xmlafile.png");
        this.imageNamesMap.put(XML_FILE_ICON, "/oracle/javatools/images/xmlfile.png");
        this.imageNamesMap.put(OMB_FILE_ICON, "/oracle/javatools/images/varfile.png");
        this.imageNamesMap.put(DBM_ICON, "/oracle/javatools/images/importdb.png");
        this.imageNamesMap.put(OD_ICON, "/oracle/javatools/images/importdb.png");
        this.imageNamesMap.put(DOMAIN_ICON, "/oracle/javatools/images/domain.png");
        this.imageNamesMap.put(REMOTE_DOMAIN_ICON, "/oracle/javatools/images/remote_domain.png");
        this.imageNamesMap.put(VERSIONED_LOCKED_ICON, "/oracle/javatools/images/SVNLocked.png");
        this.imageNamesMap.put(VERSIONED_ICON, "/oracle/javatools/images/SVNVersioned.png");
        this.imageNamesMap.put(VERSIONED_NORMAL_ICON, "/oracle/javatools/images/SVNNormal.png");
        this.imageNamesMap.put(VERSIONED_MODIFIED_ICON, "/oracle/javatools/images/SVNModified.png");
        this.imageNamesMap.put(VERSIONED_ADDED_ICON, "/oracle/javatools/images/SVNAdded.png");
        this.imageNamesMap.put(MASK_TEMPLATE_ICON, "/oracle/javatools/images/domain.png");
        this.imageNamesMap.put(CSV_FILE, "/oracle/javatools/images/csv.png");
        this.imageNamesMap.put(REPORTS_ICON, "/oracle/javatools/images/reports.png");
        this.imageNamesMap.put(EXPORT_TO_DB_ICON, "/oracle/javatools/images/exportdb.png");
        this.imageNamesMap.put(PRINT_ICON, "/oracle/javatools/images/print.png");
        this.imageNamesMap.put(PAGE_SETUP_ICON, "/oracle/javatools/images/pageconfigure.png");
        this.imageNamesMap.put(EXPORT_TO_IMAGE, "/oracle/javatools/images/image.png");
        this.imageNamesMap.put(RECENT_ICON, "/oracle/javatools/images/recent.png");
        this.imageNamesMap.put(EXIT_ICON, "/oracle/javatools/images/exit.png");
        this.imageNamesMap.put(UNDO_ICON, "/oracle/javatools/images/undo.png");
        this.imageNamesMap.put(REDO_ICON, "/oracle/javatools/images/redo.png");
        this.imageNamesMap.put(CUT_ICON, "/oracle/javatools/images/cut.png");
        this.imageNamesMap.put(COPY_ICON, "/oracle/javatools/images/copy.png");
        this.imageNamesMap.put(PASTE_ICON, "/oracle/javatools/images/paste.png");
        this.imageNamesMap.put(DELETE_ICON, "/oracle/javatools/images/delete.png");
        this.imageNamesMap.put(ALIGN_LEFT_ICON, "/oracle/javatools/images/alignleft.png");
        this.imageNamesMap.put(ALIGN_TOP_ICON, "/oracle/javatools/images/aligntop.png");
        this.imageNamesMap.put(EQUAL_WIDTH_ICON, "/oracle/javatools/images/equalwidth.png");
        this.imageNamesMap.put(EQUAL_HEIGHT_ICON, "/oracle/javatools/images/equalheight.png");
        this.imageNamesMap.put(ADD_ICON, "/oracle/javatools/images/add.png");
        this.imageNamesMap.put(ADD_NEW_ICON, "/oracle/javatools/images/addnew.png");
        this.imageNamesMap.put(REMOVE_ICON, "/oracle/javatools/images/delete.png");
        this.imageNamesMap.put(MOVE_UP_ICON, "/oracle/javatools/images/moveup.png");
        this.imageNamesMap.put(MOVE_DOWN_ICON, "/oracle/javatools/images/movedown.png");
        this.imageNamesMap.put(MOVE_LEFT_ICON, "/oracle/javatools/images/moveleft.png");
        this.imageNamesMap.put(MOVE_RIGHT_ICON, "/oracle/javatools/images/moveright.png");
        this.imageNamesMap.put(PROPERTIES_ICON, "/oracle/javatools/images/properties.png");
        this.imageNamesMap.put(EDIT_ICON, "/oracle/javatools/images/properties.png");
        this.imageNamesMap.put(BROWSER_ICON, "/oracle/javatools/images/tree.png");
        this.imageNamesMap.put(NAVIGATOR_ICON, "/oracle/javatools/images/navigator.png");
        this.imageNamesMap.put(LOG_ICON, "/oracle/javatools/images/log.png");
        this.imageNamesMap.put(DDL_PREVIEW_ICON, "/oracle/javatools/images/preview.png");
        this.imageNamesMap.put(DDL_EDITOR_ICON, "/oracle/javatools/images/ddleditor.png");
        this.imageNamesMap.put(OPEN_STORAGE_ICON, "/oracle/javatools/images/open.png");
        this.imageNamesMap.put(CLOSE_STORAGE_ICON, "/oracle/javatools/images/close.png");
        this.imageNamesMap.put(DESIGN_RULES_ICON, "/oracle/javatools/images/rules.png");
        this.imageNamesMap.put(DESIGN_RULE_ICON, "/oracle/javatools/images/designrule.png");
        this.imageNamesMap.put(CUSTOM_DESIGN_RULE_ICON, "/oracle/javatools/images/customdesignrule.png");
        this.imageNamesMap.put(MOVE_LEFT_S_ICON, "/oracle/javatools/images/shuttleleft_ena.png");
        this.imageNamesMap.put(MOVE_RIGHT_S_ICON, "/oracle/javatools/images/shuttleright_ena.png");
        this.imageNamesMap.put(MOVE_LEFT_ALL_S_ICON, "/oracle/javatools/images/shuttleleftall_ena.png");
        this.imageNamesMap.put(MOVE_RIGHT_ALL_S_ICON, "/oracle/javatools/images/shuttlerightall_ena.png");
        this.imageNamesMap.put(TRANSFORMATION_SCRIPT_LIBRARIES_ICON, "/oracle/javatools/images/scriptlibraries.png");
        this.imageNamesMap.put(TRANSFORMATION_SCRIPT_ICON, "/oracle/javatools/images/javascript.png");
        this.imageNamesMap.put(ENG_STATUS_ICON, "/oracle/javatools/images/engstatus.png");
        this.imageNamesMap.put(COMPARE_ICON, "/oracle/javatools/images/compare.png");
        this.imageNamesMap.put(GENERAL_OPTIONS_ICON, "/oracle/javatools/images/options.png");
        this.imageNamesMap.put(HELP_ICON, "/oracle/javatools/images/help.png");
        this.imageNamesMap.put(ABOUT_ICON, "/oracle/javatools/images/about.png");
        this.imageNamesMap.put(CHECKOUT_ICON, "/oracle/javatools/images/checkmark.png");
        this.imageNamesMap.put(CHECKOUT_ICON_RED, "/oracle/javatools/images/checkmark_red.png");
        this.imageNamesMap.put(SYNC_MODEL_WITH_DICT, "/oracle/javatools/images/moveleft.png");
        this.imageNamesMap.put(SYNC_DICT_WITH_MODEL, "/oracle/javatools/images/moveright.png");
        this.imageNamesMap.put(SUBVIEW_ICON, "/oracle/javatools/images/subview.png");
        this.imageNamesMap.put(DISPLAY_ICON, "/oracle/javatools/images/diagram.png");
        this.imageNamesMap.put(PACKAGE_ICON, "/oracle/javatools/images/package.png");
        this.imageNamesMap.put(PACKAGE_GROUP_ICON, "/oracle/javatools/images/packagegroup.png");
        this.imageNamesMap.put(TRANSFORMATION_ICON, "/oracle/javatools/images/transform.png");
        this.imageNamesMap.put(TASK_ICON, "/oracle/javatools/images/task.png");
        this.imageNamesMap.put(STRUCTURE_ICON, "/oracle/javatools/images/structure.png");
        this.imageNamesMap.put(RECORD_STRUCTURE_ICON, "/oracle/javatools/images/recordstruct.png");
        this.imageNamesMap.put(TABLE_2_VIEW_WIZARD_ICON, "/oracle/javatools/images/tablewizard.png");
        this.imageNamesMap.put(VIEW_2_TABLE_WIZARD_ICON, "/oracle/javatools/images/viewwizard.png");
        this.imageNamesMap.put(TYPES_ADMIN_ICON, "/oracle/javatools/images/typesadmin.png");
        this.imageNamesMap.put(TYPES_TO_DOMAINS_WIZARD_ICON, "/oracle/javatools/images/domain.png");
        this.imageNamesMap.put(OBJECT_ADDED, "/oracle/javatools/images/added_status.png");
        this.imageNamesMap.put(OBJECT_DELETED, "/oracle/javatools/images/deleted_status.png");
        this.imageNamesMap.put(INFO_ICON, "/oracle/javatools/images/info_status.png");
        this.imageNamesMap.put(ERROR_ICON, "/oracle/javatools/images/error_status.png");
        this.imageNamesMap.put(WARNING_ICON, "/oracle/javatools/images/warning_status.png");
        this.imageNamesMap.put(WARNING_RED_ICON, "/oracle/javatools/images/warning_red.png");
        this.imageNamesMap.put(WARNING_YELLOW_ICON, "/oracle/javatools/images/warning_yellow.png");
        this.imageNamesMap.put(BROWSER_OPEN_ICON, "/oracle/javatools/images/open.png");
        this.imageNamesMap.put(BROWSER_CLOSED_ICON, "/oracle/javatools/images/close.png");
        this.imageNamesMap.put(ENTITY_ICON, "/oracle/javatools/images/entity.png");
        this.imageNamesMap.put(REMOTE_ENTITY_ICON, "/oracle/javatools/images/remote_entity.png");
        this.imageNamesMap.put(REMOTE_ENTITY_VIEW_ICON, "/oracle/javatools/images/remote_entityview.png");
        this.imageNamesMap.put(ENTITY_FOLDER_ICON, "/oracle/javatools/images/table_folder.png");
        this.imageNamesMap.put(ATTRIBUTE_ICON, "/oracle/javatools/images/column.png");
        this.imageNamesMap.put(ATTRIBUTE_FOLDER_ICON, "/oracle/javatools/images/columnGroup.png");
        this.imageNamesMap.put(M_TO_N_RELATION_ICON, "/oracle/javatools/images/MNRelation.png");
        this.imageNamesMap.put(ONE_TO_N_RELATION_ICON, "/oracle/javatools/images/1MRelation.png");
        this.imageNamesMap.put(ONE_TO_N_I_RELATION_ICON, "/oracle/javatools/images/1MIRelation.png");
        this.imageNamesMap.put(ONE_TO_N_LINE_ICON, "/oracle/javatools/images/1MLine.png");
        this.imageNamesMap.put(ONE_TO_ONE_LINE_ICON, "/oracle/javatools/images/1_1Line.png");
        this.imageNamesMap.put(N_TO_ONE_LINE_ICON, "/oracle/javatools/images/M1Line.png");
        this.imageNamesMap.put(ONE_TO_1_RELATION_ICON, "/oracle/javatools/images/11Relation.png");
        this.imageNamesMap.put(ONE_TO_1_I_RELATION_ICON, "/oracle/javatools/images/11IRelation.png");
        this.imageNamesMap.put(RAGGED_LINK_ICON, "/oracle/javatools/images/substitution.png");
        this.imageNamesMap.put(CANDIDATE_KEY_ICON, "/oracle/javatools/images/index.png");
        this.imageNamesMap.put(CANDIDATE_KEY_FOLDER_ICON, "/oracle/javatools/images/index_folder.png");
        this.imageNamesMap.put(ENTITY_VIEW_ICON, "/oracle/javatools/images/entityview.png");
        this.imageNamesMap.put(VIEW_FOLDER_ICON, "/oracle/javatools/images/view_folder.png");
        this.imageNamesMap.put(CUBE_ICON, "/oracle/javatools/images/cube.png");
        this.imageNamesMap.put(LEVEL_ICON, "/oracle/javatools/images/level.png");
        this.imageNamesMap.put(DIMENSION_ICON, "/oracle/javatools/images/dimension.png");
        this.imageNamesMap.put(HIERARCHY_ICON, "/oracle/javatools/images/hierarchy.png");
        this.imageNamesMap.put(MEASURE_ICON, "/oracle/javatools/images/measure.png");
        this.imageNamesMap.put(LINK_ICON, "/oracle/javatools/images/link.png");
        this.imageNamesMap.put(FLOW_ICON, "/oracle/javatools/images/flow.png");
        this.imageNamesMap.put(SLICE_ICON, "/oracle/javatools/images/slice.png");
        this.imageNamesMap.put(TABLE_ICON, "/oracle/javatools/images/table.png");
        this.imageNamesMap.put(REMOTE_TABLE_ICON, "/oracle/javatools/images/remote_table.png");
        this.imageNamesMap.put(REMOTE_VIEW_ICON, "/oracle/javatools/images/remote_view.png");
        this.imageNamesMap.put(REMOTE_TABLE_LINK_ICON, "/oracle/javatools/images/remote_table_link.png");
        this.imageNamesMap.put(PARTITIONED_TABLE_ICON, "/oracle/javatools/images/partitioned_table.png");
        this.imageNamesMap.put(TEMPORARY_TABLE_ICON, "/oracle/javatools/images/temporarytable.png");
        this.imageNamesMap.put(TABLE_FOLDER_ICON, "/oracle/javatools/images/table_folder.png");
        this.imageNamesMap.put(COLUMN_ICON, "/oracle/javatools/images/column.png");
        this.imageNamesMap.put(COLUMN_FOLDER_ICON, "/oracle/javatools/images/columnGroup.png");
        this.imageNamesMap.put(FKEY_SMALL_ICON, "/oracle/javatools/images/fkey.png");
        this.imageNamesMap.put(FK_ICON, "/oracle/javatools/images/foreignkey.png");
        this.imageNamesMap.put(INDEX_ICON, "/oracle/javatools/images/index.png");
        this.imageNamesMap.put(INDEX_FOLDER_ICON, "/oracle/javatools/images/index_folder.png");
        this.imageNamesMap.put(PK_ICON, "/oracle/javatools/images/pkey.png");
        this.imageNamesMap.put(SPLIT_TABLE_ICON, "/oracle/javatools/images/split.png");
        this.imageNamesMap.put(MERGE_TABLE_ICON, "/oracle/javatools/images/merge.png");
        this.imageNamesMap.put(VIEW_ICON, "/oracle/javatools/images/view.png");
        this.imageNamesMap.put(STRUCTURED_TYPE_ICON, "/oracle/javatools/images/complextype.png");
        this.imageNamesMap.put(TYPE_ELEMENT_ICON, "/oracle/javatools/images/attribute.png");
        this.imageNamesMap.put(COLLECTION_TYPE_ICON, "/oracle/javatools/images/collectiontype.png");
        this.imageNamesMap.put(DISTINCT_TYPE_ICON, "/oracle/javatools/images/distincttype.png");
        this.imageNamesMap.put(METHOD_ICON, "/oracle/javatools/images/method.png");
        this.imageNamesMap.put(PROCESS_ICON, "/oracle/javatools/images/process.png");
        this.imageNamesMap.put(AGENT_ICON, "/oracle/javatools/images/agent.png");
        this.imageNamesMap.put(EVENT_ICON, "/oracle/javatools/images/event.png");
        this.imageNamesMap.put(ROLE_ICON, "/oracle/javatools/images/role.png");
        this.imageNamesMap.put(INFO_STORE_ICON, "/oracle/javatools/images/infostore.png");
        this.imageNamesMap.put(BI_DOCUMENT_ICON, "/oracle/javatools/images/document.png");
        this.imageNamesMap.put(BI_RES_PARTY_ICON, "/oracle/javatools/images/user.png");
        this.imageNamesMap.put(BI_CONTACT_ICON, "/oracle/javatools/images/contact.png");
        this.imageNamesMap.put(BI_EMAIL_ICON, "/oracle/javatools/images/email.png");
        this.imageNamesMap.put(BI_LOCATION_ICON, "/oracle/javatools/images/location.png");
        this.imageNamesMap.put(BI_PHONE_ICON, "/oracle/javatools/images/phone.png");
        this.imageNamesMap.put(BI_URL_ICON, "/oracle/javatools/images/url.png");
        this.imageNamesMap.put(CHANGE_REQUEST_ICON, "/oracle/javatools/images/log.png");
        this.imageNamesMap.put(MODULE_ICON, "/oracle/javatools/images/module.png");
        this.imageNamesMap.put(CLASS_ICON, "/oracle/javatools/images/class.png");
        this.imageNamesMap.put(CLASS_FOLDER_ICON, "/oracle/javatools/images/class_folder.png");
        this.imageNamesMap.put(NEW_COMPOSITION_ICON, "/oracle/javatools/images/composition.png");
        this.imageNamesMap.put(NEW_ASSOCIATION_A2B, "/oracle/javatools/images/to_reference.png");
        this.imageNamesMap.put(NEW_ASSOCIATION_B2A, "/oracle/javatools/images/from_reference.png");
        this.imageNamesMap.put(NEW_ASSOCIATION_A_B, "/oracle/javatools/images/ab_reference.png");
        this.imageNamesMap.put(NEW_ARC_ICON, "/oracle/javatools/images/newarc.gif");
        this.imageNamesMap.put(ADD_TO_ARC_ICON, "/oracle/javatools/images/add2arc.gif");
        this.imageNamesMap.put(REMOVE_FROM_ARC_ICON, "/oracle/javatools/images/removefromarc.gif");
        this.imageNamesMap.put(NEW_REFERENCE_ICON, "/oracle/javatools/images/reference.gif");
        this.imageNamesMap.put(NEW_COL_REFS_ICON, "/oracle/javatools/images/collectionrefs.gif");
        this.imageNamesMap.put(NEW_COL_COMPOSITIONS_ICON, "/oracle/javatools/images/collectioncompositions.gif");
        this.imageNamesMap.put(APPLICATION_ICON, "/oracle/javatools/images/appicon.png");
        this.imageNamesMap.put(DESIGN_ICON, "/oracle/javatools/images/selectdesign.gif");
        this.imageNamesMap.put(KEY_ICON, "/oracle/javatools/images/Key.gif");
        this.imageNamesMap.put(PKEY_ICON, "/oracle/javatools/images/PKey.gif");
        this.imageNamesMap.put(BACKDROP_ICON, "/oracle/javatools/images/splash.png");
        this.imageNamesMap.put(ABOUT_LOGO, "/oracle/javatools/images/aboutlogo.png");
        this.imageNamesMap.put(PERMISSIONS_ICON, "/oracle/javatools/images/permissions.png");
        this.imageNamesMap.put(RDBMS_ICON, "/oracle/javatools/images/rdbms.gif");
        this.imageNamesMap.put(DBM_WIZARD_BANNER, "/oracle/javatools/images/banner.png");
        this.imageNamesMap.put(NAMES_ICON, "/oracle/javatools/images/names.png");
        this.imageNamesMap.put(PROGRESS_ICON, "/oracle/javatools/images/status.gif");
        this.imageNamesMap.put(SELECT_ALL, "/oracle/javatools/images/selected.png");
        this.imageNamesMap.put(DESELECT_ALL, "/oracle/javatools/images/deselected.png");
        this.imageNamesMap.put(PROPS_PROPAGATION, "/oracle/javatools/images/propagate.png");
        this.imageNamesMap.put(NOTATION_BACHMAN, "/oracle/javatools/images/bachman.gif");
        this.imageNamesMap.put(NOTATION_BARKER, "/oracle/javatools/images/barker.gif");
        this.imageNamesMap.put(DIAGRAM_ICON, "/oracle/javatools/images/dbdiagram.png");
        this.imageNamesMap.put(DATABASE_ICON, "/oracle/javatools/images/storagemodel.png");
        this.imageNamesMap.put(STORAGE_OBJECT_ICON, "/oracle/javatools/images/storageobject.png");
        this.imageNamesMap.put(CLUSTER_ICON, "/oracle/javatools/images/cluster.png");
        this.imageNamesMap.put(DATAFILE_ICON, "/oracle/javatools/images/datafile.png");
        this.imageNamesMap.put(GROUP_ICON, "/oracle/javatools/images/group.png");
        this.imageNamesMap.put(DISK_ICON, "/oracle/javatools/images/disk.png");
        this.imageNamesMap.put(EXTERNAL_TABLE_ICON, "/oracle/javatools/images/externaltable.png");
        this.imageNamesMap.put(MATERIALIZED_VIEW_ICON, "/oracle/javatools/images/materialized_view.png");
        this.imageNamesMap.put(MATERIALIZED_VIEW_FOLDER_ICON, "/oracle/javatools/images/materialized_view_folder.png");
        this.imageNamesMap.put(MATERIALIZED_VIEW_LOG_ICON, "/oracle/javatools/images/materialized_view_log.png");
        this.imageNamesMap.put(MATERIALIZED_VIEW_LOG_FOLDER_ICON, "/oracle/javatools/images/materializedviewslogs.png");
        this.imageNamesMap.put(SEQUENCE_ICON, "/oracle/javatools/images/sequence.png");
        this.imageNamesMap.put(SEQUENCE_FOLDER_ICON, "/oracle/javatools/images/sequence_folder.png");
        this.imageNamesMap.put(PARTITION_ICON, "/oracle/javatools/images/partition.png");
        this.imageNamesMap.put(PROCEDURE_ICON, "/oracle/javatools/images/procedure.png");
        this.imageNamesMap.put(PROCEDURE_FOLDER_ICON, "/oracle/javatools/images/procedure_folder.png");
        this.imageNamesMap.put(DIRECTORIES_ICON, "/oracle/javatools/images/folders.png");
        this.imageNamesMap.put(SYNONYM_ICON, "/oracle/javatools/images/synonym.png");
        this.imageNamesMap.put(SYNONYM_FOLDER_ICON, "/oracle/javatools/images/synonym_folder.png");
        this.imageNamesMap.put(TRIGGER_ICON, "/oracle/javatools/images/trigger.png");
        this.imageNamesMap.put(TRIGGER_FOLDER_ICON, "/oracle/javatools/images/trigger_folder.png");
        this.imageNamesMap.put(CONSTRAINT_ICON, "/oracle/javatools/images/constraints.png");
        this.imageNamesMap.put(USER_ICON, "/oracle/javatools/images/user.png");
        this.imageNamesMap.put(USER_FOLDER_ICON, "/oracle/javatools/images/users.png");
        this.imageNamesMap.put(ALIAS_ICON, "/oracle/javatools/images/alias.png");
        this.imageNamesMap.put(TEMPLATE_ICON, "/oracle/javatools/images/template.png");
        this.imageNamesMap.put(CATALOG_ICON, "/oracle/javatools/images/catalog.png");
        this.imageNamesMap.put(RULE_ICON, "/oracle/javatools/images/rule.png");
        this.imageNamesMap.put(SCHEMA_ICON, "/oracle/javatools/images/schema.png");
        this.imageNamesMap.put(SCHEMA_FOLDER_ICON, "/oracle/javatools/images/schema_folder.png");
        this.imageNamesMap.put(FUNCTION_ICON, "/oracle/javatools/images/function.png");
        this.imageNamesMap.put(FUNCTION_FOLDER_ICON, "/oracle/javatools/images/function_folder.png");
        this.imageNamesMap.put(PACKAGE_FOLDER_ICON, "/oracle/javatools/images/package_folder.png");
        this.imageNamesMap.put(CONTAINER_ICON, "/oracle/javatools/images/container.png");
        this.imageNamesMap.put(CONTEXT_ICON, "/oracle/javatools/images/context.png");
        this.imageNamesMap.put(SEGMENT_ICON, "/oracle/javatools/images/segment.png");
        this.imageNamesMap.put(DEFAULT_ICON, "/oracle/javatools/images/default.png");
        this.imageNamesMap.put(QUOTA_ITEM_ICON, "/oracle/javatools/images/item.png");
        this.imageNamesMap.put(TABLESPACE_ICON, "/oracle/javatools/images/tablespace.png");
        this.imageNamesMap.put(DB_CONNECT_ICON, "/oracle/javatools/images/dbconn.png");
        this.imageNamesMap.put(DB_DISCONNECT_ICON, "/oracle/javatools/images/dbdisconn.png");
        this.imageNamesMap.put(FILES_ICON, "/oracle/dbtools/raptor/images/files.png");
        this.imageNamesMap.put(CONNECTIONS_FOLDER_ICON, "/oracle/dbtools/raptor/images/connections_folder.png");
        this.imageNamesMap.put(TYPE_FOLDER_ICON, "/oracle/dbtools/raptor/images/type_folder.png");
        this.imageNamesMap.put(NO_SCHEMA_FOLDER_ICON, "/oracle/javatools/images/no_schema_folder.png");
        this.imageNamesMap.put(NOT_ASSIGNED_TO_DB_ICON, "/oracle/javatools/images/not_assigned_to_db.png");
        this.imageNamesMap.put(SENSITIVE_TYPE_ICON, "/oracle/javatools/images/sensitive_type.png");
        this.imageNamesMap.put(TSDP_POLICY_ICON, "/oracle/javatools/images/tsdp_policy.png");
        this.imageNamesMap.put(SORT_ASC_ICON, "/oracle/javatools/icons/sortbyalpha.png");
        this.imageNamesMap.put(SORT_DESC_ICON, "/oracle/javatools/icons/sortdescending_ena.png");
        this.imageNamesMap.put(CANCEL_ICON, "/oracle/javatools/images/cancel.png");
        this.imageNamesMap.put(PARAMETER_ICON, "/oracle/javatools/images/parameter.png");
        this.imageNamesMap.put(SHOW_PAGE_GRID_ICON, "/oracle/javatools/images/showpagegrid.png");
        this.imageNamesMap.put(SHOW_GRID_ICON, "/oracle/javatools/images/showgrid.png");
        this.imageNamesMap.put(COLOR_ICON, "/oracle/javatools/images/color.png");
        this.imageNamesMap.put(CALENDAR_ICON, "/oracle/javatools/images/calendar.png");
        this.imageNamesMap.put(PREFERENCES_ICON, "/oracle/javatools/images/objectdisplaypreferences.png");
        this.imageNamesMap.put(DL_SETTINGS_ICON, "/oracle/javatools/images/preferencePage.png");
        this.imageNamesMap.put(FEATURE_ICON, "/oracle/javatools/images/feature.png");
        this.imageNamesMap.put(FILTER_ICON, "/oracle/javatools/images/filter.png");
        this.imageNamesMap.put(START_FILTER_ICON, "/oracle/javatools/images/startfilter_ena.png");
        this.imageNamesMap.put(STOP_FILTER_ICON, "/oracle/javatools/images/stopfilter_ena.png");
    }

    public Dimension getWorkSpaceSize() {
        return WORKSPACESIZE;
    }

    protected Icon createIcon(String name, int squareSize) {
        Icon icon = this.getIcon(name);
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        double scaleIcon = (double)squareSize / (double)Math.min(width, height);
        width = (int)Math.round((double)width * scaleIcon);
        height = (int)Math.round((double)height * scaleIcon);
        double scaleTo24px = Math.min(width, height) / squareSize;
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        AffineTransform transform = g.getTransform();
        g.transform(AffineTransform.getScaleInstance(scaleTo24px, scaleTo24px));
        icon.paintIcon(null, g, 0, 0);
        g.setTransform(transform);
        g.transform(AffineTransform.getTranslateInstance((double)height * 0.7, (double)width * 0.7));
        g.transform(AffineTransform.getScaleInstance(0.5 * scaleTo24px, 0.5 * scaleTo24px));
        return new ImageIcon(img);
    }

    public Icon getIcon(String name, int size) {
        String longName = new StringBuffer().append(name).append(":").append(size).toString();
        if (this.imageCacheMap.containsKey(longName)) {
            return (Icon)this.imageCacheMap.get(longName);
        }
        Icon icon = this.createIcon(name, size);
        this.imageCacheMap.put(longName, icon);
        return icon;
    }

    public Icon getIcon(String name) {
        return this.getIcon(name, true);
    }

    public Icon getIcon(String name, boolean cache) {
        if (this.imageCacheMap.containsKey(name)) {
            return (Icon)this.imageCacheMap.get(name);
        }
        URL url = null;
        if (this.imageNamesMap.containsKey(name)) {
            url = this.getClass().getResource(this.imageNamesMap.get(name).toString());
        }
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            if (cache) {
                this.imageCacheMap.put(name, icon);
            }
            return icon;
        }
        return new ImageIcon(name);
    }

    public Image getImage(String name) {
        Icon icon = this.getIcon(name);
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        return img;
    }

    private Icon getStatusIcon(Image baseImage, Image statusImage) {
        int w1 = baseImage.getWidth(null);
        int h1 = baseImage.getHeight(null);
        int w2 = statusImage.getWidth(null);
        int h2 = statusImage.getHeight(null);
        BufferedImage result = new BufferedImage(w1 + 2, h1 + 2, 2);
        Graphics2D g = result.createGraphics();
        g.drawImage(baseImage, 0, 0, w1, h1, null);
        g.drawImage(statusImage, w1 - w2 + 2, h1 - h2 + 2, w2, h2, null);
        g.dispose();
        return new ImageIcon(result);
    }

    public Image getImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        return img;
    }

    public Icon getObjectAddedIcon(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_ADDED);
    }

    public Icon getObjectDeletedIcon(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_DELETED);
    }

    public Icon getObjectModifiedIcon(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_MODIFIED);
    }

    public Icon getObjectMissingIcon(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_MISSING);
    }

    public Icon getCheckOutIcon(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_CHECKOUT);
    }

    public Icon getCheckOutIconRed(Icon icon) {
        return this.getStatusIcon(this.getImage(icon), ICON_OBJECT_CHECKOUT_RED);
    }

    public Image getAddedImage() {
        return ICON_OBJECT_ADDED;
    }

    public Image getDeletedImage() {
        return ICON_OBJECT_DELETED;
    }

    public Image getModifiedImage() {
        return ICON_OBJECT_MODIFIED;
    }

    static {
        WORKSPACESIZE = new Dimension(30000, 20000);
        ICON_OBJECT_ADDED = GUIConfiguration.getInstance().getImage(OBJECT_ADDED);
        ICON_OBJECT_DELETED = GUIConfiguration.getInstance().getImage(OBJECT_DELETED);
        ICON_OBJECT_MODIFIED = GUIConfiguration.getInstance().getImage(WARNING_ICON);
        ICON_OBJECT_MISSING = GUIConfiguration.getInstance().getImage(ERROR_ICON);
        ICON_OBJECT_CHECKOUT = GUIConfiguration.getInstance().getImage(CHECKOUT_ICON);
        ICON_OBJECT_CHECKOUT_RED = GUIConfiguration.getInstance().getImage(CHECKOUT_ICON_RED);
    }

    class EmptyIcon
    implements Icon {
        EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Paint p = g2.getPaint();
            g2.setPaint(Color.darkGray);
            g2.fillRect(6 + x, 6 + y, 12, 12);
            g2.setPaint(Color.red);
            g2.fillRect(7 + x, 7 + y, 10, 10);
            g2.setPaint(p);
        }

        @Override
        public int getIconWidth() {
            return 32;
        }

        @Override
        public int getIconHeight() {
            return 32;
        }
    }
}

