/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTReference;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.AttributeMap;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.ide.Ide;

public abstract class TVConnector
extends TopView {
    public static final int SITE_SOURCE = 0;
    public static final int SITE_CENTER = 1;
    public static final int SITE_TARGET = 2;
    public static boolean updateSettings = false;
    protected List edgePoints = new ArrayList();
    protected DefaultEdge edge;
    protected Rectangle labelBounds;
    protected Rectangle sourceLabelBounds = new Rectangle(-1, -1, -1, -1);
    protected Rectangle targetLabelBounds;
    public boolean wait = false;
    private Label sourceLabel = null;
    private Label centerLabel = null;
    private Label targetLabel = null;
    private Label tempSourceLabel;
    private Label tempCenterLabel;
    private Label tempTargetLabel;

    public TVConnector(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
        this.labelBounds = new Rectangle(-1, -1, -1, -1);
        this.targetLabelBounds = new Rectangle(-1, -1, -1, -1);
    }

    public List getEdgePoints() {
        return this.edgePoints;
    }

    public List getEdgeViewPoints() {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        if (this.getEdge() != null) {
            EdgeView ev = (EdgeView)this.getEdge().getCellView();
            int k = ev.getPoints().size();
            for (int i = 0; i < k; ++i) {
                Point2D point = ev.getPoint(i);
                list.add(point);
            }
        }
        return list;
    }

    @Override
    public void move(int dx, int dy) {
        for (Point2D p : this.edgePoints) {
            p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
        }
    }

    public DefaultEdge getEdge() {
        return this.edge;
    }

    public boolean remove(DesignObject connection) {
        if (this.canRemove()) {
            int res = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TVConnector.HasMoreThan1GraphicalRepresentation"), this.getModel().getName()), Messages.getString("TVConnector.WhatWouldYouLikeToDo"), 1, 3, null, new String[]{Messages.getString("TVConnector.RemoveObject"), Messages.getString("TVConnector.RemoveView"), Messages.getString("TVConnector.Cancel")}, Messages.getString("TVConnector.RemoveView"));
            if (res == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                connection.remove();
                return true;
            }
            if (res == 1) {
                DesignPartView dpv = this.getDesignPartView();
                dpv.unregisterFromTreemodel(this);
                if (this.getCellView() != null) {
                    Object[] cells = new Object[]{this.getCellView().getCell()};
                    this.getDesignPartView().getWorkSpace().removeCells(cells);
                    this.getDesignPartView().setDirty(true);
                }
                this.doPrivateActions();
                this.clearLabels();
                this.getDesignPartView().removeView(this);
                this.getDesignPartView().getWorkSpace().repaint();
                return true;
            }
        } else {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TVConnector.SureYouWantToDelete"), this.getModel().getName()), Messages.getString("TVConnector.ConfirmObjectDelete"), 0);
            if (res == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                connection.remove();
                return true;
            }
        }
        return false;
    }

    public void hide() {
        DesignPartView dpv = this.getDesignPartView();
        dpv.unregisterFromTreemodel(this);
        if (this.getCellView() != null) {
            Object[] cells = new Object[]{this.getCellView().getCell()};
            this.getDesignPartView().getWorkSpace().removeCells(cells);
            this.getDesignPartView().setDirty(true);
        }
        this.doPrivateActions();
        this.clearLabels();
        this.getDesignPartView().removeView(this);
        DesignObject dobj = this.getModel();
        if (dobj instanceof ConnectionInterface) {
            ((ConnectionInterface)((Object)dobj)).removeTopView(this);
        }
        this.getDesignPartView().getWorkSpace().repaint();
    }

    @Override
    public boolean canRemove() {
        DesignPartView dpv = this.getDesignPartView();
        DesignPartView masterDPV = dpv.getMasterDPV();
        if (masterDPV == null) {
            masterDPV = dpv;
        }
        return masterDPV != this.getModel().getDesignPart().getMainView();
    }

    protected void doPrivateActions() {
    }

    public void removeConnection() {
        this.getDesignPartView().getWorkSpace().removeConnection(this.getModel());
        this.edge = null;
        this.setCellView(null);
    }

    public void clearLabels() {
        this.removeLabel(0);
        this.removeLabel(1);
        this.removeLabel(2);
    }

    public Rectangle getLabelBounds() {
        return this.labelBounds;
    }

    public void setLabelBounds(Rectangle labelBounds) {
        this.labelBounds = labelBounds;
    }

    public Rectangle getSourceLabelBounds() {
        return this.sourceLabelBounds;
    }

    public void setSourceLabelBounds(Rectangle sourceLabelBounds) {
        this.sourceLabelBounds = sourceLabelBounds;
    }

    public Rectangle getTargetLabelBounds() {
        return this.targetLabelBounds;
    }

    public void setTargetLabelBounds(Rectangle targetLabelBounds) {
        this.targetLabelBounds = targetLabelBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabelPos(Point2D pos, Point2D otherPoint, Rectangle2D rect, int site, boolean calculated, boolean shiftOnYs, boolean shiftOnYt, EdgeView edgeView) {
        TopView topView;
        Label label;
        if (!this.wait && pos != null && (label = this.getLabel(site)) != null && (topView = label.getFirstViewForDPV(this.dpv)) != null && topView.getCellView() != null) {
            this.wait = true;
            try {
                Rectangle2D rec = topView.getCellView().getBounds();
                double dx = pos.getX();
                double dy = pos.getY();
                if (calculated) {
                    if (site == 2) {
                        dy = shiftOnYt ? (label.isTargetAboveTheLine() ? (dy -= rec.getHeight()) : (dy += 3.0)) : (dy += edgeView.getTargetOffcetY());
                    } else if (site == 0) {
                        dy = shiftOnYs ? (label.isSourceBelowTheLine() ? (dy += 3.0) : (dy -= rec.getHeight())) : (dy += edgeView.getSourceOffsetY());
                    }
                } else if (this instanceof TVDTReference) {
                    dx = this.getMiddle(pos.getX(), otherPoint.getX(), 3);
                    dy = this.getMiddle(pos.getY(), otherPoint.getY(), 3);
                } else {
                    dx = this.getMiddle(pos.getX(), otherPoint.getX(), 2);
                    dy = this.getMiddle(pos.getY(), otherPoint.getY(), 2);
                    if (site == 2) {
                        dy += 3.0;
                    }
                    if (site == 0) {
                        dy -= rec.getHeight();
                    }
                }
                topView.getCellView().setNewBounds(new Rectangle(new Point((int)dx, (int)dy), new Dimension((int)rec.getWidth(), (int)rec.getHeight())), false);
                label.setLastPos(pos);
            }
            finally {
                this.wait = false;
            }
        }
    }

    private double getMiddle(double xy, double other, int counts) {
        double res = other;
        for (int i = 0; i < counts; ++i) {
            res = (xy + res) / 2.0;
        }
        return res;
    }

    public Point2D getDefaultLabelPosition(EdgeView view, int site) {
        if (1 != site) {
            try {
                Point2D pe;
                Point2D p0;
                view.getEdgeRenderer().setView(view);
                Rectangle2D tmp = null;
                if (view.getShape() != null) {
                    tmp = view.getShape().getBounds2D();
                }
                int labelWidth = 1;
                if (site == 0) {
                    p0 = view.getPoint(0);
                    pe = view.getPoint(view.getPointCount() - 1);
                } else {
                    p0 = view.getPoint(view.getPointCount() - 1);
                    pe = view.getPoint(0);
                }
                if (tmp != null) {
                    double x0 = tmp.getX() + (double)labelWidth;
                    int xdir = labelWidth - 40;
                    if (p0.getX() > pe.getX()) {
                        x0 += tmp.getWidth();
                        xdir = -labelWidth;
                    }
                    double y0 = tmp.getY();
                    int ydir = 30;
                    if (p0.getY() > pe.getY()) {
                        y0 += tmp.getHeight();
                        ydir = -20;
                    }
                    double x = x0 + (double)xdir;
                    double y = y0 + (double)ydir;
                    return DiagramConstants.createPoint(x, y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Point2D getCenterPoint(EdgeView view) {
        Point2D.Double p = new Point2D.Double();
        view.getEdgeRenderer().setView(view);
        Point2D p0 = view.getPoint(0);
        Point2D pe = view.getPoint(view.getPointCount() - 1);
        double x = p0.getX() <= pe.getX() ? pe.getX() - p0.getX() : p0.getX() - pe.getX();
        double y = p0.getY() <= pe.getY() ? pe.getY() - p0.getY() : p0.getY() - pe.getY();
        ((Point2D)p).setLocation(x, y);
        return p;
    }

    public Point2D getCenterLabelPosition(EdgeView view) {
        view.getEdgeRenderer().setView(view);
        Rectangle2D tmp = null;
        if (view.getShape() != null) {
            tmp = view.getShape().getBounds2D();
        }
        int unit = 1000;
        Point2D.Double pos = new Point2D.Double(500.0, 500.0);
        Point2D p0 = view.getPoint(0);
        Point2D pe = view.getPoint(view.getPointCount() - 1);
        if (pos != null && tmp != null) {
            double x0 = tmp.getX();
            int xdir = 1;
            if (p0.getX() > pe.getX()) {
                x0 += tmp.getWidth();
                xdir = -1;
            }
            double y0 = tmp.getY();
            int ydir = 1;
            if (p0.getY() > pe.getY()) {
                y0 += tmp.getHeight();
                ydir = -1;
            }
            double x = x0 + (double)xdir * (tmp.getWidth() * ((Point2D)pos).getX() / (double)unit);
            double y = y0 + (double)ydir * (tmp.getHeight() * ((Point2D)pos).getY() / (double)unit);
            return new Point2D.Double(x, y);
        }
        return null;
    }

    public void removeLabel(int site) {
        Label label = this.getLabel(site);
        if (label != null) {
            this.getDesignPartView().getWorkSpace().removeLabel(label);
            label.remove();
            switch (site) {
                case 0: {
                    this.sourceLabel = null;
                    break;
                }
                case 1: {
                    this.centerLabel = null;
                    break;
                }
                case 2: {
                    this.targetLabel = null;
                }
            }
        }
    }

    public Label getLabel(int site) {
        switch (site) {
            case 0: {
                return this.sourceLabel;
            }
            case 1: {
                return this.centerLabel;
            }
            case 2: {
                return this.targetLabel;
            }
        }
        return null;
    }

    public Label getCenterLabel() {
        return this.getLabel(1);
    }

    public Label getSourceLabel() {
        return this.getLabel(0);
    }

    public Label getTargetLabel() {
        return this.getLabel(2);
    }

    public void clearCenterLabel() {
        this.centerLabel = null;
    }

    public void clearSourceLabel() {
        this.sourceLabel = null;
    }

    public void clearTargetLabel() {
        this.targetLabel = null;
    }

    private Label getOrCreateLabel(int site, Rectangle bounds, String text) {
        Label label = this.getLabel(site);
        if (label == null) {
            Point2D.Double pos;
            label = this.getDesignPartView().getDesignPart().createLabel();
            label.setTVConnector(this);
            label.setSite(site);
            TopView topView = label.getFirstViewForDPV(this.getDesignPartView());
            if (topView == null) {
                topView = this.getDesignPartView().createTopViewFor(label);
            }
            if (((Point2D)(pos = new Point2D.Double(bounds.getX(), bounds.getY()))).getX() == -1.0 && ((Point2D)pos).getY() == -1.0) {
                Point2D defLoc = this.getDefaultLabelPosition(this.getEdgeView(), site);
                if (defLoc == null) {
                    pos.setLocation(new Point2D.Double(bounds.getX(), bounds.getY()));
                } else {
                    pos.setLocation(defLoc);
                }
            }
            int width = (int)bounds.getWidth();
            int height = (int)bounds.getHeight();
            DefaultFontAndColor dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                Font font = label.isRelationshipAttributesLabel() ? dfc.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont() : dfc.getFontObject(EditableFonts.FO_TEXT).getFont();
                FontMetrics m = this.getEdgeView().getDiagram().getFontMetrics(font);
                if (this.getDesignPartView() instanceof DPVLogical && 1 == site) {
                    int rows = 0;
                    if (width == -1) {
                        StringTokenizer st = new StringTokenizer(text, "\n");
                        while (st.hasMoreTokens()) {
                            String colName = st.nextToken().trim();
                            width = Math.max(width, m.stringWidth(colName) + 10);
                            ++rows;
                        }
                    }
                    if (height == -1) {
                        if (rows == 0) {
                            rows = 1;
                        }
                        height = font.getSize() * 2 * rows + 10;
                    }
                } else {
                    if (width == -1) {
                        width = m.stringWidth(text) + 15;
                    }
                    if (height == -1) {
                        height = font.getSize() * 2 + 10;
                    }
                }
            }
            Rectangle rec = bounds.getX() < 0.0 || bounds.getY() < 0.0 || bounds.getWidth() < 0.0 || bounds.getHeight() < 0.0 ? new Rectangle((int)((Point2D)pos).getX() - width / 2, (int)((Point2D)pos).getY() - height / 2, width, height) : new Rectangle(bounds);
            LabelDiagramCell cell = this.getDesignPartView().getWorkSpace().addLabel(label, rec);
            if (cell != null) {
                cell.setTopView(topView);
                topView.setCellView(cell.getCellView());
                cell.setEdge((DefaultEdge)this.getCellView().getCell());
            }
            switch (site) {
                case 0: {
                    this.sourceLabel = label;
                    this.sourceLabelBounds = rec;
                    this.readProps(this.sourceLabel, this.tempSourceLabel);
                    break;
                }
                case 1: {
                    this.centerLabel = label;
                    this.labelBounds = rec;
                    this.readProps(this.centerLabel, this.tempCenterLabel);
                    break;
                }
                case 2: {
                    this.targetLabel = label;
                    this.targetLabelBounds = rec;
                    this.readProps(this.targetLabel, this.tempTargetLabel);
                }
            }
        }
        return label;
    }

    private void readProps(Label label, Label temp) {
        if (temp != null) {
            label.setUseDefaultColor(temp.useDefaultColor());
            label.setBackgroundColor(temp.getBackgroundColor());
            label.setForegroundColor(temp.getForegroundColor());
            label.setNoBackgroundColor(temp.getNoBackgroundColor());
            label.setNoForegroundColor(temp.getNoForegroundColor());
            label.setTargetAboveTheLine(temp.isTargetAboveTheLine());
            label.setSourceBelowTheLine(temp.isSourceBelowTheLine());
            if (label.getTopView() != null && temp.getTopView() != null) {
                label.getTopView().getEditableFonts().clear();
                Iterator it = temp.getTopView().getEditableFonts().iterator();
                while (it.hasNext()) {
                    label.getTopView().getEditableFonts().add(it.next());
                }
            }
            temp.remove();
        }
    }

    protected void displayLabel(String text, Rectangle bounds, int site) {
        Label label = this.getOrCreateLabel(site, bounds, text);
        if (label != null) {
            AbstractCellView cellView;
            label.setText(text);
            TopView topView = label.getFirstViewForDPV(this.getDesignPartView());
            if (topView != null && (cellView = topView.getCellView()) != null && bounds.getX() != -1.0 && bounds.getY() != -1.0) {
                Rectangle2D rec = cellView.getBounds();
                rec.setFrame(bounds.getX(), bounds.getY(), rec.getWidth(), rec.getHeight());
                topView.getCellView().setNewBounds(rec.getBounds(), false);
            }
        }
    }

    public EdgeView getEdgeView() {
        return (EdgeView)this.getCellView();
    }

    public void displayLabels() {
    }

    @Override
    public SelectableObject getSelectableObject() {
        return null;
    }

    public void connectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(true);
        }
    }

    public void disconnectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(false);
        }
    }

    public Label getTempCenterLabel() {
        if (this.tempCenterLabel == null) {
            this.tempCenterLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempCenterLabel.setTVConnector(this);
        }
        return this.tempCenterLabel;
    }

    public Label getTempSourceLabel() {
        if (this.tempSourceLabel == null) {
            this.tempSourceLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempSourceLabel.setTVConnector(this);
        }
        return this.tempSourceLabel;
    }

    public Label getTempTargetLabel() {
        if (this.tempTargetLabel == null) {
            this.tempTargetLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempTargetLabel.setTVConnector(this);
        }
        return this.tempTargetLabel;
    }

    @Override
    public void setCellView(AbstractCellView cellView) {
        super.setCellView(cellView);
        this.edge = cellView != null && cellView.getCell() instanceof DefaultEdge ? (DefaultEdge)cellView.getCell() : null;
    }

    public TopView getSourceTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getSourceTopView(this.getDesignPartView());
    }

    public TopView getTargetTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getTargetTopView(this.getDesignPartView());
    }

    public List getLabels() {
        ArrayList<Label> list = new ArrayList<Label>();
        if (this.sourceLabel != null) {
            list.add(this.sourceLabel);
        }
        if (this.targetLabel != null) {
            list.add(this.targetLabel);
        }
        if (this.centerLabel != null) {
            list.add(this.centerLabel);
        }
        return list;
    }

    public Rectangle getLabelBounds(int site) {
        TopView tvl;
        Label label = this.getLabel(site);
        if (label != null && (tvl = label.getFirstViewForDPV(this.dpv)) != null) {
            Rectangle r = this.getLabelBoundsFor(site);
            if (tvl.getCellView() != null) {
                r = tvl.getCellView().getBounds().getBounds();
            }
            return r;
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    public Rectangle getLabelBoundsFor(int site) {
        switch (site) {
            case 0: {
                return this.getSourceLabelBounds();
            }
            case 1: {
                return this.getLabelBounds();
            }
            case 2: {
                return this.getTargetLabelBounds();
            }
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    public void setLabelBoundsFor(Rectangle rect, int site) {
        switch (site) {
            case 0: {
                this.setSourceLabelBounds(rect);
                break;
            }
            case 1: {
                this.setLabelBounds(rect);
                break;
            }
            case 2: {
                this.setTargetLabelBounds(rect);
            }
        }
    }

    public void setLabel(Label label, int site) {
        switch (site) {
            case 0: {
                this.sourceLabel = label;
                break;
            }
            case 1: {
                this.centerLabel = label;
                break;
            }
            case 2: {
                this.targetLabel = label;
            }
        }
    }

    public List getActualPoints() {
        ArrayList<Point2D> list = null;
        EdgeView ev = (EdgeView)this.getCellView();
        if ((ev == null || this.edgePoints.size() == 0) && this.getEdge() != null && this.getEdge().getCellView() != null) {
            ev = (EdgeView)this.getEdge().getCellView();
        }
        if (ev != null) {
            int k = ev.getPoints().size();
            for (int i = 0; i < k; ++i) {
                if (list == null) {
                    list = new ArrayList<Point2D>();
                }
                Point2D point = ev.getPoint(i);
                list.add(point);
            }
        } else {
            List edgePoints = this.getEdgePoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(p);
            }
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public void applyEdgePointsToCellView() {
        if (this.getEdge() != null && this.getEdge().getCellView() != null) {
            Hashtable hashtable = new Hashtable();
            DiagramConstants.setPoints(hashtable, this.edgePoints);
            this.getEdge().changeAttributes(hashtable);
            if (this.getEdge().getCellView() != null) {
                this.getEdge().getCellView().update();
            }
        }
    }

    public Rectangle getLineBounds() {
        List list = this.getActualPoints();
        if (list.size() > 0) {
            Point2D p = (Point2D)list.get(0);
            Rectangle r = new Rectangle((int)p.getX(), (int)p.getY());
            for (int i = 1; i < list.size(); ++i) {
                p = (Point2D)list.get(i);
                Rectangle rt = new Rectangle((int)p.getX(), (int)p.getY());
                r.union(rt);
            }
            return r;
        }
        return null;
    }

    public void resetEdgeParams() {
    }

    public void createDefaultSelfReferencePoints() {
        List points;
        EdgeView edgeView;
        if (this.edge != null && (edgeView = (EdgeView)this.getCellView()) != null && edgeView.getPoints().size() < 3 && (points = this.edge.createDefaultSelfReferencePoints()) != null) {
            this.getDesignPartView().getWorkSpace().addPoints(this.edge, points, true);
            this.edge.getCellView().update();
        }
    }

    public void resetSFRouting(boolean autoRoute) {
        if (this.edge != null) {
            Hashtable<DefaultEdge, Map> attributes = new Hashtable<DefaultEdge, Map>();
            Map edgeAttributes = DiagramConstants.createMap();
            attributes.put(this.edge, edgeAttributes);
            if (!autoRoute) {
                AttributeMap map = new AttributeMap();
                HashMap<DefaultEdge, List> hm = new HashMap<DefaultEdge, List>();
                List points = ((EdgeView)this.edge.getTopView().getCellView()).getPoints();
                points = this.getDesignPartView().getWorkSpace().clonePoints(points);
                hm.put(this.edge, points);
                Object[] edges = new Object[]{this.edge};
                DiagramConstants.setRemoveAttributes(map, new Object[]{"routing", "points"});
                this.getDesignPartView().getWorkSpace().setSelectionAttributes(map, edges);
                for (DefaultEdge edge : hm.keySet()) {
                    points = (List)hm.get(edge);
                    this.getDesignPartView().getWorkSpace().addPoints(edge, points, true);
                    edge.getCellView().update();
                }
            }
        }
    }

    @Override
    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    @Override
    public void setUseDefaultColor(boolean useDefaultColor) {
        this.useDefaultColor = useDefaultColor;
    }

    @Override
    public Color getBackgroundColor() {
        if (!this.useDefaultColor()) {
            return this.backgroundColor;
        }
        Color color = this.getModel().getBackgroundColor();
        if (color != null) {
            return this.getModel().getBackgroundColor();
        }
        return this.getDefaultLineColor();
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (!this.useDefaultColor()) {
            this.getModel().setBackgroundColor(backgroundColor);
        }
    }

    @Override
    public Color getForegroundColor() {
        if (!this.useDefaultColor()) {
            return this.foregroundColor;
        }
        return this.getModel().getForegroundColor();
    }

    @Override
    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
        if (!this.useDefaultColor()) {
            this.getModel().setForegroundColor(foregroundColor);
        }
    }

    public boolean isCanGoBack() {
        return true;
    }

    public boolean isSelfReference() {
        ConnectionInterface ci = (ConnectionInterface)((Object)this.getModel());
        if (ci != null) {
            return ci.getSourceObject() == ci.getTargetObject();
        }
        return false;
    }

    @Override
    public int getLineWidth() {
        if (!this.useDefaultColor) {
            return this.lineWidth;
        }
        return this.getDefaultLineWidth();
    }
}

