/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.swing.JCheckBox;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.SSBConstraints;
import oracle.dbtools.crest.exports.ddl.db2.SSBAutoIncrementColumnDB2;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.sqlserver.SSBAutoIncrementColumnSqlServer;
import oracle.dbtools.crest.exports.ddl.udb.SSBAutoIncrementColumnUDB;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;

public class DDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private String ddlFilesFolder = null;
    private static int createDatabase = 0;
    private static int createTable = 0;
    private static int createIndex = 0;
    private static int createTablespace = 0;
    private static int createView = 0;
    private static int alterTable = 0;
    private static int alterView = 0;
    private static int createTrigger = 0;
    private static int alterTrigger = 0;
    private static int createPackage = 0;
    private static int createPackageBody = 0;
    private static int createProc = 0;
    private static int createFunction = 0;
    private static int redactionPolicies = 0;
    private static int tsdpPolicies = 0;
    private static int createAlias = 0;
    private static int createAuxTable = 0;
    private static int createDistinctType = 0;
    private static int createStructuredType = 0;
    private static int createStructuredTypeBody = 0;
    private static int createStoGroup = 0;
    private static int createSynomym = 0;
    private static int createCluster = 0;
    private static int createContext = 0;
    private static int createDimension = 0;
    private static int createDirectory = 0;
    private static int createRole = 0;
    private static int createRollbackSegment = 0;
    private static int createSequence = 0;
    private static int createSnapshot = 0;
    private static int createMaterializedViewLog = 0;
    private static int createDiskgroup = 0;
    private static int createUser = 0;
    private static int createDefault = 0;
    private static int createRule = 0;
    private static int createIndexOnView = 0;
    private static int createInstance = 0;
    private static int createNodeGroup = 0;
    private static int createDbPartitionGroup = 0;
    private static int createBufferPool = 0;
    private static int createSchema = 0;
    private static int ordsDropSchema = 0;
    private static int ordsEnableSchema = 0;
    private static int ordsEnableObject = 0;
    private static int dropDatabase = 0;
    private static int dropTablespace = 0;
    private static int dropAlias = 0;
    private static int dropTriggers = 0;
    private static int dropProcedures = 0;
    private static int dropStogroup = 0;
    private static int dropSynonym = 0;
    private static int dropDistinctType = 0;
    private static int dropSequence = 0;
    private static int errors = 0;
    private static int warnings = 0;
    private static int createCollectionType = 0;
    private static int createPartitionFunction = 0;
    private static int createPartitionScheme = 0;
    private static int advancedStep = 10;
    private static boolean normalIncrement = true;
    private static final char INTERVAL = ' ';
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private List sorted = new ArrayList();
    private Map sortedMap = new HashMap();
    private Map tracedMap = new HashMap();
    private SSBConstraints ssbConstraints = null;
    private DBConfig options = null;
    private RelationalDesign relationalDesign;
    private static final Logger LOGGER = new Logger(DDLFileMaker.class);

    public DDLFileMaker(Design design, RelationalDesign relationalDesign) {
        this.setDesign(design);
        this.relationalDesign = relationalDesign;
    }

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getRelationalDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private String getDDLFilesMainFolder() {
        if (this.ddlFilesFolder == null) {
            this.ddlFilesFolder = this.getAppView().getSettings().getDefaultDDLFilesPath().trim();
            if (this.ddlFilesFolder == null || this.ddlFilesFolder.isEmpty()) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                try {
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(1);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setPathContext("dataModeler_DDL");
                }
                catch (Exception e) {
                    LOGGER.error("URLChooser: ", e);
                }
                JCheckBox chSaveAsDefault = new JCheckBox(Messages.getString("DDLFileMaker.SaveAsDefault"));
                fileChooser.add((Component)chSaveAsDefault, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFileMaker.SelectDDLFilesFolder"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    this.ddlFilesFolder = file.getAbsolutePath();
                    if (chSaveAsDefault.isSelected()) {
                        this.getAppView().getSettings().setDefaultDDLFilesPath(this.ddlFilesFolder);
                    }
                }
            }
        }
        return this.ddlFilesFolder;
    }

    private static String fixPathName(String path) {
        return path.replaceAll("\\\\|/", " ");
    }

    private void saveDDLToFile(String content, String folderName, String fileName, boolean isDataObject) {
        this.saveDDLToFile(content, folderName, fileName, isDataObject, true);
    }

    private void saveDDLToFile(String content, String folderName, String fileName, boolean isDataObject, boolean deleteExistingFile) {
        if (!content.isEmpty()) {
            String folder = folderName;
            if (folderName == null) {
                folder = "";
            }
            try {
                String basePath = this.getDDLFilesMainFolder();
                if (!basePath.isEmpty()) {
                    File file;
                    if (this.getAppView().getSettings().isIncludeDesgnNameInDDLPath()) {
                        file = new File(basePath, DDLFileMaker.fixPathName(this.getRelationalDesign().getDesign().getName()));
                        file = new File(file.getAbsolutePath(), DDLFileMaker.fixPathName(this.getStorageDesign().getPhysicalDesign().getName()));
                        file = new File(file.getAbsolutePath(), DDLFileMaker.fixPathName(this.getStorageDesign().getName()));
                    } else {
                        file = new File(basePath);
                    }
                    if (!folder.isEmpty()) {
                        file = isDataObject ? new File(file.getAbsolutePath(), "DataObjects") : new File(file.getAbsolutePath(), "Code");
                        file = new File(file.getAbsolutePath(), folder);
                    }
                    file.mkdirs();
                    String ext = isDataObject || !(this.getStorageDesign() instanceof StorageDesignOracle) ? ".sql" : (folder.equalsIgnoreCase("Package") ? ".pks" : (folder.equalsIgnoreCase("Package Body") ? ".pkb" : ".pls"));
                    String FN = fileName + ext;
                    file = new File(file.getAbsolutePath(), FN);
                    if (deleteExistingFile && file.exists()) {
                        file.delete();
                    }
                    FileOutputStream fs = new FileOutputStream(file, !deleteExistingFile);
                    OutputStreamWriter bs = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    bs.write(content);
                    bs.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to Save File: " + fileName, e);
            }
        }
    }

    private String getConstraintsDefinitionFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(tableProxy);
    }

    private String getSupplementalLogIDSAlterFor(TableProxy tableProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getSupplementalLogIDSAlterFor(tableProxy);
    }

    private String getConstraintsDefinitionFor(TableViewProxy viewProxy) {
        if (this.ssbConstraints == null) {
            this.ssbConstraints = new SSBConstraints();
        }
        return this.ssbConstraints.getConstraintsDefinitionFor(viewProxy);
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    private DBConfig getDBConfig() {
        if (this.options == null) {
            this.options = DBConfig.getInstance();
        }
        return this.options;
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            if (ApplicationView.isGUIMode()) {
                boolean formatStatement = true;
                if (!this.getDBConfig().getBoolean("AUTO_READONLY_FORMAT").booleanValue() && (object instanceof TableView || object instanceof TableViewProxy || object instanceof IStoredProcedure || object instanceof Trigger || object instanceof PackageOracle)) {
                    formatStatement = false;
                }
                if (formatStatement) {
                    String formatted = this.formatSQL(result, this.getStorageDesign());
                    if (!"".equalsIgnoreCase(result.trim())) {
                        result = formatted;
                    }
                }
            }
            result = StringUtilities.rtrim(StringUtilities.ltrim(result));
            this.buffer().append(result);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
        }
        return result;
    }

    List<ModelIDObject> getFilteredList(Map filter, List<ModelIDObject> objects) {
        if (filter == null || filter.size() == 0) {
            return objects;
        }
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        for (ModelIDObject obj : objects) {
            if (filter.get(obj.getObjectID()) == null) continue;
            list.add(obj);
        }
        return list;
    }

    public void generateDDLContent(ProgressDialog monitor) {
        this.generateDDLContent(monitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void generateDDLContent(ProgressDialog monitor, List<ModelIDObject> selectedObjects) {
        HashMap<String, ModelIDObject> objMap = null;
        if (selectedObjects != null && selectedObjects.size() > 0) {
            objMap = new HashMap<String, ModelIDObject>();
            for (ModelIDObject obj : selectedObjects) {
                objMap.put(obj.getObjectID(), obj);
                if (!(obj instanceof FKIndexAssociation)) continue;
                objMap.put(((FKIndexAssociation)obj).getLocalFKIndex().getObjectID(), obj);
            }
        }
        boolean title = true;
        if (objMap != null && objMap.size() > 0) {
            title = false;
        }
        List<ModelIDObject> listOfDDLObjects = this.getFilteredList(objMap, this.getStorageDesign().getListOfDDLObjects());
        int size = listOfDDLObjects.size();
        HashMap<String, ModelIDObject> ddlObjMap = new HashMap<String, ModelIDObject>();
        for (ModelIDObject obj : listOfDDLObjects) {
            ddlObjMap.put(obj.getObjectID(), obj);
        }
        monitor.setMaximum(size + 10);
        monitor.setNote(Messages.getString("DDLFileMaker.ClearContent"));
        monitor.setProgress(0);
        this.clearContent();
        if (ApplicationView.isGUIMode() && title) {
            this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
        }
        if (title) {
            this.buffer().append(Messages.getString("DDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        }
        if (this.getStorageDesign() != null) {
            ModelObject object;
            String result;
            if (title) {
                this.buffer().append(Messages.getString("DDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
                this.buffer().append(Messages.getString("DDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
                this.buffer().append(this.newline());
            }
            int p = 0;
            DDLFileMaker.resetCounters();
            DDLFileMaker.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                DDLFileMaker.setddlAdvancedGenenerator(ddlAdvancedGenerator);
                ddlAdvancedGenerator.setDDLExceptionList(this.getAppView().getDDLExceptionList());
                ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
            }
            DesignPartView sdpv = this.design.getSelectedSubView();
            HashMap<DesignObject, DesignObject> selMap = new HashMap<DesignObject, DesignObject>();
            if (sdpv != null && sdpv instanceof DPVRelational) {
                for (TopView tv : sdpv.getTVShapes()) {
                    DesignObject obj = tv.getModel();
                    if (obj == null || !(obj instanceof FKContainer)) continue;
                    selMap.put(obj, obj);
                }
            }
            DDLGenerator dropGenerator = this.getStorageDesign().getDDLDropGenerator();
            dropGenerator.clearTemporaryObjects();
            List<ModelIDObject> dropList = this.getFilteredList(objMap, this.getStorageDesign().getDDLDropObjectsList());
            ArrayList<ModelIDObject> temp = new ArrayList<ModelIDObject>();
            Iterator<ModelIDObject> it = dropList.iterator();
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateDropStatements"));
            monitor.setProgress(5);
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    ModelIDObject object2 = it.next();
                    result = this.appendStatementFor(object2, dropGenerator);
                    if (result == null || result.isEmpty()) continue;
                    content.append(result);
                    content.append(this.newline());
                    boolean gen = object2.isMarkedGenerate();
                    ModelIDObject tp = null;
                    if (object2 instanceof TableProxy) {
                        tp = object2;
                        object2 = ((TableProxy)object2).getObject();
                    }
                    if (gen || selMap.size() <= 0 || !(object2 instanceof FKContainer)) continue;
                    selMap.remove(object2);
                    if (tp == null) continue;
                    temp.add(tp);
                }
                this.saveDDLToFile(content.toString(), null, "DropStatements", true);
            } else {
                while (it.hasNext()) {
                    ModelIDObject object3 = it.next();
                    this.appendStatementFor(object3, dropGenerator);
                    boolean gen = object3.isMarkedGenerate();
                    ModelIDObject tp = null;
                    if (object3 instanceof TableProxy) {
                        tp = object3;
                        object3 = ((TableProxy)object3).getObject();
                    }
                    if (gen || selMap.size() <= 0 || !(object3 instanceof FKContainer)) continue;
                    selMap.remove(object3);
                    if (tp == null) continue;
                    temp.add(tp);
                }
            }
            dropList.removeAll(temp);
            monitor.setProgress(10);
            DDLGenerator userGenerator = this.getStorageDesign().getDDLUserGenerator();
            it = this.getFilteredList(objMap, this.getStorageDesign().getDDLUserObjecstList()).iterator();
            monitor.setNote(Messages.getString("DDLFileMaker.DDLFileMaker.GenerateUserDefinitions"));
            monitor.setProgress(12);
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    ModelObject object4 = it.next();
                    result = this.appendStatementFor(object4, userGenerator);
                    if (result == null || result.isEmpty()) continue;
                    this.saveDDLToFile(result, ((ModelIDObject)object4).getOldObjectTypeName(), object4.getName(), true);
                }
            } else {
                while (it.hasNext()) {
                    ModelObject object5 = it.next();
                    this.appendStatementFor(object5, userGenerator);
                }
            }
            monitor.setProgress(14);
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateIncompleteTypeDefinitions"));
            ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
            List<ModelIDObject> refList = new ArrayList<ModelIDObject>();
            for (ModelIDObject obj : this.getFilteredList(objMap, this.getStorageDesign().getDDLTypeObjectsList())) {
                if (!obj.isMarkedGenerate()) continue;
                list.add(obj);
                this.getStorageDesign().processDependencies(obj, Collections.EMPTY_LIST, refList);
            }
            refList = this.getFilteredList(objMap, refList);
            DDLGenerator incompleteTypesGenerator = this.getStorageDesign().getDDLIncompleteTypeGenerator();
            it = this.getStorageDesign() instanceof StorageDesignOracle ? refList.iterator() : this.getFilteredList(objMap, this.getStorageDesign().getDDLIncompleteTypeObjectsList()).iterator();
            while (it.hasNext()) {
                ModelObject object6 = it.next();
                this.appendStatementFor(object6, incompleteTypesGenerator);
            }
            monitor.setProgress(16);
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateTypeDefinitions"));
            DDLGenerator typesGenerator = this.getStorageDesign().getDDLTypeGenerator();
            this.sortObjects(list);
            it = this.sorted.iterator();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    object = it.next();
                    String result2 = this.appendStatementFor(object, typesGenerator);
                    if (result2 == null || result2.isEmpty()) continue;
                    this.saveDDLToFile(result2, ((ModelIDObject)object).getOldObjectTypeName(), object.getLongName(), true);
                }
            } else {
                while (it.hasNext()) {
                    object = it.next();
                    this.appendStatementFor(object, typesGenerator);
                }
            }
            monitor.setProgress(20);
            DDLGenerator ddlGenerator = this.getStorageDesign().getDDLGenerator();
            list.clear();
            ArrayList<ModelIDObject> tableProxies = new ArrayList<ModelIDObject>();
            ArrayList<FKIndexAssociation> clearMarkGenerated = new ArrayList<FKIndexAssociation>();
            if (dropList.size() > 0) {
                ArrayList<ModelIDObject> dlist = new ArrayList<ModelIDObject>();
                for (ModelIDObject obj : dropList) {
                    if (!obj.isDropEnabled()) continue;
                    dlist.add(obj);
                }
                List fkeys = this.getStorageDesign().getPhysicalDesign().getFKIndexAssociationSet().getFKeysToListOfTables(dlist, selMap);
                for (FKIndexAssociation fk2 : fkeys) {
                    ModelIDObject obj = (ModelIDObject)ddlObjMap.get(fk2.getObjectID());
                    if (obj == null) {
                        obj = (ModelIDObject)ddlObjMap.get(fk2.getLocalFKIndex().getObjectID());
                    }
                    if (obj == null) {
                        listOfDDLObjects.add(fk2);
                    }
                    if (fk2.isMarkedGenerate()) continue;
                    fk2.setMarkedGenerate(true);
                    clearMarkGenerated.add(fk2);
                }
            }
            for (ModelIDObject obj : listOfDDLObjects) {
                if (obj.isMarkedGenerate()) {
                    list.add(obj);
                    if (!(obj instanceof TableProxy)) continue;
                    tableProxies.add(obj);
                    continue;
                }
                if (!(obj instanceof TableProxy) && !(obj instanceof TableViewProxy)) continue;
                list.add(obj);
            }
            monitor.setNote(Messages.getString("DDLFileMaker.FindingDependencies"));
            monitor.setProgress(25);
            this.getStorageDesign().parse(list);
            monitor.setProgress(30);
            this.sortObjects(list);
            DRCustomScript ddlScriptIOC = null;
            DRCustomScript ddlScriptBC = null;
            DRCustomScript ddlScriptAC = null;
            ArrayList<TableProxy> processedTables = new ArrayList<TableProxy>();
            for (ModelObject object7 : this.sorted) {
                void var30_39;
                monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AppendDDLInfoFor"), object7.getName()));
                monitor.setProgress(++p);
                String string = "";
                String constraints = null;
                if (object7 instanceof TableProxy) {
                    TableProxy tableProxy = (TableProxy)object7;
                    Table table = (Table)tableProxy.getObject();
                    if (table.isUseDDLTransformationScript() && tableProxy.isMarkedGenerate()) {
                        void var30_42;
                        StringBuffer scriptResult;
                        processedTables.add(tableProxy);
                        if (ddlScriptBC == null) {
                            ddlScriptBC = this.storageDesign.getAppView().getDDLTransformationScriptByName("Before Create");
                        }
                        if ((scriptResult = this.getCustomDDLTransformationScriptResult(object7, "Before Create", ddlScriptBC)).length() > 0) {
                            this.buffer().append(scriptResult);
                            String string2 = string + scriptResult;
                        }
                        if (ddlScriptIOC == null) {
                            ddlScriptIOC = this.storageDesign.getAppView().getDDLTransformationScriptByName("Instead Of Create");
                        }
                        if (ddlScriptIOC != null && !ddlScriptIOC.getScript().trim().equals("")) {
                            scriptResult = this.getCustomDDLTransformationScriptResult(object7, "Instead Of Create", ddlScriptIOC);
                            if (scriptResult.length() > 0) {
                                this.buffer().append(scriptResult);
                                String string3 = (String)var30_42 + scriptResult;
                                DDLFileMaker.incrementCreateTable();
                            }
                        } else {
                            String sl;
                            String string4 = this.appendStatementFor(object7, ddlGenerator);
                            String string5 = (String)var30_42 + string4;
                            constraints = this.getConstraintsDefinitionFor(tableProxy);
                            if (constraints != null && !constraints.isEmpty()) {
                                constraints = this.formatSQL(constraints, this.getStorageDesign());
                                constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                                this.buffer().append(constraints);
                                this.buffer().append(this.newline());
                                this.buffer().append(this.newline());
                            }
                            if ((sl = this.getSupplementalLogIDSAlterFor(tableProxy)) != null && !sl.isEmpty()) {
                                sl = this.formatSQL(sl, this.getStorageDesign());
                                sl = StringUtilities.rtrim(StringUtilities.ltrim(sl));
                                this.buffer().append(sl);
                                this.buffer().append(this.newline());
                                this.buffer().append(this.newline());
                            }
                        }
                        if (ddlScriptAC == null) {
                            ddlScriptAC = this.storageDesign.getAppView().getDDLTransformationScriptByName("After Create");
                        }
                        if ((scriptResult = this.getCustomDDLTransformationScriptResult(object7, "After Create", ddlScriptAC)).length() > 0) {
                            void var30_45;
                            this.buffer().append(scriptResult);
                            String string6 = (String)var30_45 + scriptResult;
                        }
                    } else {
                        String sl;
                        String string7 = this.appendStatementFor(object7, ddlGenerator);
                        constraints = this.getConstraintsDefinitionFor(tableProxy);
                        if (constraints != null && !constraints.isEmpty()) {
                            constraints = this.formatSQL(constraints, this.getStorageDesign());
                            constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                            this.buffer().append(constraints);
                            this.buffer().append(this.newline());
                            this.buffer().append(this.newline());
                        }
                        if ((sl = this.getSupplementalLogIDSAlterFor(tableProxy)) != null && !sl.isEmpty()) {
                            sl = this.formatSQL(sl, this.getStorageDesign());
                            sl = StringUtilities.rtrim(StringUtilities.ltrim(sl));
                            this.buffer().append(sl);
                            this.buffer().append(this.newline());
                            this.buffer().append(this.newline());
                        }
                    }
                } else {
                    TableViewProxy tableViewProxy;
                    String string8 = this.appendStatementFor(object7, ddlGenerator);
                    if (object7 instanceof TableViewProxy && (constraints = this.getConstraintsDefinitionFor(tableViewProxy = (TableViewProxy)object7)) != null && !constraints.isEmpty()) {
                        constraints = this.formatSQL(constraints, this.getStorageDesign());
                        constraints = StringUtilities.rtrim(StringUtilities.ltrim(constraints));
                        this.buffer().append(constraints);
                        this.buffer().append(this.newline());
                        this.buffer().append(this.newline());
                    }
                }
                if (var30_39 == null || var30_39.isEmpty() || !DDLGenerationOptions.generateDDLInFiles()) continue;
                this.saveDDLToFile((String)var30_39, ((ModelIDObject)object7).getOldObjectTypeName(), object7.getLongName(), ((ModelIDObject)object7).isDataObject());
                if (constraints == null || constraints.isEmpty()) continue;
                this.saveDDLToFile(constraints, ((ModelIDObject)object7).getOldObjectTypeName(), object7.getLongName() + "_Constraints", ((ModelIDObject)object7).isDataObject());
            }
            this.sorted.clear();
            clearMarkGenerated.forEach(fk -> fk.setMarkedGenerate(false));
            DDLGenerator scopeGenerator = this.getStorageDesign().getDDLScopeGenerator();
            for (ModelObject modelObject : this.getFilteredList(objMap, this.getStorageDesign().getDDLScopeObjectsList())) {
                monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AlterTableAddScopeFor"), modelObject.getName()));
                monitor.setProgress(++p);
                this.appendStatementFor(modelObject, scopeGenerator);
            }
            DDLGenerator dDLGenerator = this.getStorageDesign().getRedactionPolicyGenerator();
            it = this.getFilteredList(objMap, this.getStorageDesign().getDDLRedactionPolicyObjectsList()).iterator();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    ModelObject modelObject = it.next();
                    String result4 = this.appendStatementFor(modelObject, dDLGenerator);
                    if (result4 == null || result4.isEmpty()) continue;
                    content.append(result4);
                    content.append(this.newline());
                }
                this.saveDDLToFile(content.toString(), null, "RedactionPolicies", true);
            } else {
                while (it.hasNext()) {
                    ModelIDObject object10 = it.next();
                    this.appendStatementFor(object10, dDLGenerator);
                }
            }
            DDLGenerator tsdpGenerator = this.getStorageDesign().getTSDPGenerator();
            tsdpGenerator.clearTemporaryObjects();
            for (ModelIDObject modelIDObject : this.getFilteredList(objMap, this.getStorageDesign().getDDLTSDPPolicyObjectsList())) {
                this.appendStatementFor(modelIDObject, tsdpGenerator);
            }
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer stringBuffer = new StringBuffer();
                tsdpGenerator.doOnFinish(stringBuffer);
                this.saveDDLToFile(stringBuffer.toString(), null, "TSDPPolicies", true);
                this.buffer().append(stringBuffer.toString());
            } else {
                tsdpGenerator.doOnFinish(this.buffer());
            }
            DDLGenerator dDLGenerator2 = this.getStorageDesign().getDDLTriggerGenerator();
            for (ModelIDObject object11 : this.getStorageDesign().getDDLTriggersCausingObjects(objMap)) {
                this.appendStatementFor(object11, dDLGenerator2);
            }
            if (!tableProxies.isEmpty()) {
                DDLGenerator autoIncrementColumnGenerator = this.getStorageDesign().getDDLAutoIncrementColumnGenerator();
                for (ModelIDObject tableProxy : tableProxies) {
                    this.appendStatementFor(tableProxy, autoIncrementColumnGenerator);
                }
                if (this.storageDesign instanceof StorageDesignOracle) {
                    SSBAutoIncrementColumnOracle.clearGenSequenceSet();
                } else if (this.storageDesign instanceof StorageDesignSqlServer) {
                    SSBAutoIncrementColumnSqlServer.clearGenSequenceSet();
                } else if (this.storageDesign instanceof AbstractStorageDesignDB2) {
                    SSBAutoIncrementColumnDB2.clearGenSequenceSet();
                } else if (this.storageDesign instanceof StorageDesignUDB) {
                    SSBAutoIncrementColumnUDB.clearGenSequenceSet();
                }
            }
            for (DDLGenerator endScriptGenerator : this.getStorageDesign().getDDLEndScriptGenerators()) {
                it = this.getFilteredList(objMap, this.getStorageDesign().getDDLEndScriptObjectsList()).iterator();
                if (DDLGenerationOptions.generateDDLInFiles()) {
                    while (it.hasNext()) {
                        ModelObject modelObject = it.next();
                        String result5 = this.appendStatementFor(modelObject, endScriptGenerator);
                        if (result5 == null || result5.isEmpty()) continue;
                        this.saveDDLToFile(result5, ((ModelIDObject)modelObject).getOldObjectTypeName(), modelObject.getLongName(), true, false);
                    }
                    continue;
                }
                while (it.hasNext()) {
                    ModelObject modelObject = it.next();
                    monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.EndScriptFor"), modelObject.getName()));
                    monitor.setProgress(++p);
                    this.appendStatementFor(modelObject, endScriptGenerator);
                }
            }
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                ddlAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            if (DDLGenerationOptions.generateRESTServices() && this.getStorageDesign() instanceof StorageDesignOraclev10g) {
                monitor.setProgress(90);
                monitor.setNote(Messages.getString("DDLFileMaker.AppendORDS"));
                DDLGenerator ordsGenerator = this.getStorageDesign().getORDSGenerator();
                for (ModelObject modelObject : this.getFilteredList(objMap, this.getStorageDesign().getDDLORDSObjectsList())) {
                    ordsGenerator.appendDDLFor(this.buffer(), modelObject);
                }
            }
            monitor.setNote(Messages.getString("DDLFileMaker.FinishingGeneration"));
            monitor.setProgress(97);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            DRCustomScript ddlScript = this.storageDesign.getAppView().getDDLTransformationScriptByName("End Of Script");
            if (ddlScript != null && !ddlScript.getScript().trim().equals("")) {
                try {
                    ddlScript.setPhysicalModel(this.storageDesign);
                    ddlScript.setRelationalModel(this.storageDesign.getPhysicalDesign());
                    for (TableProxy tableProxy : processedTables) {
                        Table table = (Table)tableProxy.getObject();
                        ddlScript.setRelationalModelObject(table);
                        ddlScript.setPhysicalModelObject(tableProxy);
                        try {
                            ScriptEngine eng;
                            ApplyCustomTransformation act = new ApplyCustomTransformation("relational", this.storageDesign.getPhysicalDesign(), new ArrayList<DRCustomScript>(Arrays.asList(ddlScript)));
                            boolean hasErr = act.runTransformation();
                            if (!hasErr && (eng = ddlScript.getEngine()) != null) {
                                Object obj = eng.get("ddlStatementsList");
                                Iterator<Object> ddlStatementsListIt = null;
                                ddlStatementsListIt = obj instanceof ArrayList ? ((ArrayList)obj).iterator() : Collections.emptyListIterator();
                                while (ddlStatementsListIt.hasNext()) {
                                    String statement = (String)ddlStatementsListIt.next();
                                    this.buffer().append(this.newline());
                                    this.buffer().append(statement);
                                }
                            }
                            this.buffer().append(this.newline());
                        }
                        catch (Exception ex) {
                            LOGGER.error("DDL generation. Error during execution of custom transformation script End Of Script : ", ex);
                        }
                    }
                }
                finally {
                    ddlScript.setPhysicalModel(null);
                    ddlScript.setRelationalModel(null);
                    ddlScript.setRelationalModelObject(null);
                    ddlScript.setPhysicalModelObject(null);
                }
            }
            processedTables.clear();
            if (title) {
                this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
            }
        } else {
            monitor.setProgress(100);
            this.buffer().append(Messages.getString("DDLFileMaker.NoStorageDesignAvailable"));
        }
        this.ddlFilesFolder = null;
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append(Messages.getString("DDLFileMaker.SummaryReport"));
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", createTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", createIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", alterTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", createView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER VIEW", alterView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE", createPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE BODY", createPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PROCEDURE", createProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE FUNCTION", createFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", createTrigger);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", alterTrigger);
        if (type == StorageDesignDB2v70.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
        } else if (type == StorageDesignDB2v80.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SEQUENCE", dropSequence);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv71.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE NODE GROUP", createNodeGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv81.RDBMS_TYPE || type == StorageDesignUDBv9.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE PARTITION GROUP", createDbPartitionGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SCHEMA", createSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev9i.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW LOG", createMaterializedViewLog);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev10g.RDBMS_TYPE || type == StorageDesignOraclev11g.RDBMS_TYPE || type == StorageDesignOraclev12c.RDBMS_TYPE || type == StorageDesignOraclev12cR2.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISK GROUP", createDiskgroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW LOG", createMaterializedViewLog);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            if (type != StorageDesignOraclev10g.RDBMS_TYPE) {
                buffer.append("-- ");
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- REDACTION POLICY", redactionPolicies);
                buffer.append(this.newline());
                if (type == StorageDesignOraclev12c.RDBMS_TYPE) {
                    this.appendFormattedString(buffer, "-- TSDP POLICY", tsdpPolicies);
                    buffer.append(this.newline());
                }
            }
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS DROP SCHEMA", ordsDropSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE SCHEMA", ordsEnableSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- ORDS ENABLE OBJECT", ordsEnableObject);
            buffer.append(this.newline());
        } else if (type == StorageDesignSqlServerv2k.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignSqlServerv2k5.RDBMS_TYPE || type == StorageDesignSqlServerv2k8.RDBMS_TYPE || type == StorageDesignSqlServerv2k12.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SCHEMA", createSchema);
            if (type == StorageDesignSqlServerv2k12.RDBMS_TYPE) {
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            }
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION FUNCTION", createPartitionFunction);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION SCHEME", createPartitionScheme);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        }
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", errors);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", warnings);
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = Integer.valueOf(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public static void incrementCreateDatabase() {
        if (normalIncrement) {
            ++createDatabase;
        }
    }

    public static void incrementCreateTable() {
        if (normalIncrement) {
            ++createTable;
        }
    }

    public static int getCreateTable() {
        return createTable;
    }

    public static void incrementCreateIndex() {
        if (normalIncrement) {
            ++createIndex;
        }
    }

    public static int getCreateIndex() {
        return createIndex;
    }

    public static void incrementCreateTablespace() {
        if (normalIncrement) {
            ++createTablespace;
        }
    }

    public static void incrementCreateView() {
        if (normalIncrement) {
            ++createView;
        }
    }

    public static int getCreateView() {
        return createView;
    }

    public static void incrementAlterTable() {
        if (normalIncrement) {
            ++alterTable;
        }
    }

    public static void incrementAlterView() {
        if (normalIncrement) {
            ++alterView;
        }
    }

    public static int getAlterTable() {
        return alterTable;
    }

    public static int getAlterView() {
        return alterView;
    }

    public static void incrementCreateTrigger() {
        if (normalIncrement) {
            ++createTrigger;
        }
    }

    public static int getCreateTrigger() {
        return createTrigger;
    }

    public static int getRedactionPolicies() {
        return redactionPolicies;
    }

    public static int getTSDPPolicies() {
        return tsdpPolicies;
    }

    public static int getORDSDropSchema() {
        return ordsDropSchema;
    }

    public static int getORDSEnableSchema() {
        return ordsEnableSchema;
    }

    public static void incrementORDSDropSchema() {
        if (normalIncrement) {
            ++ordsDropSchema;
        }
    }

    public static void incrementORDSEnableSchema() {
        if (normalIncrement) {
            ++ordsEnableSchema;
        }
    }

    public static int getORDSEnableObject() {
        return ordsEnableObject;
    }

    public static void incrementORDSEnableObject() {
        if (normalIncrement) {
            ++ordsEnableObject;
        }
    }

    public static void incrementAlterTrigger() {
        if (normalIncrement) {
            ++alterTrigger;
        }
    }

    public static int getAlterTrigger() {
        return alterTrigger;
    }

    public static void incrementCreatePackage() {
        if (normalIncrement) {
            ++createPackage;
        }
    }

    public static void incrementCreateProc() {
        if (normalIncrement) {
            ++createProc;
        }
    }

    public static void incrementCreateFunction() {
        if (normalIncrement) {
            ++createFunction;
        }
    }

    public static void incrementCreatePackageBody() {
        if (normalIncrement) {
            ++createPackageBody;
        }
    }

    public static void incrementCreateAlias() {
        if (normalIncrement) {
            ++createAlias;
        }
    }

    public static void incrementCreateAuxTable() {
        if (normalIncrement) {
            ++createAuxTable;
        }
    }

    public static void incrementCreateDistinctType() {
        if (normalIncrement) {
            ++createDistinctType;
        }
    }

    public static void incrementCreateStructuredType() {
        if (normalIncrement) {
            ++createStructuredType;
        }
    }

    public static int getCreateStructuredType() {
        return createStructuredType;
    }

    public static void incrementCreateStructuredTypeBody() {
        if (normalIncrement) {
            ++createStructuredTypeBody;
        }
    }

    public static int getCreateStructuredTypeBody() {
        return createStructuredTypeBody;
    }

    public static void incrementCreateCollectionType() {
        if (normalIncrement) {
            ++createCollectionType;
        }
    }

    public static int getCreateCollectionType() {
        return createCollectionType;
    }

    public static void incrementCreateStoGroup() {
        if (normalIncrement) {
            ++createStoGroup;
        }
    }

    public static void incrementCreateSynomym() {
        if (normalIncrement) {
            ++createSynomym;
        }
    }

    public static int getCreateSynonym() {
        return createSynomym;
    }

    public static void incrementCreateCluster() {
        if (normalIncrement) {
            ++createCluster;
        }
    }

    public static void incrementCreateContext() {
        if (normalIncrement) {
            ++createContext;
        }
    }

    public static int getCreateContext() {
        return createContext;
    }

    public static void incrementCreateDimension() {
        if (normalIncrement) {
            ++createDimension;
        }
    }

    public static int getCreateDimension() {
        return createDimension;
    }

    public static void incrementCreateDirectory() {
        if (normalIncrement) {
            ++createDirectory;
        }
    }

    public static int getCreateDirectory() {
        return createDirectory;
    }

    public static void incrementCreateRole() {
        if (normalIncrement) {
            ++createRole;
        }
    }

    public static void incrementCreateRollbackSegment() {
        if (normalIncrement) {
            ++createRollbackSegment;
        }
    }

    public static void incrementCreateSequence() {
        if (normalIncrement) {
            ++createSequence;
        }
    }

    public static int getCreateSequence() {
        return createSequence;
    }

    public static void incrementCreateSnapshot() {
        if (normalIncrement) {
            ++createSnapshot;
        }
    }

    public static void incrementCreateMaterializedViewLog() {
        if (normalIncrement) {
            ++createMaterializedViewLog;
        }
    }

    public static int getCreateSnapshot() {
        return createSnapshot;
    }

    public static int getCreateMaterializedViewLog() {
        return createMaterializedViewLog;
    }

    public static void incrementCreateDiskgroup() {
        if (normalIncrement) {
            ++createDiskgroup;
        }
    }

    public static void incrementCreateUser() {
        if (normalIncrement) {
            ++createUser;
        }
    }

    public static void incrementCreateDefault() {
        if (normalIncrement) {
            ++createDefault;
        }
    }

    public static void incrementCreateRule() {
        if (normalIncrement) {
            ++createRule;
        }
    }

    public static void incrementCreateIndexOnView() {
        if (normalIncrement) {
            ++createIndexOnView;
        }
    }

    public static void incrementCreateInstance() {
        if (normalIncrement) {
            ++createInstance;
        }
    }

    public static void incrementCreateNodeGroup() {
        if (normalIncrement) {
            ++createNodeGroup;
        }
    }

    public static void incrementCreateDbPartitionGroup() {
        if (normalIncrement) {
            ++createDbPartitionGroup;
        }
    }

    public static void incrementCreateBufferPool() {
        if (normalIncrement) {
            ++createBufferPool;
        }
    }

    public static void incrementCreateSchema() {
        if (normalIncrement) {
            ++createSchema;
        }
    }

    public static void incrementRedactionPolicies() {
        if (normalIncrement) {
            ++redactionPolicies;
        }
    }

    public static void incrementTSDPPolicies() {
        if (normalIncrement) {
            ++tsdpPolicies;
        }
    }

    public static void incrementDropAlias() {
        if (normalIncrement) {
            ++dropAlias;
        }
    }

    public static void incrementDropTriggers() {
        if (normalIncrement) {
            ++dropTriggers;
        }
    }

    public static void incrementDropProcedures() {
        if (normalIncrement) {
            ++dropProcedures;
        }
    }

    public static void incrementDropSynonym() {
        if (normalIncrement) {
            ++dropSynonym;
        }
    }

    public static void incrementDropStogroup() {
        if (normalIncrement) {
            ++dropStogroup;
        }
    }

    public static void incrementDropDistinctType() {
        if (normalIncrement) {
            ++dropDistinctType;
        }
    }

    public static void incrementDropSequence() {
        if (normalIncrement) {
            ++dropSequence;
        }
    }

    public static void incrementDropDatabase() {
        if (normalIncrement) {
            ++dropDatabase;
        }
    }

    public static void incrementDropTablespace() {
        if (normalIncrement) {
            ++dropTablespace;
        }
    }

    public static void incrementErrors() {
        if (normalIncrement) {
            ++errors;
        }
    }

    public static int getErrors() {
        return errors;
    }

    public static void incrementWarnings() {
        if (normalIncrement) {
            ++warnings;
        }
    }

    public static int getWarnings() {
        return warnings;
    }

    public static void incrementPartitionFunction() {
        if (normalIncrement) {
            ++createPartitionFunction;
        }
    }

    public static void incrementPartitionSheme() {
        if (normalIncrement) {
            ++createPartitionScheme;
        }
    }

    public static void incrementAdvancedStep() {
        if (normalIncrement) {
            advancedStep += 10;
        }
    }

    public static void resetCounters() {
        createDatabase = 0;
        createTable = 0;
        createIndex = 0;
        createTablespace = 0;
        createView = 0;
        alterTable = 0;
        alterView = 0;
        createTrigger = 0;
        alterTrigger = 0;
        createPackage = 0;
        createPackageBody = 0;
        createProc = 0;
        createFunction = 0;
        redactionPolicies = 0;
        tsdpPolicies = 0;
        ordsDropSchema = 0;
        ordsEnableSchema = 0;
        ordsEnableObject = 0;
        createAlias = 0;
        createAuxTable = 0;
        createDistinctType = 0;
        createStructuredType = 0;
        createStructuredTypeBody = 0;
        createCollectionType = 0;
        createStoGroup = 0;
        createSynomym = 0;
        createCluster = 0;
        createContext = 0;
        createDimension = 0;
        createDirectory = 0;
        createRole = 0;
        createRollbackSegment = 0;
        createSequence = 0;
        createSnapshot = 0;
        createMaterializedViewLog = 0;
        createDiskgroup = 0;
        createUser = 0;
        createDefault = 0;
        createRule = 0;
        createIndexOnView = 0;
        createInstance = 0;
        createNodeGroup = 0;
        createDbPartitionGroup = 0;
        createBufferPool = 0;
        createSchema = 0;
        createPartitionFunction = 0;
        createPartitionScheme = 0;
        dropDatabase = 0;
        dropTablespace = 0;
        dropAlias = 0;
        dropSynonym = 0;
        dropStogroup = 0;
        dropSequence = 0;
        dropDistinctType = 0;
        dropProcedures = 0;
        dropTriggers = 0;
        errors = 0;
        warnings = 0;
        advancedStep = 10;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        if (!ApplicationView.isGUIMode() || !this.getAppView().getSettings().useSQLDevFormatting()) {
            return sql;
        }
        DMSQLFormatter command = new DMSQLFormatter();
        if (storageDesign instanceof StorageDesignOracle) {
            return command.formatSQL(sql, "Oracle");
        }
        if (storageDesign instanceof StorageDesignSqlServer) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (storageDesign instanceof AbstractStorageDesignDB2 || storageDesign instanceof StorageDesignUDB) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String message, Object object) {
        this.statusMessage(message + object);
    }

    public void statusMessage(String message) {
        this.statusBarOwner.setTempStatusMessage(message, 5000);
    }

    public void checkErrors(Component parent) {
        if (errors > 0) {
            String message = errors == 1 ? Messages.getString("DDLFileMaker.OneError") : MessageFormat.format(Messages.getString("DDLFileMaker.MultipleErrors"), errors);
            MessageDialogs.showMessage(parent, MessageFormat.format(Messages.getString("DDLFileMaker.CheckDesignRules"), message));
        }
    }

    public static int getAdvancedStep() {
        return advancedStep;
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator ddladvgen) {
        ddlAdvancedGenenerator = ddladvgen;
    }

    private void sortObjects(List objects) {
        this.sorted.clear();
        this.sortedMap.clear();
        this.tracedMap.clear();
        for (ModelIDObject obj : objects) {
            this.addToSorted(obj, obj, objects);
            this.tracedMap.clear();
        }
        this.sortedMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSorted(ModelIDObject obj, ModelIDObject topLevelObj, List initialList) {
        if (this.sortedMap.containsKey(obj)) {
            return;
        }
        this.tracedMap.put(obj, obj);
        List<ModelIDObject> list = obj.getParsedDependOnList();
        if (list != null) {
            for (ModelIDObject dep : list) {
                if (this.sortedMap.containsKey(dep) || !initialList.contains(dep) || this.tracedMap.containsKey(dep)) continue;
                if ((topLevelObj instanceof FunctionOracle || topLevelObj instanceof StoredProcedureOracle) && dep instanceof TableProxyOracle) {
                    DDLAdvancedGenerator savedGenerator = DDLFileMaker.getddlAdvancedGenenerator();
                    DDLFileMaker.setddlAdvancedGenenerator(null);
                    normalIncrement = false;
                    try {
                        StringBuffer ddlStringBuffer = new StringBuffer();
                        this.storageDesign.getDDLGenerator().appendDDLFor(ddlStringBuffer, dep);
                        String sql = ddlStringBuffer.toString();
                        this.storageDesign.processDependencies(dep, SQLAnalyzer.getTablesAndFunctions(sql), null);
                    }
                    finally {
                        DDLFileMaker.setddlAdvancedGenenerator(savedGenerator);
                        normalIncrement = true;
                    }
                }
                this.addToSorted(dep, topLevelObj, initialList);
            }
        }
        this.sorted.add(obj);
        this.sortedMap.put(obj, obj);
    }

    private StringBuffer getCustomDDLTransformationScriptResult(Object object, String scriptName, DRCustomScript ddlScript) {
        StringBuffer buffer = new StringBuffer();
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        table.getAppView().loadCustomDRScripts();
        if (table.isUseDDLTransformationScript()) {
            DRCustomScript usedDDLScript = ddlScript;
            if (usedDDLScript == null) {
                usedDDLScript = this.storageDesign.getAppView().getDDLTransformationScriptByName(scriptName);
            }
            if (usedDDLScript != null && !usedDDLScript.getScript().trim().equals("")) {
                usedDDLScript.setRelationalModel(table.getDesignPart());
                usedDDLScript.setRelationalModelObject(table);
                usedDDLScript.setPhysicalModel(this.storageDesign);
                usedDDLScript.setPhysicalModelObject(tableProxy);
                try {
                    ScriptEngine eng;
                    ApplyCustomTransformation act = new ApplyCustomTransformation("relational", table.getRelationalModel(), new ArrayList<DRCustomScript>(Arrays.asList(usedDDLScript)));
                    boolean hasErr = act.runTransformation();
                    if (!hasErr && (eng = usedDDLScript.getEngine()) != null) {
                        Object obj = eng.get("ddlStatementsList");
                        Iterator<Object> ddlStatementsListIt = null;
                        ddlStatementsListIt = obj instanceof ArrayList ? ((ArrayList)obj).iterator() : Collections.emptyListIterator();
                        while (ddlStatementsListIt.hasNext()) {
                            String statement = (String)ddlStatementsListIt.next();
                            buffer.append(this.newline());
                            buffer.append(statement);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Table " + table.getName() + "DDL generation. Error during execution of custom transformation script " + scriptName + " : ", ex);
                }
            }
        }
        return buffer;
    }

    public RelationalDesign getRelationalDesign() {
        return this.relationalDesign;
    }
}

