/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.MessageDialogs;

public class DDLSelectionTabs {
    private JPanel panel;
    private JTable table;
    private List list;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private GUIConfiguration configuration;
    private JTextField tfFilterText = new JTextField();
    private StorageDesign storageDesign;
    static final String regExSpecialChars = "<([{\\^-=$!|]})?*+.>";
    static final String regExSpecialCharsRE = "<([{\\^-=$!|]})?*+.>".replaceAll(".", "\\\\$0");
    static final Pattern reCharsREP = Pattern.compile("[" + regExSpecialCharsRE + "]");

    public DDLSelectionTabs(JPanel panel, JTable table, List list, StorageDesign storageDesign) {
        this.panel = panel;
        this.table = table;
        this.list = list;
        this.storageDesign = storageDesign;
        this.initPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.table.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.configuration = GUIConfiguration.getInstance();
        this.btnSelectAll = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.btnSelectAll.setToolTipText(Messages.getString("DDLSelectionTabs.SelectAll"));
        this.btnDeselectAll = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.btnDeselectAll.setToolTipText(Messages.getString("DDLSelectionTabs.DeselectAll"));
        this.btnSelectAll.addActionListener(new SelectAllListener(this.list, this.table));
        this.btnDeselectAll.addActionListener(new DeselectAllListener(this.list, this.table));
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.btnSelectAll);
        this.toolBar.add(this.btnDeselectAll);
        JLabel lblFormat = new JLabel(Messages.getString("DDLGenerationOptions.Filter"));
        this.tfFilterText.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        this.tfFilterText.setMaximumSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        this.tfFilterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }
        });
        lblFormat.setLabelFor(this.tfFilterText);
        JPanel fp = new JPanel(new FlowLayout(0));
        fp.add(new JPanel());
        fp.add(lblFormat);
        fp.add(this.tfFilterText);
        this.toolBar.add(fp);
        this.panel.add((Component)this.toolBar, "North");
        this.panel.add((Component)this.scrollPane, "Center");
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable == null) {
            return;
        }
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("^(?i)(?:(\\([PU]K\\)) )?" + DDLSelectionTabs.quoteRegExSpecialChars(filterText.getText()), this.getFilterColumn(currentTable));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    static String quoteRegExSpecialChars(String matchChars) {
        Matcher m = reCharsREP.matcher(matchChars);
        return m.replaceAll("\\\\$0");
    }

    protected int getFilterColumn(JTable table) {
        if (table != null) {
            if (table.getColumnModel().getColumnCount() > 2) {
                return table.getColumnModel().getColumn(2).getModelIndex();
            }
            return table.getColumnModel().getColumn(1).getModelIndex();
        }
        return -1;
    }

    private int getPreferredIconSize() {
        return 16;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public class DeselectAllListener
    implements ActionListener {
        private List deselList;
        private JTable deselTable;

        public DeselectAllListener(List deselList, JTable deselTable) {
            this.deselList = deselList;
            this.deselTable = deselTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ModelIdObjectSelection obj : this.deselList) {
                obj.setSelected(false);
            }
            this.deselTable.updateUI();
        }
    }

    public class SelectAllListener
    implements ActionListener {
        private List selList;
        private JTable selTable;

        public SelectAllListener(List selList, JTable selTable) {
            this.selList = selList;
            this.selTable = selTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ModelIdObjectSelection obj : this.selList) {
                obj.setSelected(true);
            }
            this.selTable.updateUI();
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        private List modelList;

        public ObjectModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.ObjectName");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                SynonymOracle syn;
                if (modelObject.getObject() instanceof SynonymSqlServer) {
                    if (((SynonymSqlServer)modelObject.getObject()).getProcedure() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getProcedure().getLongName();
                    }
                    if (((SynonymSqlServer)modelObject.getObject()).getTable() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getTable().getLongName();
                    }
                    if (((SynonymSqlServer)modelObject.getObject()).getView() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getView().getLongName();
                    }
                }
                if ((syn = (SynonymOracle)modelObject.getObject()).getObjectUser() != null) {
                    return new StringBuffer(syn.getObjectUser().getLongName()).append('.').append(syn.getObject()).toString();
                }
                return syn.getObject();
            }
            if (col == 2) {
                if (modelObject.getObject() instanceof SynonymOracle) {
                    SynonymOracle syn = (SynonymOracle)modelObject.getObject();
                    return syn.getLongName();
                }
                return modelObject.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class UserModel
    extends AbstractTableModel {
        private List modelList;

        public UserModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                if (modelObject.getObject() instanceof UserSqlServer) {
                    return ((UserSqlServer)modelObject.getObject()).getDatabase().getName() + "." + modelObject.getObject().getName();
                }
                return ((SchemaSqlServer)modelObject.getObject()).getDatabase().getName() + "." + modelObject.getObject().getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class ConstraintModel
    extends AbstractTableModel {
        private List modelList;

        public ConstraintModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.TableName");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.modelList.size()) {
                ModelIdObjectSelection modelObjectSel = (ModelIdObjectSelection)this.modelList.get(row);
                if (col == 0) {
                    return modelObjectSel.isSelected();
                }
                if (col == 1) {
                    ModelIDObject modelObject = modelObjectSel.getObject();
                    if (modelObject instanceof Index) {
                        TableProxy tableProxy;
                        ContainerObject container = ((Index)modelObject).getContainerObject();
                        StorageDesign storageDesign = DDLSelectionTabs.this.getStorageDesign();
                        if (storageDesign.isOpen() && (tableProxy = (TableProxy)storageDesign.getTableProxySet().getProxy(container.getObjectID())) != null) {
                            return tableProxy.getLongName();
                        }
                        return container.getLongName();
                    }
                    if (modelObject instanceof FKIndexAssociation) {
                        return ((FKIndexAssociation)modelObject).getContainerWithKeyObject().getLongName();
                    }
                    if (modelObject instanceof BitmapJoinIndexOracle) {
                        return ((BitmapJoinIndexOracle)modelObject).getTable().getLongName();
                    }
                    if (modelObject instanceof Trigger) {
                        if (modelObject instanceof TriggerOracle) {
                            if (((TriggerOracle)modelObject).getTable() != null) {
                                return ((TriggerOracle)modelObject).getTable().getLongName();
                            }
                            if (((TriggerOracle)modelObject).getView() != null) {
                                return ((TriggerOracle)modelObject).getView().getLongName();
                            }
                        } else if (modelObject instanceof TriggerUDB) {
                            if (((TriggerUDB)modelObject).getTable() != null) {
                                return ((TriggerUDB)modelObject).getTable().getLongName();
                            }
                            if (((TriggerUDBv81)modelObject).getView() != null) {
                                return ((TriggerUDBv81)modelObject).getView().getLongName();
                            }
                        } else if (modelObject instanceof TriggerSqlServer) {
                            if (((TriggerSqlServer)modelObject).getTable() != null) {
                                return ((TriggerSqlServer)modelObject).getTable().getLongName();
                            }
                            if (((TriggerSqlServer)modelObject).getView() != null) {
                                return ((TriggerSqlServer)modelObject).getView().getLongName();
                            }
                        }
                    } else {
                        if (modelObject instanceof ViewIndex) {
                            TableViewProxy viewProxy;
                            TableView view = ((ViewIndex)modelObject).getView();
                            StorageDesign storageDesign = DDLSelectionTabs.this.getStorageDesign();
                            if (storageDesign.isOpen() && (viewProxy = (TableViewProxy)storageDesign.getTableViewProxySet().getProxy(view.getObjectID())) != null) {
                                return viewProxy.getLongName();
                            }
                            return view.getLongName();
                        }
                        if (modelObject instanceof IndexOnViewSqlServer) {
                            return ((IndexOnViewSqlServer)modelObject).getView().getLongName();
                        }
                    }
                    return ((IndexProxy)modelObject).getTableProxy().getLongName();
                }
                if (col == 2) {
                    ModelIDObject modelObject = modelObjectSel.getObject();
                    boolean isPK = false;
                    if (modelObject instanceof Index) {
                        isPK = ((Index)modelObject).isPK();
                    } else if (modelObject instanceof IndexProxy) {
                        isPK = ((IndexProxy)modelObject).getIndex().isPK();
                    } else if (modelObject instanceof ViewIndex) {
                        isPK = ((ViewIndex)modelObject).isPK();
                    }
                    if (isPK) {
                        return "(PK) " + modelObject.getName();
                    }
                    return modelObject.getName();
                }
                return new Integer(row * col);
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class TableViewSchemaModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewSchemaModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Schema");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.modelList.size()) {
                ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
                ModelIDObject obj = modelObject.getObject();
                String longName = obj.getLongName();
                String schema = "";
                String name = longName;
                int k = longName.indexOf(46);
                if (k > 0 && k < longName.length() - 1) {
                    schema = longName.substring(0, k);
                    name = longName.substring(k + 1);
                }
                if (col == 0) {
                    return modelObject.isSelected();
                }
                if (col == 1) {
                    return schema;
                }
                if (col == 2) {
                    return name;
                }
                return new Integer(row * col);
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class TableViewModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                return modelObject.getObject().getLongName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }
}

