/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class DesignRuleSetPropertiesDialog
extends CustomDialog {
    private static final String NA = "N/A";
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private JDialog dialog;
    private int result = 0;
    private JPanel mainPanel;
    private JTable availableDesignRulesTable;
    private JTable selectedDesignRulesTable;
    private List<DesignRule> availableDesignRulesList;
    private List<DesignRule> selectedDesignRulesList;
    private DesignRuleView parent;
    private JButton buttonRuleAdd;
    private JButton buttonRuleRemove;
    private DesignRule currentRule;
    private JPanel btnPanel;
    private DesignRuleSet drs;
    private ArrayList<DesignRule> allRules = new ArrayList();
    private JSearchTextField allFilterField;
    private JSearchTextField selectedFilterField;
    private TableRowSorter availableDesignRulesTableSorter;
    private TableRowSorter selectedDesignRulesTableSorter;
    private Settings settings;
    private TableRowSorter availableDRsorter;
    private TableRowSorter selectedDRsorter;
    private List availableDRsortKeys;
    private List selectedDRSortKeys;
    private boolean parentSaveBtnInitiallyWasEnabled = false;

    public DesignRuleSetPropertiesDialog(ApplicationView view, DesignRuleSet rs, DesignRuleView drv) {
        super(view);
        this.parent = drv;
        this.drs = rs;
        this.parentSaveBtnInitiallyWasEnabled = this.parent.bnSaveRuleSets.isEnabled();
        if (this.settings == null) {
            this.settings = this.getApplicationView().getSettings();
        }
        this.init();
        this.add((Component)this.mainPanel, "Center");
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel jp = new JPanel();
        BoxLayout bl = new BoxLayout(jp, 2);
        jp.setLayout(bl);
        this.availableDesignRulesList = new ArrayList<DesignRule>();
        this.selectedDesignRulesList = new ArrayList<DesignRule>();
        this.availableDesignRulesTable = new JTable(new AllRulesTableModel()){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.selectedDesignRulesTable = new JTable(new SelRulesTableModel()){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.selectedDesignRulesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        this.availableDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.getSelectedRow() == -1) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(true);
                }
            }
        });
        this.availableDesignRulesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.doClick();
                }
            }
        });
        this.selectedDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getSelectedRow() == -1 || DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getValueAt(DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getSelectedRow(), 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(true);
                }
            }
        });
        this.selectedDesignRulesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.doClick();
                }
            }
        });
        TableColumn col1 = this.availableDesignRulesTable.getColumnModel().getColumn(0);
        col1.setMinWidth(100);
        TableColumn col2 = this.availableDesignRulesTable.getColumnModel().getColumn(1);
        col2.setMinWidth(130);
        TableColumn col3 = this.availableDesignRulesTable.getColumnModel().getColumn(2);
        col3.setMinWidth(370);
        col3.setPreferredWidth(370);
        col3.setCellRenderer(new NameCellRenderer());
        col1 = this.selectedDesignRulesTable.getColumnModel().getColumn(0);
        col1.setMinWidth(120);
        col2 = this.selectedDesignRulesTable.getColumnModel().getColumn(1);
        col2.setMinWidth(120);
        col3 = this.selectedDesignRulesTable.getColumnModel().getColumn(2);
        col3.setMinWidth(370);
        col3.setCellRenderer(new NameCellRenderer());
        this.availableDesignRulesTable.setAutoResizeMode(0);
        this.selectedDesignRulesTable.setAutoResizeMode(0);
        this.availableDesignRulesTableSorter = new TableRowSorter<TableModel>(this.availableDesignRulesTable.getModel());
        this.availableDRsortKeys = new ArrayList();
        this.availableDRsortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.availableDRsortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.availableDRsortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        this.availableDesignRulesTableSorter.setSortsOnUpdates(true);
        this.availableDRsorter = new TableRowSorter<TableModel>(this.availableDesignRulesTable.getModel());
        this.availableDRsorter.setSortsOnUpdates(true);
        this.selectedDesignRulesTableSorter = new TableRowSorter<TableModel>(this.selectedDesignRulesTable.getModel());
        this.selectedDRSortKeys = new ArrayList();
        this.selectedDRSortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.selectedDRSortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.selectedDRSortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        this.selectedDesignRulesTableSorter.setSortsOnUpdates(true);
        this.selectedDRsorter = new TableRowSorter<TableModel>(this.selectedDesignRulesTable.getModel());
        this.selectedDRsorter.setSortsOnUpdates(true);
        JScrollPane allScrollPane = new JScrollPane(this.availableDesignRulesTable, 20, 30);
        JScrollPane selScrollPane = new JScrollPane(this.selectedDesignRulesTable);
        this.allFilterField = new JSearchTextField(true, true, "");
        this.allFilterField.setToolTipText(Messages.getString("DesignRuleSetPropertiesDialog.FilterIngCol1"));
        this.allFilterField.getDocument().addDocumentListener(new AllDRFilterListener());
        this.allFilterField.setPreferredSize(new Dimension(200, 20));
        this.allFilterField.setMinimumSize(new Dimension(200, 20));
        this.allFilterField.setMaximumSize(new Dimension(200, 20));
        this.selectedFilterField = new JSearchTextField(true, true, "");
        this.selectedFilterField.setToolTipText(Messages.getString("DesignRuleSetPropertiesDialog.FilterIngCol1"));
        this.selectedFilterField.getDocument().addDocumentListener(new SelectedDRFilterListener());
        this.selectedFilterField.setPreferredSize(new Dimension(200, 20));
        this.selectedFilterField.setMinimumSize(new Dimension(200, 20));
        this.selectedFilterField.setMaximumSize(new Dimension(200, 20));
        JToolBar leftToolBar = new JToolBar(0);
        leftToolBar.setPreferredSize(new Dimension(160, 25));
        leftToolBar.setFloatable(false);
        leftToolBar.setRollover(true);
        leftToolBar.setBorder(null);
        leftToolBar.add(this.allFilterField);
        JToolBar rightToolBar = new JToolBar(0);
        rightToolBar.setPreferredSize(new Dimension(160, 25));
        rightToolBar.setFloatable(false);
        rightToolBar.setRollover(true);
        rightToolBar.setBorder(null);
        rightToolBar.add(this.selectedFilterField);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.AllRules")));
        leftPanel.add((Component)leftToolBar, "North");
        leftPanel.add((Component)allScrollPane, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.SelectedRules")));
        rightPanel.add((Component)rightToolBar, "North");
        rightPanel.add((Component)selScrollPane, "Center");
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonRuleAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonRuleAdd.addActionListener(new AddRuleActionListener());
        this.buttonRuleAdd.setEnabled(false);
        this.buttonRuleAdd.setToolTipText(Messages.getString("DesignRuleView.AddRule"));
        this.buttonRuleRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRuleRemove.setEnabled(false);
        this.buttonRuleRemove.addActionListener(new RemoveRuleActionListener());
        this.buttonRuleRemove.setToolTipText(Messages.getString("DesignRuleView.RemoveRule"));
        this.buttonRuleAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRuleRemove.setPreferredSize(this.buttonRuleAdd.getPreferredSize());
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonRuleAdd);
        verticalBox.add(this.buttonRuleRemove);
        verticalBox.add(Box.createVerticalGlue());
        jp.add(leftPanel);
        jp.add(verticalBox);
        jp.add(rightPanel);
        this.mainPanel.add((Component)jp, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.mainPanel.add((Component)bottomPanel, "South");
        this.initRules();
    }

    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 1080 : 1030;
    }

    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 560 : 500;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        this.settings.setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.RuleSetProperties") + " - " + this.drs.getName());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(true);
            this.dialog.setModal(true);
            Settings.DialogSettings ds = this.settings.getDialogSettings(this.getClass().getName());
            if (ds == null) {
                this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(ds.rec.getSize());
                this.dialog.setLocation(ds.rec.getLocation());
            }
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DesignRuleSetPropertiesDialog.this.dialog.getWidth();
                    int h = DesignRuleSetPropertiesDialog.this.dialog.getHeight();
                    w = Math.max(DesignRuleSetPropertiesDialog.this.getMinimumWidth(), w);
                    h = Math.max(DesignRuleSetPropertiesDialog.this.getMinimumHeight(), h);
                    DesignRuleSetPropertiesDialog.this.dialog.setSize(w, h);
                }
            });
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "RULESET_PROPERRTIES_DIALOG";
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void initRules() {
        this.availableDesignRulesList.clear();
        this.selectedDesignRulesList.clear();
        this.allRules.clear();
        this.availableDesignRulesList.addAll(this.parent.getAllDesignRules());
        this.selectedDesignRulesList.addAll(this.drs.getDesignRules());
        this.selectedDesignRulesList.addAll(this.drs.getDesignRulesMissing());
        this.allRules.addAll(this.availableDesignRulesList);
        for (DesignRule dr : this.selectedDesignRulesList) {
            for (DesignRule dr1 : this.allRules) {
                if (!dr.getRuleId().equals(dr1.getRuleId())) continue;
                this.availableDesignRulesList.remove(dr1);
            }
        }
        this.manageSorters();
    }

    private void manageSorters() {
        if (this.availableDesignRulesList.size() > 0) {
            this.availableDesignRulesTable.setRowSorter(null);
            this.availableDesignRulesTable.setRowSorter(this.availableDRsorter);
            this.availableDesignRulesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.availableDesignRulesTable, 0);
            this.allFilterField.setEnabled(true);
        } else {
            this.availableDesignRulesTable.setAutoCreateRowSorter(false);
            this.availableDesignRulesTable.setRowSorter(null);
            this.allFilterField.setEnabled(false);
        }
        if (this.selectedDesignRulesList.size() > 0) {
            this.selectedDRsorter.setSortKeys(this.selectedDRSortKeys);
            this.selectedDesignRulesTable.setRowSorter(this.selectedDRsorter);
            this.selectedDesignRulesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.selectedDesignRulesTable, 0);
            this.selectedFilterField.setEnabled(true);
        } else {
            this.selectedDesignRulesTable.setAutoCreateRowSorter(false);
            this.selectedDesignRulesTable.setRowSorter(null);
            this.selectedFilterField.setEnabled(false);
        }
    }

    protected JPanel getButtonPanel() {
        if (this.btnPanel == null) {
            this.btnPanel = new JPanel();
            JButton ok = new JButton(Messages.getString("DesignRuleView.OK"));
            ok.setMnemonic(79);
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignRuleSetPropertiesDialog.this.applyRulesToRuleset();
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
                    DesignRuleSetPropertiesDialog.this.result = 1;
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton cancel = new JButton(Messages.getString("DesignRuleView.Cancel"));
            cancel.setMnemonic(67);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignRuleSetPropertiesDialog.this.result = 0;
                    if (!DesignRuleSetPropertiesDialog.this.parentSaveBtnInitiallyWasEnabled) {
                        ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(false);
                        ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = true;
                    }
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnPanel.add(ok);
            this.btnPanel.add(cancel);
            this.btnPanel.add(bnHelp);
        }
        return this.btnPanel;
    }

    private void applyRulesToRuleset() {
        this.drs.getDesignRules().clear();
        int i = this.selectedDesignRulesList.size();
        if (i > 0) {
            for (int h = 0; h < i; ++h) {
                if (this.selectedDesignRulesTable.getValueAt(h, 2).equals(NA)) continue;
                DesignRule dr = this.selectedDesignRulesList.get(h);
                this.drs.addRule(dr);
            }
        }
    }

    private void designRulesFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(2));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    class NameCellRenderer
    extends DefaultTableCellRenderer {
        NameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String pathValue = value.toString();
            c.setToolTipText(pathValue);
            c.setToolTipText(c.getText());
            return c;
        }
    }

    private class SelectedDRFilterListener
    implements DocumentListener {
        private SelectedDRFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.selectedFilterField, DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable);
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.selectedFilterField, DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable);
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.selectedFilterField, DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable);
        }
    }

    private class AllDRFilterListener
    implements DocumentListener {
        private AllDRFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.allFilterField, DesignRuleSetPropertiesDialog.this.availableDesignRulesTable);
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.allFilterField, DesignRuleSetPropertiesDialog.this.availableDesignRulesTable);
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            DesignRuleSetPropertiesDialog.this.designRulesFilter(DesignRuleSetPropertiesDialog.this.allFilterField, DesignRuleSetPropertiesDialog.this.availableDesignRulesTable);
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3947219013441913836L;
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color fc = null;
            if (table.getValueAt(row, 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                fc = Color.RED;
            }
            comp.setForeground(fc);
            return comp;
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getRowSorter().setSortKeys(null);
            if (DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.getRowSorter() != null && DesignRuleSetPropertiesDialog.this.availableDesignRulesList.size() >= 1) {
                DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.getRowSorter().setSortKeys(null);
            }
            boolean wasEmpty = DesignRuleSetPropertiesDialog.this.availableDesignRulesList.size() == 0;
            int[] selected = DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> tempList = new ArrayList<DesignRule>();
            for (int i = 0; i < selected.length; ++i) {
                DesignRule current = (DesignRule)DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.get(DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.convertRowIndexToModel(selected[i]));
                if (DesignRuleSetPropertiesDialog.this.availableDesignRulesList.contains(current)) continue;
                tempList.add(current);
                DesignRuleSetPropertiesDialog.this.availableDesignRulesList.add(current);
            }
            DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.removeAll(tempList);
            DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
            DesignRuleSetPropertiesDialog.this.manageSorters();
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.getRowSorter().setSortKeys(null);
            if (DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getRowSorter() != null && DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.size() >= 1) {
                DesignRuleSetPropertiesDialog.this.selectedDesignRulesTable.getRowSorter().setSortKeys(null);
            }
            int[] selected = DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> tempList = new ArrayList<DesignRule>();
            for (int i = 0; i < selected.length; ++i) {
                DesignRule current = (DesignRule)DesignRuleSetPropertiesDialog.this.availableDesignRulesList.get(DesignRuleSetPropertiesDialog.this.availableDesignRulesTable.convertRowIndexToModel(selected[i]));
                if (DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.contains(current)) continue;
                tempList.add(current);
                DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.add(current);
            }
            DesignRuleSetPropertiesDialog.this.availableDesignRulesList.removeAll(tempList);
            DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(DesignRuleSetPropertiesDialog.this.availableDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
            DesignRuleSetPropertiesDialog.this.manageSorters();
        }
    }

    private class SelRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5686761803148703793L;
        final String[] COL_NAMES = new String[]{Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private SelRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRule rs = (DesignRule)DesignRuleSetPropertiesDialog.this.selectedDesignRulesList.get(row);
            if (col == 0) {
                if (rs.getRuleHandler() != null) {
                    return rs.getContextString();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (col == 1) {
                if (rs.getRuleHandler() != null) {
                    return rs.getRuleHandler().getLabel();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (col == 2) {
                return rs.getName();
            }
            return row + 1;
        }
    }

    private class AllRulesTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private AllRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.availableDesignRulesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRule rs = (DesignRule)DesignRuleSetPropertiesDialog.this.availableDesignRulesList.get(row);
            if (col == 0) {
                return rs.getContextString();
            }
            if (col == 1) {
                return rs.getRuleHandler().getLabel();
            }
            if (col == 2) {
                return rs.getName();
            }
            return row + 1;
        }
    }
}

