/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.OverviewPanel;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDiagramCell;
import oracle.dbtools.crest.swingui.diagram.datatypes.InheritanceEdge;
import oracle.dbtools.crest.swingui.diagram.datatypes.ReferenceEdge;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeView;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.AttributeMap;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewView;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.ImageDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ImageView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.diagram.graph.LegendDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LegendView;
import oracle.dbtools.crest.swingui.diagram.graph.MarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.NoteDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.NoteView;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.graph.TypeSubstitutionEdge;
import oracle.dbtools.crest.swingui.diagram.logical.ArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.ArcView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityViewView;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.diagram.multidimensional.CubeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.CubeView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LevelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LevelView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LinkEdge;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.RaggedHLinkEdge;
import oracle.dbtools.crest.swingui.diagram.process.AgentDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.AgentView;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.InOutParamsDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.InOutParamsView;
import oracle.dbtools.crest.swingui.diagram.process.ProcessDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.ProcessView;
import oracle.dbtools.crest.swingui.diagram.process.StoreDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.StoreView;
import oracle.dbtools.crest.swingui.diagram.process.TransformationDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.TransformationView;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcView;
import oracle.dbtools.crest.swingui.diagram.relational.FKDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableView;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;

public class Diagram
extends AbstractDiagram {
    public static final int DEFAULT_CONTAINER_WIDTH = 170;
    public static final int DEFAULT_CONTAINER_HEIGHT = 110;
    public static final int DEFAULT_NOTE_WIDTH = 95;
    public static final int DEFAULT_NOTE_HEIGHT = 40;
    public static final int DEFAULT_IMAGE_WIDTH = 80;
    public static final int DEFAULT_IMAGE_HEIGHT = 80;
    public static final int DEFAULT_PROCESS_WIDTH = 130;
    public static final int DEFAULT_PROCESS_HEIGHT = 90;
    public static final int DEFAULT_AGENT_WIDTH = 80;
    public static final int DEFAULT_AGENT_HEIGHT = 80;
    public static final int DEFAULT_STORE_WIDTH = 140;
    public static final int DEFAULT_STORE_HEIGHT = 30;
    public static final int DEFAULT_CUBE_SIZE = 80;
    public static final int DEFAULT_LEVEL_WIDTH = 80;
    public static final int DEFAULT_LEVEL_HEIGHT = 30;
    public static final int DEFAULT_DIMENSION_WIDTH = 80;
    public static final int DEFAULT_DIMENSION_HEIGHT = 30;
    public static final int DEFAULT_STRUCTURED_TYPE_WIDTH = 170;
    public static final int DEFAULT_STRUCTURED_TYPE_HEIGHT = 110;
    public static final Color DEFAULT_BORDER_COLOR = Color.BLUE;
    public static final int DEFAULT_DIAGRAM_VIEW_WIDTH = 140;
    public static final int DEFAULT_DIAGRAM_VIEW_HEIGHT = 100;
    public static final double ZOOM_FACTOR = 1.3;
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    public static final Cursor DELETE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DELETE"), new Point(1, 1), "DELETE_CURSOR");
    public static final Cursor LINE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_LINE"), new Point(1, 1), "LINE_CURSOR");
    public static final Cursor MERGE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_MERGE"), new Point(1, 1), "MERGE_CURSOR");
    public static final Cursor DRAG_YES_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DRAG_YES"), new Point(1, 1), "DRAG_YES_CURSOR");
    public static final Cursor DRAG_NO_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DRAG_NO"), new Point(1, 1), "DRAG_NO_CURSOR");
    public static final int DRAWN_OBJECT_NONE = -1;
    public static final int DRAWN_OBJECT_ENTITY = 0;
    public static final int DRAWN_OBJECT_RELATION = 1;
    public static final int DRAWN_OBJECT_TABLE = 2;
    public static final int DRAWN_OBJECT_FK = 3;
    public static final int DRAWN_OBJECT_VIEW = 4;
    public static final int DRAWN_OBJECT_TEXT = 5;
    public static final int DELETE_OBJECT = 6;
    public static final int DRAWN_OBJECT_PROCESS = 7;
    public static final int DRAWN_OBJECT_AGENT = 8;
    public static final int DRAWN_OBJECT_STORE = 9;
    public static final int DRAWN_OBJECT_FLOW = 10;
    public static final int DRAWN_OBJECT_CUBE = 11;
    public static final int DRAWN_OBJECT_LEVEL = 12;
    public static final int DRAWN_OBJECT_DIMENSION = 13;
    public static final int DRAWN_OBJECT_LINK = 14;
    public static final int DRAWN_OBJECT_TRANSFORMATION = 15;
    public static final int DRAWN_OBJECT_RAGEDH_LINK = 16;
    public static final int DRAWN_OBJECT_STRUCTURED_TYPE = 17;
    public static final int DRAWN_OBJECT_TYPE_SUBSTITUTION = 18;
    public static final int DRAWN_OBJECT_ENTIY_VIEW = 19;
    public static final int DRAWN_OBJECT_UDCLASS = 20;
    public static final int DRAWN_OBJECT_UDCOMPOSITION = 21;
    public static final int DRAWN_OBJECT_UDASSOCIATION = 22;
    public static final int DRAWN_OBJECT_PDCLASS = 23;
    public static final int DRAWN_OBJECT_ARC = 24;
    public static final int DRAWN_OBJECT_IMAGE = 25;
    public static final int BACHMAN_NOTATION = 0;
    public static final int BARKER_NOTATION = 1;
    public static final int IE_NOTATION = 2;
    private JScrollPane scrollPane;
    private String name;
    private JPanel overview;
    private ApplicationView appView;
    private int drawnObjectID = -1;
    private MDBAction currentAction;
    private DesignPartView dpv;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 1;
    public static final int EQUAL_WIDTH = 3;
    public static final int EQUAL_HEIGHT = 4;

    public Diagram(ApplicationView appView, DesignPartView dpv) {
        super(new DefaultDiagramModel());
        this.appView = appView;
        this.dpv = dpv;
        this.setMarqueeHandler(new MarqueeHandler(this));
        this.setGridEnabled(dpv.isGridEnabled());
        this.setGridVisible(dpv.showGrid());
        this.setPageGridVisible(dpv.showPageGrid());
        this.setPageFormat(appView.getSettings().getPageFormat());
        this.setGridSize(appView.getSettings().getGridSize());
        if (appView != null) {
            this.setBackground(dpv.getDiagramColor());
        }
        this.setHandleColor(Color.BLUE);
        this.setEditable(false);
        this.setAntiAliased(true);
        this.setGridColor(Color.GRAY);
        this.setSizeable(true);
        if (this.isRestricted()) {
            this.setMoveable(false);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setFont(DEFAULT_FONT);
        this.createOverview();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((dpv.getDesignPart() instanceof RelationalDesign || dpv.getDesignPart() instanceof DataTypesDesign) && appView != null && appView.getDropTargetListener() != null) {
            this.setDropTarget(new DropTarget(this, 0x40000003, appView.getDropTargetListener(), true));
        }
    }

    public static Object[] getNotations() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Bachman");
        list.add("Barker");
        return list.toArray();
    }

    public void updateReadOnlyStatus() {
        this.setMoveable(!this.isRestricted());
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.dpv != null) {
            this.dpv.getGlassPane().setCursor(cursor);
        }
    }

    public boolean canAlign() {
        int count = 0;
        Object[] selectedCells = this.getSelectionCells();
        for (int i = 0; i < selectedCells.length; ++i) {
            Object selected = selectedCells[i];
            if (!(selected instanceof DefaultDiagramCell) || selected instanceof DefaultEdge) continue;
            ++count;
        }
        return count > 1;
    }

    public void alignSelected(int type) {
        Object[] selectedCells = this.getSelectionCells();
        int pos = -1;
        block6: for (int i = 0; i < selectedCells.length; ++i) {
            Object selected = selectedCells[i];
            if (!(selected instanceof DefaultDiagramCell) || selected instanceof DefaultEdge) continue;
            switch (type) {
                case 0: {
                    if (pos == -1) {
                        pos = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().x;
                        continue block6;
                    }
                    int y = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().y;
                    int w = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().width;
                    int h = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)selected).getCellView().setNewBounds(new Rectangle(pos, y, w, h));
                    continue block6;
                }
                case 1: {
                    if (pos == -1) {
                        pos = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().y;
                        continue block6;
                    }
                    int x = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().x;
                    int w = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().width;
                    int h = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)selected).getCellView().setNewBounds(new Rectangle(x, pos, w, h));
                    continue block6;
                }
                case 3: {
                    if (pos == -1) {
                        pos = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().width;
                        continue block6;
                    }
                    int x = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().x;
                    int y = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().y;
                    int h = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)selected).getCellView().setNewBounds(new Rectangle(x, y, pos, h));
                    continue block6;
                }
                case 4: {
                    if (pos == -1) {
                        pos = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().height;
                        continue block6;
                    }
                    int x = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().x;
                    int y = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().y;
                    int w = ((DefaultDiagramCell)selected).getCellView().getBounds().getBounds().width;
                    ((DefaultDiagramCell)selected).getCellView().setNewBounds(new Rectangle(x, y, w, pos));
                }
            }
        }
    }

    private boolean isRestricted() {
        if (this.dpv != null && this.dpv.isReadOnly()) {
            return true;
        }
        if (ApplicationView.IS_VIEWER && !this.dpv.getDesign().isNewDesign()) {
            return true;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return !(this.dpv instanceof DPVLogical);
        }
        return false;
    }

    public void deleteSelected() {
        if (!this.isRestricted()) {
            Object[] selectedCells = this.getSelectionCells();
            for (int i = 0; i < selectedCells.length; ++i) {
                Object selected = selectedCells[i];
                if (!(selected instanceof DefaultDiagramCell)) continue;
                ((DefaultDiagramCell)selected).deleteSelected();
            }
        } else if (ApplicationView.LOGICAL_MODEL_ONLY) {
            // empty if block
        }
    }

    public void deleteAllSelected() {
        if (!this.isRestricted()) {
            Object[] selectedObjects = this.getDesignPartView().getSelectedObjects();
            if (selectedObjects.length == 1) {
                this.deleteSelected();
            } else if (selectedObjects.length > 1) {
                DefaultDiagramCell.deleteObjects(selectedObjects, this.getAppView());
            }
        }
    }

    public void showPropertiesForSelected() {
        SelectableObject so;
        DesignObject designObject;
        if (this.getDesignPartView().getCurrentSelection() != null && (designObject = (so = this.getDesignPartView().getCurrentSelection()).getSelectedDesignObject()) != null) {
            if (designObject instanceof Note) {
                ((Note)designObject).showPropertyDialog(this.getDesignPartView());
            } else {
                designObject.showPropertyDialog();
            }
        }
    }

    public void moveSelectedObjects(int keyCode) {
        if (!this.isRestricted()) {
            Object[] selectedTopViews = this.getDesignPartView().getSelectedTopViews();
            for (int i = 0; i < selectedTopViews.length; ++i) {
                TopView tv = (TopView)selectedTopViews[i];
                if (tv instanceof TVConnector) continue;
                this.getDesignPartView().moveTopView(tv, keyCode);
            }
        }
    }

    public void resizeSelectedObjects(int keyCode) {
        if (!this.isRestricted()) {
            Object[] selectedTopViews = this.getDesignPartView().getSelectedTopViews();
            for (int i = 0; i < selectedTopViews.length; ++i) {
                TopView tv = (TopView)selectedTopViews[i];
                if (tv instanceof TVConnector) continue;
                this.getDesignPartView().resizeTopView(tv, keyCode);
            }
        }
    }

    public void SendLinesToBack(List<TVConnector> lines) {
        ArrayList<DefaultEdge> list = new ArrayList<DefaultEdge>();
        for (TVConnector tv : lines) {
            DefaultEdge edge;
            if (!tv.isCanGoBack() || (edge = tv.getEdge()) == null) continue;
            list.add(edge);
        }
        if (list.size() > 0) {
            this.getDiagramLayoutCache().toBack(list.toArray());
        }
    }

    public void SendAllLinesToBack() {
        ArrayList<Object> result = new ArrayList<Object>();
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            DefaultEdge edge;
            TVConnector tv;
            Object obj = cellViews[i].getCell();
            if (!(obj instanceof DefaultEdge) || (tv = (TVConnector)(edge = (DefaultEdge)obj).getTopView()) != null && !tv.isCanGoBack()) continue;
            result.add(obj);
        }
        if (result.size() > 0) {
            this.getDiagramLayoutCache().toBack(result.toArray());
        }
    }

    public void updateBackground() {
        if (this.dpv != null) {
            this.setGridEnabled(this.dpv.isGridEnabled());
            this.setGridVisible(this.dpv.showGrid());
            this.setPageGridVisible(this.dpv.showPageGrid());
            this.setPageFormat(this.appView.getSettings().getPageFormat());
            this.setGridSize(this.appView.getSettings().getGridSize());
            this.setBackground(this.dpv.getDiagramColor());
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        TVConnector.updateSettings = true;
        boolean route = false;
        try {
            AttributeMap map;
            Object[] edges = this.getEdges();
            if (this.dpv != null) {
                this.setGridEnabled(this.dpv.isGridEnabled());
                this.setGridVisible(this.dpv.showGrid());
                this.setPageGridVisible(this.dpv.showPageGrid());
                this.setPageFormat(this.appView.getSettings().getPageFormat());
                this.setGridSize(this.appView.getSettings().getGridSize());
                this.setBackground(this.dpv.getDiagramColor());
                route = this.dpv.isAutoRoute();
            }
            if (route) {
                map = new AttributeMap();
                DiagramConstants.setRouting(map, DiagramConstants.ROUTING_SIMPLE);
                DiagramConstants.setRemoveAttributes(map, new Object[]{"points"});
                this.setSelectionAttributes(map, this.getEdges());
            } else {
                List points;
                map = new AttributeMap();
                HashMap<DefaultEdge, List> hm = new HashMap<DefaultEdge, List>();
                for (int i = 0; i < edges.length; ++i) {
                    DefaultEdge edge = (DefaultEdge)edges[i];
                    points = ((EdgeView)edge.getTopView().getCellView()).getPoints();
                    points = this.clonePoints(points);
                    hm.put(edge, points);
                }
                DiagramConstants.setRemoveAttributes(map, new Object[]{"routing", "points"});
                this.setSelectionAttributes(map, edges);
                for (DefaultEdge edge : hm.keySet()) {
                    points = (List)hm.get(edge);
                    this.addPoints(edge, points, true);
                    edge.getCellView().update();
                    if (!this.dpv.showLabels()) continue;
                    ((EdgeView)edge.getCellView()).refreshLabels();
                }
            }
            this.getDiagramLayoutCache().reload();
            this.getDiagramLayoutCache().toBack(edges);
            if (this.dpv != null && this.dpv.getDesignPart() instanceof LogicalDesign) {
                this.dpv.fixBoxInBox();
            }
            this.repaint();
            for (int i = 0; i < edges.length; ++i) {
                DefaultEdge edge = (DefaultEdge)edges[i];
                ((EdgeView)edge.getCellView()).update();
            }
        }
        finally {
            TVConnector.updateSettings = false;
        }
    }

    public List clonePoints(List points) {
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        for (Object sp : points) {
            Point2D oldPoint = sp instanceof PortView ? ((PortView)sp).getPoint() : (Point2D)sp;
            Point2D.Double newPoint = new Point2D.Double(oldPoint.getX(), oldPoint.getY());
            list.add(newPoint);
        }
        return list;
    }

    public Object[] getEdges() {
        ArrayList<Object> result = new ArrayList<Object>();
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            Object obj = cellViews[i].getCell();
            if (!(obj instanceof DefaultEdge)) continue;
            result.add(obj);
        }
        return result.toArray();
    }

    public Object[] getEdgesUnder(Rectangle2D bounds) {
        ArrayList<Object> result = new ArrayList<Object>();
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            Object obj = cellViews[i].getCell();
            if (!(obj instanceof DefaultEdge) && !(obj instanceof FKArcDiagramCell) && !(obj instanceof ArcDiagramCell) || !bounds.intersects(((DefaultDiagramCell)obj).getCellView().getBounds())) continue;
            result.add(obj);
        }
        return result.toArray();
    }

    public void setSelectionAttributes(Map map, Object[] edges) {
        map = new Hashtable(map);
        map.remove("bounds");
        map.remove("points");
        this.editCells(this, edges, map);
    }

    public void editCells(AbstractDiagram diagram, Object[] aobj, Map map) {
        if (diagram != null && map != null && aobj != null && aobj.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            for (int i = 0; i < aobj.length; ++i) {
                hashtable.put(aobj[i], map);
            }
            diagram.getDiagramLayoutCache().edit(hashtable, null, null, null);
        }
    }

    @Override
    protected AbstractCellView createVertexView(AbstractDiagram diagram, CellMapper mapper, Object cell) {
        if (cell instanceof EntityDiagramCell) {
            return new EntityView(cell, diagram, mapper);
        }
        if (cell instanceof EntityViewDiagramCell) {
            return new EntityViewView(cell, diagram, mapper);
        }
        if (cell instanceof TableDiagramCell) {
            return new TableView(cell, diagram, mapper);
        }
        if (cell instanceof TableViewDiagramCell) {
            return new TableViewView(cell, diagram, mapper);
        }
        if (cell instanceof NoteDiagramCell) {
            return new NoteView(cell, diagram, mapper);
        }
        if (cell instanceof ImageDiagramCell) {
            return new ImageView(cell, diagram, mapper);
        }
        if (cell instanceof LegendDiagramCell) {
            return new LegendView(cell, diagram, mapper);
        }
        if (cell instanceof LabelDiagramCell) {
            return new LabelView(cell, diagram, mapper);
        }
        if (cell instanceof ProcessDiagramCell) {
            return new ProcessView(cell, diagram, mapper);
        }
        if (cell instanceof TransformationDiagramCell) {
            return new TransformationView(cell, diagram, mapper);
        }
        if (cell instanceof AgentDiagramCell) {
            return new AgentView(cell, diagram, mapper);
        }
        if (cell instanceof StoreDiagramCell) {
            return new StoreView(cell, diagram, mapper);
        }
        if (cell instanceof InOutParamsDiagramCell) {
            return new InOutParamsView(cell, diagram, mapper);
        }
        if (cell instanceof CubeDiagramCell) {
            return new CubeView(cell, diagram, mapper);
        }
        if (cell instanceof LevelDiagramCell) {
            return new LevelView(cell, diagram, mapper);
        }
        if (cell instanceof DimensionDiagramCell) {
            return new DimensionView(cell, diagram, mapper);
        }
        if (cell instanceof StructuredTypeDiagramCell) {
            return new StructuredTypeView(cell, diagram, mapper);
        }
        if (cell instanceof ArcDiagramCell) {
            return new ArcView(cell, diagram, mapper);
        }
        if (cell instanceof FKArcDiagramCell) {
            return new FKArcView(cell, diagram, mapper);
        }
        if (cell instanceof DiagramViewDiagramCell) {
            return new DiagramViewView(cell, diagram, mapper);
        }
        return new ContainerView(cell, diagram, mapper);
    }

    private void createOverview() {
        this.overview = OverviewPanel.createOverviewPanel(this, this.getScrollPane().getViewport());
    }

    public JPanel getNavigatorPanel() {
        return this.overview;
    }

    public DefaultDiagramCell addEntity(Entity entity, Rectangle bounds) {
        EntityDiagramCell entityCell = new EntityDiagramCell(entity);
        this.addContainer(entityCell, bounds);
        return entityCell;
    }

    public DefaultDiagramCell addArc(Arc arc, Rectangle bounds) {
        ArcDiagramCell arcCell = new ArcDiagramCell(arc);
        this.addContainer(arcCell, bounds);
        this.getDiagramLayoutCache().toBack(new Object[]{arcCell});
        return arcCell;
    }

    public DefaultDiagramCell addFKArc(FKArc arc, Rectangle bounds) {
        FKArcDiagramCell arcCell = new FKArcDiagramCell(arc);
        this.addContainer(arcCell, bounds);
        this.getDiagramLayoutCache().toBack(new Object[]{arcCell});
        return arcCell;
    }

    public DefaultDiagramCell addTable(Table table, Rectangle bounds) {
        TableDiagramCell tableCell = new TableDiagramCell(table);
        this.addContainer(tableCell, bounds);
        return tableCell;
    }

    public DefaultDiagramCell addTableView(oracle.dbtools.crest.model.design.relational.TableView view, Rectangle bounds) {
        TableViewDiagramCell viewCell = new TableViewDiagramCell(view);
        this.addContainer(viewCell, bounds);
        return viewCell;
    }

    public DefaultDiagramCell addEntityView(oracle.dbtools.crest.model.design.logical.EntityView view, Rectangle bounds) {
        EntityViewDiagramCell viewCell = new EntityViewDiagramCell(view);
        this.addContainer(viewCell, bounds);
        return viewCell;
    }

    public DefaultDiagramCell addNote(Note note, Rectangle bounds) {
        NoteDiagramCell noteCell = new NoteDiagramCell(note);
        if (bounds.width == 0) {
            bounds.width = 95;
        }
        if (bounds.height == 0) {
            bounds.height = 40;
        }
        this.addContainer(noteCell, bounds);
        return noteCell;
    }

    public DefaultDiagramCell addImage(ImageObject image, Rectangle bounds) {
        ImageDiagramCell imageCell = new ImageDiagramCell(image);
        if (bounds.width == 0) {
            bounds.width = 80;
        }
        if (bounds.height == 0) {
            bounds.height = 80;
        }
        this.addContainer(imageCell, bounds);
        return imageCell;
    }

    public DefaultDiagramCell addLegend(Legend legend, Rectangle bounds) {
        LegendDiagramCell legendCell = new LegendDiagramCell(legend);
        if (bounds.width == 0) {
            bounds.width = 170;
        }
        if (bounds.height == 0) {
            bounds.height = 110;
        }
        this.addContainer(legendCell, bounds);
        return legendCell;
    }

    public LabelDiagramCell addLabel(Label label, Rectangle bounds) {
        LabelDiagramCell labelCell = new LabelDiagramCell(label);
        if (bounds.width == 0) {
            bounds.width = 95;
        }
        if (bounds.height == 0) {
            bounds.height = 40;
        }
        this.addContainer(labelCell, bounds);
        return labelCell;
    }

    public DefaultDiagramCell addDiagramView(DiagramView diagramView, Rectangle bounds) {
        DiagramViewDiagramCell diagramViewCell = new DiagramViewDiagramCell(diagramView);
        if (bounds.width == 0) {
            bounds.width = 140;
        }
        if (bounds.height == 0) {
            bounds.height = 100;
        }
        this.addContainer(diagramViewCell, bounds);
        return diagramViewCell;
    }

    public DefaultDiagramCell addProcess(Process process, Rectangle bounds) {
        ProcessDiagramCell processCell = new ProcessDiagramCell(process);
        this.addContainer(processCell, bounds);
        return processCell;
    }

    public DefaultDiagramCell addTransformation(Transformation process, Rectangle bounds) {
        TransformationDiagramCell processCell = new TransformationDiagramCell(process);
        this.addContainer(processCell, bounds);
        return processCell;
    }

    public DefaultDiagramCell addAgent(ExternalAgent agent, Rectangle bounds) {
        AgentDiagramCell agentCell = new AgentDiagramCell(agent);
        this.addContainer(agentCell, bounds);
        return agentCell;
    }

    public DefaultDiagramCell addStore(InfoStore store, Rectangle bounds) {
        StoreDiagramCell storeCell = new StoreDiagramCell(store);
        this.addContainer(storeCell, bounds);
        return storeCell;
    }

    public DefaultDiagramCell addInOutParams(InOutParams inOutParams, Rectangle bounds) {
        InOutParamsDiagramCell inoutCell = new InOutParamsDiagramCell(inOutParams);
        this.addContainer(inoutCell, bounds);
        return inoutCell;
    }

    public DefaultDiagramCell addCube(Cube cube, Rectangle bounds) {
        CubeDiagramCell cell = new CubeDiagramCell(cube);
        this.addContainer(cell, bounds);
        return cell;
    }

    public DefaultDiagramCell addLevel(Level level, Rectangle bounds) {
        LevelDiagramCell cell = new LevelDiagramCell(level);
        this.addContainer(cell, bounds);
        return cell;
    }

    public DefaultDiagramCell addDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension, Rectangle bounds) {
        DimensionDiagramCell cell = new DimensionDiagramCell(dimension);
        this.addContainer(cell, bounds);
        return cell;
    }

    public DefaultDiagramCell addStructuredType(StructuredType structuredType, Rectangle bounds) {
        StructuredTypeDiagramCell cell = new StructuredTypeDiagramCell(structuredType);
        this.addContainer(cell, bounds);
        return cell;
    }

    public void addContainer(DefaultDiagramCell cell, Rectangle bounds) {
        if (bounds.width == 0) {
            bounds.width = 170;
        }
        if (bounds.height == 0) {
            bounds.height = 110;
        }
        Hashtable<DefaultDiagramCell, Map> attributes = new Hashtable<DefaultDiagramCell, Map>();
        Map containerAttributes = DiagramConstants.createMap();
        attributes.put(cell, containerAttributes);
        DiagramConstants.setBounds(containerAttributes, bounds);
        DiagramConstants.setOpaque(containerAttributes, true);
        DiagramConstants.setBorderColor(containerAttributes, DEFAULT_BORDER_COLOR);
        Object[] cells = new Object[]{cell};
        this.getModel().insert(cells, attributes, null, null, null);
    }

    public void removeContainer(ContainerObject container) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            ContainerDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof ContainerDiagramCell) || !container.equals((cell = (ContainerDiagramCell)o).getContainer())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void alignDiagram() {
        int y;
        int x;
        AbstractCellView cellView;
        int i;
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        int minLeft = Integer.MAX_VALUE;
        int minTop = Integer.MAX_VALUE;
        for (i = 0; i < cellViews.length; ++i) {
            cellView = (AbstractCellView)cellViews[i];
            if (cellView instanceof EdgeView) continue;
            x = cellView.getBounds().getBounds().x;
            y = cellView.getBounds().getBounds().y;
            minLeft = Math.min(minLeft, x);
            minTop = Math.min(minTop, y);
        }
        for (i = 0; i < cellViews.length; ++i) {
            cellView = (AbstractCellView)cellViews[i];
            if (cellView instanceof EdgeView) continue;
            x = cellView.getBounds().getBounds().x - minLeft + 20;
            y = cellView.getBounds().getBounds().y - minTop + 20;
            int w = cellView.getBounds().getBounds().width;
            int h = cellView.getBounds().getBounds().height;
            cellView.setNewBounds(new Rectangle(x, y, w, h));
        }
    }

    public Rectangle2D getDiagramBounds() {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        if (cellViews != null && cellViews.length > 0) {
            Rectangle2D tmp = cellViews[0].getBounds();
            Rectangle2D.Double ret = tmp != null ? new Rectangle2D.Double(tmp.getX(), tmp.getY(), tmp.getWidth(), tmp.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            for (int i = 1; i < cellViews.length; ++i) {
                Rectangle2D r = cellViews[i].getBounds();
                if (r == null) continue;
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public void selectAll() {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < cellViews.length; ++i) {
            Object cell = cellViews[i].getCell();
            list.add(cell);
        }
        this.setSelectionCells(list.toArray());
    }

    public void removeProcessObject(AbstractProcessObject processObject) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            DFDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof DFDiagramCell) || !processObject.equals((cell = (DFDiagramCell)o).getProcessObject())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void removeMDObject(AbstractMDObject mdObject) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            MDDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof MDDiagramCell) || !mdObject.equals((cell = (MDDiagramCell)o).getMDObject())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void removeDTObject(AbstractDTObject dtObject) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            DTDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof DTDiagramCell) || !dtObject.equals((cell = (DTDiagramCell)o).getDTObject())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void removeArc(Arc arc) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            ArcDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof ArcDiagramCell) || !arc.equals((cell = (ArcDiagramCell)o).getArc())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void removeFKArc(FKArc arc) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            FKArcDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof FKArcDiagramCell) || !arc.equals((cell = (FKArcDiagramCell)o).getArc())) continue;
            Object[] cells = new Object[]{cell};
            this.removeCells(cells);
        }
    }

    public void removeCells(Object[] cells) {
        cells = this.getDescendants(cells);
        this.getModel().remove(cells);
    }

    public void removeNote(Note note) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            NoteDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof NoteDiagramCell) || !note.equals((cell = (NoteDiagramCell)o).getNote())) continue;
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
            break;
        }
    }

    public void removeImage(ImageObject image) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            ImageDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof ImageDiagramCell) || !image.equals((cell = (ImageDiagramCell)o).getImage())) continue;
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
            break;
        }
    }

    public void removeLegend(Legend legend) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            LegendDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof LegendDiagramCell) || !legend.equals((cell = (LegendDiagramCell)o).getLegend())) continue;
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
            break;
        }
    }

    public void removeLabel(Label label) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            LabelDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof LabelDiagramCell) || !label.equals((cell = (LabelDiagramCell)o).getLabel())) continue;
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
            break;
        }
    }

    public void LabelsToFront() {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < cellViews.length; ++i) {
            Object ldc = cellViews[i].getCell();
            if (!(ldc instanceof LabelDiagramCell) || ((LabelDiagramCell)ldc).getTopView() == null) continue;
            try {
                Label l = (Label)((LabelDiagramCell)ldc).getTopView().getModel();
                if (l == null || l.getTVConnector().isCanGoBack()) continue;
                list.add(ldc);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getDiagramLayoutCache().toFront(list.toArray());
    }

    public void removeDiagramView(DiagramView diagramView) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            DiagramViewDiagramCell cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof DiagramViewDiagramCell) || !diagramView.equals((cell = (DiagramViewDiagramCell)o).getDiagramView())) continue;
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
            break;
        }
    }

    public void sendToBack(Object cell) {
        this.getDiagramLayoutCache().toBack(new Object[]{cell});
        Rectangle2D rec = ((DefaultDiagramCell)cell).getCellView().getBounds();
        Object[] edges = this.getEdgesUnder(rec);
        if (edges.length > 0) {
            this.getDiagramLayoutCache().toBack(edges);
        }
    }

    public void removeConnection(DesignObject connection) {
        CellView[] cellViews = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViews.length; ++i) {
            DefaultEdge cell;
            Object o = cellViews[i].getCell();
            if (!(o instanceof DefaultEdge) || (cell = (DefaultEdge)o).getTopView() != null && !connection.equals(cell.getTopView().getModel())) continue;
            if (cell.getTopView() != null) {
                ((TVConnector)cell.getTopView()).clearLabels();
            }
            Object[] cells = new Object[]{cell};
            cells = this.getDescendants(cells);
            this.getModel().remove(cells);
        }
    }

    public DefaultEdge addConnection(DefaultDiagramCell source, DefaultDiagramCell target, Color color) {
        Hashtable<RelationEdge, Map> attributes = new Hashtable<RelationEdge, Map>();
        DefaultEdge edge = source instanceof EntityDiagramCell && target instanceof EntityDiagramCell ? new RelationEdge() : (source instanceof FKDiagramCell && target instanceof FKDiagramCell ? new FKEdge() : (source instanceof DFDiagramCell && target instanceof DFDiagramCell ? new FlowEdge() : (source instanceof MDDiagramCell && target instanceof MDDiagramCell ? new LinkEdge() : new DefaultEdge())));
        Map edgeAttributes = DiagramConstants.createMap();
        attributes.put((RelationEdge)edge, edgeAttributes);
        DiagramConstants.setLineStyle(edgeAttributes, 11);
        if (source instanceof EntityDiagramCell && target instanceof EntityDiagramCell) {
            Entity sourceEntity = (Entity)((EntityDiagramCell)source).getContainer();
            Entity targetEntity = (Entity)((EntityDiagramCell)target).getContainer();
            if (targetEntity.getHierarchicalParent() == sourceEntity) {
                DiagramConstants.setLineBegin(edgeAttributes, 4);
            }
        } else {
            if (edge instanceof FlowEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else if (edge instanceof LinkEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else if (edge instanceof FKEdge) {
                DiagramConstants.setLineBegin(edgeAttributes, 2);
            } else {
                DiagramConstants.setLineEnd(edgeAttributes, 2);
            }
            DiagramConstants.setBeginSize(edgeAttributes, 4);
            DiagramConstants.setBeginFill(edgeAttributes, true);
            if (edge instanceof LinkEdge) {
                if (!(source instanceof DimensionDiagramCell)) {
                    DiagramConstants.setLineBegin(edgeAttributes, 8);
                }
            } else if (edge instanceof FKEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 5);
                DiagramConstants.setBeginSize(edgeAttributes, 8);
                DiagramConstants.setEndSize(edgeAttributes, 4);
            } else {
                DiagramConstants.setLineBegin(edgeAttributes, 5);
            }
            DiagramConstants.setEndFill(edgeAttributes, true);
        }
        DiagramConstants.setDisconnectable(edgeAttributes, false);
        boolean route = false;
        if (this.dpv != null) {
            route = this.dpv.isAutoRoute();
        }
        if (route) {
            DiagramConstants.setRouting(edgeAttributes, DiagramConstants.ROUTING_SIMPLE);
        }
        DiagramConstants.setLineColor(edgeAttributes, color);
        DiagramConstants.setTransferable(edgeAttributes, true);
        DefaultPort sp = new DefaultPort();
        source.add(sp);
        DefaultPort tp = new DefaultPort();
        target.add(tp);
        ConnectionSet cs = new ConnectionSet((Edge)edge, (Port)sp, tp);
        Object[] cells = new Object[]{edge};
        this.getModel().insert(cells, attributes, cs, null, null);
        if (DefaultDiagramModel.canUpdate) {
            this.getDiagramLayoutCache().toBack(cells);
        }
        return edge;
    }

    public DefaultEdge addConnection(DefaultDiagramCell source, DefaultDiagramCell target, Color color, Object object) {
        Hashtable<RelationEdge, Map> attributes = new Hashtable<RelationEdge, Map>();
        DefaultEdge edge = object instanceof Relation ? new RelationEdge() : (object instanceof FKIndexAssociation ? new FKEdge() : (object instanceof TypeSubstitution ? new TypeSubstitutionEdge() : (object instanceof Flow ? new FlowEdge() : (object instanceof Link ? new LinkEdge() : (object instanceof RaggedHLink ? new RaggedHLinkEdge() : (object instanceof DTReference ? new ReferenceEdge() : (object instanceof DTInheritance ? new InheritanceEdge() : new DefaultEdge())))))));
        Map edgeAttributes = DiagramConstants.createMap();
        attributes.put((RelationEdge)edge, edgeAttributes);
        DiagramConstants.setLineStyle(edgeAttributes, 11);
        if (source instanceof EntityDiagramCell && target instanceof EntityDiagramCell) {
            if (edge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineBegin(edgeAttributes, 2);
                DiagramConstants.setEndFill(edgeAttributes, false);
                DiagramConstants.setBeginFill(edgeAttributes, false);
                DiagramConstants.setLineEnd(edgeAttributes, 5);
                DiagramConstants.setBeginSize(edgeAttributes, 8);
                DiagramConstants.setEndSize(edgeAttributes, 4);
            }
        } else if (edge instanceof InheritanceEdge) {
            if (source == target) {
                DiagramConstants.setLineEnd(edgeAttributes, 2);
                DiagramConstants.setBeginSize(edgeAttributes, 10);
            } else {
                DiagramConstants.setLineBegin(edgeAttributes, 2);
                DiagramConstants.setBeginSize(edgeAttributes, 10);
                DiagramConstants.setLineEnd(edgeAttributes, 5);
                DiagramConstants.setEndSize(edgeAttributes, 4);
            }
        } else if (edge instanceof ReferenceEdge) {
            if (source == target) {
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else {
                DiagramConstants.setLineBegin(edgeAttributes, 1);
                DiagramConstants.setLineEnd(edgeAttributes, 9);
                DiagramConstants.setEndSize(edgeAttributes, 10);
            }
        } else {
            if (edge instanceof FlowEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else if (edge instanceof LinkEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else if (edge instanceof RaggedHLinkEdge) {
                float[] dashpattern = new float[]{10.0f, 4.0f, 4.0f, 4.0f};
                DiagramConstants.setDashPattern(edgeAttributes, dashpattern);
                DiagramConstants.setLineEnd(edgeAttributes, 1);
            } else if (edge instanceof FKEdge) {
                DiagramConstants.setLineBegin(edgeAttributes, 2);
            } else if (edge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineBegin(edgeAttributes, 2);
                DiagramConstants.setEndFill(edgeAttributes, false);
                DiagramConstants.setBeginFill(edgeAttributes, false);
            } else {
                DiagramConstants.setLineEnd(edgeAttributes, 2);
            }
            DiagramConstants.setBeginSize(edgeAttributes, 4);
            DiagramConstants.setBeginFill(edgeAttributes, true);
            if (edge instanceof LinkEdge) {
                if (!(source instanceof DimensionDiagramCell)) {
                    DiagramConstants.setLineBegin(edgeAttributes, 8);
                }
            } else if (edge instanceof FKEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 5);
                DiagramConstants.setBeginSize(edgeAttributes, 8);
                DiagramConstants.setEndSize(edgeAttributes, 4);
                if (object instanceof FKIndexAssociation && !((FKIndexAssociation)object).isMandatory()) {
                    DiagramConstants.setDashPattern(edgeAttributes, FKIndexAssociation.dashpattern);
                }
            } else if (edge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineEnd(edgeAttributes, 5);
                DiagramConstants.setBeginSize(edgeAttributes, 8);
                DiagramConstants.setEndSize(edgeAttributes, 4);
            } else {
                DiagramConstants.setLineBegin(edgeAttributes, 5);
            }
            if (!(edge instanceof TypeSubstitutionEdge)) {
                DiagramConstants.setEndFill(edgeAttributes, true);
            } else {
                DiagramConstants.setEndFill(edgeAttributes, false);
                DiagramConstants.setBeginFill(edgeAttributes, false);
            }
        }
        DiagramConstants.setDisconnectable(edgeAttributes, false);
        boolean route = false;
        if (this.dpv != null) {
            route = this.dpv.isAutoRoute();
        }
        if (route) {
            DiagramConstants.setRouting(edgeAttributes, DiagramConstants.ROUTING_SIMPLE);
        }
        DiagramConstants.setLineColor(edgeAttributes, color);
        DiagramConstants.setTransferable(edgeAttributes, true);
        DefaultPort sp = new DefaultPort();
        source.add(sp);
        DefaultPort tp = new DefaultPort();
        target.add(tp);
        ConnectionSet cs = new ConnectionSet((Edge)edge, (Port)sp, tp);
        Object[] cells = new Object[]{edge};
        this.getModel().insert(cells, attributes, cs, null, null);
        if (DefaultDiagramModel.canUpdate) {
            this.getDiagramLayoutCache().toBack(cells);
        }
        return edge;
    }

    public void restoreConnection(DefaultEdge edge, DefaultPort sourcePort, DefaultPort targetPort, Map edgeAttributes) {
        Map attributes = DiagramConstants.createMap();
        attributes.put(edge, edgeAttributes);
        ConnectionSet cs = new ConnectionSet((Edge)edge, (Port)sourcePort, targetPort);
        Object[] cells = new Object[]{edge};
        this.getModel().insert(cells, attributes, cs, null, null);
        this.getDiagramLayoutCache().toBack(cells);
    }

    public void actualSize() {
        this.setScale(1.0);
    }

    public void zoomIn() {
        if (this.getScale() < 8.0) {
            this.setScale(this.getScale() * 1.3);
        }
    }

    public void zoomOut() {
        this.setScale(this.getScale() / 1.3);
    }

    public void fitScreen() {
        Rectangle p;
        Rectangle2D rec2D = this.getCellBounds(this.getRoots());
        if (rec2D != null && (p = rec2D.getBounds()) != null) {
            double s2;
            Dimension s = this.getScrollPane().getViewport().getExtentSize();
            double scale = 1.0;
            double s1 = s.getWidth() / ((double)p.x + p.getWidth());
            scale = s1 < (s2 = s.getHeight() / ((double)p.y + p.getHeight())) ? Math.max(Math.min(s1, 16.0), 0.01) : Math.max(Math.min(s2, 16.0), 0.01);
            this.setScale(scale);
        }
    }

    public JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this);
        }
        return this.scrollPane;
    }

    public AbstractController getController() {
        return null;
    }

    public void addPoints(DefaultEdge edge, List points) {
        this.addPoints(edge, points, false);
    }

    public void addPoints(DefaultEdge edge, List points, boolean addPorts) {
        EdgeView edgeView = (EdgeView)this.getDiagramLayoutCache().getMapping(edge, false);
        Hashtable hashtable = new Hashtable();
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        if (addPorts && this.getDesignPartView().getDesign().getLoadedVersion() >= 2.3f) {
            CellView source = edgeView.getSource();
            CellView target = edgeView.getTarget();
            if (source != null && target != null && source != target) {
                PortView pvs = (PortView)source;
                PortView pvt = (PortView)target;
                if (points.size() > 1) {
                    Object sp = points.get(0);
                    if (sp instanceof PortView) {
                        pvs.setPoint(((PortView)sp).getPoint());
                    } else {
                        pvs.setPoint((Point2D)sp);
                    }
                    Object tp = points.get(points.size() - 1);
                    if (tp instanceof PortView) {
                        pvt.setPoint(((PortView)tp).getPoint());
                    } else {
                        pvt.setPoint((Point2D)tp);
                    }
                }
                newPoints.add(pvs.getPoint());
                for (int i = 1; i < points.size() - 1; ++i) {
                    Point2D routingPoint = (Point2D)points.get(i);
                    newPoints.add(routingPoint);
                }
                newPoints.add(pvt.getPoint());
            } else {
                Point2D start = edgeView.getPoint(0);
                Point2D end = edgeView.getPoint(1);
                newPoints.add(start);
                if (points.size() > 0) {
                    for (int i = 0; i < points.size(); ++i) {
                        Point2D routingPoint = (Point2D)points.get(i);
                        newPoints.add(routingPoint);
                    }
                }
                newPoints.add(end);
            }
        } else {
            Point2D start = edgeView.getPoint(0);
            Point2D end = edgeView.getPoint(1);
            newPoints.add(start);
            if (points.size() > 0) {
                for (int i = 0; i < points.size(); ++i) {
                    Object obj = points.get(i);
                    if (!(obj instanceof Point2D)) continue;
                    newPoints.add((Point2D)obj);
                }
            }
            newPoints.add(end);
        }
        DiagramConstants.setPoints(hashtable, newPoints);
        edge.changeAttributes(hashtable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public int getDrawnObjectID() {
        return this.drawnObjectID;
    }

    public void setDrawnObjectID(int drawnObjectID) {
        this.drawnObjectID = drawnObjectID;
    }

    public void showPopupMenu(Point pt) {
        if (!this.getDesignPartView().getDesign().isHidden()) {
            this.dpv.pt = pt;
            JPopupMenu menu = this.dpv.getPopupMenu();
            menu.show(this, pt.x, pt.y);
        }
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public MDBAction getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(MDBAction currentAction) {
        this.currentAction = currentAction;
    }

    public void setDPVtoNull() {
        this.dpv = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiagramSelectionListener.class || !(listeners[i + 1] instanceof DiagramSelectionListener)) continue;
            this.listenerList.remove(DiagramSelectionListener.class, (DiagramSelectionListener)listeners[i + 1]);
        }
        this.scrollPane = null;
        this.overview = null;
        this.diagramModel = null;
        this.selectionModel = null;
    }

    public void updateNavigator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Diagram.this.firePropertyChange("diagramChanged", false, true);
            }
        });
    }
}

