/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.ImageDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ImageView;

public class ImageRenderer
extends JComponent
implements CellViewRenderer {
    private static final String NO_IMAGE = "NO IMAGE";
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient int borderWidth;
    protected transient Color bordercolor;
    protected transient ImageObject image;
    protected CellView view;

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof ImageView) {
            ImageDiagramCell cell = (ImageDiagramCell)view.getCell();
            this.image = cell.getImage();
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            this.view = view;
            if (cell.getImage().getScaledPicture() == null) {
                cell.getImage().scalePicture(view.getBounds().getBounds());
            }
        }
        this.installAttributes(view);
        return this;
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.image != null) {
            return this.image.getTopView();
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        if (this.image != null) {
            if (this.image.getPicture() != null) {
                g.drawImage(this.image.getScaledPicture(), 0, 0, this);
            } else {
                this.drawEmptyImage(g, width, height);
            }
        } else {
            this.drawEmptyImage(g, width, height);
        }
    }

    private void drawEmptyImage(Graphics g, int width, int height) {
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, width - 1, height - 1);
        FontMetrics fm = g.getFontMetrics();
        int xCursor = (width - fm.stringWidth(NO_IMAGE)) / 2;
        g.drawString(NO_IMAGE, xCursor, height / 2 + 4);
    }

    @Override
    public Color getBGColor() {
        return null;
    }

    @Override
    public Color getFGColor() {
        return null;
    }

    public Point2D getPerimeterPoint(ImageView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }
}

