/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;

public class RelationEdge
extends DefaultEdge {
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem miStraightLine = null;
    private JMenuItem miPaste = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();
    private JCheckBoxMenuItem mTargetAboveLine;
    private JCheckBoxMenuItem mSourceBelowLine;

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        this.point.setLocation(pt);
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                DesignPartView dpv;
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(RelationEdge.this.selectedObjects, RelationEdge.this.getDiagram().getAppView());
                    }
                });
                final List list = this.getConnectors(this.selectedObjects);
                if (list.size() > 0 && this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE_LINES){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RelationEdge.this.hideRelations(list);
                        }
                    });
                }
            } else {
                DesignPartView dpv;
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RelationEdge.this.deleteRelation();
                    }
                });
                if (this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RelationEdge.this.hideRelation();
                        }
                    });
                }
            }
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.access$102(RelationEdge.this, RelationEdge.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < RelationEdge.this.selectedObjects.length; ++i) {
                        try {
                            if (!(RelationEdge.this.selectedObjects[i] instanceof Relation)) continue;
                            ((Relation)RelationEdge.this.selectedObjects[i]).getOwnedEntity().paste();
                            continue;
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.menu.addSeparator();
            this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.straightenLine();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.format();
                }
            });
            this.menu.addSeparator();
            this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.addBreakpoint(RelationEdge.this.point);
                }
            });
            this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.removeBreakpoint(RelationEdge.this.point);
                }
            });
            this.menu.addSeparator();
        }
        boolean haslabel = false;
        TVConnector tv = (TVConnector)this.getTopView();
        Label label = tv.getTargetLabel();
        if (label != null) {
            haslabel = true;
            this.mTargetAboveLine = new JCheckBoxMenuItem(TARGET_LABEL_ABOVE);
            this.menu.add(this.mTargetAboveLine);
            this.mTargetAboveLine.setSelected(label.isTargetAboveTheLine());
            this.mTargetAboveLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TVConnector tv = (TVConnector)RelationEdge.this.getTopView();
                    Label label = tv.getTargetLabel();
                    TVLabel tvl = (TVLabel)label.getFirstViewForDPV(tv.getDesignPartView());
                    if (tvl != null) {
                        TVConnector tc;
                        label.setTargetAboveTheLine(!label.isTargetAboveTheLine());
                        LabelView lv = (LabelView)tvl.getCellView();
                        if (lv != null && (tc = label.getTVConnector()) != null) {
                            try {
                                EdgeView ev = (EdgeView)RelationEdge.this.getCellView();
                                if (ev != null) {
                                    ev.refreshLabels();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            tc.getDesignPartView().setDirty(true);
                        }
                    }
                }
            });
        }
        if ((label = tv.getSourceLabel()) != null) {
            haslabel = true;
            this.mSourceBelowLine = new JCheckBoxMenuItem(SOURCE_LABEL_BELOW);
            this.menu.add(this.mSourceBelowLine);
            this.mSourceBelowLine.setSelected(label.isSourceBelowTheLine());
            this.mSourceBelowLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TVConnector tv = (TVConnector)RelationEdge.this.getTopView();
                    Label label = tv.getSourceLabel();
                    TVLabel tvl = (TVLabel)label.getFirstViewForDPV(tv.getDesignPartView());
                    if (tvl != null) {
                        TVConnector tc;
                        label.setSourceBelowTheLine(!label.isSourceBelowTheLine());
                        LabelView lv = (LabelView)tvl.getCellView();
                        if (lv != null && (tc = label.getTVConnector()) != null) {
                            try {
                                EdgeView ev = (EdgeView)RelationEdge.this.getCellView();
                                if (ev != null) {
                                    ev.refreshLabels();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            tc.getDesignPartView().setDirty(true);
                        }
                    }
                }
            });
        }
        if (haslabel) {
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationEdge.this.showProperty();
            }
        });
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }

    public Relation getRelation() {
        return (Relation)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        if (this.getTopView() != null) {
            return this.getRelation().getName();
        }
        return "";
    }

    public void deleteRelation() {
        Relation relation = this.getRelation();
        TVConnector connector = (TVConnector)this.getTopView();
        if (connector.remove(relation)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("RelationEdge.RemoveRelation"), relation.getName()));
        }
    }

    public String getSourceCardinality() {
        return this.getRelation().getSourceCardinality().toString();
    }

    public String getSourceName() {
        return this.getRelation().getNameOnSource();
    }

    public String getTargetCardinality() {
        return this.getRelation().getTargetCardinality().toString();
    }

    public String getTargetName() {
        return this.getRelation().getNameOnTarget();
    }

    public String getSourceLabel() {
        return this.getSourceName() != null ? this.getSourceName() : "";
    }

    public String getTargetLabel() {
        return this.getTargetName() != null ? this.getTargetName() : "";
    }

    public String getAttributesAsString() {
        Collection collection = this.getRelation().getAttributesCollection();
        if (collection.size() > 0) {
            String result = "";
            int p = 0;
            for (ContainedObjectWithDomain next : collection) {
                if (p > 0) {
                    result = result + "\n";
                }
                ++p;
                String rowText = !next.getNullsAllowed() ? "*" : "o";
                rowText = rowText + " " + next.getName();
                int notation = this.getDiagram().getDesignPartView().getNotation();
                if (notation != 1) {
                    rowText = rowText + "    " + ((Attribute)next).getLogicalRepresentationName();
                }
                result = result + rowText;
            }
            return result;
        }
        return null;
    }

    @Override
    public void deleteSelected() {
        this.deleteRelation();
    }

    static /* synthetic */ Object[] access$102(RelationEdge x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

