/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.process.TVInfoStore;
import oracle.ide.Ide;

public class StoreDiagramCell
extends DFDiagramCell {
    private JPopupMenu menu;

    public StoreDiagramCell(AbstractProcessObject processObject) {
        super(processObject);
    }

    public StoreDiagramCell(AbstractProcessObject processObject, Map attributeMap) {
        super(processObject, attributeMap);
    }

    private void showProperty() {
        this.getProcessObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(COPY){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StoreDiagramCell.this.getProcessObject().getAppView().clearCopiedObjects();
                        StoreDiagramCell.access$002(StoreDiagramCell.this, StoreDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                        for (int i = 0; i < StoreDiagramCell.this.selectedObjects.length; ++i) {
                            if (!(StoreDiagramCell.this.selectedObjects[i] instanceof ExternalAgent) && !(StoreDiagramCell.this.selectedObjects[i] instanceof Process) && !(StoreDiagramCell.this.selectedObjects[i] instanceof InfoStore)) continue;
                            StoreDiagramCell.this.getProcessObject().getAppView().addCopiedObject((DesignObject)StoreDiagramCell.this.selectedObjects[i]);
                        }
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StoreDiagramCell.this.deleteStore();
                    }
                });
                this.menu.add(new AbstractAction(DELETE_FROM_DFD){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StoreDiagramCell.this.deleteStoreFromDFD();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StoreDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StoreDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(DESIGN_RULES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StoreDiagramCell.this.showDesignRulesDialog();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StoreDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteStore() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        if (view.getCurrentDPV().getDesignPart() instanceof DataFlowDesign) {
            DataFlowDesign dfd = (DataFlowDesign)view.getCurrentDPV().getDesignPart();
            Process proc = dfd.getProcess();
            DataFlowDesign pardfd = dfd.getParentDataFlowdesign();
            InfoStore store = (InfoStore)this.getProcessObject();
            if (proc == null || pardfd != null && pardfd.getFirstFlowBetween(proc, store) == null && pardfd.getFirstFlowBetween(store, proc) == null) {
                ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), store.getName()));
                TVInfoStore tv = (TVInfoStore)this.getTopView();
                tv.remove(true);
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("StoreDiagramCell.ConnectedToUpperLevel"), proc.getName()));
            }
        } else {
            InfoStore store = (InfoStore)this.getProcessObject();
            ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), store.getName()));
            TVInfoStore tv = (TVInfoStore)this.getTopView();
            tv.remove();
        }
    }

    public void deleteStoreFromDFD() {
        InfoStore store = (InfoStore)this.getProcessObject();
        ApplicationView.log(MessageFormat.format(Messages.getString("StoreDiagramCell.DeleteInformationStore"), store.getName()));
        TVInfoStore tv = (TVInfoStore)this.getTopView();
        tv.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteStore();
    }

    static /* synthetic */ Object[] access$002(StoreDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

