/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class LogicalTypeDialog
extends JDialog {
    private ApplicationView view;
    private ContainedObjectWithDomain object;
    private JPanel buttonPanel;
    private JPanel general;
    private JButton bnLogicalType;
    private String selectedRdbmsSite;
    private JComboBox cbLogicalType;
    private JTextField tfSize;
    private JIntegerField tfPrecision;
    private JIntegerField tfScale;
    private JComboBox cbUnits;
    protected static final int FIELD_WIDTH = 10;
    private static final String EMPTY_STRING = "";
    private boolean readOnly = false;
    private boolean usePreferredList = false;

    public LogicalTypeDialog(ApplicationView view, ContainedObjectWithDomain object, JButton bnLogicalType, String selectedRdbmsSite, boolean usePreferred) {
        super(view.getFrame());
        this.usePreferredList = usePreferred;
        this.view = view;
        this.object = object;
        this.bnLogicalType = bnLogicalType;
        this.selectedRdbmsSite = selectedRdbmsSite;
        this.setTitle(Messages.getString("LogicalTypeDialog.LogicalType"));
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.initProperties();
        this.getContentPane().add((Component)this.general, "Center");
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = this.getButtonPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        this.general.setPreferredSize(new Dimension(350, 140));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    public LogicalTypeDialog(ApplicationView view, ContainedObjectWithDomain object, String selectedRdbmsSite, boolean usePreferred) {
        super(view.getFrame());
        this.usePreferredList = usePreferred;
        this.view = view;
        this.object = object;
        this.selectedRdbmsSite = selectedRdbmsSite;
        this.readOnly = true;
        this.setTitle(Messages.getString("LogicalTypeDialog.LogicalType"));
        this.general = new JPanel(new SpringLayout());
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.initProperties();
        this.cbLogicalType.setEnabled(false);
        this.tfSize.setEnabled(false);
        this.tfPrecision.setEnabled(false);
        this.tfScale.setEnabled(false);
        this.cbUnits.setEnabled(false);
        this.getContentPane().add((Component)this.general, "Center");
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = this.getButtonPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        this.general.setPreferredSize(new Dimension(340, 140));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        CommonUtil.centerOnScreen(this);
    }

    private void initGeneral() {
        this.initSize();
        this.initLogicalType();
        this.initPrecision();
        this.initScale();
    }

    private void initLogicalType() {
        JLabel label = new JLabel(Messages.getString("LogicalTypeDialog.LogicalTypeL"));
        this.general.add(label);
        this.cbLogicalType = new JComboBox<Object>(this.object.getDesign().getLogicalDatatypeSet().toArray());
        this.general.add(this.cbLogicalType);
        this.cbLogicalType.setBackground(Color.WHITE);
        this.cbLogicalType.setFont(new Font(this.cbLogicalType.getFont().getName(), 0, this.cbLogicalType.getFont().getSize()));
        this.cbLogicalType.setPreferredSize(new Dimension(210, 20));
        this.cbLogicalType.setMaximumRowCount(30);
        this.cbLogicalType.addActionListener(new DatatypeListener());
        this.setLabelConstraints(label, 15);
        this.setObjectConstraints(this.cbLogicalType, 15);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("LogicalTypeDialog.SizeL"));
        this.general.add(label);
        this.tfSize = new JTextField();
        this.tfSize.setColumns(10);
        this.general.add(this.tfSize);
        this.setLabelConstraints(label, 45);
        this.setObjectConstraints(this.tfSize, 45);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        int rdbmsType = this.object.getContainer().getSelectedRDBMSType().getType();
        if (rdbmsType == 7 || rdbmsType == 8 || rdbmsType == 9 || rdbmsType == 11) {
            label = new JLabel(Messages.getString("LogicalTypeDialog.Units"));
            this.general.add(label);
            this.general.add(this.cbUnits);
            this.setObjectConstraints(label, 230, 47);
            this.setObjectConstraints(this.cbUnits, 290, 45);
        }
    }

    private void initPrecision() {
        JLabel label = new JLabel(Messages.getString("LogicalTypeDialog.PrecisionL"));
        this.general.add(label);
        this.tfPrecision = new JIntegerField();
        this.tfPrecision.setAllowAsterisks(true);
        this.tfPrecision.setColumns(10);
        this.general.add(this.tfPrecision);
        this.setLabelConstraints(label, 75);
        this.setObjectConstraints(this.tfPrecision, 75);
    }

    private void initScale() {
        JLabel label = new JLabel(Messages.getString("LogicalTypeDialog.ScaleL"));
        this.general.add(label);
        this.tfScale = new JIntegerField();
        this.tfScale.setColumns(10);
        this.general.add(this.tfScale);
        this.setLabelConstraints(label, 105);
        this.setObjectConstraints(this.tfScale, 105);
    }

    public void initProperties() {
        LogicalDatatype logicalDatatype = this.object.getLogicalDatatype();
        Map m = logicalDatatype.getToPhysical();
        MDDataType datatype = logicalDatatype.createDataType(this.selectedRdbmsSite, m);
        this.cbLogicalType.removeAllItems();
        Iterator it = this.usePreferredList ? this.view.getSettings().getPreferredLogicaltypes().iterator() : this.object.getDesign().getLogicalDatatypeSet().iterator();
        while (it.hasNext()) {
            this.cbLogicalType.addItem(it.next());
        }
        this.cbLogicalType.setSelectedItem(this.object.getLogicalDatatype());
        if (datatype instanceof MDImplicitSized) {
            this.tfSize.setText(EMPTY_STRING);
            this.tfSize.setEnabled(false);
            this.cbUnits.setSelectedIndex(0);
            this.cbUnits.setEnabled(false);
            this.tfPrecision.setText(EMPTY_STRING);
            this.tfPrecision.setEnabled(false);
            this.tfScale.setText(EMPTY_STRING);
            this.tfScale.setEnabled(false);
        } else if (datatype instanceof MDPackedSized) {
            this.tfSize.setText(EMPTY_STRING);
            this.tfSize.setEnabled(false);
            this.cbUnits.setSelectedIndex(0);
            this.cbUnits.setEnabled(false);
            try {
                if (!this.object.getPrecision().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfPrecision.setText(this.object.getPrecision());
                } else if (datatype.getPrecision() != 0) {
                    this.tfPrecision.setText(EMPTY_STRING + datatype.getPrecisionStr());
                }
                datatype.getPrecision();
                this.tfPrecision.setEnabled(true);
            }
            catch (Exception e) {
                this.tfPrecision.setEnabled(false);
            }
            try {
                if (!this.object.getScale().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfScale.setText(this.object.getScale());
                } else if (datatype.getScale() != 0) {
                    this.tfScale.setText(EMPTY_STRING + datatype.getScale());
                }
                datatype.getScale();
                this.tfScale.setEnabled(true);
            }
            catch (Exception e) {
                this.tfScale.setEnabled(false);
            }
        } else {
            try {
                if (!this.object.getSize().equalsIgnoreCase(EMPTY_STRING)) {
                    String size = this.object.getSize();
                    String[] parts_n = size.split(" ");
                    this.tfSize.setText(parts_n[0]);
                    if (parts_n.length == 2) {
                        this.cbUnits.setSelectedItem(parts_n[1]);
                    }
                } else if (!datatype.getSize().equalsIgnoreCase("0")) {
                    String size = datatype.getSize();
                    String[] parts_n = size.split(" ");
                    this.tfSize.setText(parts_n[0]);
                    if (parts_n.length == 2) {
                        this.cbUnits.setSelectedItem(parts_n[1]);
                    }
                }
                datatype.getSize();
                this.tfSize.setEnabled(true);
                this.cbUnits.setEnabled(true);
            }
            catch (Exception e) {
                this.tfSize.setText(EMPTY_STRING);
                this.tfSize.setEnabled(false);
                this.cbUnits.setSelectedIndex(0);
                this.cbUnits.setEnabled(false);
            }
            try {
                if (!this.object.getPrecision().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfPrecision.setText(this.object.getPrecision());
                } else if (datatype.getPrecision() != 0) {
                    this.tfPrecision.setText(EMPTY_STRING + datatype.getPrecision());
                }
                datatype.getPrecision();
                this.tfPrecision.setEnabled(true);
            }
            catch (Exception e) {
                this.tfPrecision.setText(EMPTY_STRING);
                this.tfPrecision.setEnabled(false);
            }
            try {
                if (!this.object.getScale().equalsIgnoreCase(EMPTY_STRING)) {
                    this.tfScale.setText(this.object.getScale());
                } else if (datatype.getScale() != 0) {
                    this.tfScale.setText(EMPTY_STRING + datatype.getScale());
                }
                datatype.getScale();
                this.tfScale.setEnabled(true);
            }
            catch (Exception e) {
                this.tfScale.setText(EMPTY_STRING);
                this.tfScale.setEnabled(false);
            }
        }
    }

    private void setProperties() {
        this.object.setLogicalDatatype((LogicalDatatype)this.cbLogicalType.getSelectedItem());
        if (this.cbUnits.getSelectedIndex() > 0) {
            this.object.setDataTypeParameter("size", this.tfSize.getText() + ' ' + this.cbUnits.getSelectedItem());
        } else {
            this.object.setDataTypeParameter("size", this.tfSize.getText());
        }
        this.object.setDataTypeParameter("precision", this.tfPrecision.getText());
        this.object.setDataTypeParameter("scale", this.tfScale.getText());
        if (this.bnLogicalType != null) {
            StringBuffer logical = new StringBuffer(this.cbLogicalType.getSelectedItem().toString());
            boolean needBracket = false;
            boolean needComma = false;
            if (!this.tfSize.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfSize.getText().equalsIgnoreCase("0") || !this.tfPrecision.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfPrecision.getText().equalsIgnoreCase("0") || !this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfScale.getText().equalsIgnoreCase("0")) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append(" (");
            }
            if (!this.tfSize.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfSize.getText().equalsIgnoreCase("0") && (this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) || this.tfScale.getText().equalsIgnoreCase("0"))) {
                logical.append(this.tfSize.getText());
                needComma = true;
            }
            if (!this.tfPrecision.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfPrecision.getText().equalsIgnoreCase("0")) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(this.tfPrecision.getText());
                needComma = true;
            }
            if (!this.tfScale.getText().equalsIgnoreCase(EMPTY_STRING) && !this.tfScale.getText().equalsIgnoreCase("0")) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(this.tfScale.getText());
            }
            if (needBracket) {
                logical.append(')');
            }
            this.bnLogicalType.setText(logical.toString());
        }
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(125));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                JButton ok = new JButton(Messages.getString("LogicalTypeDialog.OK"));
                ok.setMnemonic(79);
                ok.setCursor(Cursor.getPredefinedCursor(12));
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogicalTypeDialog.this.setProperties();
                        LogicalTypeDialog.this.dispose();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
            }
            String bnTitle = this.readOnly ? Messages.getString("LogicalTypeDialog.Close") : Messages.getString("LogicalTypeDialog.Cancel");
            JButton cancel = new JButton(bnTitle);
            cancel.setMnemonic(67);
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogicalTypeDialog.this.dispose();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING);
            LogicalTypeDialog.this.cbUnits.setSelectedIndex(0);
            LogicalTypeDialog.this.cbUnits.setEnabled(false);
            if (LogicalTypeDialog.this.cbLogicalType.getSelectedItem() != null) {
                LogicalDatatype selected = (LogicalDatatype)LogicalTypeDialog.this.cbLogicalType.getSelectedItem();
                Map m = selected.getToPhysical();
                MDDataType datatype = selected.createDataType(LogicalTypeDialog.this.selectedRdbmsSite, m);
                if (datatype instanceof MDImplicitSized) {
                    LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfSize.setEnabled(false);
                    LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfScale.setEnabled(false);
                } else if (datatype instanceof MDPackedSized) {
                    LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                    LogicalTypeDialog.this.tfSize.setEnabled(false);
                    try {
                        if (datatype.getPrecision() != 0) {
                            LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING + datatype.getPrecisionStr());
                        }
                        LogicalTypeDialog.this.tfPrecision.setEnabled(true);
                    }
                    catch (Exception e) {
                        LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    }
                    try {
                        if (datatype.getScale() != 0) {
                            LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING + datatype.getScale());
                        }
                        LogicalTypeDialog.this.tfScale.setEnabled(true);
                    }
                    catch (Exception e) {
                        LogicalTypeDialog.this.tfScale.setEnabled(false);
                    }
                } else {
                    try {
                        if (datatype.hasSize()) {
                            if (!datatype.getSize().equalsIgnoreCase("0")) {
                                String size = datatype.getSize();
                                String[] parts_n = size.split(" ");
                                LogicalTypeDialog.this.tfSize.setText(parts_n[0]);
                                if (parts_n.length == 2) {
                                    LogicalTypeDialog.this.cbUnits.setSelectedItem(parts_n[1]);
                                }
                            } else {
                                LogicalTypeDialog.this.tfSize.setText(LogicalTypeDialog.EMPTY_STRING);
                            }
                            LogicalTypeDialog.this.tfSize.setEnabled(true);
                            LogicalTypeDialog.this.cbUnits.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfSize.setEnabled(false);
                            LogicalTypeDialog.this.cbUnits.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        LogicalTypeDialog.this.tfSize.setEnabled(false);
                        LogicalTypeDialog.this.cbUnits.setEnabled(false);
                    }
                    try {
                        if (datatype.hasPrecision()) {
                            if (datatype.getPrecision() != 0) {
                                LogicalTypeDialog.this.tfPrecision.setText(LogicalTypeDialog.EMPTY_STRING + datatype.getPrecision());
                            }
                            LogicalTypeDialog.this.tfPrecision.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        LogicalTypeDialog.this.tfPrecision.setEnabled(false);
                    }
                    try {
                        if (datatype.hasScale()) {
                            if (datatype.getScale() != 0) {
                                LogicalTypeDialog.this.tfScale.setText(LogicalTypeDialog.EMPTY_STRING + datatype.getScale());
                            }
                            LogicalTypeDialog.this.tfScale.setEnabled(true);
                        } else {
                            LogicalTypeDialog.this.tfScale.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        LogicalTypeDialog.this.tfScale.setEnabled(false);
                    }
                }
            }
        }
    }
}

