/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectRelationalModelDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private DefaultListModel listModel;
    private JList list;
    private RelationalDesign result = null;
    private JButton bnOK;
    private ApplicationView appView;
    private JComboBox cbDesigns;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectRelationalModelDialog.this.result = null;
            SelectRelationalModelDialog.this.dispose();
        }
    };

    public SelectRelationalModelDialog(ApplicationView appView) {
        super(appView.getFrame(), Messages.getString("SelectRelationalModelDialog.SelectRelationalModel"), true);
        this.appView = appView;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        this.updateRelationalModels();
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setResizable(false);
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init() {
        JPanel jpanel = new JPanel();
        JPanel jpMain = new JPanel(new BorderLayout());
        jpMain.setPreferredSize(new Dimension(280, 230));
        jpMain.add((Component)this.initDesignList(), "North");
        jpMain.add((Component)this.initRMList(), "Center");
        jpanel.add(jpMain);
        return jpanel;
    }

    private JPanel initDesignList() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Messages.getString("SelectRelationalModelDialog.SelectDesign"));
        jpanel.add((Component)label, "North");
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.cbDesigns = new JComboBox<Object>(this.appView.getDesigns().toArray());
        this.cbDesigns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRelationalModelDialog.this.updateRelationalModels();
            }
        });
        jpanel.add((Component)this.cbDesigns, "Center");
        jpanel.add((Component)new JPanel(), "South");
        return jpanel;
    }

    private void updateRelationalModels() {
        this.listModel.clear();
        this.bnOK.setEnabled(false);
        Design design = (Design)this.cbDesigns.getSelectedItem();
        if (design != null) {
            Iterator it = design.getRelationalDesigns().iterator();
            while (it.hasNext()) {
                this.listModel.addElement(it.next());
            }
        }
        this.list.updateUI();
    }

    private JPanel initRMList() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Messages.getString("SelectRelationalModelDialog.SelectRelationalModel1"));
        jpanel.add((Component)label, "North");
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectRelationalModelDialog.this.result = (RelationalDesign)SelectRelationalModelDialog.this.list.getSelectedValue();
                if (e.getClickCount() == 2) {
                    SelectRelationalModelDialog.this.dispose();
                }
                SelectRelationalModelDialog.this.bnOK.setEnabled(SelectRelationalModelDialog.this.result != null);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean adjust = e.getValueIsAdjusting();
                if (!adjust) {
                    JList list = (JList)e.getSource();
                    int selection = list.getSelectedIndex();
                    SelectRelationalModelDialog.this.bnOK.setEnabled(selection >= 0);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        jpanel.add(sp);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("JListDialog.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRelationalModelDialog.this.result = (RelationalDesign)SelectRelationalModelDialog.this.list.getSelectedValue();
                if (SelectRelationalModelDialog.this.result != null) {
                    SelectRelationalModelDialog.this.appView.setCurrentDesign(SelectRelationalModelDialog.this.result.getDesign());
                }
                SelectRelationalModelDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.list.getSelectedValue() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        bottomPanel.add(this.bnOK);
        JButton bnCancel = new JButton(Messages.getString("JListDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRelationalModelDialog.this.result = null;
                SelectRelationalModelDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    public RelationalDesign getResult() {
        return this.result;
    }

    public static RelationalDesign showDialog(ApplicationView appView) {
        SelectRelationalModelDialog dialog = new SelectRelationalModelDialog(appView);
        dialog.setVisible(true);
        return dialog.getResult();
    }
}

