/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;

public abstract class LogicalObjectPropertiesDialog
extends AbstractPropertiesDialog {
    private JPanel pnEngineering;
    protected JTable eTable;
    protected List eList;
    protected ETModel etModel;

    public LogicalObjectPropertiesDialog(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    public LogicalObjectPropertiesDialog(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
    }

    protected JPanel getEngineeringPanel() {
        if (this.pnEngineering == null) {
            this.pnEngineering = this.createPage(PANEL_ENGINEERING_TO);
            this.eList = this.getEngineering();
            this.etModel = new ETModel();
            this.eTable = new JTable(this.etModel);
            this.eTable.setSelectionMode(0);
            TableColumn column = this.eTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(10);
            column = this.eTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(150);
            JScrollPane scrollpane = new JScrollPane(this.eTable);
            this.pnEngineering.add(scrollpane);
        }
        return this.pnEngineering;
    }

    private List getEngineering() {
        ArrayList<EngineerObject> temp = new ArrayList<EngineerObject>();
        Map engineerTo = this.getDesignObject().getEngineerTo();
        Object[] keys = engineerTo.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object engineer = engineerTo.get(key);
            RelationalDesign design = (RelationalDesign)this.getDesignObject().getDesign().getRelationalDesigns().getById((String)key);
            if (design == null) continue;
            Boolean val = "true".equals(engineer.toString());
            EngineerObject eo = new EngineerObject(design, val);
            temp.add(eo);
        }
        Object[] designs = temp.toArray();
        Arrays.sort(designs, new ListComparator());
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < designs.length; ++i) {
            result.add(designs[i]);
        }
        return result;
    }

    protected void setEngineering() {
        this.getDesignObject().clearEngineerTo();
        for (EngineerObject eo : this.eList) {
            this.getDesignObject().setEngineerTo(eo.getDesign().getObjectID(), eo.engineer);
        }
    }

    private class EngineerObject {
        private boolean engineer;
        private RelationalDesign design;

        public EngineerObject(RelationalDesign design, boolean engineer) {
            this.engineer = engineer;
            this.design = design;
        }

        public boolean isEngineer() {
            return this.engineer;
        }

        public void setEngineer(boolean engineer) {
            this.engineer = engineer;
        }

        public RelationalDesign getDesign() {
            return this.design;
        }
    }

    public class ETModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return LogicalObjectPropertiesDialog.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LogicalObjectPropertiesDialog.Engineer");
            }
            if (column == 1) {
                return Messages.getString("LogicalObjectPropertiesDialog.RelationalDesign");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!LogicalObjectPropertiesDialog.this.isEditable()) {
                return false;
            }
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngineerObject eo = (EngineerObject)LogicalObjectPropertiesDialog.this.eList.get(row);
            if (col == 0) {
                return eo.isEngineer();
            }
            if (col == 1) {
                return eo.getDesign().getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            EngineerObject eo = (EngineerObject)LogicalObjectPropertiesDialog.this.eList.get(row);
            if (col == 0) {
                eo.setEngineer((Boolean)aValue);
            }
        }
    }

    private class ListComparator
    implements Comparator {
        private ListComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((EngineerObject)o1).getDesign().getName().compareTo(((EngineerObject)o2).getDesign().getName());
        }
    }
}

