/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;

public class FKColumnsCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -238454750200950513L;
    private JComboBox cbox = (JComboBox)this.getComponent();
    private FKElement[] fkColumns;
    private KeyObject referencedKey;
    private Collection<FKElement> referencingTableColumns;

    public FKColumnsCellEditor() {
        super(new JComboBox());
        this.cbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKElement selectedColumn = (FKElement)FKColumnsCellEditor.this.cbox.getSelectedItem();
                if (selectedColumn != null) {
                    FKColumnsCellEditor.this.onSelectedColumnChanged(selectedColumn);
                }
            }
        });
    }

    public void init(KeyObject referencedKey) {
        this.referencedKey = referencedKey;
        ((JComboBox)this.getComponent()).setSelectedItem(null);
    }

    public void init(FKElement[] fkColumns, KeyObject referencedKey, Collection referencingTableColumns) {
        this.fkColumns = fkColumns;
        this.referencingTableColumns = referencingTableColumns;
        this.init(referencedKey);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        FKElement col = (FKElement)this.referencedKey.getElement(row);
        this.cbox.setModel(new DefaultComboBoxModel<FKElement>(FKUtilities.getCompatibleColumns(this.referencingTableColumns, col)));
        if (this.fkColumns != null && this.fkColumns.length > row) {
            this.cbox.setSelectedItem(this.fkColumns[row]);
        }
        return this.cbox;
    }

    public void onSelectedColumnChanged(FKElement selectedColumn) {
    }
}

