/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.undo.relational.memento.ViewIndexMemento;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.relational.AbstractViewIndexPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ViewIndexColumnsPanel
extends AbstractViewIndexPanel {
    private static final int PREFERRED_HEIGHT = 145;
    private static final int PREFERRED_WIDTH = 145;
    private static final String COLUMNS = Messages.getString("IndexColumnsPanel.Columns");
    private JPanel mainPanel;
    private JButton btnAddColumns;
    private JButton btnRemoveColumns;
    private JButton btnUp;
    private JButton btnDown;
    private JList allColumnsList;
    private JPanel buttonsPanel;
    private JToolBar toolBar;
    private DefaultListModel allColumnsModel;
    private List<FKElement> selectedColumnsList;
    private JPanel pnSelected;
    private JTable selectedColumnsTable;
    private JScrollPane selectedColumnsScrollPane;
    private JScrollPane allColumnsScrollPane;
    private JPanel pnAttributes;
    private Collection<FKElement> viewColumns;

    public ViewIndexColumnsPanel(ViewIndex index, boolean editable, int buttonsSize, boolean showDesc) {
        super(index, editable, buttonsSize, showDesc);
    }

    @Override
    protected void init(Collection<FKElement> viewColumns) {
        this.viewColumns = viewColumns;
        this.allColumnsModel.clear();
        for (FKElement column : viewColumns) {
            if (this.selectedColumnsList.contains(column)) continue;
            this.allColumnsModel.addElement(column);
        }
    }

    @Override
    protected void init(ViewIndex index) {
        if (this.index != index) {
            this.selectedColumnsList.clear();
            if (index != null) {
                this.selectedColumnsList.addAll(index.getElementsCollection());
            }
            this.selectedColumnsTable.updateUI();
        }
        this.index = index;
    }

    public void refresh() {
        if (this.viewColumns != null) {
            this.init(this.viewColumns);
        }
        this.allColumnsList.updateUI();
        this.selectedColumnsTable.updateUI();
    }

    public void removeSelectedColumn(FKElement column) {
        this.selectedColumnsList.remove(column);
        this.selectedColumnsTable.updateUI();
    }

    @Override
    public void init(ViewIndex index, Collection<FKElement> viewColumns) {
        super.init(index, viewColumns);
        this.selectedColumnsList.clear();
        if (index != null) {
            if (index.isPK()) {
                for (ContainedObject column : index.getElements()) {
                    this.selectedColumnsList.add((FKElement)column);
                }
            } else {
                ViewIndexMemento indexMemento = (ViewIndexMemento)index.getIndexMemento();
                TableView indexTable = indexMemento.view;
                if (indexTable != null) {
                    for (ViewIndexMemento.ColWr colWr : indexMemento.columns) {
                        FKElement column = this.findColumnByID(colWr.col_id, viewColumns);
                        if (column == null) continue;
                        this.selectedColumnsList.add(column);
                    }
                }
            }
        }
        this.init(viewColumns);
        this.enableComponents(index != null && this.editable);
        ((SelectedColumnsModel)this.selectedColumnsTable.getModel()).fireTableDataChanged();
    }

    private FKElement findColumnByID(String id, Collection<FKElement> columns) {
        for (FKElement column : columns) {
            if (!column.getObjectID().equals(id)) continue;
            return column;
        }
        return null;
    }

    public List<FKElement> getSelectedColumns() {
        return this.selectedColumnsList;
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setName(COLUMNS);
        this.setBorder(BorderFactory.createTitledBorder(COLUMNS));
        this.selectedColumnsList = new ArrayList<FKElement>();
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.buttonsSize));
        this.btnRemoveColumns = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.buttonsSize));
        this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.buttonsSize));
        this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.buttonsSize));
        this.buttonsPanel = new JPanel();
        this.toolBar = new JToolBar(1);
        this.toolBar.add(this.btnAddColumns);
        this.toolBar.add(this.btnRemoveColumns);
        this.toolBar.add(this.btnUp);
        this.toolBar.add(this.btnDown);
        this.buttonsPanel.add(this.toolBar);
        this.selectedColumnsTable = new JTable(new SelectedColumnsModel(this.showDesc));
        if (!this.isEditable()) {
            this.selectedColumnsTable.setEnabled(false);
        }
        this.selectedColumnsScrollPane = new JScrollPane(this.selectedColumnsTable);
        this.selectedColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnSelected = new JPanel(new BorderLayout());
        this.pnSelected.add(this.selectedColumnsScrollPane);
        this.allColumnsScrollPane = new JScrollPane(this.allColumnsList);
        this.allColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnAttributes = new JPanel(new BorderLayout());
        this.pnAttributes.add(this.allColumnsScrollPane);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.mainPanel.add(this.pnAttributes);
        this.mainPanel.add(this.buttonsPanel);
        this.mainPanel.add(this.pnSelected);
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
        this.allColumnsList.getSelectionModel().addListSelectionListener(new AllColumnsListSelectionListener());
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new SelectedColumnsListSelectionListener());
        this.initColumnsButtons(this.mainPanel);
        this.initSelectedColumnsList(this.mainPanel);
    }

    private void enableComponents(boolean enabled) {
        this.allColumnsList.setEnabled(enabled);
        this.selectedColumnsTable.setEnabled(enabled);
    }

    private void initSelectedColumnsList(JPanel jpanel) {
        TableColumn col0 = this.selectedColumnsTable.getColumnModel().getColumn(0);
        col0.setWidth(220);
        if (this.showDesc) {
            TableColumn col1 = this.selectedColumnsTable.getColumnModel().getColumn(1);
            col1.setWidth(40);
            col1.setMaxWidth(40);
            col1.setCellRenderer(new ColumnOrderRenderer());
        }
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ViewIndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    ViewIndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        });
    }

    private void initColumnsButtons(JPanel jpanel) {
        this.toolBar.setFloatable(false);
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Add"));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("IndexPropertiesDialogEx.Remove"));
        this.btnUp.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown.setToolTipText(Messages.getString("IndexPropertiesDialogEx.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
    }

    public void onAddColumn(FKElement column) {
    }

    public void onRemoveColumn(FKElement column) {
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.selectedColumnsList.contains(object) && this.selectedColumnsList.size() > index && index >= 0) {
            this.selectedColumnsList.remove(object);
            this.selectedColumnsList.add(index, (FKElement)object);
            return true;
        }
        return false;
    }

    public void clearSelectedColumns() {
        if (this.selectedColumnsList != null) {
            this.selectedColumnsList.clear();
            this.selectedColumnsTable.updateUI();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < ViewIndexColumnsPanel.this.selectedColumnsList.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = ViewIndexColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    ViewIndexColumnsPanel.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                ViewIndexColumnsPanel.this.selectedColumnsTable.updateUI();
                ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber + 1, objectNumber + 1);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = ViewIndexColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    ViewIndexColumnsPanel.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                ViewIndexColumnsPanel.this.selectedColumnsTable.updateUI();
                ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber - 1, objectNumber - 1);
            }
        }
    }

    private class ColumnOrderRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private ColumnOrderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class SelectedColumnsModel
    extends AbstractTableModel {
        private String[] COL_NAMES = new String[]{Messages.getString("IndexColumnsPanel.Column"), Messages.getString("IndexColumnsPanel.Desc")};
        private boolean showDesc;

        public SelectedColumnsModel(boolean showDesc) {
            this.showDesc = showDesc;
        }

        @Override
        public int getColumnCount() {
            return this.showDesc ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return ViewIndexColumnsPanel.this.selectedColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FKElement column = (FKElement)ViewIndexColumnsPanel.this.selectedColumnsList.get(row);
            if (value instanceof Boolean) {
                ViewIndexColumnsPanel.this.index.setColumnSortOrder(column, (Boolean)value != false ? "DESC" : "ASC");
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            FKElement column = (FKElement)ViewIndexColumnsPanel.this.selectedColumnsList.get(row);
            if (col == 0) {
                return column.getName();
            }
            if (col == 1) {
                return new Boolean("DESC".equals(ViewIndexColumnsPanel.this.index.getColumnSortOrder(column)));
            }
            return "";
        }
    }

    private class SelectedColumnsListSelectionListener
    implements ListSelectionListener {
        private SelectedColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ViewIndexColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ViewIndexColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                    ViewIndexColumnsPanel.this.btnUp.setEnabled(false);
                    ViewIndexColumnsPanel.this.btnDown.setEnabled(false);
                } else {
                    ViewIndexColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                    ViewIndexColumnsPanel.this.btnUp.setEnabled(true);
                    ViewIndexColumnsPanel.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionListener
    implements ListSelectionListener {
        private AllColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ViewIndexColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (ViewIndexColumnsPanel.this.allColumnsList.getSelectedIndex() == -1) {
                    ViewIndexColumnsPanel.this.btnAddColumns.setEnabled(false);
                } else {
                    ViewIndexColumnsPanel.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] selected = ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            for (i = 0; i < selected.length; ++i) {
                FKElement column = (FKElement)ViewIndexColumnsPanel.this.selectedColumnsList.get(selected[i]);
                if (ViewIndexColumnsPanel.this.allColumnsModel.contains(column)) continue;
                ViewIndexColumnsPanel.this.allColumnsModel.addElement(column);
                ViewIndexColumnsPanel.this.allColumnsList.setSelectedValue(column, true);
            }
            for (i = selected.length - 1; i >= 0; --i) {
                ViewIndexColumnsPanel.this.onRemoveColumn((FKElement)ViewIndexColumnsPanel.this.selectedColumnsList.remove(selected[i]));
            }
            ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().clearSelection();
            ((SelectedColumnsModel)ViewIndexColumnsPanel.this.selectedColumnsTable.getModel()).fireTableDataChanged();
        }
    }

    public class AddColumnsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewIndexColumnsPanel.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = ViewIndexColumnsPanel.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    FKElement column = (FKElement)selectedObjects[i];
                    if (ViewIndexColumnsPanel.this.selectedColumnsList.contains(column)) continue;
                    ViewIndexColumnsPanel.this.selectedColumnsList.add(column);
                    ViewIndexColumnsPanel.this.allColumnsModel.removeElement(column);
                    ViewIndexColumnsPanel.this.onAddColumn(column);
                }
            }
            ViewIndexColumnsPanel.this.allColumnsList.getSelectionModel().clearSelection();
            ((SelectedColumnsModel)ViewIndexColumnsPanel.this.selectedColumnsTable.getModel()).fireTableDataChanged();
            ViewIndexColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(ViewIndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1, ViewIndexColumnsPanel.this.selectedColumnsTable.getRowCount() - 1);
        }
    }
}

