/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class AbstractPropertyDialog
extends JDialog
implements AbstractEditorConstants {
    protected static final String ADD_CAPTION = Messages.getString("AbstractPropertyDialog.Add");
    protected static final String REMOVE_CAPTION = Messages.getString("AbstractPropertyDialog.Remove");
    private static final Logger LOGGER = new Logger(AbstractPropertyDialog.class);
    private ApplicationView appView;
    protected JTabbedPane tpane;
    protected JPanel general;
    protected JPanel comments;
    protected JPanel notes;
    protected JLabel lbName;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected JTextArea taCommentsInRDBMS;
    protected JTextArea taNotes;
    protected JScrollPane spComments;
    protected JScrollPane spCommentsInRDBMS;
    public static final String YES = Messages.getString("AbstractPropertyDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertyDialog.NO");
    public static final String NONE = Messages.getString("AbstractPropertyDialog.NONE");
    public static final String[] YES_NO = new String[]{YES, NO};
    public static final String[] EMPTY_YES_NO = new String[]{"", YES, NO};
    public static final String[] NONE_YES_NO = new String[]{NONE, YES, NO};
    protected static final int FIELD_WIDTH = 26;
    protected static final int RIGHT_MARGIN_WIDTH = 15;
    private int dialogWidth = this.getDialogWidth();
    protected StorageDesign storageDesign;
    protected StorageObject storageObject;
    protected String oldObjectStatus;
    private JButton bnCancel;
    protected GUIConfiguration guiConfiguration = GUIConfiguration.getInstance();
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPropertyDialog.this.bnCancel.doClick();
        }
    };

    public AbstractPropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.storageObject = object;
        this.oldObjectStatus = view.getXMLTransformationManager().getFilteredXMLString(object);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractPropertyDialog.this.onCancel();
                AbstractPropertyDialog.this.storageObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractPropertyDialog.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.appView = view;
        this.storageDesign = storageDesign;
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tpane = new JTabbedPane();
        this.general = new JPanel(new SpringLayout());
        this.initGeneralView();
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.General"), this.general);
        this.addTabs();
        this.comments = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Comments"), this.comments);
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.tpane, "Center");
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            JButton bnOK = new JButton(Messages.getString("AbstractPropertyDialog.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(Messages.getString("AbstractPropertyDialog.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("AbstractPropertyDialog.Cancel") : Messages.getString("AbstractPropertyDialog.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(jpanel);
    }

    protected int getDialogWidth() {
        return 450;
    }

    public static void equalizeButtonSizes(JButton button1, JButton button2) {
        Dimension dimension1 = button1.getPreferredSize();
        Dimension dimension2 = button2.getPreferredSize();
        if (dimension1.getWidth() < dimension2.getWidth()) {
            button1.setPreferredSize(dimension2);
        } else {
            button2.setPreferredSize(dimension1);
        }
    }

    public String getCaption() {
        return Messages.getString("AbstractPropertyDialog.Properties");
    }

    public abstract void initProperties();

    protected abstract void setProperties();

    protected void addTabs() {
    }

    protected boolean canExit() {
        String newName = this.tfName.getText().trim();
        if ("".equalsIgnoreCase(newName)) {
            MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertyDialog.NameCanNotBeEmpty"));
            this.tfName.requestFocus();
            return false;
        }
        if (this.storageObject.isTopLevelObject() && !this.allowName(newName)) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("AbstractPropertyDialog.NameNotUnique"), newName));
            this.tfName.requestFocus();
            return false;
        }
        return true;
    }

    protected boolean allowName(String newName) {
        return this.storageObject.allowName(newName, true);
    }

    protected void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    protected void initGeneralView() {
        this.lbName = new JLabel(Messages.getString("AbstractPropertyDialog.Name"));
        this.general.add(this.lbName);
        this.tfName = new JTextField("", 26);
        this.general.add(this.tfName);
        this.setLabelConstraints(this.lbName, 20);
        this.setObjectConstraints(this.tfName, 20);
    }

    protected void initCommentsView() {
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        Dimension paneDimension = this.getPane().getPreferredSize();
        this.spComments.setPreferredSize(new Dimension(paneDimension.width - 20, paneDimension.height - 45));
        this.spComments.setBorder(BorderFactory.createEtchedBorder(0));
        this.taComments.setLineWrap(true);
        this.comments.add(this.spComments);
        this.setObjectConstraints(this.getCommentsLayout(), this.spComments, 10, 12);
    }

    protected void initNotesView() {
        this.notes = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Notes"), this.notes);
        this.taNotes = new JTextArea();
        JScrollPane spNotes = new JScrollPane(this.taNotes);
        Dimension paneDimension = this.getPane().getPreferredSize();
        spNotes.setPreferredSize(new Dimension(paneDimension.width - 20, paneDimension.height - 45));
        spNotes.setBorder(BorderFactory.createEtchedBorder(0));
        this.taNotes.setLineWrap(true);
        this.notes.add(spNotes);
        this.setObjectConstraints((SpringLayout)this.notes.getLayout(), spNotes, 10, 12);
    }

    protected void initNotesView(int height) {
        this.notes = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("AbstractPropertyDialog.Notes"), this.notes);
        this.taNotes = new JTextArea();
        JScrollPane spNotes = new JScrollPane(this.taNotes);
        Dimension paneDimension = this.getPane().getPreferredSize();
        spNotes.setPreferredSize(new Dimension(paneDimension.width - 25, height));
        spNotes.setBorder(BorderFactory.createEtchedBorder(0));
        this.taNotes.setLineWrap(true);
        this.notes.add(spNotes);
        this.setObjectConstraints((SpringLayout)this.notes.getLayout(), spNotes, 10, 12);
    }

    protected void initCommentsView(int height) {
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        Dimension paneDimension = this.getPane().getPreferredSize();
        this.spComments.setPreferredSize(new Dimension(paneDimension.width - 25, height));
        this.spComments.setBorder(BorderFactory.createEtchedBorder(0));
        this.taComments.setLineWrap(true);
        this.comments.add(this.spComments);
        this.setObjectConstraints(this.getCommentsLayout(), this.spComments, 10, 12);
    }

    protected void initCommentsInRDBMS(int y) {
        JLabel label = new JLabel(Messages.getString("AbstractPropertyDialog.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, y + 15);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        Dimension paneDimension = this.getPane().getPreferredSize();
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(paneDimension.width - 25, y));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, y + 35);
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected SpringLayout getCommentsLayout() {
        return (SpringLayout)this.comments.getLayout();
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setLabelConstraints(SpringLayout layout, JLabel label, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setConstraint("East", Spring.constant(this.dialogWidth - 15));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setConstraint("East", Spring.constant(this.dialogWidth - 15));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(SpringLayout layout, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = layout.getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    public JTabbedPane getPane() {
        return this.tpane;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public JTextArea getCommentsList() {
        return this.taComments;
    }

    public JTextArea getNotesList() {
        return this.taNotes;
    }

    public JTextArea getCommentsInRDBMSList() {
        return this.taCommentsInRDBMS;
    }

    public void fillComboItems(Object[] items, JComboBox comboBox) {
        comboBox.addItem(null);
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    public void fillComboItems(Object[] items, JComboBox comboBox, Object exclude) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (object.equals(exclude)) continue;
            comboBox.addItem(items[i]);
        }
    }

    public void fillComboItems(Object[] items, JComboBox comboBox, ArrayList exclude) {
        for (int i = 0; i < items.length; ++i) {
            Object object = items[i];
            if (exclude.contains(object)) continue;
            comboBox.addItem(items[i]);
        }
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public void selectObject(JComboBox combo, StorageObject storageObject) {
        combo.setSelectedItem(storageObject);
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    protected void setHeight(int height) {
        this.getPane().setPreferredSize(new Dimension(this.dialogWidth, height));
    }

    protected void setPreferredSize(int width, int height) {
        this.getPane().setPreferredSize(new Dimension(width, height));
    }

    public StorageObject getStorageObject() {
        return this.storageObject;
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.storageObject.showModal || this.storageObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
        }
        super.show();
        this.storageObject.setDialogVisible(true, this);
    }

    private void disableControls(Container container) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c instanceof JTable || c instanceof JButton || c instanceof JList) continue;
            if (!(c instanceof JTabbedPane) && !(c instanceof JLabel)) {
                c.setEnabled(false);
            }
            if (!(c instanceof Container)) continue;
            this.disableControls((Container)c);
        }
    }

    protected void clearOnDispose() {
    }

    protected void onCancel() {
        if (this.storageObject.showForFirstTime()) {
            this.storageObject.remove();
        }
    }

    protected void postProcessingInApply() {
    }

    protected boolean isEditable() {
        if (this.getStorageObject().isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected boolean notEquals(Integer value, JIntegerField integerField) {
        int integerFieldValue = integerField.getIntValue();
        return value == null && integerFieldValue > 0 || value != null && value != integerFieldValue;
    }

    protected boolean notEquals(String value, JTextField textField) {
        String text = textField.getText();
        return StringUtilities.isNotEmpty(value) && !StringUtilities.isNotEmpty(text) || !StringUtilities.isNotEmpty(value) && StringUtilities.isNotEmpty(text) || value != null && !value.equals(text);
    }

    protected boolean notEquals(boolean value, JComboBox comboBox, Object valueWhenTrue, Object valueWhenFalse) {
        Object comboBoxValue = comboBox.getSelectedItem();
        return value && valueWhenFalse.equals(comboBoxValue) || !value && valueWhenTrue.equals(comboBoxValue);
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public static String translateYesNoForDisplay(String internalValue) {
        if ("YES".equals(internalValue)) {
            return YES;
        }
        if ("NO".equals(internalValue)) {
            return NO;
        }
        return internalValue;
    }

    public static String translateYesNoForStorage(String displayValue) {
        if (YES.equals(displayValue)) {
            return "YES";
        }
        if (NO.equals(displayValue)) {
            return "NO";
        }
        return displayValue;
    }

    public static String translateNoneYesNoForDisplay(String internalValue) {
        if ("NONE".equals(internalValue)) {
            return NONE;
        }
        return AbstractPropertyDialog.translateYesNoForDisplay(internalValue);
    }

    public static String translateNoneYesNoForStorage(String displayValue) {
        if (NONE.equals(displayValue)) {
            return "NONE";
        }
        return AbstractPropertyDialog.translateYesNoForStorage(displayValue);
    }

    public static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1 && irow < table.getRowCount()) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPropertyDialog.this.clearOnDispose();
            AbstractPropertyDialog.this.onCancel();
            AbstractPropertyDialog.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AbstractPropertyDialog.this.canExit()) {
                    AbstractPropertyDialog.this.setProperties();
                    AbstractPropertyDialog.this.postProcessingInApply();
                    String status = AbstractPropertyDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractPropertyDialog.this.storageObject);
                    if (AbstractPropertyDialog.this.oldObjectStatus != null) {
                        if (!AbstractPropertyDialog.this.oldObjectStatus.equals(status)) {
                            AbstractPropertyDialog.this.storageObject.setDirty(true);
                            AbstractPropertyDialog.this.oldObjectStatus = status;
                        }
                    } else {
                        AbstractPropertyDialog.this.storageObject.setDirty(true);
                    }
                    AbstractPropertyDialog.this.storageObject.setShowForFirstTime(false);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(AbstractPropertyDialog.this.getCaption()).append(" - ").append(AbstractPropertyDialog.this.tfName.getText());
                    AbstractPropertyDialog.this.setTitle(buffer.toString());
                }
            }
            catch (Exception exc) {
                LOGGER.error("Apply properties failed", exc);
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (AbstractPropertyDialog.this.canExit()) {
                    AbstractPropertyDialog.this.setProperties();
                    String status = AbstractPropertyDialog.this.appView.getXMLTransformationManager().getFilteredXMLString(AbstractPropertyDialog.this.storageObject);
                    if (AbstractPropertyDialog.this.oldObjectStatus != null) {
                        if (!AbstractPropertyDialog.this.oldObjectStatus.equals(status)) {
                            AbstractPropertyDialog.this.storageObject.setDirty(true);
                            AbstractPropertyDialog.this.oldObjectStatus = status;
                        }
                    } else {
                        AbstractPropertyDialog.this.storageObject.setDirty(true);
                    }
                    AbstractPropertyDialog.this.storageObject.setShowForFirstTime(false);
                    AbstractPropertyDialog.this.clearOnDispose();
                    AbstractPropertyDialog.this.close();
                }
            }
            catch (Exception exc) {
                LOGGER.error("Set properties failed", exc);
            }
        }
    }
}

