/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AliasPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private JComboBox cbOwner;
    private JComboBox cbView;
    private JComboBox cbTable;
    private JComboBox cbAnotherAlias;
    private AliasDB2 alias;

    public AliasPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.alias = (AliasDB2)object;
        this.setHeight(200);
        this.initCommentsView(65);
        this.initCommentsInRDBMS(65);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AliasPropertyDialogDB2.AliasProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.alias.getName());
        this.tfName.setText(this.alias.getName());
        this.selectObject(this.cbOwner, this.alias.getOwner());
        this.selectObject(this.cbView, this.alias.getView());
        this.selectObject(this.cbTable, this.alias.getTable());
        this.cbAnotherAlias.removeItem(this.alias);
        this.selectObject(this.cbAnotherAlias, this.alias.getAnotherAlias());
        this.getCommentsList().insert(this.alias.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.alias.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.alias != null) {
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof Owner) {
                this.alias.setOwner((Owner)selected);
            } else {
                this.alias.setOwner(null);
            }
            this.alias.setName(this.tfName.getText());
            selected = this.cbView.getSelectedItem();
            if (selected instanceof StorageObject) {
                this.alias.setView((TableViewProxyDB2)selected);
            } else {
                selected = this.cbTable.getSelectedItem();
                if (selected instanceof StorageObject) {
                    this.alias.setTable((TableProxyDB2)selected);
                } else {
                    selected = this.cbAnotherAlias.getSelectedItem();
                    if (selected instanceof StorageObject) {
                        this.alias.setAnotherAlias((AliasDB2)selected);
                    }
                }
            }
            this.alias.setComment(this.getCommentsList().getText());
            this.alias.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initView();
        this.initTable();
        this.initAnotherAlias();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("AliasPropertyDialogDB2.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initView() {
        JLabel lbView = new JLabel(Messages.getString("AliasPropertyDialogDB2.View"));
        this.general.add(lbView);
        this.cbView = new JComboBox();
        this.setBG(this.cbView);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableViewProxySet().toArray(), this.cbView);
        }
        this.cbView.setPreferredSize(this.tfName.getPreferredSize());
        this.cbView.addActionListener(new ComboListener());
        this.general.add(this.cbView);
        this.setLabelConstraints(lbView, 80);
        this.setObjectConstraints(this.cbView, 80);
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("AliasPropertyDialogDB2.Table"));
        this.general.add(label);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTable.addActionListener(new ComboListener());
        this.general.add(this.cbTable);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTable, 110);
    }

    private void initAnotherAlias() {
        JLabel label = new JLabel(Messages.getString("AliasPropertyDialogDB2.AnotherAlias"));
        this.general.add(label);
        this.cbAnotherAlias = new JComboBox();
        this.setBG(this.cbAnotherAlias);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getAliasSet().toArray(), this.cbAnotherAlias);
        }
        this.cbAnotherAlias.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAnotherAlias.addActionListener(new ComboListener());
        this.general.add(this.cbAnotherAlias);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbAnotherAlias, 140);
    }

    @Override
    protected boolean allowName(String newName) {
        Owner owner;
        Object selectedOwner = this.cbOwner.getSelectedItem();
        if (selectedOwner instanceof Owner && !(owner = (Owner)selectedOwner).isNullInstance()) {
            newName = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + newName : owner.getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object selected = cb.getSelectedItem();
            if (selected instanceof StorageObject) {
                if (AliasPropertyDialogDB2.this.cbView.equals(cb)) {
                    AliasPropertyDialogDB2.this.cbTable.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogDB2.this.cbTable.equals(cb)) {
                    AliasPropertyDialogDB2.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogDB2.this.cbAnotherAlias.equals(cb)) {
                    AliasPropertyDialogDB2.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogDB2.this.cbTable.setSelectedIndex(0);
                }
            }
        }
    }
}

