/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.SequenceDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SequencePropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    protected SequenceDB2 sequence;
    protected JComboBox cbOwner;
    protected JComboBox cbCycle;
    protected JComboBox cbOrder;
    protected JIntegerField ifStartWith;
    protected JIntegerField ifIncrementBy;
    protected JIntegerField ifMinValue;
    protected JIntegerField ifMaxValue;
    protected JTextField ifCache;
    protected JTextField tfDataType;
    private static final int SEQ_VALUE_MAX_DIGITS_DB2 = 19;

    public SequencePropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.sequence = (SequenceDB2v80)object;
        this.setHeight(385);
        this.initCommentsView(140);
        this.initCommentsInRDBMS(140);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SequencePropertyDialogDB2v80.SequenceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initDataType();
        this.initStartWith();
        this.initIncrementBy();
        this.initMinValue();
        this.initMaxValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    protected void initDataType() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.setBG(this.tfDataType);
        this.tfDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfDataType, 80);
    }

    protected void initStartWith() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.StartWith"));
        this.general.add(label);
        this.ifStartWith = new JIntegerField(0, 26);
        this.general.add(this.ifStartWith);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifStartWith, 110);
    }

    protected void initIncrementBy() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.IncrementBy"));
        this.general.add(label);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.general.add(this.ifIncrementBy);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifIncrementBy, 140);
    }

    protected void initMinValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.MinValue"));
        this.general.add(label);
        this.ifMinValue = new JIntegerField();
        this.ifMinValue.setColumns(26);
        this.ifMinValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMinValue);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifMinValue, 170);
    }

    protected void initMaxValue() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.MaxValue"));
        this.general.add(label);
        this.ifMaxValue = new JIntegerField();
        this.ifMaxValue.setColumns(26);
        this.ifMaxValue.setLargeIntegerDocument(19);
        this.general.add(this.ifMaxValue);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifMaxValue, 200);
    }

    protected void initCycle() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.Cycle"));
        this.general.add(label);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCycle);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbCycle, 230);
    }

    protected void initCache() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.Cache"));
        this.general.add(label);
        this.ifCache = new JTextField("", 26);
        this.general.add(this.ifCache);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifCache, 260);
    }

    protected void initOrder() {
        JLabel label = new JLabel(Messages.getString("SequencePropertyDialogDB2v80.Order"));
        this.general.add(label);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOrder);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbOrder, 290);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.sequence.getName());
        this.tfName.setText(this.sequence.getName());
        this.cbOwner.setSelectedItem(this.sequence.getOwner());
        this.tfDataType.setText(this.sequence.getDatatype());
        this.ifStartWith.setValue((long)this.sequence.getStartWith());
        this.ifIncrementBy.setValue((long)this.sequence.getIncrementBy());
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMinValue())) {
                double d = Double.parseDouble(this.sequence.getMinValue());
            }
            this.ifMinValue.setText(this.sequence.getMinValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMinValue.setText("");
        }
        try {
            if (!"NO".equalsIgnoreCase(this.sequence.getMaxValue())) {
                double nfe = Double.parseDouble(this.sequence.getMaxValue());
            }
            this.ifMaxValue.setText(this.sequence.getMaxValue());
        }
        catch (NumberFormatException nfe) {
            this.ifMaxValue.setText("");
        }
        this.cbCycle.setSelectedItem(SequencePropertyDialogDB2v80.translateYesNoForDisplay(this.sequence.getCycle()));
        if (this.sequence.getCache() == 0) {
            this.ifCache.setText(NO);
        } else {
            this.ifCache.setText(Integer.toString(this.sequence.getCache()));
        }
        this.cbOrder.setSelectedItem(SequencePropertyDialogDB2v80.translateYesNoForDisplay(this.sequence.getOrder()));
        this.getCommentsList().insert(this.sequence.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.sequence.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.sequence != null) {
            this.sequence.setOwner((Owner)this.cbOwner.getSelectedItem());
            this.sequence.setName(this.tfName.getText());
            this.sequence.setDatatype(this.tfDataType.getText());
            this.sequence.setStartWith(this.ifStartWith.getIntValue());
            this.sequence.setIncrementBy(this.ifIncrementBy.getIntValue());
            try {
                if (!"NO".equalsIgnoreCase(this.ifMinValue.getText())) {
                    double d = Double.parseDouble(this.ifMinValue.getText());
                }
                this.sequence.setMinValue(this.ifMinValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMinValue("");
            }
            try {
                if (!"NO".equalsIgnoreCase(this.ifMaxValue.getText())) {
                    double nfe = Double.parseDouble(this.ifMaxValue.getText());
                }
                this.sequence.setMaxValue(this.ifMaxValue.getText());
            }
            catch (NumberFormatException nfe) {
                this.sequence.setMaxValue("");
            }
            this.sequence.setCycle(SequencePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
            this.sequence.setOrder(SequencePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
            String cache = this.ifCache.getText();
            if (cache.equalsIgnoreCase(NO)) {
                this.sequence.setCache(0);
            } else {
                try {
                    this.sequence.setCache(Integer.parseInt(cache));
                }
                catch (NumberFormatException e) {
                    this.sequence.setCache(0);
                }
            }
            this.sequence.setComment(this.getCommentsList().getText());
            this.sequence.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("SequencePropertyDialogDB2v80.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(((StorageDesignDB2v80)SequencePropertyDialogDB2v80.this.getStorageDesign()).getSequenceSet().getElementsList());
                list.remove(SequencePropertyDialogDB2v80.this.sequence);
                new PropertiesPropagationDialog(SequencePropertyDialogDB2v80.this.getAppView(), SequencePropertyDialogDB2v80.this.sequence, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 325);
    }

    @Override
    protected boolean allowName(String newName) {
        Owner owner;
        Object selectedOwner = this.cbOwner.getSelectedItem();
        if (selectedOwner instanceof Owner && !(owner = (Owner)selectedOwner).isNullInstance()) {
            newName = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + '.' + newName : owner.getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }
}

