/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SupplementalLogGroup;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ClusterOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.PartitionPropertyTabOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.TablePropertyDialogOraclev11g;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    protected TableProxyOraclev10g table;
    protected PartitionPropertyTabOraclev10g partitionPropertyTab;
    private static final String YES_PRESERVE = Messages.getString("TablePropertyDialogOracle.YES_PRESERVE_ROWS");
    private static final String YES_DELETE = Messages.getString("TablePropertyDialogOracle.YES_DELETE_ROWS");
    private static final String[] NO_PRESERVE_DELETE = new String[]{NO, YES_PRESERVE, YES_DELETE};
    private JComboBox cbUser;
    private JComboBox cbTemporary;
    private JLabel lbTableSpace;
    private JLabel lbTemporaryTablespace;
    private JComboBox cbTableSpace;
    private JComboBox cbTemporaryTablespace;
    private JComboBox cbOrganization;
    private JComboBox cbCluster;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbCache;
    private JComboBox cbParallel;
    private JPositiveIntegerField ifDegree;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbPartRowMovement;
    protected JComboBox cbDataSegmentCompression;
    private JTextField tfBasedOnStructuredType;
    private JComboBox cbSnapshot;
    private JPositiveIntegerField ifIotCompress;
    private JPositiveIntegerField ifIotPctThreshold;
    private JComboBox cbIotIncluding;
    private JComboBox cbIotOverflowTablespace;
    private JComboBox cbIotOverflowLogging;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbIotMappingTable;
    private JPanel iotProperties;
    private JPanel partitioningTab;
    private JPanel supplementalLog;
    private JTextField tfSLGroupName;
    private JComboBox cbSLGrouoCondition;
    private JTable slGroupAvailableColumnsTable;
    private JTable slGroupSelectedColumnsTable;
    private AvailableSupplementalColumnsModel slGroupAvailableColumnsModel;
    private ArrayList<SupplementalColumn> slGroupAvailableColumnsList;
    private ArrayList<SupplementalColumn> slGroupSelectedColumnsList;
    private SelectedSupplementalColumnsModel slGroupSelectedColumnsModel;
    private JButton bnSLGroupAddColumn;
    private JButton bnSLGroupRemoveColumn;
    private JCheckBox chbSupplementalPKColumns;
    private JCheckBox chbSupplementalFKColumns;
    private JCheckBox chbSupplementalUKColumns;
    private JCheckBox chbSupplementalAllColumns;
    private JPanel clusterColumns;
    private JList allClusterColumnsList;
    private JList selectedClusterColumnsList;
    private DefaultListModel allClusterColumnsModel;
    private DefaultListModel selectedClusterColumnsModel;
    private JButton bnAddClusterColumn;
    private JButton bnRemoveClusterColumn;
    private String comment;
    private String commentInRDBMS;
    private JPanel oidProperties;
    private JTextField tfOidIndexName;
    private JComboBox cbOidIndexSegment;
    private JTextField tfOidType;
    protected JPanel xmlTypeProperties;
    protected JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    private JComboBox cbStoreAs;
    protected JComboBox cbAllowAnySchema;
    protected JComboBox cbAllowNonSchema;
    protected JComboBox cbLobStorageType;
    private JTextField tfLobSegmentName;
    private JComboBox cbXmlTypeTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbXmlTypeLogging;
    private JComboBox cbXmlTypeCache;
    private JPositiveIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JPositiveIntegerField ifPctVersion;
    private JPositiveIntegerField ifFreePools;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    protected JTextField tfAccessDriverType;
    protected JTextField tfLocation;
    protected JComboBox cbDefaultDir;
    protected JComboBox cbAccessParamType;
    protected JComboBox cbBigDataProcessingMode;
    private JTextField tfRejectLimit;
    private JPanel opaqueFormatSpecPanel;
    private JPanel clobSubqueryPanel;
    private JTextArea opaqueFormatSpecArea;
    private JTextArea clobSubqueryArea;
    private JTabbedPane extTableTabPane;
    private JPanel externalTableProps;
    private static final int height = 370;
    private ColumnProxy[] columnSet;
    private SupplementalLogGroup currentSLGroup;
    private static final String SL_GROUP_TEMPLATE_NAME = "Group";
    private int gnCounter = 0;
    private DefaultListModel slGroupsModel;
    private JList slGroupsList;
    private JButton btnAddSLGroup;
    private JButton btnEditSLGroup;
    private JButton btnCancelSLGroup;
    private JButton btnRemoveSLGroup;
    private JButton btnSaveSLGroup;
    private List localSLGroupsList;
    private boolean isSLGroupSaved = true;
    private JComboBox cbProjectColumn;
    private JTable locationsSpecifiersTable;
    private List<TreeMap> locationSpecifiersList;
    private ArrayList<String> dirNames;

    public TablePropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxyOraclev10g)object;
        this.setHeight(660);
        this.initCommentsView(260);
        this.initCommentsInRDBMS(265);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogOracle.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initUser();
        this.initTemporary();
        this.initTableSpace();
        this.initOrganization();
        this.initCluster();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataSegmentCompression();
        int yCoord = this.initCompressionType(470);
        yCoord = this.initBasedOnStructuredType(yCoord);
        yCoord = this.initSnapshot(yCoord) + 10;
        if (this.isEditable()) {
            this.initPropagatePropsButton(yCoord);
        }
        this.initPermissionsButton(yCoord);
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTemporary() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Temporary"));
        this.general.add(label);
        this.cbTemporary = new JComboBox<String>(NO_PRESERVE_DELETE);
        this.setBG(this.cbTemporary);
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.cbTemporary.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTemporary, 80);
    }

    private void initTableSpace() {
        this.lbTableSpace = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.general.add(this.lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(this.lbTableSpace, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.lbTemporaryTablespace = new JLabel(Messages.getString("TablePropertyDialogOracle.TemporaryTablespace"));
            this.general.add(this.lbTemporaryTablespace);
            this.cbTemporaryTablespace = new JComboBox();
            this.setBG(this.cbTemporaryTablespace);
            if (this.getStorageDesign() != null) {
                this.fillComboItems(this.getStorageDesign().getTemporaryTablespaceSet().toArray(), this.cbTemporaryTablespace);
            }
            this.cbTemporaryTablespace.setPreferredSize(this.tfName.getPreferredSize());
            this.general.add(this.cbTemporaryTablespace);
            this.setLabelConstraints(this.lbTemporaryTablespace, 110);
            this.setObjectConstraints(this.cbTemporaryTablespace, 110);
        }
    }

    private void initOrganization() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Organization"));
        this.general.add(label);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.setBG(this.cbOrganization);
        this.cbOrganization.setPreferredSize(this.tfName.getPreferredSize());
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbOrganization, 140);
    }

    private void initCluster() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cluster"));
        this.general.add(label);
        this.cbCluster = new JComboBox();
        this.setBG(this.cbCluster);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.cbCluster.addActionListener(new ClusterListener());
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbLogging, 200);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbSegment, 230);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbCache, 260);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbParallel, 290);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.ifDegree, 320);
    }

    private void initRowDependency() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowDependency"));
        this.general.add(label);
        this.cbRowDependency = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRowDependency);
        this.cbRowDependency.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbRowDependency, 350);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbPartitioned, 380);
    }

    private void initPartRowMovement() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.RowMovement"));
        this.general.add(label);
        this.cbPartRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.setBG(this.cbPartRowMovement);
        this.cbPartRowMovement.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartRowMovement);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbPartRowMovement, 410);
    }

    private void initDataSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.DataCompression"));
        this.general.add(label);
        this.cbDataSegmentCompression = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDataSegmentCompression);
        this.cbDataSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataSegmentCompression);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbDataSegmentCompression, 440);
    }

    protected int initCompressionType(int yCoord) {
        return yCoord;
    }

    private List getSnapshots() {
        ArrayList<SnapshotOracle> result = new ArrayList<SnapshotOracle>();
        for (SnapshotOracle snapshot : this.getStorageDesign().getSnapshotSet()) {
            TableProxyOracle snapshotTable = snapshot.getImplementedTable();
            if (snapshotTable != null && snapshotTable != this.getStorageObject()) continue;
            result.add(snapshot);
        }
        return result;
    }

    private int initBasedOnStructuredType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StructuredType"));
        this.general.add(label);
        this.tfBasedOnStructuredType = new JTextField();
        this.setBG(this.tfBasedOnStructuredType);
        this.tfBasedOnStructuredType.setEnabled(false);
        this.tfBasedOnStructuredType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfBasedOnStructuredType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfBasedOnStructuredType, yCoord);
        return yCoord + 30;
    }

    private int initSnapshot(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.ImplementAsSnapshot"));
        this.general.add(label);
        this.cbSnapshot = new JComboBox();
        this.cbSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePropertyDialogOraclev10g.this.snapshotChanged();
            }
        });
        this.setBG(this.cbSnapshot);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getSnapshots().toArray(), this.cbSnapshot);
        }
        this.cbSnapshot.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSnapshot);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbSnapshot, yCoord);
        return yCoord + 30;
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogOraclev10g.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogOraclev10g.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initPermissionsButton(int yCoord) {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, yCoord);
    }

    protected SpringLayout getIOTPropertiesLayout() {
        return (SpringLayout)this.iotProperties.getLayout();
    }

    protected SpringLayout getSupplementalLogLayout() {
        return (SpringLayout)this.supplementalLog.getLayout();
    }

    private void initIOTCompress() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTCompress"));
        this.iotProperties.add(label);
        this.ifIotCompress = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotCompress);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotCompress, 20);
    }

    private void initIOTPCTThreshold() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTPCTThreshold"));
        this.iotProperties.add(label);
        this.ifIotPctThreshold = new JPositiveIntegerField(0, 26);
        this.iotProperties.add(this.ifIotPctThreshold);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.ifIotPctThreshold, 50);
    }

    private void initIOTIncluding() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTIncluding"));
        this.iotProperties.add(label);
        this.cbIotIncluding = new JComboBox();
        this.setBG(this.cbIotIncluding);
        this.cbIotIncluding.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotIncluding);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotIncluding, 80);
    }

    private void initIOTOverflowTablespace() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowTablespace"));
        this.iotProperties.add(label);
        this.cbIotOverflowTablespace = new JComboBox();
        this.setBG(this.cbIotOverflowTablespace);
        this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIotOverflowTablespace);
        this.cbIotOverflowTablespace.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowTablespace);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 110);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowTablespace, 110);
    }

    private void initIOTOverflowLogging() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowLogging"));
        this.iotProperties.add(label);
        this.cbIotOverflowLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbIotOverflowLogging);
        this.cbIotOverflowLogging.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowLogging);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 140);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowLogging, 140);
    }

    private void initIOTOverflowSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OverflowSegment"));
        this.iotProperties.add(label);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 170);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotOverflowSegment, 170);
    }

    private void initIOTMappingTable() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.MappingTable"));
        this.iotProperties.add(label);
        this.cbIotMappingTable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIotMappingTable);
        this.cbIotMappingTable.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.iotProperties.add(this.cbIotMappingTable);
        this.setLabelConstraints(this.getIOTPropertiesLayout(), label, 200);
        this.setObjectConstraints(this.getIOTPropertiesLayout(), this.cbIotMappingTable, 200);
    }

    @Override
    protected void addTabs() {
        this.initClusterColumnsView();
        this.partitioningTab = this.initPartitioningView();
        this.initIOTPropertiesView();
        this.initSupplementalLogView();
        this.initOIDView();
        this.initXMLTypeView();
        this.initExternalTablePropsPanes();
        this.initInMemoryPropsPane();
    }

    protected void initInMemoryPropsPane() {
    }

    private void initXMLTypeView() {
        this.xmlTypeProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.XMLTypeProperties"), this.xmlTypeProperties);
        this.initXMLTypeProperties();
    }

    private void initXMLTypeProperties() {
        this.initXMLSchemaURL(20);
        this.initXMLSchemaElement(50);
        int yCoord = this.initAllowAnySchema(80);
        yCoord = this.initAllowNonSchema(yCoord);
        this.initStoreAs(yCoord);
        yCoord += 30;
        yCoord = this.initLobStorageType(yCoord);
        this.initLobSegmentName(yCoord);
        this.initXmlTypeTableSpace(yCoord += 30);
        this.initStorageInRow(yCoord += 30);
        this.initXmlTypeLogging(yCoord += 30);
        this.initXmlTypeCache(yCoord += 30);
        this.initChunk(yCoord += 30);
        this.initOldVersions(yCoord += 30);
        this.initPctVersion(yCoord += 30);
        this.initFreePools(yCoord += 30);
    }

    private void initStoreAs(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StoreAs"));
        this.xmlTypeProperties.add(label);
        this.cbStoreAs = this.getStorageDesign() instanceof StorageDesignOraclev11g ? new JComboBox<String>(TableProxyOraclev11g.getStoreAsValues11g()) : new JComboBox<String>(TableProxyOraclev10g.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStoreAs);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStoreAs, yCoord);
    }

    private void initXMLSchemaURL(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaURL"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaUrl);
        this.xmlTypeProperties.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaUrl, yCoord);
    }

    private void initXMLSchemaElement(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.XMLSchemaElem"));
        this.xmlTypeProperties.add(label);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.setBG(this.tfXmlSchemaElement);
        this.xmlTypeProperties.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfXmlSchemaElement, yCoord);
    }

    protected int initAllowAnySchema(int yCoord) {
        return yCoord;
    }

    protected int initAllowNonSchema(int yCoord) {
        return yCoord;
    }

    protected int initLobStorageType(int yCoord) {
        return yCoord;
    }

    private void initLobSegmentName(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.LobSegmentName"));
        this.xmlTypeProperties.add(label);
        this.tfLobSegmentName = new JTextField("", 26);
        this.xmlTypeProperties.add(this.tfLobSegmentName);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.tfLobSegmentName, yCoord);
    }

    private void initXmlTypeTableSpace(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.TableSpace"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeTableSpace = new JComboBox();
        this.setBG(this.cbXmlTypeTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbXmlTypeTableSpace);
        }
        this.cbXmlTypeTableSpace.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeTableSpace);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeTableSpace, yCoord);
    }

    private void initStorageInRow(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.StorageInRow"));
        this.xmlTypeProperties.add(label);
        this.cbStorageInRow = new JComboBox<String>(TableProxyOracle.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbStorageInRow, yCoord);
    }

    private void initXmlTypeLogging(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Logging"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeLogging = new JComboBox<String>(this instanceof TablePropertyDialogOraclev11g ? TableProxyOraclev11g.getXmlTypeLoggingChoices11g() : EMPTY_YES_NO);
        this.setBG(this.cbXmlTypeLogging);
        this.cbXmlTypeLogging.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeLogging);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeLogging, yCoord);
    }

    private void initXmlTypeCache(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Cache"));
        this.xmlTypeProperties.add(label);
        this.cbXmlTypeCache = new JComboBox<String>(TableProxyOracle.getXmlTypeCacheValues());
        this.setBG(this.cbXmlTypeCache);
        this.cbXmlTypeCache.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbXmlTypeCache);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbXmlTypeCache, yCoord);
    }

    private void initChunk(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.Chunk"));
        this.xmlTypeProperties.add(label);
        this.ifChunk = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifChunk);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifChunk, yCoord);
    }

    private void initOldVersions(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OldVersions"));
        this.xmlTypeProperties.add(label);
        this.cbOldVersions = new JComboBox<String>(TableProxyOraclev10g.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbOldVersions, yCoord);
    }

    private void initPctVersion(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.PCTVersion"));
        this.xmlTypeProperties.add(label);
        this.ifPctVersion = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifPctVersion, yCoord);
    }

    private void initFreePools(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.FreePools"));
        this.xmlTypeProperties.add(label);
        this.ifFreePools = new JPositiveIntegerField(0, 26);
        this.xmlTypeProperties.add(this.ifFreePools);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.ifFreePools, yCoord);
    }

    private void enableXMLTypeClobOptions(boolean enable) {
        if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
            this.cbLobStorageType.setEnabled(enable);
        }
        this.tfLobSegmentName.setEnabled(enable);
        this.cbXmlTypeTableSpace.setEnabled(enable);
        this.cbStorageInRow.setEnabled(enable);
        this.cbXmlTypeLogging.setEnabled(enable);
        this.cbXmlTypeCache.setEnabled(enable);
        this.ifChunk.setEnabled(enable);
        this.cbOldVersions.setEnabled(enable);
        this.ifPctVersion.setEnabled(enable);
        this.ifFreePools.setEnabled(enable);
    }

    protected SpringLayout getXMLTypePropertiesLayout() {
        return (SpringLayout)this.xmlTypeProperties.getLayout();
    }

    private void initOIDView() {
        this.oidProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.OIDProperties"), this.oidProperties);
        this.initOIDProperties();
    }

    private void initOIDProperties() {
        this.initOidType();
        this.initOidIndexName();
        this.initOidIndexSegment();
    }

    private void initOidType() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDType"));
        this.oidProperties.add(label);
        this.tfOidType = new JTextField();
        this.tfOidType.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.tfOidType.setEnabled(false);
        this.oidProperties.add(this.tfOidType);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidType, 20);
    }

    private void initOidIndexName() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexName"));
        this.oidProperties.add(label);
        this.tfOidIndexName = new JTextField();
        this.tfOidIndexName.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.tfOidIndexName);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.tfOidIndexName, 50);
    }

    private void initOidIndexSegment() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.OIDIndexSegment"));
        this.oidProperties.add(label);
        this.cbOidIndexSegment = new JComboBox();
        this.setBG(this.cbOidIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbOidIndexSegment);
        }
        this.cbOidIndexSegment.setPreferredSize(this.ifIotCompress.getPreferredSize());
        this.oidProperties.add(this.cbOidIndexSegment);
        this.setLabelConstraints(this.getOIDPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getOIDPropertiesLayout(), this.cbOidIndexSegment, 80);
    }

    protected SpringLayout getOIDPropertiesLayout() {
        return (SpringLayout)this.oidProperties.getLayout();
    }

    private void initSupplementalLogView() {
        this.supplementalLog = new JPanel((LayoutManager)new MigLayout("fill", "0[130::150]0[]0", "0[]0"));
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.SupplementalLog"), this.supplementalLog);
        this.initSupplementalLog();
    }

    private void initSupplementalLog() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("", "5[]0[]0", "5[]0"));
        this.supplementalLog.add((Component)northPanel, new CC().height("50").dockNorth());
        this.chbSupplementalPKColumns = new JCheckBox(Messages.getString("TablePropertyDialogOraclev10g.PKColumns"));
        this.chbSupplementalFKColumns = new JCheckBox(Messages.getString("TablePropertyDialogOraclev10g.FKColumns"));
        this.chbSupplementalUKColumns = new JCheckBox(Messages.getString("TablePropertyDialogOraclev10g.UKColumns"));
        this.chbSupplementalAllColumns = new JCheckBox(Messages.getString("TablePropertyDialogOraclev10g.AllColumns"));
        northPanel.add((Component)this.chbSupplementalPKColumns, new CC().width("120"));
        northPanel.add((Component)this.chbSupplementalFKColumns, new CC().width("120").wrap());
        northPanel.add((Component)this.chbSupplementalUKColumns, new CC().width("120"));
        northPanel.add((Component)this.chbSupplementalAllColumns, new CC().width("120"));
        JPanel westPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        westPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev10g.Groups")));
        JPanel eastPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[100!]0[]0", "0[30!]0[30!]0[]0"));
        eastPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev10g.GroupDetails")));
        this.supplementalLog.add((Component)westPanel, new CC().growY());
        this.supplementalLog.add((Component)eastPanel, new CC().grow());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        this.btnAddSLGroup = new JButton(this.guiConfiguration.getIcon("ADD_ICON", 16));
        this.btnAddSLGroup.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnAddSLGroup.setEnabled(true);
        this.btnAddSLGroup.addActionListener(new AddSLGroupAction());
        this.btnAddSLGroup.setMnemonic(65);
        this.btnAddSLGroup.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Add"));
        this.btnEditSLGroup = new JButton(this.guiConfiguration.getIcon("EDIT_ICON", 16));
        this.btnEditSLGroup.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnEditSLGroup.setEnabled(false);
        this.btnEditSLGroup.addActionListener(new EditSLGroupAction());
        this.btnEditSLGroup.setMnemonic(69);
        this.btnEditSLGroup.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Edit"));
        this.btnCancelSLGroup = new JButton(this.guiConfiguration.getIcon("CANCEL_ICON", 16));
        this.btnCancelSLGroup.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnCancelSLGroup.setEnabled(false);
        this.btnCancelSLGroup.addActionListener(new CancelSLGroupAction());
        this.btnCancelSLGroup.setMnemonic(67);
        this.btnCancelSLGroup.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Cancel"));
        this.btnRemoveSLGroup = new JButton(this.guiConfiguration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveSLGroup.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemoveSLGroup.setEnabled(false);
        this.btnRemoveSLGroup.addActionListener(new RemoveSLGroupAction());
        this.btnRemoveSLGroup.setMnemonic(82);
        this.btnRemoveSLGroup.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Remove"));
        this.btnSaveSLGroup = new JButton(this.guiConfiguration.getIcon("SAVE_ICON", 16));
        this.btnSaveSLGroup.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSaveSLGroup.setEnabled(false);
        this.btnSaveSLGroup.addActionListener(new SaveSLGroupAction());
        this.btnSaveSLGroup.setMnemonic(83);
        this.btnSaveSLGroup.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Save"));
        toolBar.add(this.btnAddSLGroup);
        toolBar.add(this.btnEditSLGroup);
        toolBar.add(this.btnCancelSLGroup);
        toolBar.add(this.btnRemoveSLGroup);
        toolBar.add(this.btnSaveSLGroup);
        this.slGroupsModel = new DefaultListModel();
        this.slGroupsList = new JList(this.slGroupsModel);
        SLGroupsSelectionListener slGroupsSelectionListener = new SLGroupsSelectionListener();
        this.slGroupsList.addListSelectionListener(slGroupsSelectionListener);
        this.slGroupsList.setCellRenderer(new SLGroupsRenderer());
        this.slGroupsList.setSelectionMode(0);
        JScrollPane slGroupsSP = new JScrollPane(this.slGroupsList);
        westPanel.add((Component)toolBar, new CC().dockNorth());
        westPanel.add((Component)slGroupsSP, new CC().grow());
        JLabel lblSLGroupName = new JLabel(Messages.getString("TablePropertyDialogOracle.GroupName"));
        this.tfSLGroupName = new JTextField("");
        this.tfSLGroupName.setEnabled(false);
        JLabel lblSLCondition = new JLabel(Messages.getString("TablePropertyDialogOracle.Condition"));
        this.cbSLGrouoCondition = new JComboBox<String>(TableProxyOraclev10g.suplementalLogConditionChoices);
        this.cbSLGrouoCondition.setEnabled(false);
        JPanel slGroupColumnsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[140::]0[35!]0[140::]0", "0[0]0"));
        slGroupColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev10g.22")));
        JPanel slGroupAvailableColumnsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[]0", "0[0]0"));
        slGroupAvailableColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev10g.Columns")));
        this.slGroupAvailableColumnsList = new ArrayList();
        this.slGroupAvailableColumnsModel = new AvailableSupplementalColumnsModel();
        this.slGroupAvailableColumnsTable = new JTable(this.slGroupAvailableColumnsModel);
        this.slGroupAvailableColumnsTable.setEnabled(false);
        this.slGroupAvailableColumnsTable.setShowGrid(false);
        this.slGroupAvailableColumnsTable.setIntercellSpacing(new Dimension(0, 0));
        this.slGroupAvailableColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                    int[] selectedRows = TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.getSelectedRows();
                    if (selectedRows.length == 0) {
                        TablePropertyDialogOraclev10g.this.bnSLGroupAddColumn.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev10g.this.bnSLGroupAddColumn.setEnabled(true);
                    }
                }
            }
        });
        JScrollPane slGroupAvailableColumnsSP = new JScrollPane(this.slGroupAvailableColumnsTable);
        slGroupAvailableColumnsPanel.add((Component)slGroupAvailableColumnsSP, new CC().grow());
        JPanel slGroupSelectedColumnsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[]0", "0[0]0"));
        slGroupSelectedColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev10g.Selected")));
        this.slGroupSelectedColumnsList = new ArrayList();
        this.slGroupSelectedColumnsModel = new SelectedSupplementalColumnsModel();
        this.slGroupSelectedColumnsTable = new JTable(this.slGroupSelectedColumnsModel);
        this.slGroupSelectedColumnsTable.setEnabled(false);
        this.slGroupSelectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                    int[] selectedRows = TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.getSelectedRows();
                    if (selectedRows.length == 0) {
                        TablePropertyDialogOraclev10g.this.bnSLGroupRemoveColumn.setEnabled(false);
                    } else {
                        TablePropertyDialogOraclev10g.this.bnSLGroupRemoveColumn.setEnabled(true);
                    }
                }
            }
        });
        this.slGroupSelectedColumnsTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col1 = this.slGroupSelectedColumnsTable.getColumnModel().getColumn(1);
        col1.setMinWidth(50);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        JScrollPane slGroupSelectedColumnsSP = new JScrollPane(this.slGroupSelectedColumnsTable);
        slGroupSelectedColumnsPanel.add((Component)slGroupSelectedColumnsSP, new CC().grow());
        this.bnSLGroupAddColumn = new JButton(this.guiConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.bnSLGroupAddColumn.setEnabled(false);
        this.bnSLGroupAddColumn.setPreferredSize(new Dimension(32, 32));
        this.bnSLGroupAddColumn.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Add"));
        this.bnSLGroupAddColumn.addActionListener(new AddSLGroupColumnAction());
        this.bnSLGroupRemoveColumn = new JButton(this.guiConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.bnSLGroupRemoveColumn.setEnabled(false);
        this.bnSLGroupRemoveColumn.setPreferredSize(new Dimension(32, 32));
        this.bnSLGroupRemoveColumn.setToolTipText(Messages.getString("TablePropertyDialogOraclev10g.Remove"));
        this.bnSLGroupRemoveColumn.addActionListener(new RemoveSLGroupColumnAction());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalGlue());
        vBox.add(this.bnSLGroupAddColumn);
        vBox.add(this.bnSLGroupRemoveColumn);
        vBox.add(Box.createVerticalGlue());
        slGroupColumnsPanel.add((Component)slGroupAvailableColumnsPanel, new CC().grow());
        slGroupColumnsPanel.add((Component)vBox, new CC().width("35!"));
        slGroupColumnsPanel.add((Component)slGroupSelectedColumnsPanel, new CC().grow());
        eastPanel.add(lblSLGroupName);
        eastPanel.add((Component)this.tfSLGroupName, new CC().growX().wrap());
        eastPanel.add(lblSLCondition);
        eastPanel.add((Component)this.cbSLGrouoCondition, new CC().width("100!").wrap());
        eastPanel.add((Component)slGroupColumnsPanel, new CC().span(new int[]{2}).grow());
    }

    private String generateSLGroupName() {
        String name = SL_GROUP_TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.slGroupsModel.size();
        if (lastNumber != 0) {
            newNumber = this.gnCounter = lastNumber + 1;
        } else {
            ++this.gnCounter;
            newNumber = this.gnCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName, null)) {
            newNumber = ++this.gnCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name, SupplementalLogGroup current) {
        for (int i = 0; i < this.slGroupsModel.size(); ++i) {
            SupplementalLogGroup slg = (SupplementalLogGroup)this.slGroupsModel.get(i);
            if (current == slg || !slg.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void initIOTPropertiesView() {
        this.iotProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.IOTProperties"), this.iotProperties);
        this.initIOTProperties();
    }

    private void initIOTProperties() {
        this.initIOTCompress();
        this.initIOTPCTThreshold();
        this.initIOTIncluding();
        this.initIOTOverflowTablespace();
        this.initIOTOverflowLogging();
        this.initIOTOverflowSegment();
        this.initIOTMappingTable();
    }

    private void initClusterColumnsView() {
        this.clusterColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.ClusterColumns"), this.clusterColumns);
        this.initClusterColumns();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumns.getLayout();
    }

    private void initClusterColumns() {
        this.initAllClusterColumnsList();
        this.initSelectedClusterColumnsList();
        this.initClusterColumnsButtons();
    }

    private void initAllClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllColumns"));
        this.clusterColumns.add(label);
        this.allClusterColumnsModel = new DefaultListModel();
        this.allClusterColumnsList = new JList(this.allClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.allClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allClusterColumnsList);
        sp.setPreferredSize(new Dimension(144, 540));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 12, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 10, 22);
    }

    private void initSelectedClusterColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.SelectedColumns"));
        this.clusterColumns.add(label);
        this.selectedClusterColumnsModel = new DefaultListModel();
        this.selectedClusterColumnsList = new JList(this.selectedClusterColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedClusterColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedClusterColumnListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedClusterColumnsList);
        sp.setPreferredSize(new Dimension(145, 540));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumns.add(sp);
        this.setLabelConstraints(this.getClusterColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getClusterColumnsLayout(), sp, 290, 22);
    }

    private void initClusterColumnsButtons() {
        this.bnAddClusterColumn = new JButton(ADD_CAPTION);
        this.bnAddClusterColumn.addActionListener(new AddClusterColumnsActionListener());
        this.bnAddClusterColumn.setEnabled(false);
        this.clusterColumns.add(this.bnAddClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnAddClusterColumn, 175, 240);
        this.bnRemoveClusterColumn = new JButton(REMOVE_CAPTION);
        this.bnRemoveClusterColumn.setEnabled(false);
        this.bnRemoveClusterColumn.addActionListener(new RemoveClusterColumnsActionListener());
        this.clusterColumns.add(this.bnRemoveClusterColumn);
        this.setObjectConstraints(this.getClusterColumnsLayout(), this.bnRemoveClusterColumn, 175, 270);
        TablePropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddClusterColumn, this.bnRemoveClusterColumn);
    }

    protected JPanel initPartitioningView() {
        this.partitionPropertyTab = new PartitionPropertyTabOraclev10g(this.getAppView(), this.getStorageDesign(), this.getStorageObject(), this);
        return this.partitionPropertyTab.addTab(this.getPane());
    }

    @Override
    public void initProperties() {
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        String basedOnStructuredType = this.table.getBasedOnStructuredType();
        this.tfBasedOnStructuredType.setText(basedOnStructuredType);
        this.selectObject(this.cbUser, this.table.getUser());
        this.cbPartitioned.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbPartRowMovement.setSelectedItem(this.table.getParttitionedRowMovement());
        this.cbOrganization.setSelectedItem(this.table.getOrganization());
        this.selectObject(this.cbCluster, this.table.getCluster());
        this.cbLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getLogging()));
        this.selectObject(this.cbSegment, this.table.getSegment());
        this.cbCache.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getCache()));
        this.cbRowDependency.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getRowDependency()));
        this.cbDataSegmentCompression.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.table.getIotCompress());
        this.ifIotPctThreshold.setValue((long)this.table.getIotPctThreshold());
        this.fillComboItems(this.table.getColumnProxies(), this.cbIotIncluding);
        this.cbIotIncluding.setSelectedItem(this.table.getIotIncluding());
        this.cbIotOverflowTablespace.setSelectedItem(this.table.getIotOverflowTablespace());
        this.cbIotOverflowLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getIotOverflowLogging()));
        this.cbIotOverflowSegment.setSelectedItem(this.table.getIotOverflowSegment());
        this.cbIotMappingTable.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getIOTMappingTable()));
        this.cbSnapshot.setSelectedItem(this.table.getSnapshot());
        this.columnSet = this.table.getColumnProxies();
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.oidProperties), !basedOnStructuredType.equals(""));
        this.tfOidType.setText(this.table.getOidType());
        this.tfOidIndexName.setText(this.table.getOidIndexName());
        this.cbOidIndexSegment.setSelectedItem(this.table.getOidIndexSegment());
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.xmlTypeProperties), basedOnStructuredType.equalsIgnoreCase("XMLTYPE"));
        this.tfXmlSchemaUrl.setText(this.table.getXmlSchemaUrl());
        this.tfXmlSchemaElement.setText(this.table.getXmlSchemaElement());
        this.cbStoreAs.setSelectedItem(this.table.getStoreAs());
        this.tfLobSegmentName.setText(this.table.getLobSegmentName());
        this.selectObject(this.cbXmlTypeTableSpace, this.table.getXmlTypeTableSpace());
        this.cbStorageInRow.setSelectedItem(this.table.getStorageInRow());
        this.cbXmlTypeLogging.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getXmlTypeLogging()));
        this.cbXmlTypeCache.setSelectedItem(this.table.getXmlTypeCache());
        this.ifChunk.setValue((long)this.table.getChunk());
        this.cbOldVersions.setSelectedItem(this.table.getOldVersions());
        this.ifPctVersion.setValue((long)this.table.getPCTVersion());
        this.ifFreePools.setValue((long)this.table.getFreepools());
        block0: for (String colId : this.table.getClusterColumnsSet()) {
            for (int i = 0; i < this.columnSet.length; ++i) {
                ColumnProxy col = this.columnSet[i];
                if (!col.getObjectID().equals(colId)) continue;
                this.selectedClusterColumnsModel.addElement(col);
                continue block0;
            }
        }
        for (int i = 0; i < this.columnSet.length; ++i) {
            ColumnProxy col = this.columnSet[i];
            if (this.selectedClusterColumnsModel.contains(col)) continue;
            this.allClusterColumnsModel.addElement(col);
        }
        this.partitionPropertyTab.initProperties();
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        if (this.table.getTemporary().equals("NO")) {
            this.cbTemporary.setSelectedItem(NO);
        } else if (this.table.getTempPreserveRows().equals("YES")) {
            this.cbTemporary.setSelectedItem(YES_PRESERVE);
        } else {
            this.cbTemporary.setSelectedItem(YES_DELETE);
        }
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        if (this.cbTemporaryTablespace != null) {
            this.selectObject(this.cbTemporaryTablespace, this.table.getTemporaryTablespace());
        }
        this.cbParallel.setSelectedItem(TablePropertyDialogOraclev10g.translateYesNoForDisplay(this.table.getParallel()));
        this.ifDegree.setText(this.table.getDegree());
        if (this.cbSnapshot.getSelectedItem() != null) {
            this.snapshotChanged();
        }
        this.initExternalTableProperties();
        this.chbSupplementalPKColumns.setSelected(this.table.getSupplementalLogPK());
        this.chbSupplementalFKColumns.setSelected(this.table.getSupplementalLogFK());
        this.chbSupplementalUKColumns.setSelected(this.table.getSupplementalLogUK());
        this.chbSupplementalAllColumns.setSelected(this.table.getSupplementalLogALL());
        this.localSLGroupsList = new ArrayList();
        this.localSLGroupsList.addAll(this.table.getLoggingGroups());
        Iterator it = this.localSLGroupsList.iterator();
        while (it.hasNext()) {
            this.slGroupsModel.addElement(it.next());
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            TablePropertyDialogOraclev10g.stopCellEditing(this.locationsSpecifiersTable);
            this.table.setName(this.tfName.getText());
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOraclev10g) {
                this.table.setUser((UserOraclev10g)selected);
            } else {
                this.table.setUser(null);
            }
            if (this.cbTemporary.getSelectedItem().equals(NO)) {
                this.table.setTemporary("NO");
                selected = this.cbTableSpace.getSelectedItem();
                if (selected instanceof TableSpaceOracle) {
                    this.table.setTableSpace((TableSpaceOracle)selected);
                } else {
                    this.table.setTableSpace(null);
                }
            } else {
                this.table.setTemporary("YES");
                if (this.cbTemporary.getSelectedItem().equals(YES_PRESERVE)) {
                    this.table.setTempPreserveRows("YES");
                } else {
                    this.table.setTempPreserveRows("NO");
                }
                if (this.cbTemporaryTablespace != null) {
                    selected = this.cbTemporaryTablespace.getSelectedItem();
                    if (selected instanceof TemporaryTablespaceOracle) {
                        this.table.setTemporaryTablespace((TemporaryTablespaceOracle)selected);
                    } else {
                        this.table.setTableSpace(null);
                    }
                }
            }
            this.table.setOrganization((String)this.cbOrganization.getSelectedItem());
            selected = this.cbCluster.getSelectedItem();
            if (selected instanceof ClusterOraclev10g) {
                this.table.setCluster((ClusterOraclev10g)selected);
            } else {
                this.table.setCluster(null);
            }
            this.table.setLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.table.setSegment((SegmentOraclev10g)selected);
            } else {
                this.table.setSegment(null);
            }
            this.table.setCache(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.table.setParallel(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.table.setDegree(this.ifDegree.getText());
            this.table.setRowDependency(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
            this.table.setPartitioned(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setParttitionedRowMovement((String)this.cbPartRowMovement.getSelectedItem());
            this.table.setDataSegmentCompression(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDataSegmentCompression.getSelectedItem()));
            this.table.setOidIndexName(this.tfOidIndexName.getText());
            this.table.setOidIndexSegment((SegmentOracle)this.cbOidIndexSegment.getSelectedItem());
            this.table.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
            this.table.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
            String storeAs = (String)this.cbStoreAs.getSelectedItem();
            this.table.setStoreAs(storeAs);
            if (!storeAs.equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.table.setLobSegmentName(this.tfLobSegmentName.getText());
                selected = this.cbXmlTypeTableSpace.getSelectedItem();
                if (selected instanceof TableSpaceOraclev10g) {
                    this.table.setXmlTypeTableSpace((TableSpaceOraclev10g)selected);
                } else {
                    this.table.setXmlTypeTableSpace(null);
                }
                this.table.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                this.table.setXmlTypeLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbXmlTypeLogging.getSelectedItem()));
                this.table.setXmlTypeCache((String)this.cbXmlTypeCache.getSelectedItem());
                this.table.setChunk(this.ifChunk.getIntValue());
                this.table.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                this.table.setFreepools(this.ifFreePools.getIntValue());
                this.table.setPCTVersion(this.ifPctVersion.getIntValue());
            }
            this.table.setIotCompress(this.ifIotCompress.getIntValue());
            this.table.setIotPctThreshold(this.ifIotPctThreshold.getIntValue());
            selected = this.cbIotIncluding.getSelectedItem();
            if (selected instanceof ColumnProxy) {
                this.table.setIotIncluding((ColumnProxy)selected);
            } else {
                this.table.setIotIncluding(null);
            }
            selected = this.cbIotOverflowTablespace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.table.setIotOverflowTablespace((TableSpaceOraclev10g)selected);
            } else {
                this.table.setIotOverflowTablespace(null);
            }
            this.table.setIotOverflowLogging(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIotOverflowLogging.getSelectedItem()));
            selected = this.cbIotOverflowSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.table.setIotOverflowSegment((SegmentOraclev10g)selected);
            } else {
                this.table.setIotOverflowSegment(null);
            }
            this.table.setIOTMappingTable(TablePropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIotMappingTable.getSelectedItem()));
            selected = this.cbSnapshot.getSelectedItem();
            if (selected instanceof SnapshotOracle) {
                this.table.setSnapshot((SnapshotOracle)selected);
            } else {
                this.table.setSnapshot(null);
            }
            this.table.setSupplementalLogPK(this.chbSupplementalPKColumns.isSelected());
            this.table.setSupplementalLogFK(this.chbSupplementalFKColumns.isSelected());
            this.table.setSupplementalLogUK(this.chbSupplementalUKColumns.isSelected());
            this.table.setSupplementalLogALL(this.chbSupplementalAllColumns.isSelected());
            this.btnSaveSLGroup.doClick();
            List<SupplementalLogGroup> lgList = this.table.getLoggingGroups();
            lgList.clear();
            lgList.addAll(this.localSLGroupsList);
            Object[] columnSet = this.selectedClusterColumnsModel.toArray();
            this.table.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxy)) continue;
                this.table.setClusterColumns(((ColumnProxy)ob).getObjectID());
            }
            this.partitionPropertyTab.setProperties(this.isPartitioned());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String taCommentsInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(taCommentsInRDBMSText) && !this.commentInRDBMS.equals(taCommentsInRDBMSText)) {
                this.table.setCommentInRDBMS(taCommentsInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
            this.setExternalTableProps();
        }
    }

    protected boolean isPartitioned() {
        return this.cbPartitioned.getSelectedItem().equals(YES);
    }

    protected boolean isIndexOrg() {
        return this.cbOrganization.getSelectedItem().equals("INDEX");
    }

    private void snapshotChanged() {
        boolean enable = this.cbSnapshot.getSelectedItem() == null;
        this.tfName.setEnabled(enable);
        this.cbUser.setEnabled(enable);
        this.cbTemporary.setEnabled(enable);
        this.cbCluster.setEnabled(enable);
        this.cbParallel.setEnabled(enable);
        this.ifDegree.setEnabled(enable);
        this.cbRowDependency.setEnabled(enable);
        this.cbPartRowMovement.setEnabled(enable);
        this.cbDataSegmentCompression.setEnabled(enable);
        this.bnPermissions.setEnabled(enable);
        try {
            this.getPane().setEnabledAt(1, enable);
            this.getPane().setEnabledAt(4, enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void postProcessingInApply() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.postProcessingInApply();
        }
    }

    @Override
    protected void clearOnDispose() {
        if (this.partitionPropertyTab != null) {
            this.partitionPropertyTab.clearOnDispose();
        }
    }

    private void initAccessDriverType(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.AccessDriver"));
        panel.add(label);
        this.tfAccessDriverType = new JTextField("", 26);
        panel.add(this.tfAccessDriverType);
        this.setExtTabLabelConstraints(label, 20);
        this.setExtTabObjectConstraints(this.tfAccessDriverType, 20);
    }

    private void initDefaultDir(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.DefaultDir"));
        panel.add(label);
        this.cbDefaultDir = new JComboBox<Object>(this.dirNames.toArray());
        this.cbDefaultDir.setEditable(true);
        this.cbDefaultDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)TablePropertyDialogOraclev10g.this.cbDefaultDir.getSelectedItem();
                if (!TablePropertyDialogOraclev10g.this.dirNames.contains(value)) {
                    TablePropertyDialogOraclev10g.this.dirNames.add(value);
                    TablePropertyDialogOraclev10g.this.cbDefaultDir.addItem(value);
                }
            }
        });
        this.setBG(this.cbDefaultDir);
        this.cbDefaultDir.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbDefaultDir);
        this.setExtTabLabelConstraints(label, 50);
        this.setExtTabObjectConstraints(this.cbDefaultDir, 50);
    }

    private void initAccessParametersType(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.AccessParams"));
        panel.add(label);
        this.cbAccessParamType = new JComboBox<String>(ExternalTableOracle.getAccessParametersChoices());
        this.setBG(this.cbAccessParamType);
        this.cbAccessParamType.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbAccessParamType);
        this.setExtTabLabelConstraints(label, 80);
        this.setExtTabObjectConstraints(this.cbAccessParamType, 80);
    }

    private void initRejectLimit(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.RejectLimit"));
        panel.add(label);
        this.tfRejectLimit = new JTextField("", 26);
        panel.add(this.tfRejectLimit);
        this.setExtTabLabelConstraints(label, 110);
        this.setExtTabObjectConstraints(this.tfRejectLimit, 110);
    }

    private void initProjectColumn(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.ProjectColumn"));
        panel.add(label);
        this.cbProjectColumn = new JComboBox<String>(ExternalTableOracle.getProjectColumnChoices());
        this.setBG(this.cbProjectColumn);
        this.cbProjectColumn.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbProjectColumn);
        this.setExtTabLabelConstraints(label, 140);
        this.setExtTabObjectConstraints(this.cbProjectColumn, 140);
    }

    private void iniBigDataProcessingMode(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("ExternalTableOraclePropertyDialog.BigDataProcessingMode"));
        panel.add(label);
        label.setToolTipText(Messages.getString("ExternalTableOraclePropertyDialog.BigDataProcessingModeHint"));
        this.cbBigDataProcessingMode = new JComboBox<String>(TableProxyOracle.BIG_DATA_ROW_PROCESSING_OPTIONS);
        this.setBG(this.cbBigDataProcessingMode);
        this.cbBigDataProcessingMode.setPreferredSize(this.tfName.getPreferredSize());
        this.cbBigDataProcessingMode.setToolTipText(Messages.getString("ExternalTableOraclePropertyDialog.BigDataProcessingModeHint"));
        panel.add(this.cbBigDataProcessingMode);
        this.setExtTabLabelConstraints(label, 170);
        this.setExtTabObjectConstraints(this.cbBigDataProcessingMode, 170);
    }

    private void initLocation(JPanel panel) {
        this.locationSpecifiersList = new ArrayList<TreeMap>();
        this.locationsSpecifiersTable = new JTable(new LocationSpecifierModel());
        this.locationsSpecifiersTable.setSelectionMode(0);
        this.locationsSpecifiersTable.getTableHeader().setReorderingAllowed(false);
        this.locationsSpecifiersTable.setCellSelectionEnabled(true);
        TableColumn col0 = this.locationsSpecifiersTable.getColumnModel().getColumn(0);
        col0.setCellEditor(new LocationSpecifierDirEditor());
        DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
        singleclick.setClickCountToStart(1);
        TableColumn col1 = this.locationsSpecifiersTable.getColumnModel().getColumn(1);
        col1.setCellEditor(singleclick);
        JButton btnLocationSpecifierAdd = new JButton(this.getAppView().getConfiguration().getIcon("ADD_ICON", 16));
        btnLocationSpecifierAdd.setToolTipText(BTN_ADD);
        btnLocationSpecifierAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                String dirName = " ";
                String defDir = (String)TablePropertyDialogOraclev10g.this.cbDefaultDir.getSelectedItem();
                if (defDir != null) {
                    dirName = defDir;
                }
                map.put(dirName, " ");
                TablePropertyDialogOraclev10g.this.locationSpecifiersList.add(map);
                TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.updateUI();
                TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.changeSelection(TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.convertRowIndexToModel(TablePropertyDialogOraclev10g.this.locationSpecifiersList.size() - 1), 0, false, false);
            }
        });
        final JButton btnLocationSpecifierRemove = new JButton(this.getAppView().getConfiguration().getIcon("DELETE_ICON", 16));
        btnLocationSpecifierRemove.setToolTipText(BTN_REMOVE);
        btnLocationSpecifierRemove.setEnabled(false);
        btnLocationSpecifierRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int selected;
                int icol = TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.getEditingColumn();
                int irow = TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.getEditingRow();
                if (icol > -1 && irow > -1) {
                    TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.getCellEditor(irow, icol).stopCellEditing();
                }
                if ((selected = TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.getSelectedRow()) != -1) {
                    TablePropertyDialogOraclev10g.this.locationSpecifiersList.remove(selected);
                    if (TablePropertyDialogOraclev10g.this.locationSpecifiersList.size() >= 1) {
                        TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.changeSelection(TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.convertRowIndexToModel(TablePropertyDialogOraclev10g.this.locationSpecifiersList.size() - 1), 0, false, false);
                    }
                    TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.updateUI();
                }
            }
        });
        final JButton btnLocationSpecifierMoveUp = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_UP_ICON", 16));
        btnLocationSpecifierMoveUp.setToolTipText(BTN_UP);
        btnLocationSpecifierMoveUp.setEnabled(false);
        MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.locationSpecifiersList, this.locationsSpecifiersTable);
        btnLocationSpecifierMoveUp.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveUpAction(upDown)));
        final JButton btnLocationSpecifierMoveDown = new JButton(this.getAppView().getConfiguration().getIcon("MOVE_DOWN_ICON", 16));
        btnLocationSpecifierMoveDown.setToolTipText(BTN_DOWN);
        btnLocationSpecifierMoveDown.setEnabled(false);
        btnLocationSpecifierMoveDown.addActionListener(new UpDownAction(new MoveUpDownListJTable.MoveDownAction(upDown)));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnLocationSpecifierAdd);
        toolBar.add(btnLocationSpecifierRemove);
        toolBar.add(btnLocationSpecifierMoveUp);
        toolBar.add(btnLocationSpecifierMoveDown);
        this.locationsSpecifiersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] rowIndices = TablePropertyDialogOraclev10g.this.locationsSpecifiersTable.getSelectedRows();
                    if (rowIndices.length > 0) {
                        btnLocationSpecifierRemove.setEnabled(true);
                        btnLocationSpecifierMoveUp.setEnabled(true);
                        btnLocationSpecifierMoveDown.setEnabled(true);
                    } else {
                        btnLocationSpecifierRemove.setEnabled(false);
                        btnLocationSpecifierMoveUp.setEnabled(false);
                        btnLocationSpecifierMoveDown.setEnabled(false);
                    }
                }
            }
        });
        JPanel jp = new JPanel(new BorderLayout());
        jp.setPreferredSize(new Dimension(460, 370));
        jp.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev9i.LocationSpecifiers")));
        jp.add((Component)toolBar, "North");
        jp.add((Component)new JScrollPane(this.locationsSpecifiersTable), "Center");
        panel.add(jp);
        this.setExtTabObjectConstraints(jp, 200);
    }

    private void initExternalTablePropsPanes() {
        if (this.getStorageDesign() != null) {
            Iterator<Object> dirsIt = Arrays.asList(this.getStorageDesign().getDirectorySet().toArray()).iterator();
            this.dirNames = new ArrayList();
            while (dirsIt.hasNext()) {
                DirectoryOracle d = (DirectoryOracle)dirsIt.next();
                this.dirNames.add(d.getName());
            }
        }
        this.extTableTabPane = new JTabbedPane();
        this.externalTableProps = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ExternalTableOraclePropertyDialog.ExternalTableProperties"), this.extTableTabPane);
        this.extTableTabPane.addTab(Messages.getString("TablePropertyDialogOracle.ExternalTable"), this.externalTableProps);
        this.initAccessDriverType(this.externalTableProps);
        this.initDefaultDir(this.externalTableProps);
        this.initAccessParametersType(this.externalTableProps);
        this.initLocation(this.externalTableProps);
        this.initRejectLimit(this.externalTableProps);
        this.initProjectColumn(this.externalTableProps);
        this.iniBigDataProcessingMode(this.externalTableProps);
        this.initOpaqueFormatSpecView(this.extTableTabPane);
        this.initClobSubqueryView(this.extTableTabPane);
    }

    protected SpringLayout getOpaqueFormatSpecLayout() {
        return (SpringLayout)this.opaqueFormatSpecPanel.getLayout();
    }

    protected SpringLayout getClobSubqueryLayout() {
        return (SpringLayout)this.clobSubqueryPanel.getLayout();
    }

    private void initOpaqueFormatSpecView(JTabbedPane panel) {
        this.opaqueFormatSpecPanel = new JPanel(new SpringLayout());
        panel.addTab(Messages.getString("ExternalTableOraclePropertyDialog.OpaqueFormatSpec"), this.opaqueFormatSpecPanel);
        this.initOpaqueFormatSpec();
    }

    private void initOpaqueFormatSpec() {
        this.opaqueFormatSpecArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.opaqueFormatSpecArea);
        sp.setPreferredSize(new Dimension(this.getDialogWidth() - 20, 325));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.opaqueFormatSpecArea.setLineWrap(true);
        this.opaqueFormatSpecPanel.add(sp);
        this.setObjectConstraints(this.getOpaqueFormatSpecLayout(), sp, 10, 12);
        JButton bnCreateTemplate = new JButton(Messages.getString("TablePropertyDialogOracle.CreateTemplate"));
        this.opaqueFormatSpecPanel.add(bnCreateTemplate);
        this.setObjectConstraints(this.getOpaqueFormatSpecLayout(), bnCreateTemplate, 180, 360);
        bnCreateTemplate.addActionListener(new CreateTemplateListener());
    }

    private void initClobSubqueryView(JTabbedPane panel) {
        this.clobSubqueryPanel = new JPanel(new SpringLayout());
        panel.addTab(Messages.getString("ExternalTableOraclePropertyDialog.CLOBSubquery"), this.clobSubqueryPanel);
        this.initClobSubquery();
    }

    private void initClobSubquery() {
        this.clobSubqueryArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.clobSubqueryArea);
        sp.setPreferredSize(new Dimension(this.getDialogWidth() - 20, 325));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.opaqueFormatSpecArea.setLineWrap(true);
        this.clobSubqueryPanel.add(sp);
        this.setObjectConstraints(this.getClobSubqueryLayout(), sp, 10, 12);
    }

    private void initExternalTableProperties() {
        this.tfAccessDriverType.setText(this.table.getAccessDriverType());
        if (this.table != null && this.table.getDefaultDir() != null) {
            this.cbDefaultDir.setSelectedItem(this.table.getDefaultDir().getName());
        }
        this.cbAccessParamType.setSelectedItem(this.table.getAccessParametersType());
        this.locationSpecifiersList.clear();
        this.locationSpecifiersList.addAll(this.table.getLocations());
        this.cbParallel.setSelectedItem(this.table.getParallel());
        this.tfRejectLimit.setText(this.table.getRejectLimit());
        this.cbProjectColumn.setSelectedItem(this.table.getProjectColumn());
        this.cbBigDataProcessingMode.setSelectedItem(this.table.getBigDataRowProcessing());
        this.taComments.setText(this.table.getComment());
        this.opaqueFormatSpecArea.setText(this.table.getOpaqueFormatSpec());
        this.clobSubqueryArea.setText(this.table.getClobSubquery());
    }

    private void setExternalTableProps() {
        this.table.setAccessDriverType(this.tfAccessDriverType.getText());
        for (DirectoryOracle directoryOracle : Arrays.asList(this.getStorageDesign().getDirectorySet().toArray())) {
            if (!directoryOracle.getName().equals(this.cbDefaultDir.getSelectedItem())) continue;
            this.table.setDefaultDir(directoryOracle);
            break;
        }
        this.table.setAccessParametersType((String)this.cbAccessParamType.getSelectedItem());
        this.table.applyLocations(this.locationSpecifiersList);
        this.table.setRejectLimit(this.tfRejectLimit.getText());
        this.table.setProjectColumn((String)this.cbProjectColumn.getSelectedItem());
        this.table.setBigDataRowProcessing((String)this.cbBigDataProcessingMode.getSelectedItem());
        this.table.setOpaqueFormatSpec(this.opaqueFormatSpecArea.getText());
        this.table.setClobSubquery(this.clobSubqueryArea.getText());
    }

    protected void setExtTabLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)this.externalTableProps.getLayout()).getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setExtTabObjectConstraints(Component c, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)this.externalTableProps.getLayout()).getConstraints(c);
        labelCons.setConstraint("East", Spring.constant(this.getDialogWidth() - 15));
        labelCons.setY(Spring.constant(y));
    }

    private class SelectedSupplementalColumnsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("TablePropertyDialogOraclev10g.Name"), Messages.getString("TablePropertyDialogOraclev10g.NoLog")};

        private SelectedSupplementalColumnsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.size();
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return ColumnProxy.class;
            }
            if (c == 1) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SupplementalColumn sc = (SupplementalColumn)TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return sc.getColumn();
            }
            if (columnIndex == 1) {
                return sc.isNoLog();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            SupplementalColumn sc = (SupplementalColumn)TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.get(rowIndex);
            if (colIndex == 1) {
                sc.setNoLog((Boolean)value);
            }
        }
    }

    private class AvailableSupplementalColumnsModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("TablePropertyDialogOraclev10g.Name")};

        private AvailableSupplementalColumnsModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.size();
        }

        public Class getColumnClass(int c) {
            return ColumnProxy.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SupplementalColumn sc = (SupplementalColumn)TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.get(rowIndex);
            return sc.getColumn();
        }
    }

    private class SupplementalColumn {
        private ColumnProxy column;
        private boolean noLog;

        SupplementalColumn(ColumnProxy column, boolean noLog) {
            this.column = column;
            this.noLog = noLog;
        }

        public ColumnProxy getColumn() {
            return this.column;
        }

        public void setColumn(ColumnProxy column) {
            this.column = column;
        }

        public boolean isNoLog() {
            return this.noLog;
        }

        public void setNoLog(boolean noLog) {
            this.noLog = noLog;
        }
    }

    private class CreateTemplateListener
    implements ActionListener {
        private CreateTemplateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tableName = TablePropertyDialogOraclev10g.this.table.getName();
            StringBuffer buffer = new StringBuffer("    RECORDS DELIMITED BY NEWLINE");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    CHARACTERSET WE8MSWIN1252");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    BADFILE '").append(tableName).append("_%p.bad'");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    DISCARDFILE '").append(tableName).append("_%p.dsc'");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    LOGFILE '").append(tableName).append("_%p.log'");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"'");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    LRTRIM");
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    ( ");
            ColumnProxy[] columnProxies = TablePropertyDialogOraclev10g.this.table.getColumnProxies();
            for (int i = 0; i < columnProxies.length; ++i) {
                if (i > 0) {
                    buffer.append(" ,").append(SQLStatementBuilder.NEWLINE).append("      ");
                }
                buffer.append(TablePropertyDialogOraclev10g.this.storageDesign.getFormatedName(columnProxies[i]));
            }
            buffer.append(SQLStatementBuilder.NEWLINE);
            buffer.append("    )");
            TablePropertyDialogOraclev10g.this.opaqueFormatSpecArea.setText(buffer.toString());
        }
    }

    class LocationSpecifierDirEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TableCellEditor editor;

        LocationSpecifierDirEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editor != null) {
                return this.editor.getCellEditorValue();
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox<Object> cb = new JComboBox<Object>(TablePropertyDialogOraclev10g.this.dirNames.toArray());
            cb.setEditable(true);
            this.editor = new DefaultCellEditor(cb);
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean stopCellEditing() {
            String value = (String)this.editor.getCellEditorValue();
            if (!TablePropertyDialogOraclev10g.this.dirNames.contains(value)) {
                TablePropertyDialogOraclev10g.this.dirNames.add(value);
                TablePropertyDialogOraclev10g.this.cbDefaultDir.addItem(value);
            }
            return super.stopCellEditing();
        }
    }

    private class LocationSpecifierModel
    extends AbstractTableModel {
        private LocationSpecifierModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogOraclev10g.this.locationSpecifiersList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TablePropertyDialogOraclev9i.Directory");
            }
            if (column == 1) {
                return Messages.getString("TablePropertyDialogOraclev9i.Specifier");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map map = (Map)TablePropertyDialogOraclev10g.this.locationSpecifiersList.get(row);
            if (col == 0) {
                String dir = (String)map.get("directory");
                if (dir != null) {
                    return dir;
                }
                return "";
            }
            if (col == 1) {
                String loc = (String)map.get("location");
                if (loc != null) {
                    return loc;
                }
                return "";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            TreeMap map = (TreeMap)TablePropertyDialogOraclev10g.this.locationSpecifiersList.get(rowIndex);
            if (columnIndex == 0) {
                map.put("directory", obj.toString());
            } else if (columnIndex == 1) {
                map.put("location", obj.toString());
            }
        }
    }

    class UpDownAction
    implements ActionListener {
        ActionListener al;

        UpDownAction(ActionListener al) {
            this.al = al;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.al.actionPerformed(e);
        }
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.ifDegree.setEnabled(TablePropertyDialogOraclev10g.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String organization = (String)TablePropertyDialogOraclev10g.this.cbOrganization.getSelectedItem();
            if (organization != null) {
                boolean indexOrg = organization.equalsIgnoreCase("INDEX");
                TablePropertyDialogOraclev10g.this.cbCache.setEnabled(!indexOrg);
                TablePropertyDialogOraclev10g.this.ifIotCompress.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.ifIotPctThreshold.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotIncluding.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowTablespace.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowLogging.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotOverflowSegment.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.cbIotMappingTable.setEnabled(indexOrg);
                TablePropertyDialogOraclev10g.this.partitionPropertyTab.enableRelevantPartitionFields(TablePropertyDialogOraclev10g.this.isPartitioned());
            }
        }
    }

    private class ClusterListener
    implements ActionListener {
        private ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.cbTemporary.getSelectedItem().equals(AbstractPropertyDialog.NO)) {
                TablePropertyDialogOraclev10g.this.cbOrganization.setSelectedItem("HEAP");
                TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(false);
                if (TablePropertyDialogOraclev10g.this.cbTemporaryTablespace != null) {
                    TablePropertyDialogOraclev10g.this.lbTableSpace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.lbTemporaryTablespace.setVisible(true);
                    TablePropertyDialogOraclev10g.this.cbTemporaryTablespace.setVisible(true);
                } else {
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(false);
                }
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
            } else {
                TablePropertyDialogOraclev10g.this.cbCluster.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbPartitioned.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.cbTemporaryTablespace != null) {
                    TablePropertyDialogOraclev10g.this.lbTemporaryTablespace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.cbTemporaryTablespace.setVisible(false);
                    TablePropertyDialogOraclev10g.this.lbTableSpace.setVisible(true);
                    TablePropertyDialogOraclev10g.this.cbTableSpace.setVisible(true);
                }
                TablePropertyDialogOraclev10g.this.cbTableSpace.setEnabled(true);
                TablePropertyDialogOraclev10g.this.cbLogging.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() == null || TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem() instanceof String && ((String)TablePropertyDialogOraclev10g.this.cbCluster.getSelectedItem()).trim().equalsIgnoreCase("")) {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(false);
                } else {
                    TablePropertyDialogOraclev10g.this.cbOrganization.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbSegment.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.cbParallel.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
                    TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
                }
            }
        }
    }

    private class RemoveClusterColumnsActionListener
    implements ActionListener {
        private RemoveClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.allClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AddClusterColumnsActionListener
    implements ActionListener {
        private AddClusterColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogOraclev10g.this.allClusterColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.contains(ob)) continue;
                    TablePropertyDialogOraclev10g.this.selectedClusterColumnsModel.addElement(ob);
                    TablePropertyDialogOraclev10g.this.allClusterColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private SelectedClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnRemoveClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.selectedClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class AllClusterColumnListSelectionHandler
    implements ListSelectionListener {
        private AllClusterColumnListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.bnAddClusterColumn.setEnabled(TablePropertyDialogOraclev10g.this.allClusterColumnsList.getSelectedIndex() != -1);
            }
        }
    }

    private class RemoveSLGroupColumnAction
    implements ActionListener {
        private RemoveSLGroupColumnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] selected = TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.getSelectedRows();
            ArrayList<SupplementalColumn> tempList = new ArrayList<SupplementalColumn>();
            for (int i = 0; i < selected.length; ++i) {
                SupplementalColumn current = (SupplementalColumn)TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.get(TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.convertRowIndexToModel(selected[i]));
                if (TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.contains(current)) continue;
                tempList.add(current);
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.add(current);
            }
            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.removeAll(tempList);
            TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.updateUI();
            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.updateUI();
        }
    }

    private class AddSLGroupColumnAction
    implements ActionListener {
        private AddSLGroupColumnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int[] selected = TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.getSelectedRows();
            ArrayList<SupplementalColumn> tempList = new ArrayList<SupplementalColumn>();
            for (int i = 0; i < selected.length; ++i) {
                SupplementalColumn current = (SupplementalColumn)TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.get(TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.convertRowIndexToModel(selected[i]));
                if (TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.contains(current)) continue;
                tempList.add(current);
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.add(current);
            }
            TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.removeAll(tempList);
            TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.updateUI();
            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.updateUI();
        }
    }

    private class SLGroupsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SLGroupsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SupplementalLogGroup slg = (SupplementalLogGroup)value;
            this.setText(slg.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class SLGroupsSelectionListener
    implements ListSelectionListener {
        private SLGroupsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.clear();
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.clear();
                TablePropertyDialogOraclev10g.this.currentSLGroup = (SupplementalLogGroup)TablePropertyDialogOraclev10g.this.slGroupsList.getSelectedValue();
                if (TablePropertyDialogOraclev10g.this.currentSLGroup != null) {
                    TablePropertyDialogOraclev10g.this.tfSLGroupName.setText(TablePropertyDialogOraclev10g.this.currentSLGroup.getName());
                    TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.setSelectedItem(TablePropertyDialogOraclev10g.this.currentSLGroup.getCondition());
                    for (ColumnProxy col : Arrays.asList(TablePropertyDialogOraclev10g.this.columnSet)) {
                        SupplementalColumn sc = new SupplementalColumn(col, true);
                        boolean found = false;
                        for (String id : Arrays.asList(TablePropertyDialogOraclev10g.this.currentSLGroup.getColumns().split(","))) {
                            if (!col.getObjectID().equals(id)) continue;
                            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.add(sc);
                            found = true;
                            break;
                        }
                        if (!found) {
                            for (String id : Arrays.asList(TablePropertyDialogOraclev10g.this.currentSLGroup.getColumnsNoLog().split(","))) {
                                if (!col.getObjectID().equals(id)) continue;
                                sc.setNoLog(false);
                                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList.add(sc);
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsList.add(sc);
                    }
                    TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.updateUI();
                    TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.updateUI();
                    TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.btnCancelSLGroup.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.btnRemoveSLGroup.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.btnEditSLGroup.setEnabled(true);
                } else {
                    TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(true);
                    TablePropertyDialogOraclev10g.this.btnCancelSLGroup.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.btnRemoveSLGroup.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(false);
                    TablePropertyDialogOraclev10g.this.btnEditSLGroup.setEnabled(false);
                }
            }
        }
    }

    private class SaveSLGroupAction
    implements ActionListener {
        private SaveSLGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (TablePropertyDialogOraclev10g.this.tfSLGroupName.getText().equals("")) {
                JOptionPane.showMessageDialog(TablePropertyDialogOraclev10g.this, Messages.getString("TablePropertyDialogOraclev10g.TheNameCanNotBeEmpty"), Messages.getString("TablePropertyDialogOraclev10g.Error"), 0);
            } else {
                String name = TablePropertyDialogOraclev10g.this.tfSLGroupName.getText();
                int counter = 0;
                while (TablePropertyDialogOraclev10g.this.nameExistsInModel(name, TablePropertyDialogOraclev10g.this.currentSLGroup)) {
                    name = TablePropertyDialogOraclev10g.this.tfSLGroupName.getText().concat("_").concat(Integer.toString(++counter));
                }
                TablePropertyDialogOraclev10g.this.currentSLGroup.setName(name);
                TablePropertyDialogOraclev10g.this.currentSLGroup.setCondition((String)TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.getSelectedItem());
                TablePropertyDialogOraclev10g.this.currentSLGroup.setColumns("");
                TablePropertyDialogOraclev10g.this.currentSLGroup.setColumnsNoLog("");
                String cols = "";
                String colsNoLog = "";
                for (SupplementalColumn sc : TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsList) {
                    if (sc.noLog) {
                        colsNoLog = colsNoLog + "," + sc.getColumn().getObjectID();
                        continue;
                    }
                    cols = cols + "," + sc.getColumn().getObjectID();
                }
                TablePropertyDialogOraclev10g.this.currentSLGroup.setColumns(cols);
                TablePropertyDialogOraclev10g.this.currentSLGroup.setColumnsNoLog(colsNoLog);
                boolean found = false;
                for (SupplementalLogGroup lg : TablePropertyDialogOraclev10g.this.localSLGroupsList) {
                    if (!lg.getId().equals(TablePropertyDialogOraclev10g.this.currentSLGroup.getId())) continue;
                    lg.setName(TablePropertyDialogOraclev10g.this.currentSLGroup.getName());
                    lg.setCondition(TablePropertyDialogOraclev10g.this.currentSLGroup.getCondition());
                    lg.setColumns(TablePropertyDialogOraclev10g.this.currentSLGroup.getColumns());
                    lg.setColumnsNoLog(TablePropertyDialogOraclev10g.this.currentSLGroup.getColumnsNoLog());
                    found = true;
                    break;
                }
                if (!found) {
                    TablePropertyDialogOraclev10g.this.localSLGroupsList.add(TablePropertyDialogOraclev10g.this.currentSLGroup);
                }
                TablePropertyDialogOraclev10g.this.tfSLGroupName.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.setEnabled(false);
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.clearSelection();
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.setEnabled(false);
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.clearSelection();
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.setEnabled(false);
                TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(true);
                TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(false);
                TablePropertyDialogOraclev10g.this.btnEditSLGroup.setEnabled(true);
                TablePropertyDialogOraclev10g.this.btnRemoveSLGroup.setEnabled(true);
                TablePropertyDialogOraclev10g.this.slGroupsList.setEnabled(true);
                TablePropertyDialogOraclev10g.this.isSLGroupSaved = true;
            }
        }
    }

    private class RemoveSLGroupAction
    implements ActionListener {
        private RemoveSLGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TablePropertyDialogOraclev10g.this.currentSLGroup = (SupplementalLogGroup)TablePropertyDialogOraclev10g.this.slGroupsList.getSelectedValue();
            int result = JOptionPane.showConfirmDialog(TablePropertyDialogOraclev10g.this, MessageFormat.format(Messages.getString("TablePropertyDialogOraclev10g.SureYouWantToDelete"), TablePropertyDialogOraclev10g.this.currentSLGroup.getName()), Messages.getString("TablePropertyDialogOraclev10g.SelectAnOption"), 0);
            if (result == 0) {
                TablePropertyDialogOraclev10g.this.slGroupsModel.remove(TablePropertyDialogOraclev10g.this.slGroupsList.getSelectedIndex());
                TablePropertyDialogOraclev10g.this.tfSLGroupName.setText("");
                TablePropertyDialogOraclev10g.this.tfSLGroupName.setEnabled(false);
                TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.setEnabled(false);
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.clearSelection();
                TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.setEnabled(false);
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.clearSelection();
                TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.setEnabled(false);
                TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(true);
                TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(false);
                TablePropertyDialogOraclev10g.this.slGroupsList.setEnabled(true);
                if (TablePropertyDialogOraclev10g.this.slGroupsModel.size() > 0) {
                    TablePropertyDialogOraclev10g.this.slGroupsList.setSelectedIndex(0);
                } else {
                    TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.updateUI();
                    TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.updateUI();
                }
            }
        }
    }

    private class CancelSLGroupAction
    implements ActionListener {
        private CancelSLGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }

    private class EditSLGroupAction
    implements ActionListener {
        private EditSLGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TablePropertyDialogOraclev10g.this.slGroupsList.setEnabled(false);
            TablePropertyDialogOraclev10g.this.tfSLGroupName.setEnabled(true);
            TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.setEnabled(true);
            TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.setEnabled(true);
            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.setEnabled(true);
            TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(false);
            TablePropertyDialogOraclev10g.this.btnEditSLGroup.setEnabled(false);
            TablePropertyDialogOraclev10g.this.btnRemoveSLGroup.setEnabled(false);
            TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(true);
            TablePropertyDialogOraclev10g.this.btnCancelSLGroup.setEnabled(true);
            TablePropertyDialogOraclev10g.this.isSLGroupSaved = false;
        }
    }

    private class AddSLGroupAction
    implements ActionListener {
        private AddSLGroupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SupplementalLogGroup slg = new SupplementalLogGroup(TablePropertyDialogOraclev10g.this.storageDesign);
            TablePropertyDialogOraclev10g.this.currentSLGroup = slg;
            String name = TablePropertyDialogOraclev10g.this.generateSLGroupName();
            slg.setName(name);
            TablePropertyDialogOraclev10g.this.slGroupsModel.addElement(slg);
            TablePropertyDialogOraclev10g.this.slGroupsList.setSelectedValue(slg, true);
            TablePropertyDialogOraclev10g.this.slGroupsList.setEnabled(false);
            TablePropertyDialogOraclev10g.this.tfSLGroupName.setText(name);
            TablePropertyDialogOraclev10g.this.tfSLGroupName.setEnabled(true);
            TablePropertyDialogOraclev10g.this.cbSLGrouoCondition.setEnabled(true);
            TablePropertyDialogOraclev10g.this.slGroupAvailableColumnsTable.setEnabled(true);
            TablePropertyDialogOraclev10g.this.slGroupSelectedColumnsTable.setEnabled(true);
            TablePropertyDialogOraclev10g.this.btnAddSLGroup.setEnabled(false);
            TablePropertyDialogOraclev10g.this.btnEditSLGroup.setEnabled(false);
            TablePropertyDialogOraclev10g.this.btnRemoveSLGroup.setEnabled(true);
            TablePropertyDialogOraclev10g.this.btnSaveSLGroup.setEnabled(true);
            TablePropertyDialogOraclev10g.this.isSLGroupSaved = false;
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.ifPctVersion.setEnabled(TablePropertyDialogOraclev10g.this.cbOldVersions.getSelectedItem().equals("PCT_VERSION"));
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean objectRelational;
            if (TablePropertyDialogOraclev10g.this.cbAllowAnySchema != null && TablePropertyDialogOraclev10g.this.cbAllowNonSchema != null) {
                boolean binaryXml = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("BINARY XML");
                TablePropertyDialogOraclev10g.this.cbAllowAnySchema.setEnabled(binaryXml);
                TablePropertyDialogOraclev10g.this.cbAllowNonSchema.setEnabled(binaryXml);
            }
            TablePropertyDialogOraclev10g.this.enableXMLTypeClobOptions(!(objectRelational = TablePropertyDialogOraclev10g.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL")));
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean partitioned = TablePropertyDialogOraclev10g.this.isPartitioned();
            int partitionedTabIndex = TablePropertyDialogOraclev10g.this.getPane().indexOfComponent(TablePropertyDialogOraclev10g.this.partitioningTab);
            if (partitionedTabIndex > -1) {
                TablePropertyDialogOraclev10g.this.getPane().setEnabledAt(partitionedTabIndex, partitioned);
            }
            TablePropertyDialogOraclev10g.this.partitionPropertyTab.reinitPartitioning(partitioned);
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev10g.this.dialog = new ObjectPermissionsDialogOracle(TablePropertyDialogOraclev10g.this.getAppView(), TablePropertyDialogOraclev10g.this.getStorageDesign(), TablePropertyDialogOraclev10g.this.table);
            TablePropertyDialogOraclev10g.this.dialog.showDialog();
        }
    }
}

