/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.CollectionTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class CollectionTypePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private CollectionTypeProxyOraclev9i type;
    private JComboBox cbOwner;
    private JTextField tfType;
    private JIntegerField ifMaxElement;
    private JTextField tfDataType;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public CollectionTypePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.type = (CollectionTypeProxyOraclev9i)object;
        this.setHeight(240);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("CollectionTypePropertyDialogOracle.CollectionTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initType();
        this.initMaxElement();
        this.initDataType();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initType() {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.CollectionType"));
        this.general.add(label);
        this.tfType = new JTextField("", 26);
        this.tfType.setEnabled(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfType, 80);
    }

    private void initMaxElement() {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.MaxElement"));
        this.general.add(label);
        this.ifMaxElement = new JIntegerField(0, 26);
        this.ifMaxElement.setEnabled(false);
        this.general.add(this.ifMaxElement);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifMaxElement, 110);
    }

    private void initDataType() {
        JLabel label = new JLabel(Messages.getString("CollectionTypePropertyDialogOracle.DataType"));
        this.general.add(label);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfDataType, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.tfType.setText(this.type.getType());
        this.ifMaxElement.setValue((long)this.type.getMaxElement());
        this.tfDataType.setText(this.type.getDataType());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("CollectionTypePropertyDialogOraclev9i.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 180);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CollectionTypePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(CollectionTypePropertyDialogOraclev9i.this.getAppView(), CollectionTypePropertyDialogOraclev9i.this.getStorageDesign(), CollectionTypePropertyDialogOraclev9i.this.type);
            CollectionTypePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

