/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StoredProcedurePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private StoredProcedureUDB proc;
    private JTextField tfOwner;
    private JTextArea bodyArea;
    private JComboBox cbScheme;
    private JTextField tfSpecificName;

    public StoredProcedurePropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.proc = (StoredProcedureUDB)object;
        this.setHeight(350);
        this.initCommentsView(105);
        this.initCommentsInRDBMS(105);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogUDB.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSpecificName();
        this.initScheme();
        this.initOwner();
        this.initBody();
    }

    private void initSpecificName() {
        JLabel label = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.SpecificName"));
        this.general.add(label);
        this.tfSpecificName = new JTextField("", 26);
        this.tfSpecificName.setEditable(false);
        this.general.add(this.tfSpecificName);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfSpecificName, 50);
    }

    private void initScheme() {
        JLabel label = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Scheme"));
        this.general.add(label);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Owner"));
        this.general.add(label);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initBody() {
        JLabel bodyLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Body"));
        this.general.add(bodyLabel);
        this.setLabelConstraints(bodyLabel, 140);
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        sp.setPreferredSize(new Dimension(395, 160));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(sp);
        this.setObjectConstraints(sp, 10, 160);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        this.tfSpecificName.setText(this.proc.getSpecificName());
        this.cbScheme.setSelectedItem(this.proc.getSchema());
        this.bodyArea.setText(this.proc.getBody());
        this.getCommentsList().insert(this.proc.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.proc.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.proc.setOwner(((SchemaUDB)selected).getOwner());
                this.proc.setSchema((SchemaUDB)selected);
            } else {
                this.proc.setOwner(null);
                this.proc.setSchema(null);
            }
            this.proc.setName(this.tfName.getText());
            String specName = this.proc.getSpecificNameFromBody(this.bodyArea.getText());
            this.tfSpecificName.setText(specName);
            this.proc.setSpecificName(specName);
            this.proc.setBody(this.bodyArea.getText());
            this.proc.setComment(this.getCommentsList().getText());
            this.proc.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedSchema = this.cbScheme.getSelectedItem();
        if (selectedSchema instanceof SchemaUDB) {
            newName = ((SchemaUDB)selectedSchema).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)StoredProcedurePropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    StoredProcedurePropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                } else {
                    StoredProcedurePropertyDialogUDB.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException e1) {
                StoredProcedurePropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

