/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.fcp.preferences.ReportsPreferences;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.search.JComboHtmlItem;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.wizards.metadata.ColorTableCellRenderer;
import oracle.dbtools.crest.swingui.wizards.metadata.DMConnectionModel;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.FCPConnectionDialog;
import oracle.dbtools.crest.swingui.wizards.reports.BaseReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportsTemplatesDialog;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSeparateFiles;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSingleFile;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.RenderPDFReport;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.SaxonLoader;
import oracle.dbtools.crest.swingui.wizards.reports.SearchResultsReportsGenerationDialog;
import oracle.dbtools.crest.swingui.wizards.reports.SelectGlossaryDialog;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfigurationsPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportsConfigurationDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.sql.ORAData;

public class ReportsGenerationDialog
extends BaseReportsGenerationDialog {
    private final String captionSingleTableDetails = "Table Details";
    private final String captionAllTablesDetails = "All Tables Details";
    private final String captionSingleTableViewDetails = "Table View Details";
    private final String captionAllTablesViewsDetails = "All Tables Views Details";
    private final String captionSingleEntityDetails = "Entity Details";
    private final String captionAllEntitiesDetails = "All Entities Details";
    private final String captionSingleEntityViewDetails = "Entity View Details";
    private final String captionAllEntitiesViewsDetails = "All Entities Views Details";
    private final String captionSingleSTDetails = "Structured Type Details";
    private final String captionAllSTDetails = "All Structured Types Details";
    private final String captionSingleDTDetails = "Distinct Type Details";
    private final String captionAllDTDetails = "All Distinct Types Details";
    private final String captionSingleCTDetails = "Collection Type Details";
    private final String captionAllCTDetails = "All Collection Type Details";
    private final String captionAllDomainDetails = "All Domains Details";
    private final String captionMeasurementsDetails = "Measurements Details";
    private final String captionUDP = "User Defined Properties";
    private final String captionGlossaryDetails = "Glossary Details";
    private final String captionCRDetails = "Change Requests Details";
    private static StandardReportConfiguration blankSR = new StandardReportConfiguration(null, " ", "", "", "", true, new ArrayList(), new ArrayList(), null);
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JPanel reportingSchemaPanel;
    private JPanel loadedDesignsPanel;
    private JComboBox cmbReports;
    private JComboBox cmbDesignsLDP = new JComboBox();
    private JComboBox cmbModelsLDP = new JComboBox();
    private JComboBox cmbStandardReportConfigurationsLDP = new JComboBox();
    private JButton btnStandardReportConfigurationsLDP = new JButton(Messages.getString("ReportsGenerationDialog.Manage"));
    private JComboBox cmbDesignsRSP = new JComboBox();
    private CmbDesignsRSPRenderer cmbDesignsRSPRenderer;
    private ArrayList cmbDesignsRSPTooltips = new ArrayList();
    private JComboBox cmbModelsRSP = new JComboBox();
    private JComboBox cmbStandardReportConfigurationsRSP = new JComboBox();
    private JButton btnStandardReportConfigurationsRSP = new JButton(Messages.getString("ReportsGenerationDialog.Manage"));
    private String selectedGlossaryOVID = "";
    private JTextField txtReportsDir = new JTextField();
    private JTable tbConnections = new JTable(new DMConnectionModel(DatabaseConnections.getInstance(), true));
    private JButton btnProps;
    private JButton btnRemove;
    private JButton btnTest;
    private JButton btnReloadDesignsAndModels;
    private static boolean srLoaded = false;
    private JButton btnAdd = new JButton();
    private JCheckBox chbClearLMDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.ClearDiagrams"));
    private JCheckBox chbClearRSDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.ClearDiagrams"));
    private JTabbedPane tpane;
    private static File lastFolder = null;
    private InputStream bfileBinaryStream;
    private Connection connection = null;
    private ReportsGenerationDialog rgd;
    private File xsltFile = null;
    private String tocTagName = "";
    private String reportFileName = "";
    private StandardReportConfigurationsPersistence srp;
    private List allConfigurationsList;
    private List allRSObjectsList;
    private ReportsComboListener reportsComboListener;
    private LDDesignsComboListener ldDesignsComboListener;
    private RSDesignsComboListener rsDesignsComboListener;
    private LDModelsComboListener ldModelsComboListener;
    private RSModelsComboListener rsModelsComboListener;
    private LDReportConfigurationsComboListener ldReportConfigurationsComboListener;
    private RSReportConfigurationsComboListener rsReportConfigurationsComboListener;
    private List allRSModelsList;
    private List allRSSubViewsList;
    private Class clazz;
    private BaseReportsGenerationDialog.ManageTemplatesAction manageTemplatesAction;
    private Array objects;
    private JPanel customReportsTemplatesPanel;
    private JButton btnManageCustomTemplates;
    private JCheckBox chbReplaceBooleanValues;
    private ReportUtils.SortedComboBoxModel cmbTrueModel;
    private ReportUtils.SortedComboBoxModel cmbFalseModel;
    private JComboBox cmbTrue;
    private JComboBox cmbFalse;
    private CustomReportTemplatesPersistence customReportTemplatesPersistence;
    private static boolean replaceBooleanValues;
    private MetaDataManager metaDataManager;
    private DesignPart currentModel;
    private HashMap<String, List> modelSchemas;
    private Settings settings;
    private JTabbedPane mainJTabbedPane;
    private JPanel jpGeneral;
    private JPanel jpObjects;
    private JLabel lblCompanyName;
    private JTextField txtCompanyName;
    private JLabel lblDefaultReportsPath;
    private JTextField txtDefaultReportsPath;
    private JTextField txtDefaultSaxonPath;
    private JCheckBox cbUsePageBreaks;
    private JCheckBox cbEmbedDiagrams;
    private JCheckBox cbEmbedMainDiagram;
    private JCheckBox cbGroupBySchema;
    private JCheckBox cbHTMLTOCInSeparateFile;
    private JCheckBox cbIncludeSelectStatement;
    private String reportsPath;
    public static final String cssFiles = "css/osddm_main.css css/osddm_vs.css";
    private static final Logger LOGGER;

    public ReportsGenerationDialog(ApplicationView appView, HashMap extraParams) {
        super(appView, Collections.emptyList(), extraParams);
        this.appView = appView;
        this.settings = appView.getSettings();
        this.rgd = this;
        this.customReportTemplatesPersistence = new CustomReportTemplatesPersistence(appView);
        this.mainPanel.setPreferredSize(new Dimension(540, 680));
        this.reportTemplatesPersistence = new ReportTemplatesPersistence(appView);
        this.loadReportTemplates();
        this.loadCustomReportTemplates();
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.srp = new StandardReportConfigurationsPersistence(appView);
        this.loadReportCinfigurations();
        this.allConfigurationsList = appView.getStandardReportConfigurations();
        this.reportsComboListener = new ReportsComboListener();
        this.ldDesignsComboListener = new LDDesignsComboListener();
        this.ldModelsComboListener = new LDModelsComboListener();
        this.ldReportConfigurationsComboListener = new LDReportConfigurationsComboListener();
        this.rsReportConfigurationsComboListener = new RSReportConfigurationsComboListener();
        this.rsDesignsComboListener = new RSDesignsComboListener();
        this.rsModelsComboListener = new RSModelsComboListener();
        this.jpGeneral = new JPanel();
        this.jpObjects = new JPanel();
        this.jpGeneral.add(this.reportsPanel);
        this.initNorthPanel();
        this.initCenterPanel();
        this.cmbReports.setSelectedIndex(-1);
        this.cmbReports.setSelectedIndex(0);
        this.mainJTabbedPane = new JTabbedPane();
        this.mainJTabbedPane.addTab(Messages.getString("ReportsGenerationDialog.General"), this.jpGeneral);
        this.mainJTabbedPane.addTab(Messages.getString("ReportsGenerationDialog.Objects"), this.jpObjects);
        this.mainPanel.remove(this.reportsPanel);
        this.mainPanel.add(this.mainJTabbedPane);
    }

    @Override
    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void initNorthPanel() {
        this.reportsPanel.setPreferredSize(new Dimension(500, 450));
        JLabel lblReports = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableReports"));
        lblReports.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), lblReports, 5, 3);
        this.cmbReports = new JComboBox();
        this.cmbReports.setMaximumRowCount(20);
        this.cmbReports.setPreferredSize(new Dimension(290, 20));
        for (String r : this.getReportsList()) {
            this.cmbReports.addItem(r);
        }
        this.cmbReports.addItemListener(this.reportsComboListener);
        this.clazz = Table.class;
        this.reportsPanel.add(lblReports);
        this.reportsPanel.add(this.cmbReports);
        this.lblCompanyName = new JLabel(Messages.getString("ReportsGenerationDialog.CompanyName"));
        this.txtCompanyName = new JTextField();
        this.txtCompanyName.setPreferredSize(new Dimension(275, 20));
        this.cbUsePageBreaks = new JCheckBox(Messages.getString("ReportsGenerationDialog.InsertPageBreaks"));
        this.cbEmbedDiagrams = new JCheckBox(Messages.getString("ReportsGenerationDialog.EmbedDiagrams"));
        this.cbEmbedMainDiagram = new JCheckBox(Messages.getString("ReportsGenerationDialog.EmbedMainDiagram"));
        this.cbGroupBySchema = new JCheckBox(Messages.getString("ReportsGenerationDialog.GroupObjectsBySchema"));
        this.cbIncludeSelectStatement = new JCheckBox(Messages.getString("ReportsGenerationDialog.IncludeSelectStatement"));
        this.cbHTMLTOCInSeparateFile = new JCheckBox(Messages.getString("ReportsGenerationDialog.HTMLTOCInSeparateFile"));
        JPanel rmPanel = new JPanel(new SpringLayout());
        rmPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.RelModelReport")));
        rmPanel.setPreferredSize(new Dimension(470, 50));
        rmPanel.add(this.cbGroupBySchema);
        JPanel pathsPanel = new JPanel(new SpringLayout());
        pathsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Paths")));
        pathsPanel.setPreferredSize(new Dimension(470, 90));
        this.lblDefaultReportsPath = new JLabel(Messages.getString("ReportsGenerationDialog.ReportsDirectory"));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), this.lblDefaultReportsPath, 5, 5);
        this.txtDefaultReportsPath = new JTextField();
        this.txtDefaultReportsPath.setPreferredSize(new Dimension(220, 20));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), this.txtDefaultReportsPath, 150, 5);
        JButton bnSelectDefaultReportsPath = new JButton(Messages.getString("ReportsGenerationDialog.Select"));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), bnSelectDefaultReportsPath, 380, 3);
        bnSelectDefaultReportsPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ReportsGenerationDialog.this.txtDefaultReportsPath.getText()));
                fileChooser.setPathContext("dataModeler_Reports");
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsGenerationDialog.SelectDirectory"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ReportsGenerationDialog.this.txtDefaultReportsPath.setText(file.getAbsolutePath());
                }
            }
        });
        pathsPanel.add(this.lblDefaultReportsPath);
        pathsPanel.add(this.txtDefaultReportsPath);
        pathsPanel.add(bnSelectDefaultReportsPath);
        JLabel lblDefaultSaxonPath = new JLabel(Messages.getString("ReportsGenerationDialog.SaxonJARFile"));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), lblDefaultSaxonPath, 5, 30);
        this.txtDefaultSaxonPath = new JTextField();
        this.txtDefaultSaxonPath.setPreferredSize(new Dimension(220, 20));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), this.txtDefaultSaxonPath, 150, 30);
        JButton bnSelectSaxonJAR = new JButton(Messages.getString("ReportsGenerationDialog.Select"));
        CommonUtil.setObjectConstraints((SpringLayout)pathsPanel.getLayout(), bnSelectSaxonJAR, 380, 28);
        bnSelectSaxonJAR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)ReportsGenerationDialog.this.txtDefaultSaxonPath.getText()));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsGenerationDialog.SelectSaxonJARFIle"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    ReportsGenerationDialog.this.txtDefaultSaxonPath.setText(file.getAbsolutePath());
                }
            }
        });
        pathsPanel.add(lblDefaultSaxonPath);
        pathsPanel.add(this.txtDefaultSaxonPath);
        pathsPanel.add(bnSelectSaxonJAR);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.cmbReports, 140, 5);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblOutFormat, 5, 30);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.cmbOutFormat, 140, 30);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblVMOptions, 250, 30);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtVMOptions, 330, 30);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblTtitle, 5, 55);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportTtitle, 140, 55);
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblFileName, 5, 80);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportFileName, 140, 80);
        JPanel optionsPanel = new JPanel(new SpringLayout());
        optionsPanel.setPreferredSize(new Dimension(485, 320));
        optionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Options")));
        CommonUtil.setLabelConstraints((SpringLayout)optionsPanel.getLayout(), this.lblCompanyName, 5, 5);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.txtCompanyName, 140, 5);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbUsePageBreaks, 5, 30);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbEmbedDiagrams, 5, 55);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbEmbedMainDiagram, 5, 80);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbHTMLTOCInSeparateFile, 5, 105);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbIncludeSelectStatement, 5, 130);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), rmPanel, 0, 155);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), pathsPanel, 0, 205);
        CommonUtil.setObjectConstraints((SpringLayout)rmPanel.getLayout(), this.cbGroupBySchema, 5, 3);
        optionsPanel.add(this.lblCompanyName);
        optionsPanel.add(this.txtCompanyName);
        optionsPanel.add(this.cbUsePageBreaks);
        optionsPanel.add(this.cbEmbedDiagrams);
        optionsPanel.add(this.cbEmbedMainDiagram);
        optionsPanel.add(this.cbIncludeSelectStatement);
        optionsPanel.add(this.cbHTMLTOCInSeparateFile);
        optionsPanel.add(rmPanel);
        optionsPanel.add(pathsPanel);
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), optionsPanel, 0, 105);
        this.reportsPanel.add(optionsPanel);
        this.txtCompanyName.setText(this.settings.getReportsCompanyName());
        this.cbUsePageBreaks.setSelected(this.settings.isUsePageBreaksInReports());
        this.cbEmbedDiagrams.setSelected(this.settings.isEmbedDiagramsInReports());
        this.cbEmbedMainDiagram.setSelected(this.settings.isEmbedMainDiagramInReports());
        this.cbGroupBySchema.setSelected(this.settings.isGroupBySchemaNameInReports());
        this.cbHTMLTOCInSeparateFile.setSelected(this.settings.isGenerateHTMLReportTOCInSeparateFile());
        this.cbIncludeSelectStatement.setSelected(this.settings.isIncludeSelectStatementInViewReport());
        this.txtDefaultReportsPath.setText(this.settings.getDefaultReportsPath());
        this.txtDefaultSaxonPath.setText(this.settings.getDefaultSaxonPath());
    }

    private void initCenterPanel() {
        this.standardReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.standardReportsTemplatesPanel.setPreferredSize(new Dimension(400, 60));
        this.cmbStandardTemplates = new JComboBox();
        this.cmbStandardTemplates.setPreferredSize(new Dimension(330, 20));
        this.cmbStandardTemplates.setRenderer(new BaseReportsGenerationDialog.StandardComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.cmbStandardTemplates, 5, 5);
        this.btnManageStandardTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageStandardTemplates.setMnemonic(77);
        CommonUtil.setObjectConstraints((SpringLayout)this.standardReportsTemplatesPanel.getLayout(), this.btnManageStandardTemplates, 345, 3);
        this.manageTemplatesAction = new BaseReportsGenerationDialog.ManageTemplatesAction();
        this.btnManageStandardTemplates.addActionListener(this.manageTemplatesAction);
        this.standardReportsTemplatesPanel.add(this.cmbStandardTemplates);
        this.standardReportsTemplatesPanel.add(this.btnManageStandardTemplates);
        this.customReportsTemplatesPanel = new JPanel(new SpringLayout());
        this.cmbCustomTemplates = new JComboBox();
        this.cmbCustomTemplates.setPreferredSize(new Dimension(330, 20));
        this.cmbCustomTemplates.setRenderer(new BaseReportsGenerationDialog.CustomComboBoxRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbCustomTemplates, 5, 5);
        this.cmbCustomTemplates.removeAllItems();
        this.cmbCustomTemplates.addItem(blankCRT);
        for (CustomReportTemplate crt : this.appView.getCustomReportTemplates()) {
            if (crt.getClazz() != this.clazz) continue;
            this.cmbCustomTemplates.addItem(crt);
        }
        this.cmbCustomTemplates.updateUI();
        this.btnManageCustomTemplates = new JButton(Messages.getString("ReportTemplatesDialog.Manage"));
        this.btnManageCustomTemplates.setMnemonic(77);
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.btnManageCustomTemplates, 345, 3);
        this.btnManageCustomTemplates.addActionListener(new CustomReportsAction());
        this.chbReplaceBooleanValues = new JCheckBox(Messages.getString("BaseReportsGenerationDialog.ReplaceBooleanValues"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.chbReplaceBooleanValues, 5, 35);
        JLabel lblTrue = new JLabel(Messages.getString("BaseReportsGenerationDialog.True"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblTrue, 190, 35);
        this.cmbTrueModel = new ReportUtils.SortedComboBoxModel(arrTrue);
        this.cmbTrue = new JComboBox(this.cmbTrueModel);
        this.cmbTrue.setEnabled(false);
        this.cmbTrue.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbTrue, 230, 35);
        this.cmbTrue.setEditable(true);
        JLabel lblFalse = new JLabel(Messages.getString("BaseReportsGenerationDialog.False"));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), lblFalse, 315, 35);
        this.cmbFalseModel = new ReportUtils.SortedComboBoxModel(arrFalse);
        this.cmbFalse = new JComboBox(this.cmbFalseModel);
        this.cmbFalse.setEnabled(false);
        this.cmbFalse.setPreferredSize(new Dimension(60, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.customReportsTemplatesPanel.getLayout(), this.cmbFalse, 355, 35);
        this.cmbFalse.setEditable(true);
        this.chbReplaceBooleanValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReportsGenerationDialog.this.cmbTrue.setEnabled(true);
                    ReportsGenerationDialog.this.cmbFalse.setEnabled(true);
                    replaceBooleanValues = true;
                } else {
                    ReportsGenerationDialog.this.cmbTrue.setEnabled(false);
                    ReportsGenerationDialog.this.cmbFalse.setEnabled(false);
                    replaceBooleanValues = false;
                }
                ReportsGenerationDialog.this.chbReplaceBooleanValues.setSelected(replaceBooleanValues);
            }
        });
        this.chbReplaceBooleanValues.setSelected(false);
        this.customReportsTemplatesPanel.add(this.cmbCustomTemplates);
        this.customReportsTemplatesPanel.add(this.btnManageCustomTemplates);
        this.customReportsTemplatesPanel.add(this.chbReplaceBooleanValues);
        this.customReportsTemplatesPanel.add(lblTrue);
        this.customReportsTemplatesPanel.add(lblFalse);
        this.customReportsTemplatesPanel.add(this.cmbTrue);
        this.customReportsTemplatesPanel.add(this.cmbFalse);
        this.templatesTabbedPane = new JTabbedPane();
        this.templatesTabbedPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportTemplatesDialog.ReportTemplates")));
        this.templatesTabbedPane.setPreferredSize(new Dimension(500, 135));
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Standard"), this.standardReportsTemplatesPanel);
        this.templatesTabbedPane.addTab(Messages.getString("BaseReportsGenerationDialog.Custom"), this.customReportsTemplatesPanel);
        this.templatesTabbedPane.setToolTipTextAt(1, Messages.getString("ReportsGenerationDialog.LoadedDesignsOnly"));
        this.templatesTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("RTF");
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLS") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("XLS");
                    }
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("XLSX") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("XLSX");
                    }
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.loadedDesignsPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.reportingSchemaPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    }
                } else if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.standardReportsTemplatesPanel) {
                    if (ReportsGenerationDialog.this.cmbFormatsmodel.getIndexOf("RTF") == -1) {
                        ReportsGenerationDialog.this.cmbOutFormat.addItem("RTF");
                    }
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("XLS");
                    ReportsGenerationDialog.this.cmbOutFormat.removeItem("XLSX");
                    if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    }
                }
            }
        });
        JPanel designsPanel = new JPanel(new BorderLayout());
        designsPanel.setPreferredSize(new Dimension(500, 528));
        this.tpane = new JTabbedPane();
        this.tpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    ReportsGenerationDialog.this.adjustSettings(false);
                    if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.loadedDesignsPanel) {
                        if (!((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                            ReportsGenerationDialog.this.cmbCustomTemplates.setEnabled(true);
                            ReportsGenerationDialog.this.btnManageCustomTemplates.setEnabled(true);
                            ReportsGenerationDialog.this.chbReplaceBooleanValues.setEnabled(true);
                            ReportsGenerationDialog.this.cmbFalse.setEnabled(true);
                            ReportsGenerationDialog.this.cmbTrue.setEnabled(true);
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                        }
                    } else if (ReportsGenerationDialog.this.tpane.getSelectedComponent() == ReportsGenerationDialog.this.reportingSchemaPanel) {
                        ReportsGenerationDialog.this.cmbCustomTemplates.setEnabled(false);
                        ReportsGenerationDialog.this.btnManageCustomTemplates.setEnabled(false);
                        ReportsGenerationDialog.this.chbReplaceBooleanValues.setEnabled(false);
                        ReportsGenerationDialog.this.cmbFalse.setEnabled(false);
                        ReportsGenerationDialog.this.cmbTrue.setEnabled(false);
                        if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                        } else if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.standardReportsTemplatesPanel) {
                            ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.initDesignsPanel();
        this.initReportingSchemaPanel();
        designsPanel.add(this.tpane);
        this.jpGeneral.add(this.templatesTabbedPane);
        this.jpObjects.add(designsPanel);
    }

    private void initDesignsPanel() {
        this.loadedDesignsPanel = new JPanel(new SpringLayout());
        JLabel lblDesigns = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableDesigns"));
        lblDesigns.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblDesigns, 5, 5);
        this.loadedDesignsPanel.add(lblDesigns);
        Object[] designs = this.appView.getDesigns().toArray();
        for (int l = 0; l < designs.length; ++l) {
            this.cmbDesignsLDP.addItem(designs[l]);
        }
        this.cmbDesignsLDP.addItemListener(this.ldDesignsComboListener);
        this.cmbDesignsLDP.setPreferredSize(new Dimension(275, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbDesignsLDP, 167, 5);
        this.loadedDesignsPanel.add(this.cmbDesignsLDP);
        JLabel lblModels = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableModels"));
        lblModels.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblModels, 5, 40);
        this.loadedDesignsPanel.add(lblModels);
        this.cmbModelsLDP.setPreferredSize(new Dimension(275, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbModelsLDP, 167, 40);
        this.loadedDesignsPanel.add(this.cmbModelsLDP);
        ReportUtils.SortedComboBoxModel cmbStandardReportConfigurationsLDPModel = new ReportUtils.SortedComboBoxModel();
        this.cmbStandardReportConfigurationsLDP.setModel(cmbStandardReportConfigurationsLDPModel);
        this.cmbStandardReportConfigurationsLDP.setPreferredSize(new Dimension(188, 20));
        this.cmbStandardReportConfigurationsLDP.setRenderer(new StandardReportRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.cmbStandardReportConfigurationsLDP, 167, 75);
        this.loadedDesignsPanel.add(this.cmbStandardReportConfigurationsLDP);
        JLabel lblStandardReports = new JLabel(Messages.getString("ReportsGenerationDialog.ReportConfiguration"));
        lblStandardReports.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), lblStandardReports, 5, 75);
        this.loadedDesignsPanel.add(lblStandardReports);
        this.btnStandardReportConfigurationsLDP.addActionListener(new ShowStandardReportConfigurationsAction());
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.btnStandardReportConfigurationsLDP, 360, 73);
        this.loadedDesignsPanel.add(this.btnStandardReportConfigurationsLDP);
        this.chbClearLMDiagrams.setToolTipText(Messages.getString("ReportsGenerationDialog.ClearDiagramsTooltip"));
        CommonUtil.setObjectConstraints((SpringLayout)this.loadedDesignsPanel.getLayout(), this.chbClearLMDiagrams, 0, 110);
        this.loadedDesignsPanel.add(this.chbClearLMDiagrams);
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.LoadedDesigns"), this.loadedDesignsPanel);
        this.reloadModels();
        this.reloadReportConfigurations(true);
    }

    private void reloadModels() {
        if (this.tpane.getSelectedIndex() == 0) {
            this.cmbModelsLDP.removeItemListener(this.ldModelsComboListener);
            this.cmbModelsLDP.removeAllItems();
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.cmbModelsRSP.removeItemListener(this.rsModelsComboListener);
            this.cmbModelsRSP.removeAllItems();
        }
        List fullList = this.getFullModelList();
        if (fullList != null) {
            Iterator it = fullList.iterator();
            if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entity Views")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof LogicalDesign) {
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals("Logical") || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Table Views")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof RelationalDesign) {
                        if (!((RelationalDesign)ob).isLoaded()) continue;
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals("Relational") || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types") || ((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                while (it.hasNext()) {
                    RSchemaModel rSchemaModel;
                    Object ob = it.next();
                    if (ob instanceof DataTypesDesign) {
                        this.cmbModelsLDP.addItem(ob);
                        continue;
                    }
                    if (!(ob instanceof RSchemaModel) || !(rSchemaModel = (RSchemaModel)ob).getType().equals(Messages.getString("ReportsGenerationDialog.DataTypes")) || !rSchemaModel.getDesignOVID().equals(((RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID())) continue;
                    this.cmbModelsRSP.addItem(rSchemaModel);
                }
            }
            if (this.tpane.getSelectedIndex() == 0) {
                this.cmbModelsLDP.addItemListener(this.ldModelsComboListener);
                this.cmbModelsLDP.setSelectedIndex(-1);
                if (this.cmbModelsLDP.getModel().getSize() > 0) {
                    this.cmbModelsLDP.setSelectedIndex(0);
                }
            } else if (this.tpane.getSelectedIndex() == 1) {
                this.cmbModelsRSP.addItemListener(this.rsModelsComboListener);
                this.cmbModelsRSP.setSelectedIndex(-1);
                if (this.cmbModelsRSP.getModel().getSize() > 0) {
                    this.cmbModelsRSP.setSelectedIndex(0);
                }
            }
        }
    }

    private void initReportingSchemaPanel() {
        JPanel dirPanel = new JPanel(new SpringLayout());
        dirPanel.setPreferredSize(new Dimension(400, 50));
        dirPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ServerDir")));
        JLabel lblDir = new JLabel(Messages.getString("ReportsGenerationDialog.DirPath"));
        lblDir.setPreferredSize(new Dimension(130, 20));
        CommonUtil.setLabelConstraints((SpringLayout)dirPanel.getLayout(), lblDir, 5, 3);
        dirPanel.add(lblDir);
        this.txtReportsDir = new JTextField();
        this.txtReportsDir.setToolTipText(Messages.getString("ReportsGenerationDialog.ReportsDirTooltip"));
        this.txtReportsDir.setPreferredSize(new Dimension(272, 20));
        CommonUtil.setObjectConstraints((SpringLayout)dirPanel.getLayout(), this.txtReportsDir, 150, 3);
        dirPanel.add(this.txtReportsDir);
        this.tbConnections.setSelectionMode(0);
        this.tbConnections.setDefaultRenderer(Object.class, new ColorTableCellRenderer());
        this.tbConnections.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReportsGenerationDialog.this.showConnectionProperties();
                } else {
                    boolean enabled = ReportsGenerationDialog.this.tbConnections.getSelectedRow() > -1;
                    ReportsGenerationDialog.this.btnTest.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnReloadDesignsAndModels.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnProps.setEnabled(enabled);
                    ReportsGenerationDialog.this.btnRemove.setEnabled(enabled);
                }
            }
        });
        this.tbConnections.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = ReportsGenerationDialog.this.tbConnections.getSelectedRow();
                if (!e.getValueIsAdjusting()) {
                    if (selRow == -1) {
                        ReportsGenerationDialog.this.cmbDesignsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbModelsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.cmbDesignsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbModelsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.removeAllItems();
                        ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                        ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.tbConnections);
        sp.setPreferredSize(new Dimension(100, 50));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JPanel pnConnections = new JPanel(new BorderLayout());
        pnConnections.setPreferredSize(new Dimension(100, 90));
        pnConnections.add((Component)new JLabel(Messages.getString("ReportsGenerationDialog.Connections")), "North");
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(200, 23));
        this.btnProps = new JButton(configuration.getIcon("EDIT_ICON", 16));
        this.btnProps.setToolTipText(Messages.getString("ReportsGenerationDialog.ConnectionProperties"));
        this.btnProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportsGenerationDialog.this.showConnectionProperties();
            }
        });
        this.btnProps.setEnabled(false);
        this.btnAdd.setIcon(configuration.getIcon("ADD_ICON", 16));
        this.btnAdd.setToolTipText(Messages.getString("ReportsGenerationDialog.AddConnection"));
        this.btnAdd.addActionListener(new AddAction());
        this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setToolTipText(Messages.getString("ReportsGenerationDialog.RemoveConnection"));
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setEnabled(false);
        this.btnTest = new JButton(configuration.getIcon("DESIGN_RULES_ICON", 16));
        this.btnTest.setToolTipText(Messages.getString("ReportsGenerationDialog.TestConnection"));
        this.btnTest.addActionListener(new TestAction());
        this.btnTest.setEnabled(false);
        this.btnReloadDesignsAndModels = new JButton(configuration.getIcon("REFRESH_ICON", 16));
        this.btnReloadDesignsAndModels.setToolTipText(Messages.getString("ReportsGenerationDialog.ReloadDesignsAndModels"));
        this.btnReloadDesignsAndModels.addActionListener(new ReloadDesignsAndModelsAction());
        this.btnReloadDesignsAndModels.setEnabled(false);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.btnProps);
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnTest);
        toolBar.add(this.btnReloadDesignsAndModels);
        buttonGeneral.add(toolBar);
        pnConnections.add((Component)buttonGeneral, "North");
        pnConnections.add((Component)sp, "Center");
        this.updateConnections();
        JPanel designModelConfigPanel = new JPanel(new SpringLayout());
        designModelConfigPanel.setPreferredSize(new Dimension(100, 120));
        JLabel lblDesigns = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableDesigns"));
        lblDesigns.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblDesigns, 5, 25);
        designModelConfigPanel.add(lblDesigns);
        this.cmbDesignsRSP.setPreferredSize(new Dimension(262, 20));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbDesignsRSP, 160, 25);
        designModelConfigPanel.add(this.cmbDesignsRSP);
        this.cmbDesignsRSPRenderer = new CmbDesignsRSPRenderer();
        this.cmbDesignsRSP.setRenderer(this.cmbDesignsRSPRenderer);
        this.cmbDesignsRSP.setEnabled(false);
        JLabel lblModels = new JLabel(Messages.getString("ReportsGenerationDialog.AvailableModels"));
        lblModels.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblModels, 5, 50);
        designModelConfigPanel.add(lblModels);
        this.cmbModelsRSP.setPreferredSize(new Dimension(262, 20));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbModelsRSP, 160, 50);
        designModelConfigPanel.add(this.cmbModelsRSP);
        this.cmbModelsRSP.setRenderer(new CmbModelsRSPRenderer());
        this.cmbModelsRSP.setEnabled(false);
        ReportUtils.SortedComboBoxModel cmbStandardReportConfigurationsRSPModel = new ReportUtils.SortedComboBoxModel();
        this.cmbStandardReportConfigurationsRSP.setModel(cmbStandardReportConfigurationsRSPModel);
        this.cmbStandardReportConfigurationsRSP.setPreferredSize(new Dimension(185, 20));
        this.cmbStandardReportConfigurationsRSP.setRenderer(new StandardReportRenderer());
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.cmbStandardReportConfigurationsRSP, 160, 75);
        designModelConfigPanel.add(this.cmbStandardReportConfigurationsRSP);
        this.cmbStandardReportConfigurationsRSP.setEnabled(false);
        JLabel lblStandardReports = new JLabel(Messages.getString("ReportsGenerationDialog.ReportConfiguration"));
        lblStandardReports.setPreferredSize(new Dimension(140, 20));
        CommonUtil.setLabelConstraints((SpringLayout)designModelConfigPanel.getLayout(), lblStandardReports, 5, 75);
        designModelConfigPanel.add(lblStandardReports);
        this.btnStandardReportConfigurationsRSP.addActionListener(new ShowStandardReportConfigurationsAction());
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.btnStandardReportConfigurationsRSP, 350, 75);
        designModelConfigPanel.add(this.btnStandardReportConfigurationsRSP);
        this.btnStandardReportConfigurationsRSP.setEnabled(false);
        this.chbClearRSDiagrams.setToolTipText(Messages.getString("ReportsGenerationDialog.ClearDiagramsTooltip"));
        CommonUtil.setObjectConstraints((SpringLayout)designModelConfigPanel.getLayout(), this.chbClearRSDiagrams, 5, 100);
        designModelConfigPanel.add(this.chbClearRSDiagrams);
        this.reportingSchemaPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.ReportingSchema")));
        southPanel.setPreferredSize(new Dimension(400, 360));
        southPanel.add((Component)pnConnections, "Center");
        southPanel.add((Component)designModelConfigPanel, "South");
        this.reportingSchemaPanel.add((Component)dirPanel, "North");
        this.reportingSchemaPanel.add((Component)southPanel, "Center");
        this.tpane.addTab(Messages.getString("ReportsGenerationDialog.UseReportingSchema"), this.reportingSchemaPanel);
    }

    private Properties getSelectedConnectionProperties() {
        Properties cd = null;
        try {
            cd = ((DMConnectionModel)this.tbConnections.getModel()).getRowData(this.tbConnections.getSelectedRow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cd;
    }

    private void showConnectionProperties() {
        Properties cd = this.getSelectedConnectionProperties();
        if (cd != null) {
            String connName = ConnectionInfo.getConnectionName(cd);
            FCPConnectionDialog.showConnectionDialog(connName, true);
            this.updateConnections();
        }
    }

    private void closeConnection() {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
                this.connection = null;
            }
            catch (Exception e) {
                LOGGER.error("Unable to close the connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initConnection() {
        block5: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.closeConnection();
                Properties cd = this.getSelectedConnectionProperties();
                if (cd == null) break block5;
                try {
                    this.connection = DatabaseConnections.getInstance().getConnection(cd);
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(e.getLocalizedMessage());
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.connection != null;
    }

    private ArrayList<String> getReportsList() {
        ArrayList<String> reports = new ArrayList<String>();
        reports.add("Tables");
        reports.add("Table Views");
        reports.add("Entities");
        reports.add("Entity Views");
        reports.add("Domains");
        reports.add("Glossaries");
        reports.add("Structured Types");
        reports.add("Distinct Types");
        reports.add("Collection Types");
        reports.add("Change Requests");
        reports.add("Measurements");
        reports.add("User Defined Properties");
        return reports;
    }

    private ArrayList<String> getOutTypesList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("RTF");
        types.add("HTML");
        types.add("PDF");
        return types;
    }

    private void updateConnections() {
        ((DMConnectionModel)this.tbConnections.getModel()).reReadConnections();
    }

    public JComboBox getCmbReports() {
        return this.cmbReports;
    }

    private void applyToSettings() {
        this.settings.setReportsCompanyName(this.txtCompanyName.getText());
        this.settings.setUsePageBreaksInReports(this.cbUsePageBreaks.isSelected());
        this.settings.setEmbedDiagramsInReports(this.cbEmbedDiagrams.isSelected());
        this.settings.setEmbedMainDiagramInReports(this.cbEmbedMainDiagram.isSelected());
        this.settings.setGroupBySchemaNameInReports(this.cbGroupBySchema.isSelected());
        this.settings.setIncludeSelectStatementInViewReport(this.cbIncludeSelectStatement.isSelected());
        this.settings.setGenerateHTMLReportTOCInSeparateFile(this.cbHTMLTOCInSeparateFile.isSelected());
        this.settings.setDefaultSaxonPath(this.txtDefaultSaxonPath.getText());
        this.settings.setDefaultReportsPath(this.txtDefaultReportsPath.getText());
        Preferences p = Preferences.getPreferences();
        ReportsPreferences rp = ReportsPreferences.getInstance((PropertyStorage)p);
        rp.setCompanyName(this.txtCompanyName.getText());
        rp.setUsePageBreaks(this.cbUsePageBreaks.isSelected());
        rp.setEmbedDiagrams(this.cbEmbedDiagrams.isSelected());
        rp.setEmbedMainDiagram(this.cbEmbedMainDiagram.isSelected());
        rp.setGroupBySchemaName(this.cbGroupBySchema.isSelected());
        rp.setIncludeSelectStatementInViewReports(this.cbIncludeSelectStatement.isSelected());
        rp.setGenerateHTMLReportTOCInSeparateFile(this.cbHTMLTOCInSeparateFile.isSelected());
        rp.setDefaultReportsPath(this.txtDefaultReportsPath.getText());
        rp.setDefaultSaxonPath(this.txtDefaultSaxonPath.getText());
    }

    @Override
    protected void generateReport() {
        this.applyToSettings();
        this.reportsPath = ReportUtils.getReportsPath(this.appView);
        boolean go = true;
        if (this.tpane.getSelectedIndex() == 1) {
            if ((this.clazz == Table.class || this.clazz == TableView.class || this.clazz == Entity.class || this.clazz == EntityView.class || this.clazz == Domain.class || this.clazz == StructuredType.class || this.clazz == CollectionType.class || this.clazz == DistinctType.class || this.clazz == ChangeRequest.class || this.clazz == Measurement.class || this.clazz == UserDefinedProperty.class) && this.cmbDesignsRSP.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ReportCanNotBeGenerated_v1"), Messages.getString("ReportsGenerationDialog.Warning"), 2);
                go = false;
            } else if (this.clazz == Glossary.class && this.tbConnections.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ReportCanNotBeGenerated_v2"), Messages.getString("ReportsGenerationDialog.Warning"), 2);
                go = false;
            }
        }
        if (go) {
            this.generate();
        }
    }

    private void generate() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block194: {
                    try {
                        block195: {
                            reportTemplate = (StandardReportTemplate)ReportsGenerationDialog.this.cmbStandardTemplates.getSelectedItem();
                            ReportsGenerationDialog.this.extraParams.put("out_format", (String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("vm_options", ReportsGenerationDialog.this.txtVMOptions.getText());
                            ReportsGenerationDialog.this.extraParams.put("report_template", reportTemplate);
                            ReportsGenerationDialog.this.extraParams.put("parent", ReportsGenerationDialog.this);
                            ReportsGenerationDialog.this.extraParams.put("reportCaption", ReportsGenerationDialog.this.txtReportTtitle.getText());
                            ReportsGenerationDialog.this.extraParams.put("clearDiagrams", ReportsGenerationDialog.access$4700(ReportsGenerationDialog.this).isSelected());
                            ReportsGenerationDialog.this.extraParams.put("reportCustomFilenName", ReportsGenerationDialog.this.txtReportFileName.getText());
                            ReportsGenerationDialog.this.extraParams.put("show", false);
                            ReportsGenerationDialog.this.extraParams.put("filterObject", "");
                            ReportsGenerationDialog.this.extraParams.put("custom_report_template", (CustomReportTemplate)ReportsGenerationDialog.this.cmbCustomTemplates.getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("pboolean", ReportsGenerationDialog.access$1300(ReportsGenerationDialog.this).isSelected());
                            ReportsGenerationDialog.this.extraParams.put("ptrue", ReportsGenerationDialog.access$1000(ReportsGenerationDialog.this).getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("pfalse", ReportsGenerationDialog.access$1100(ReportsGenerationDialog.this).getSelectedItem());
                            ReportsGenerationDialog.this.extraParams.put("cssFiles", "css/osddm_main.css css/osddm_vs.css");
                            if (ReportsGenerationDialog.access$1600(ReportsGenerationDialog.this).getSelectedIndex() != 0) break block195;
                            glossary = null;
                            if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Glossary.class) {
                                glossary = ReportsGenerationDialog.access$4800(ReportsGenerationDialog.this);
                            }
                            ReportsGenerationDialog.this.extraParams.put("glossary", glossary);
                            model = (DesignPart)ReportsGenerationDialog.access$4200(ReportsGenerationDialog.this).getSelectedItem();
                            if (model == null) {
                                model = ((Design)ReportsGenerationDialog.access$4100(ReportsGenerationDialog.this).getSelectedItem()).getLogicalDesign();
                            }
                            objects = new ArrayList<Object>();
                            if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == UserDefinedProperty.class) {
                                objects.add((SearchResultObject)model.getDesign().getUserDefinedProperties());
                            } else if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Domain.class) {
                                objects.add((SearchResultObject)model.getDesign().getDomainSet());
                            }
                            ReportsGenerationDialog.this.g = new ReportsGenerator(ReportsGenerationDialog.this.appView);
                            if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() != 0) ** GOTO lbl68
                            if (ReportsGenerationDialog.access$4900(ReportsGenerationDialog.this).getSelectedItem() == ReportsGenerationDialog.access$5000()) {
                                tempL = ReportsGenerationDialog.access$4000(ReportsGenerationDialog.this);
                                for (ReportObject obj : tempL) {
                                    objects.add((SearchResultObject)obj.getObject());
                                }
                                ReportsGenerationDialog.this.extraParams.put("subviews", new HashMap<K, V>());
                            } else {
                                srConfig = (StandardReportConfiguration)ReportsGenerationDialog.access$4900(ReportsGenerationDialog.this).getSelectedItem();
                                objects = ReportsGenerationDialog.access$5100(ReportsGenerationDialog.this, model, srConfig.getObjects());
                                ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.access$5200(ReportsGenerationDialog.this, model, srConfig));
                            }
                            if (objects.size() > 0 || ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Glossary.class) {
                                ReportsGenerationDialog.this.g.createReport(ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this), model, objects, ReportsGenerationDialog.this.extraParams);
                            } else {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.NoObjectsForSelectedModel"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                return;
lbl68:
                                // 1 sources

                                if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedIndex() == 1) {
                                    if (ReportsGenerationDialog.access$4900(ReportsGenerationDialog.this).getSelectedItem() == ReportsGenerationDialog.access$5000()) {
                                        tempL = ReportsGenerationDialog.access$4000(ReportsGenerationDialog.this);
                                        for (ReportObject obj : tempL) {
                                            sro = new SearchResultObject(obj.getObject(), ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this), "", "", "", "");
                                            objects.add(sro);
                                        }
                                        ReportsGenerationDialog.this.extraParams.put("subviews", new HashMap<K, V>());
                                    } else {
                                        srConfig = (StandardReportConfiguration)ReportsGenerationDialog.access$4900(ReportsGenerationDialog.this).getSelectedItem();
                                        tempL = ReportsGenerationDialog.access$5100(ReportsGenerationDialog.this, model, srConfig.getObjects());
                                        for (DesignObject obj : tempL) {
                                            sro = new SearchResultObject(obj, ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this), "", "", "", "");
                                            objects.add(sro);
                                        }
                                        ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.access$5200(ReportsGenerationDialog.this, model, srConfig));
                                    }
                                    if (objects.size() > 0 || ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Glossary.class) {
                                        ReportsGenerationDialog.this.g.createReport(SearchResultsReportsGenerationDialog.class, model, objects, ReportsGenerationDialog.this.extraParams);
                                    } else {
                                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.NoObjectsForSelectedModel"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                        return;
                                    }
                                }
                            }
                            ReportsGenerationDialog.this.adjustSettings(false);
                            break block194;
                        }
                        if (ReportsGenerationDialog.access$1600(ReportsGenerationDialog.this).getSelectedIndex() != 1) break block194;
                        xmlISR = null;
                        xsltISR = null;
                        osw = null;
                        xmlDOS = null;
                        htmlIDXPW = null;
                        htmlTOCPW = null;
                        objID = "";
                        model = (RSchemaModel)ReportsGenerationDialog.access$2800(ReportsGenerationDialog.this).getSelectedItem();
                        objectNamesList = new ArrayList<String>();
                        if (!ReportsGenerationDialog.access$5300(ReportsGenerationDialog.this)) break block194;
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        stmt = null;
                        try {
                            ReportsGenerationDialog.this.monitor = new ProgressDialog(ReportsGenerationDialog.this.appView, "", 0, 100);
                            ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.GatherData"));
                            ReportsGenerationDialog.this.monitor.setProgress(1);
                            ReportsGenerationDialog.access$5402(ReportsGenerationDialog.this, ((OracleConnection)ReportsGenerationDialog.access$5500(ReportsGenerationDialog.this)).createOracleArray("OBJECTS_LIST", (Object)Collections.EMPTY_LIST.toArray()));
                            if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Glossary.class) {
                                sg = new SelectGlossaryDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.access$5600(ReportsGenerationDialog.this), ReportsGenerationDialog.access$5500(ReportsGenerationDialog.this));
                                sg.showDialog();
                                objID = ReportsGenerationDialog.this.getSelectedGlossaryOVID();
                            } else if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Domain.class || ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == ChangeRequest.class) {
                                for (ReportObject ro : ReportsGenerationDialog.access$4300(ReportsGenerationDialog.this)) {
                                    if (objectNamesList.contains(ro.getObjectLongName())) continue;
                                    objectNamesList.add(ro.getObjectLongName());
                                }
                                objID = ((RSchemaDesign)((JComboHtmlItem)ReportsGenerationDialog.access$2700(ReportsGenerationDialog.this).getSelectedItem()).getObject()).getDesignOVID();
                            } else if (ReportsGenerationDialog.access$4600(ReportsGenerationDialog.this) == Measurement.class) {
                                objID = ((RSchemaDesign)((JComboHtmlItem)ReportsGenerationDialog.access$2700(ReportsGenerationDialog.this).getSelectedItem()).getObject()).getDesignOVID();
                            } else {
                                objectsOVIDsList = new ArrayList<String>();
                                if (ReportsGenerationDialog.access$2900(ReportsGenerationDialog.this).getSelectedItem() == ReportsGenerationDialog.access$5000()) {
                                    for (ReportObject ro : ReportsGenerationDialog.access$4300(ReportsGenerationDialog.this)) {
                                        objectsOVIDsList.add(ro.getObjectUniqueIdentifier());
                                        if (objectNamesList.contains(ro.getObjectLongName())) continue;
                                        objectNamesList.add(ro.getObjectLongName());
                                    }
                                    ReportsGenerationDialog.access$5402(ReportsGenerationDialog.this, ((OracleConnection)ReportsGenerationDialog.access$5500(ReportsGenerationDialog.this)).createOracleArray("OBJECTS_LIST", (Object)objectsOVIDsList.toArray()));
                                    objID = ((RSchemaModel)ReportsGenerationDialog.access$2800(ReportsGenerationDialog.this).getSelectedItem()).getObjectOVID();
                                } else {
                                    srConfig = (StandardReportConfiguration)ReportsGenerationDialog.access$2900(ReportsGenerationDialog.this).getSelectedItem();
                                    block113: for (ReportObject ro : ReportsGenerationDialog.access$4300(ReportsGenerationDialog.this)) {
                                        for (String objOVID : srConfig.getObjects()) {
                                            if (!ro.getObjectUniqueIdentifier().equals(objOVID)) continue;
                                            if (objectNamesList.contains(ro.getObjectLongName())) continue block113;
                                            objectNamesList.add(ro.getObjectLongName());
                                            continue block113;
                                        }
                                    }
                                    ReportsGenerationDialog.access$5402(ReportsGenerationDialog.this, ((OracleConnection)ReportsGenerationDialog.access$5500(ReportsGenerationDialog.this)).createOracleArray("OBJECTS_LIST", (Object)srConfig.getObjects().toArray()));
                                    if (srConfig.getObjects().size() > 1) {
                                        objID = ((RSchemaModel)ReportsGenerationDialog.access$2800(ReportsGenerationDialog.this).getSelectedItem()).getObjectOVID();
                                    } else if (srConfig.getObjects().size() == 1) {
                                        objID = (String)srConfig.getObjects().get(0);
                                    }
                                }
                            }
                            ReportsGenerationDialog.access$5700(ReportsGenerationDialog.this);
                            reportCode = ReportsGenerationDialog.access$5800(ReportsGenerationDialog.this);
                            stmt = (OracleCallableStatement)ReportsGenerationDialog.access$5500(ReportsGenerationDialog.this).prepareCall("{CALL Pkg_Osdm_Utils.Generate_Report(?,?,?,?,?,?,?,?,?,?,?)}");
                            stmt.setInt(1, reportCode);
                            stmt.setString(2, objID);
                            stmt.setInt(3, 1);
                            stmt.setString(4, ReportsGenerationDialog.access$5900(ReportsGenerationDialog.this).getText().equals("") != false ? null : ReportsGenerationDialog.access$5900(ReportsGenerationDialog.this).getText().trim());
                            stmt.setString(5, ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this));
                            stmt.setORAData(6, (ORAData)reportTemplate);
                            stmt.setArray(7, ReportsGenerationDialog.access$5400(ReportsGenerationDialog.this));
                            stmt.registerOutParameter(8, -13);
                            stmt.registerOutParameter(9, 2);
                            stmt.registerOutParameter(10, 12);
                            stmt.registerOutParameter(11, -10);
                            ReportsGenerationDialog.this.monitor.setProgress(5);
                            stmt.execute();
                            generationResult = ((BigDecimal)stmt.getObject(9)).intValue();
                            if (generationResult == 0) {
                                rp = new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this));
                                rp1 = new File((String)stmt.getObject(10));
                                ReportsGenerationDialog.this.rawXMLFile = new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this) + "/report_data_rs.xml");
                                if (!rp.getAbsolutePath().equals(rp1.getAbsolutePath())) {
                                    ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.DownloadReport") + ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this) + " ...");
                                    ReportsGenerationDialog.this.monitor.setProgress(50);
                                    ReportsGenerationDialog.this.bfile = (OracleBfile)stmt.getObject(8);
                                    ReportsGenerationDialog.this.bfile.openFile();
                                    ReportsGenerationDialog.access$6202(ReportsGenerationDialog.this, ReportsGenerationDialog.this.bfile.getBinaryStream());
                                    xmlDOS = new DataOutputStream(new FileOutputStream(ReportsGenerationDialog.this.rawXMLFile));
                                    buf = new byte[1024];
                                    while ((len = ReportsGenerationDialog.access$6200(ReportsGenerationDialog.this).read(buf)) > 0) {
                                        xmlDOS.write(buf, 0, len);
                                    }
                                    xmlDOS.flush();
                                    xmlDOS.close();
                                    ReportsGenerationDialog.access$6200(ReportsGenerationDialog.this).close();
                                    ReportsGenerationDialog.this.bfile.closeFile();
                                }
                                diagramsListWithPathAndExtension = new ArrayList<String>();
                                if (model != null && !((String)ReportsGenerationDialog.access$1500(ReportsGenerationDialog.this).getSelectedItem()).equalsIgnoreCase("Distinct Types") && !((String)ReportsGenerationDialog.access$1500(ReportsGenerationDialog.this).getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                                    reportFilesDirName = ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this) + "_files";
                                    new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), reportFilesDirName).mkdir();
                                    modelExtraFilesDirName = model.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + model.getObjectOVID();
                                    modelExtraFilesDir = new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), modelExtraFilesDirName);
                                    if (modelExtraFilesDir.exists()) {
                                        if (ReportsGenerationDialog.access$6300(ReportsGenerationDialog.this).isSelected()) {
                                            list = modelExtraFilesDir.list();
                                            for (i = 0; i < list.length; ++i) {
                                                file = new File(modelExtraFilesDir, list[i]);
                                                file.delete();
                                            }
                                        }
                                    } else {
                                        modelExtraFilesDir.mkdir();
                                    }
                                    rsDiagrams = stmt.getCursor(11);
                                    while (rsDiagrams.next()) {
                                        buffer = new char[4096];
                                        s = new StringBuilder();
                                        str = null;
                                        pdfName = rsDiagrams.getString("pdf_name");
                                        diagramName = pdfName.substring(0, pdfName.indexOf(".PDF"));
                                        diagramName = diagramName.replaceAll("[^a-zA-Z1-9_]", "_");
                                        diagramsListWithPathAndExtension.add(ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this) + "_files/" + diagramName + ".pdf");
                                        pdfFile = new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this) + "/" + modelExtraFilesDirName, diagramName + ".pdf");
                                        if (pdfFile.exists() || (pdfBlob = rsDiagrams.getBlob("diagram_pdf")) == null) continue;
                                        in = pdfBlob.getBinaryStream();
                                        try {
                                            r = new InputStreamReader(in, "UTF-8");
                                            while ((len1 = r.read(buffer, 0, buffer.length)) != -1) {
                                                s.append(buffer, 0, len1);
                                                str = s.toString();
                                            }
                                            pdfInputStream = pdfBlob.getBinaryStream();
                                            pdfFOS = new FileOutputStream(pdfFile);
                                            buf = new byte[1024];
                                            while ((len = pdfInputStream.read(buf)) > 0) {
                                                pdfFOS.write(buf, 0, len);
                                            }
                                            pdfFOS.flush();
                                            pdfFOS.close();
                                            pdfInputStream.close();
                                        }
                                        finally {
                                            in.close();
                                        }
                                    }
                                    if (ReportsGenerationDialog.access$2900(ReportsGenerationDialog.this).getSelectedItem() == ReportsGenerationDialog.access$5000()) {
                                        list = modelExtraFilesDir.list();
                                        for (i = 0; i < list.length; ++i) {
                                            try {
                                                from = Paths.get(modelExtraFilesDir + "/" + list[i], new String[0]);
                                                to = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[]{reportFilesDirName + "/" + list[i]});
                                                options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                                                Files.copy(from, to, options);
                                                continue;
                                            }
                                            catch (Exception e1) {
                                                ReportsGenerationDialog.access$3600().error("Cannot copy diagram file from model directory to report directory " + e1);
                                            }
                                        }
                                    } else {
                                        for (RSchemaSubView sw : ReportsGenerationDialog.access$4400(ReportsGenerationDialog.this)) {
                                            for (ReportObject ro : ReportsGenerationDialog.access$4300(ReportsGenerationDialog.this)) {
                                                if (!ro.getObjectUniqueIdentifier().equals(objID) || !sw.getObjectOVID().equals(ro.getSubviewUniqueIdentifier())) continue;
                                                pdfFoleName = sw.getName().replaceAll("[^a-zA-Z1-9_]", "_");
                                                try {
                                                    from = Paths.get(modelExtraFilesDir + "/" + pdfFoleName + ".pdf", new String[0]);
                                                    to = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[]{reportFilesDirName + "/" + pdfFoleName + ".pdf"});
                                                    Files.copy(from, to, new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES});
                                                }
                                                catch (Exception e1) {
                                                    ReportsGenerationDialog.access$3600().error("Cannot copy diagram file from model directory to report directory " + e1);
                                                }
                                            }
                                        }
                                    }
                                }
                                xmlISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.this.rawXMLFile), "UTF-8"));
                                xmlSource = new StreamSource(xmlISR);
                                xsltISR = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ReportsGenerationDialog.access$6400(ReportsGenerationDialog.this)), "UTF-8"));
                                xsltSource = new StreamSource(xsltISR);
                                ReportsGenerationDialog.this.outputFile = new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this));
                                if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("PDF")) {
                                    ReportsGenerationDialog.this.extraParams.put("xsltFile", ReportsGenerationDialog.access$6400(ReportsGenerationDialog.this).getAbsolutePath());
                                    ReportsGenerationDialog.this.extraParams.put("reportFileName", ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this));
                                    ReportsGenerationDialog.this.extraParams.put("objectsList", objectNamesList);
                                    ReportsGenerationDialog.this.extraParams.put("diagramsList", diagramsListWithPathAndExtension);
                                    if (reportCode == 1 || reportCode == 2) {
                                        bps = false;
                                        schemas = (List)ReportsGenerationDialog.access$6500(ReportsGenerationDialog.this).get(model.getObjectOVID());
                                        bps = schemas.size() > 1;
                                        ReportsGenerationDialog.this.extraParams.put("schemaNamesList", schemas);
                                        ReportsGenerationDialog.this.extraParams.put("groupBySchemaName", bps);
                                    } else {
                                        ReportsGenerationDialog.this.extraParams.put("schemaNamesList", new ArrayList<E>());
                                        ReportsGenerationDialog.this.extraParams.put("groupBySchemaName", true);
                                    }
                                    ReportsGenerationDialog.this.extraParams.put("loaded_designs", false);
                                    new Thread(new RenderPDFReport(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.extraParams)).start();
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    ApplicationView.log(Messages.getString("ReportsGenerationDialog.RenderingPDFReport"));
                                    JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.PDFRenderingStarted"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                } else {
                                    if (ReportsGenerationDialog.this.saxonPath != null && !ReportsGenerationDialog.this.saxonPath.equals("")) {
                                        saxonClassLoader = SaxonLoader.getInstance(ReportsGenerationDialog.this.saxonPath);
                                        transFact = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", saxonClassLoader);
                                        MDTransformer.secureTransformerFactory(transFact);
                                        trans = transFact.newTransformer(xsltSource);
                                        if ("css/osddm_main.css css/osddm_vs.css".trim() != "") {
                                            paramName = "p";
                                            c = 0;
                                            for (String s : Arrays.asList("css/osddm_main.css css/osddm_vs.css".split("\\s+"))) {
                                                trans.setParameter(paramName + ++c, s);
                                            }
                                        }
                                        trans.setOutputProperty("encoding", "UTF-8");
                                        trans.transform(xmlSource, new StreamResult(ReportsGenerationDialog.this.outputFile));
                                    } else {
                                        transFact = MDTransformer.transformerFactory();
                                        trans = transFact.newTransformer(xsltSource);
                                        if ("css/osddm_main.css css/osddm_vs.css".trim() != "") {
                                            paramName = "p";
                                            c = 0;
                                            for (String s : Arrays.asList("css/osddm_main.css css/osddm_vs.css".split("\\s+"))) {
                                                trans.setParameter(paramName + ++c, s);
                                            }
                                        }
                                        trans.setOutputProperty("encoding", "UTF-8");
                                        fos = new FileOutputStream(ReportsGenerationDialog.this.outputFile);
                                        osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                        trans.transform(xmlSource, new StreamResult(osw));
                                        osw.flush();
                                        fos.close();
                                    }
                                    if (((String)ReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).equals("HTML")) {
                                        basePath = Paths.get(ApplicationView.basePath + "/reports", new String[0]).toString();
                                        if (!basePath.equals(repPath = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[0]).toString())) {
                                            try {
                                                cssP = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[]{"/css"});
                                                if (!Files.exists(cssP, new LinkOption[0])) {
                                                    FileUtils.copyFolder(Paths.get(ApplicationView.basePath, new String[]{"reports/css"}), cssP);
                                                }
                                                if (!Files.exists(imgP = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[]{"/img"}), new LinkOption[0])) {
                                                    FileUtils.copyFolder(Paths.get(ApplicationView.basePath, new String[]{"reports/img"}), imgP);
                                                }
                                                if (!Files.exists(jsP = Paths.get(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), new String[]{"/js"}), new LinkOption[0])) {
                                                    FileUtils.copyFolder(Paths.get(ApplicationView.basePath, new String[]{"reports/js"}), jsP);
                                                }
                                            }
                                            catch (Exception e) {
                                                ReportsGenerationDialog.access$3600().error("Error when trying to copy CSS, image and js files in reporting directory (single HTML file)", e);
                                            }
                                        }
                                        if (ReportsGenerationDialog.access$6600(ReportsGenerationDialog.this).isGenerateHTMLReportTOCInSeparateFile() && objectNamesList.size() > 0) {
                                            if (!ReportsGenerationDialog.access$6700(ReportsGenerationDialog.this).equals("")) {
                                                htmlIndexFileName = ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).substring(0, ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).indexOf(".")) + "_index" + ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).substring(ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).indexOf("."), ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).length());
                                                htmlContentsFileName = ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).substring(0, ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).indexOf(".")) + "_toc" + ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).substring(ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).indexOf("."), ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this).length());
                                                htmlIDXPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), htmlIndexFileName)), "UTF-8"));
                                                htmlIDXPW.print(HTMLReportSeparateFiles.createHTMLIndexPage(htmlContentsFileName, ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this)));
                                                htmlIDXPW.flush();
                                                htmlIDXPW.close();
                                                htmlTOCPW = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), htmlContentsFileName)), "UTF-8"));
                                                htmlTOCPW.print(HTMLReportSeparateFiles.createHTMLTOCPage(ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this), objectNamesList, ReportsGenerationDialog.access$6600(ReportsGenerationDialog.this), diagramsListWithPathAndExtension, true));
                                                htmlTOCPW.flush();
                                                htmlTOCPW.close();
                                                ReportsGenerationDialog.access$6002(ReportsGenerationDialog.this, htmlIndexFileName);
                                            }
                                            HTMLReportSeparateFiles.editHTMLDataPage(ReportsGenerationDialog.this.outputFile, null, diagramsListWithPathAndExtension, ReportsGenerationDialog.access$6600(ReportsGenerationDialog.this), true);
                                        } else {
                                            html = new HTMLReportSingleFile(ReportsGenerationDialog.this.outputFile, null, objectNamesList, null, ReportsGenerationDialog.access$6600(ReportsGenerationDialog.this), diagramsListWithPathAndExtension, true);
                                            html.createReport();
                                        }
                                    }
                                    ReportsGenerationDialog.this.monitor.setNote(Messages.getString("ReportsGenerationDialog.Finished"));
                                    ReportsGenerationDialog.this.monitor.setProgress(100);
                                    ReportsGenerationDialog.this.monitor.close();
                                    openReport = false;
                                    if (Desktop.isDesktopSupported()) {
                                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV1"), new Object[]{ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this), ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this)}), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                        openReport = true;
                                    } else {
                                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationOKMsgV2"), new Object[]{ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this), ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this)}), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 1);
                                    }
                                    if (openReport) {
                                        Desktop.getDesktop().open(new File(ReportsGenerationDialog.access$6100(ReportsGenerationDialog.this), ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this)));
                                    }
                                }
                                stmt.close();
                                break block194;
                            }
                            if (generationResult == 1) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirObjErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            } else if (generationResult == 2) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirPermissionsErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            } else if (generationResult == 3) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportingDirCreateErr"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                            }
                        }
                        catch (SQLException e) {
                            ReportsGenerationDialog.access$3600().error("Generating report from Reporting Schema exception - " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (FileNotFoundException e) {
                            if (e.getMessage().contains("Access is denied")) {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.ReportGenerationAccessErrMsg"), new Object[]{e.getMessage()}), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                ReportsGenerationDialog.access$3600().error("Exception during report generation " + e);
                            } else {
                                JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                                ReportsGenerationDialog.access$3600().error("Exception during report generation " + e);
                            }
                        }
                        catch (IOException e) {
                            ReportsGenerationDialog.access$3600().error("Generating report from Reporting Schema exception - " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (NullPointerException e) {
                            ReportsGenerationDialog.access$3600().error("Generating report from Reporting Schema exception. " + e);
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        catch (Exception e) {
                            ReportsGenerationDialog.access$3600().error("Generating report from Reporting Schema exception. PLSQL package Pkg_Osdm_Utils did not returned report file. See the PLSQL log file for details. " + e.getMessage());
                            JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            if (!stmt.isClosed()) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException e) {
                                    ReportsGenerationDialog.access$3600().error("SQLException on statement close " + e);
                                }
                            }
                            if (ReportsGenerationDialog.this.bfile != null) {
                                try {
                                    ReportsGenerationDialog.this.bfile.closeFile();
                                }
                                catch (SQLException e) {
                                    ReportsGenerationDialog.access$3600().error("Could not close report generation BFile " + e);
                                }
                            }
                            if (ReportsGenerationDialog.access$6200(ReportsGenerationDialog.this) != null) {
                                try {
                                    ReportsGenerationDialog.access$6200(ReportsGenerationDialog.this).close();
                                }
                                catch (IOException e) {
                                    ReportsGenerationDialog.access$3600().error("Could not close report generation BFile input stream " + e);
                                }
                            }
                            if (osw != null) {
                                try {
                                    osw.flush();
                                    osw.close();
                                }
                                catch (IOException e) {
                                    ReportsGenerationDialog.access$3600().error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + ReportsGenerationDialog.access$6000(ReportsGenerationDialog.this) + ": " + e);
                                }
                            }
                            if (htmlIDXPW != null) {
                                htmlIDXPW.flush();
                                htmlIDXPW.close();
                            }
                            if (htmlTOCPW != null) {
                                htmlTOCPW.flush();
                                htmlTOCPW.close();
                            }
                            if (xmlISR != null) {
                                try {
                                    xmlISR.close();
                                }
                                catch (IOException e) {
                                    ReportsGenerationDialog.access$3600().error("ReportsGenerator.createReport() Unable to close raw XML file after reading: " + e);
                                }
                            }
                            if (xsltISR != null) {
                                try {
                                    xsltISR.close();
                                }
                                catch (IOException e) {
                                    ReportsGenerationDialog.access$3600().error("ReportsGenerator.createReport() Unable to close XSLT file : " + e);
                                }
                            }
                            if (xmlDOS != null) {
                                xmlDOS.flush();
                                xmlDOS.close();
                            }
                            ReportsGenerationDialog.this.monitor.setProgress(100);
                            ReportsGenerationDialog.this.monitor.close();
                        }
                    }
                    catch (Exception e) {
                        if (ReportsGenerationDialog.this.g != null && ReportsGenerationDialog.this.g.getMonitor() != null) {
                            ReportsGenerationDialog.this.g.getMonitor().close();
                        }
                        JOptionPane.showMessageDialog(ReportsGenerationDialog.this, Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
                        ReportsGenerationDialog.access$3600().error("ReportsGenerationDialog.generateReport() - " + e.getMessage());
                    }
                }
            }
        };
        thread.start();
    }

    private Glossary getGlossaryFile() {
        Glossary glossary = null;
        File file = null;
        try {
            ApplicationView.waitLoadFilesThreadToComplete();
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("GlossaryDialog.CWDGlossaryFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_Glossary");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ReportsGenerationDialog.OpenGlossary"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                glossary = new Glossary(file);
                if (!glossary.isLoaded()) {
                    LOGGER.error("Reports generation : error during glossary file load " + file.toString());
                    JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ErrGlossaryOpen"), Messages.getString("ReportsGenerationDialog.OpenGlossary"), 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Generating report for glossary file : " + file != null ? file.toString() : " " + e.getMessage());
            JOptionPane.showMessageDialog(this, Messages.getString("ReportsGenerationDialog.ErrGlossaryPrint"), Messages.getString("ReportsGenerationDialog.ReportGenerationRes"), 0);
        }
        return glossary;
    }

    public JComboBox getCmbModels() {
        return this.cmbModelsLDP;
    }

    public List getFullModelList() {
        List<DataTypesDesign> fullModelsList = new ArrayList();
        if (this.tpane.getSelectedIndex() == 0) {
            Design d = (Design)this.cmbDesignsLDP.getSelectedItem();
            RelationalDesignSet rds = d.getRelationalDesigns();
            for (RelationalDesign rd : rds) {
                fullModelsList.add((DataTypesDesign)((Object)rd));
            }
            LogicalDesign ld = d.getLogicalDesign();
            fullModelsList.add((DataTypesDesign)((Object)ld));
            DataTypesDesign dtd = d.getDataTypesDesign();
            fullModelsList.add(dtd);
        } else if (this.tpane.getSelectedIndex() == 1) {
            fullModelsList = this.allRSModelsList;
        }
        return fullModelsList;
    }

    public void adjustSettings(boolean reportTypeChanged) {
        try {
            StandardReportConfiguration srConfig = blankSR;
            this.txtReportTtitle.setText("");
            Object selectedReportConfiguration = null;
            if (reportTypeChanged) {
                selectedReportConfiguration = blankSR;
            } else if (this.tpane.getSelectedIndex() == 0) {
                selectedReportConfiguration = this.cmbStandardReportConfigurationsLDP.getSelectedItem();
                if (selectedReportConfiguration != null) {
                    srConfig = (StandardReportConfiguration)selectedReportConfiguration;
                }
            } else if (this.tpane.getSelectedIndex() == 1 && (selectedReportConfiguration = this.cmbStandardReportConfigurationsRSP.getSelectedItem()) != null) {
                srConfig = (StandardReportConfiguration)selectedReportConfiguration;
            }
            if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Tables Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Tables Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Table Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleTableDetails"));
                }
                this.clazz = Table.class;
                this.cmbModelsLDP.setEnabled(true);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(!this.getApplicationView().getSettings().isEmbedDiagramsInReports());
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            }
            if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Table Views")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Tables Views Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesViewsDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Tables Views Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllTablesViewsDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Table View Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleTableViewDetails"));
                }
                this.clazz = TableView.class;
                this.cmbModelsLDP.setEnabled(true);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Entities Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Entities Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Entity Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleEntityDetails"));
                }
                this.clazz = Entity.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entity Views")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Entities Views Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesViewsDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Entities Views Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllEntitiesViewsDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Entity View Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleEntityViewDetails"));
                }
                this.clazz = EntityView.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Domains")) {
                this.clazz = Domain.class;
                this.txtReportTtitle.setText("All Domains Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDomainsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                this.clazz = Glossary.class;
                this.txtReportTtitle.setText("Glossary Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "GlossaryDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(false);
                this.btnManageStandardTemplates.setEnabled(false);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(false);
                this.btnManageCustomTemplates.setEnabled(false);
                this.chbReplaceBooleanValues.setEnabled(false);
                this.cmbFalse.setEnabled(false);
                this.cmbTrue.setEnabled(false);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Structured Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllStructuredTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Structured Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllStructuredTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Structured Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleStructuredTypeDetails"));
                }
                this.clazz = StructuredType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(true);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(true);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Distinct Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDistinctTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Distinct Types Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllDistinctTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Distinct Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleDistinctTypeDetails"));
                }
                this.clazz = DistinctType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                if (selectedReportConfiguration == blankSR) {
                    this.txtReportTtitle.setText("All Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllCollectionTypesDetails"));
                } else if (srConfig.getObjects().size() > 1) {
                    this.txtReportTtitle.setText("All Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "AllCollectionTypesDetails"));
                } else if (srConfig.getObjects().size() == 1) {
                    this.txtReportTtitle.setText("Collection Type Details");
                    this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "SingleCollectionTypeDetails"));
                }
                this.clazz = CollectionType.class;
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.btnStandardReportConfigurationsLDP.setEnabled(this.cmbModelsLDP.getSelectedIndex() > -1);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.btnStandardReportConfigurationsRSP.setEnabled(this.cmbDesignsRSP.getSelectedItem() != null);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Change Requests")) {
                this.clazz = ChangeRequest.class;
                this.txtReportTtitle.setText("Change Requests Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "ChangeRequestsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Measurements")) {
                this.clazz = Measurement.class;
                this.txtReportTtitle.setText("Measurements Details");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "MeasurementsDetails"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(true);
                this.btnManageStandardTemplates.setEnabled(true);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(true);
                this.btnManageCustomTemplates.setEnabled(true);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            } else if (((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("User Defined Properties")) {
                this.clazz = UserDefinedProperty.class;
                this.txtReportTtitle.setText("User Defined Properties");
                this.txtReportFileName.setText(ReportUtils.getReportFileName(ReportUtils.getReportsPath(this.appView), "UserDefinedProperties"));
                this.cmbModelsLDP.setEnabled(false);
                this.cmbStandardTemplates.setEnabled(false);
                this.btnManageStandardTemplates.setEnabled(false);
                this.cmbStandardReportConfigurationsLDP.setEnabled(false);
                this.btnStandardReportConfigurationsLDP.setEnabled(false);
                this.cmbCustomTemplates.setEnabled(false);
                this.btnManageCustomTemplates.setEnabled(false);
                this.chbReplaceBooleanValues.setEnabled(true);
                this.cmbFalse.setEnabled(true);
                this.cmbTrue.setEnabled(true);
                this.cmbModelsRSP.removeAllItems();
                this.cmbModelsRSP.setEnabled(false);
                this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                this.btnStandardReportConfigurationsRSP.setEnabled(false);
                this.chbClearLMDiagrams.setSelected(false);
                this.chbClearLMDiagrams.setEnabled(false);
                this.chbClearRSDiagrams.setSelected(false);
                this.chbClearRSDiagrams.setEnabled(false);
            }
            this.manageTemplatesAction.setClazz(this.clazz);
            if (!((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries") && !((String)this.cmbReports.getSelectedItem()).equalsIgnoreCase("User Defined Properties")) {
                this.initBlankCRTSearchableProperties();
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.adujstSettings Exception : " + e);
        }
    }

    private void reloadSelectableData() {
        this.cmbStandardTemplates.removeAllItems();
        this.cmbStandardTemplates.addItem(blankRT);
        for (StandardReportTemplate standardReportTemplate : this.appView.getReportTemplates()) {
            if (standardReportTemplate.getClazz() != this.clazz) continue;
            this.cmbStandardTemplates.addItem(standardReportTemplate);
        }
        this.cmbCustomTemplates.removeAllItems();
        this.cmbCustomTemplates.addItem(blankCRT);
        for (CustomReportTemplate customReportTemplate : this.appView.getCustomReportTemplates()) {
            if (customReportTemplate.getClazz() != this.clazz) continue;
            this.cmbCustomTemplates.addItem(customReportTemplate);
        }
        if (this.clazz != Domain.class || this.clazz != ChangeRequest.class || this.clazz != Measurement.class || this.clazz != Glossary.class) {
            this.reloadModels();
            this.reloadReportConfigurations(true);
        } else if (this.tpane.getSelectedIndex() == 0) {
            this.cmbModelsLDP.removeItemListener(this.ldModelsComboListener);
            this.cmbModelsLDP.removeAllItems();
            this.cmbModelsLDP.addItemListener(this.ldModelsComboListener);
        } else if (this.tpane.getSelectedIndex() == 1) {
            this.cmbModelsRSP.removeItemListener(this.rsModelsComboListener);
            this.cmbModelsRSP.removeAllItems();
            this.cmbModelsRSP.addItemListener(this.rsModelsComboListener);
        }
    }

    void reloadReportConfigurations(boolean isLoadedDesignsTab) {
        if (isLoadedDesignsTab) {
            this.cmbStandardReportConfigurationsLDP.removeItemListener(this.ldReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsLDP.removeAllItems();
            this.cmbStandardReportConfigurationsLDP.addItem(blankSR);
            for (StandardReportConfiguration rt : this.allConfigurationsList) {
                Design currentDesign = (Design)this.cmbDesignsLDP.getSelectedItem();
                DesignPart currentModel = (DesignPart)this.cmbModelsLDP.getSelectedItem();
                if (currentModel == null || !currentDesign.getObjectID().equals(rt.getDesignID()) || !currentModel.getObjectID().equals(rt.getModelID()) || this.clazz != rt.getClazz()) continue;
                this.cmbStandardReportConfigurationsLDP.addItem(rt);
            }
            this.cmbStandardReportConfigurationsLDP.addItemListener(this.ldReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsLDP.setSelectedItem(blankSR);
        } else {
            this.cmbStandardReportConfigurationsRSP.removeItemListener(this.rsReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsRSP.removeAllItems();
            this.cmbStandardReportConfigurationsRSP.addItem(blankSR);
            for (StandardReportConfiguration rt : this.allConfigurationsList) {
                RSchemaDesign currentDesign = (RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject();
                RSchemaModel currentModel = (RSchemaModel)this.cmbModelsRSP.getSelectedItem();
                if (currentModel == null || !currentDesign.getDesignOVID().equals(rt.getDesignID()) || !currentModel.getObjectOVID().equals(rt.getModelID()) || this.clazz != rt.getClazz()) continue;
                this.cmbStandardReportConfigurationsRSP.addItem(rt);
            }
            this.cmbStandardReportConfigurationsRSP.addItemListener(this.rsReportConfigurationsComboListener);
            this.cmbStandardReportConfigurationsRSP.setSelectedItem(blankSR);
        }
    }

    private void initReportParams() {
        try {
            this.tocTagName = "";
            String xsltVersion = "";
            xsltVersion = this.saxonPath != null && !this.saxonPath.equals("") ? "20" : "10";
            String fileFormat = ((String)this.cmbOutFormat.getSelectedItem()).toLowerCase();
            ArrayList<String> objList = new ArrayList<String>(Arrays.asList((String[])this.objects.getArray()));
            if (this.clazz == Table.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleTableDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleTableDetails_" + this.getLastUsedFileIdx("SingleTableDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllTablesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllTablesDetails_" + this.getLastUsedFileIdx("AllTablesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "TableName";
                }
            } else if (this.clazz == TableView.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleTableViewDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleTableViewDetails_" + this.getLastUsedFileIdx("SingleTableViewDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllTablesViewsDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllTablesViewsDetails_" + this.getLastUsedFileIdx("AllTablesViewsDetails") + "_rs." + fileFormat;
                    this.tocTagName = "ViewName";
                }
            } else if (this.clazz == Entity.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleEntityDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleEntityDetails_" + this.getLastUsedFileIdx("SingleEntityDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllEntitiesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllEntitiesDetails_" + this.getLastUsedFileIdx("AllEntitiesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "EntityName";
                }
            } else if (this.clazz == EntityView.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleEntityViewDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleEntityViewDetails_" + this.getLastUsedFileIdx("SingleEntityViewDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllEntitiesViewsDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllEntitiesViewsDetails_" + this.getLastUsedFileIdx("AllEntitiesViewsDetails") + "_rs." + fileFormat;
                    this.tocTagName = "ViewName";
                }
            } else if (this.clazz == CollectionType.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleCollectionTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleCollectionTypeDetails_" + this.getLastUsedFileIdx("SingleCollectionTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllCollectionTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllCollectionTypesDetails_" + this.getLastUsedFileIdx("AllCollectionTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "CTName";
                }
            } else if (this.clazz == StructuredType.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleStructuredTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleStructuredTypeDetails_" + this.getLastUsedFileIdx("SingleStructuredTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllStructuredTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllStructuredTypesDetails_" + this.getLastUsedFileIdx("AllStructuredTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "STName";
                }
            } else if (this.clazz == DistinctType.class) {
                if (objList.size() == 1) {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/SingleDistinctTypeDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "SingleDistinctTypeDetails_" + this.getLastUsedFileIdx("SingleDistinctTypeDetails") + "_rs." + fileFormat;
                } else {
                    this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDistinctTypesDetails_" + fileFormat + ".xslt");
                    this.reportFileName = "AllDistinctTypesDetails_" + this.getLastUsedFileIdx("AllDistinctTypesDetails") + "_rs." + fileFormat;
                    this.tocTagName = "DTName";
                }
            } else if (this.clazz == Domain.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/AllDomainsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "AllDomainsDetails_" + this.getLastUsedFileIdx("AllDomainsDetails") + "_rs." + fileFormat;
                this.tocTagName = "DomainName";
            } else if (this.clazz == Glossary.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/GlossaryDetails_" + fileFormat + ".xslt");
                this.reportFileName = "GlossaryDetails_" + this.getLastUsedFileIdx("GlossaryDetails") + "_rs." + fileFormat;
            } else if (this.clazz == ChangeRequest.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/ChangeRequestsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "ChangeRequestsDetails_" + this.getLastUsedFileIdx("ChangeRequestsDetails") + "_rs." + fileFormat;
                this.tocTagName = "CRName";
            } else if (this.clazz == Measurement.class) {
                this.xsltFile = new File(ApplicationView.basePath, "reports/xslt/" + xsltVersion + "/MeasurementsDetails_" + fileFormat + ".xslt");
                this.reportFileName = "MeasurementsDetails_" + this.getLastUsedFileIdx("MeasurementsDetails") + "_rs." + fileFormat;
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.initReportParams() Exception : " + e);
        }
    }

    private long getLastUsedFileIdx(String reportName) {
        long lastUsedIdx = 0L;
        long currIdx = 0L;
        try {
            File[] listOfFiles;
            File folder = new File(this.reportsPath);
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((listOfFiles = folder.listFiles()) == null) {
                listOfFiles = new File(folder.getParent()).listFiles();
            }
            for (int i = 0; i < listOfFiles.length; ++i) {
                File currentFile = listOfFiles[i];
                String reportFileName = currentFile.getName();
                if (!currentFile.isFile() || !reportFileName.startsWith(reportName) || reportFileName.indexOf("_rs") <= 1) continue;
                String currentIndex = reportFileName.substring(reportFileName.indexOf("_") + 1, reportFileName.indexOf("_rs"));
                try {
                    currIdx = new Long(currentIndex);
                    if (currIdx <= lastUsedIdx) continue;
                    lastUsedIdx = currIdx;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerationDialog.getLastUsedFileIdx() Exception : " + e);
        }
        return lastUsedIdx + 1L;
    }

    private void loadReportCinfigurations() {
        if (!srLoaded) {
            this.srp.loadStandardReportConfigurations();
            srLoaded = true;
        }
    }

    private List<DesignObject> getDesignObjectsForObjectsIDs(DesignPart model, List<String> objectsIDsList) {
        DesignObject o;
        ArrayList<DesignObject> objects = new ArrayList<DesignObject>();
        ArrayList<DesignObject> tempList = new ArrayList<DesignObject>();
        Iterator it = null;
        Iterator<String> objectsIDsIt = objectsIDsList.iterator();
        if (model instanceof RelationalDesign) {
            it = ((RelationalDesign)model).getTableSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((RelationalDesign)model).getTableViewSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        } else if (model instanceof LogicalDesign) {
            it = ((LogicalDesign)model).getEntitySet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((LogicalDesign)model).getEntityViewSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        } else if (model instanceof DataTypesDesign) {
            it = ((DataTypesDesign)model).getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((DataTypesDesign)model).getCollectionTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
            it = ((DataTypesDesign)model).getDistinctTypeSet().iterator();
            while (it.hasNext()) {
                o = (DesignObject)it.next();
                tempList.add(o);
            }
        }
        block7: while (objectsIDsIt.hasNext()) {
            String objId = objectsIDsIt.next();
            for (DesignObject o2 : tempList) {
                if (!o2.getObjectID().equals(objId)) continue;
                objects.add(o2);
                continue block7;
            }
        }
        return objects;
    }

    private HashMap<DesignPartViewPlaceHolder, List<String>> getSubViewsMap(DesignPart model, StandardReportConfiguration src) {
        HashMap<DesignPartViewPlaceHolder, List<String>> subviews = new HashMap<DesignPartViewPlaceHolder, List<String>>();
        List<String> subviewsIDsList = src.getSubviews();
        Iterator allSWIt = model.getDesignSubviews().iterator();
        block0: while (allSWIt.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)allSWIt.next();
            for (String swId : subviewsIDsList) {
                if (!ph.getObjectID().equals(swId)) continue;
                ArrayList<String> objectsNamesList = new ArrayList<String>();
                for (TopView tv : ph.getDesignPartView().getTopviewsList()) {
                    DesignObject desObj = tv.getModel();
                    for (String objId : src.getObjects()) {
                        if (!desObj.getObjectID().equals(objId)) continue;
                        objectsNamesList.add(desObj.getLongName());
                    }
                }
                Collections.sort(objectsNamesList, this.toStringComparator);
                subviews.put(ph, objectsNamesList);
                continue block0;
            }
        }
        return subviews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getLDObjects() {
        ArrayList<ReportObject> currentObjectsList = new ArrayList<ReportObject>();
        try {
            DesignPart model = (DesignPart)this.cmbModelsLDP.getSelectedItem();
            if (model != null) {
                AbstractView view;
                Iterator it;
                DesignPart d;
                if (this.clazz == Table.class) {
                    d = (RelationalDesign)model;
                    it = ((RelationalDesign)d).getTableSet().iterator();
                    while (it.hasNext()) {
                        Table table = (Table)it.next();
                        currentObjectsList.add(new ReportObject(table, table.getName(), table.getLongName(), table.getObjectID(), "", "", "", "", true, ""));
                    }
                }
                if (this.clazz == TableView.class) {
                    d = (RelationalDesign)model;
                    it = ((RelationalDesign)d).getTableViewSet().iterator();
                    while (it.hasNext()) {
                        view = (TableView)it.next();
                        currentObjectsList.add(new ReportObject(view, view.getName(), ((TableView)view).getLongName(), view.getObjectID(), "", "", "", "", true, ""));
                    }
                } else if (this.clazz == Entity.class) {
                    d = (LogicalDesign)model;
                    it = ((LogicalDesign)d).getEntitySet().iterator();
                    while (it.hasNext()) {
                        Entity entity = (Entity)it.next();
                        currentObjectsList.add(new ReportObject(entity, entity.getName(), "", entity.getObjectID(), "", "", "", "", true, ""));
                    }
                } else if (this.clazz == EntityView.class) {
                    d = (LogicalDesign)model;
                    it = ((LogicalDesign)d).getEntityViewSet().iterator();
                    while (it.hasNext()) {
                        view = (EntityView)it.next();
                        currentObjectsList.add(new ReportObject(view, view.getName(), "", view.getObjectID(), "", "", "", "", true, ""));
                    }
                } else if (this.clazz == StructuredType.class) {
                    d = (DataTypesDesign)model;
                    it = ((DataTypesDesign)d).getStructuredTypeSet().iterator();
                    while (it.hasNext()) {
                        StructuredType structuredType = (StructuredType)it.next();
                        currentObjectsList.add(new ReportObject(structuredType, structuredType.getName(), "", structuredType.getObjectID(), "", "", "", "", true, ""));
                    }
                } else if (this.clazz == CollectionType.class) {
                    d = (DataTypesDesign)model;
                    it = ((DataTypesDesign)d).getCollectionTypeSet().iterator();
                    while (it.hasNext()) {
                        CollectionType collectionType = (CollectionType)it.next();
                        currentObjectsList.add(new ReportObject(collectionType, collectionType.getName(), "", collectionType.getObjectID(), "", "", "", "", true, ""));
                    }
                } else if (this.clazz == DistinctType.class) {
                    d = (DataTypesDesign)model;
                    it = ((DataTypesDesign)d).getDistinctTypeSet().iterator();
                    while (it.hasNext()) {
                        DistinctType distinctType = (DistinctType)it.next();
                        currentObjectsList.add(new ReportObject(distinctType, distinctType.getName(), "", distinctType.getObjectID(), "", "", "", "", true, ""));
                    }
                }
            } else if (this.clazz == Domain.class) {
                Iterator it = ((Design)this.cmbDesignsLDP.getSelectedItem()).getDomainSet().iterator();
                while (it.hasNext()) {
                    Domain domain = (Domain)it.next();
                    currentObjectsList.add(new ReportObject(domain, domain.getName(), "", domain.getObjectID(), "", "", "", "", true, ""));
                }
            } else if (this.clazz == Measurement.class) {
                for (DesignPart dp : ((Design)this.cmbDesignsLDP.getSelectedItem()).getStorableDesignParts()) {
                    List owm = dp.getObjectsWithMeasurements();
                    if (owm.size() <= 0) continue;
                    for (DesignObject desObject : owm) {
                        for (Measurement measurement : desObject.getMeasurements()) {
                            currentObjectsList.add(new ReportObject(measurement, measurement.getName(), "", measurement.getObjectID(), "", "", "", "", true, ""));
                        }
                    }
                }
            } else if (this.clazz == ChangeRequest.class) {
                Iterator it = ((Design)this.cmbDesignsLDP.getSelectedItem()).getChangeRequestSet().iterator();
                while (it.hasNext()) {
                    ChangeRequest changeRequest = (ChangeRequest)it.next();
                    currentObjectsList.add(new ReportObject(changeRequest, changeRequest.getName(), "", changeRequest.getObjectID(), "", "", "", "", true, ""));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getLDObjects()", e);
        }
        return currentObjectsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getRSObjects() {
        ArrayList<ReportObject> currentObjectsList = new ArrayList<ReportObject>();
        ReportObject ro2 = null;
        try {
            String designOVID = ((RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID();
            String modelOVID = "";
            Object mOvid = this.cmbModelsRSP.getSelectedItem();
            if (mOvid != null) {
                modelOVID = ((RSchemaModel)mOvid).getObjectOVID();
            }
            for (ReportObject ro2 : this.allRSObjectsList) {
                String objType = ro2.getObjectType();
                String objDesignOVID = ro2.getDesignOVID();
                String objModelOVID = ro2.getModelOVID();
                if (!modelOVID.equals("")) {
                    if (this.clazz == Table.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Tables")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz == TableView.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Table Views")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz == Entity.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Entities")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz == EntityView.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Entity Views")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz == StructuredType.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Structured Types")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz == CollectionType.class && objDesignOVID.equals(designOVID) && objModelOVID.equals(modelOVID) && objType.equals("Collection Types")) {
                        currentObjectsList.add(ro2);
                        continue;
                    }
                    if (this.clazz != DistinctType.class || !objDesignOVID.equals(designOVID) || !objModelOVID.equals(modelOVID) || !objType.equals("Distinct Types")) continue;
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz == Domain.class && objDesignOVID.equals(designOVID) && objType.equals("Domains")) {
                    currentObjectsList.add(ro2);
                    continue;
                }
                if (this.clazz != ChangeRequest.class || !objDesignOVID.equals(designOVID) || !objType.equals("Change Requests")) continue;
                currentObjectsList.add(ro2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getRSObjects()", e);
        }
        return currentObjectsList;
    }

    private List getRSSubViews() {
        ArrayList<RSchemaSubView> currentSWList = new ArrayList<RSchemaSubView>();
        String designOVID = ((RSchemaDesign)((JComboHtmlItem)this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID();
        String modelOVID = ((RSchemaModel)this.cmbModelsRSP.getSelectedItem()).getObjectOVID();
        for (RSchemaSubView rSchemaSubView : this.allRSSubViewsList) {
            if (!rSchemaSubView.getModelOVID().equals(modelOVID)) continue;
            currentSWList.add(rSchemaSubView);
        }
        return currentSWList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDesigns(Connection connection) {
        block26: {
            this.cmbDesignsRSP.removeItemListener(this.rsDesignsComboListener);
            this.cmbDesignsRSP.removeAllItems();
            this.cmbModelsRSP.removeAllItems();
            this.allRSObjectsList = new ArrayList();
            this.allRSModelsList = new ArrayList();
            this.allRSSubViewsList = new ArrayList();
            Statement stmt = null;
            ArrayList<String> tempDesignsList = new ArrayList<String>();
            ArrayList<String> tempModelsList = new ArrayList<String>();
            ArrayList<String> tempSubviewsList = new ArrayList<String>();
            try {
                if (connection == null) break block26;
                try {
                    float vers = SchemaFactory.schemaVersion(connection);
                    if (vers != 0.0f) {
                        String designsQuery = "SELECT  design_ovid, design_name, version_comments, TO_CHAR(date_published,'dd.mm.yyyy hh24:mi:ss') FROM    dmrs_designs ORDER BY design_name ASC, date_published DESC";
                        String modelsQuery = "SELECT m.model_ovid, m.model_name, m.model_type, m.design_ovid, s.schema_name FROM  \tdmrs_models m LEFT JOIN dmrs_schema_object s ON     m.model_ovid = s.model_ovid ORDER BY m.model_ovid, s.schema_name";
                        String subviewsQuery = "SELECT ovid, diagram_name, model_ovid, diagram_type  FROM  \tdmrs_diagrams";
                        String objectsQuery = "SELECT d.ovid, b.name,  b.ovid,  DECODE(b.type,  'Table','Tables', 'Entity', 'Entities', 'StructuredType', 'Structured Types'), b.model_ovid, d.design_ovid, d.diagram_type, b.long_name FROM   dmrs_vdiagrams d , dmrs_diagram_elements b WHERE d.ovid = b.diagram_ovid AND   d.diagram_type IN ('MainView', 'Subview') AND   d.is_display = 'N' AND   b.type IN ('Table', 'Entity', 'StructuredType')";
                        String additionalObjectsQuery = "SELECT collection_type_name, collection_type_ovid, 'Collection Types', model_ovid, design_ovid, 'MainView' FROM dmrs_collection_types UNION SELECT distinct_type_name, distinct_type_ovid, 'Distinct Types', model_ovid, design_ovid, 'MainView' FROM dmrs_distinct_types";
                        String domainsQuery = "SELECT domain_name, ovid, 'Domains', design_ovid FROM dmrs_domains";
                        String crQuery = "SELECT change_request_name, change_request_ovid, 'Change Requests', design_ovid FROM dmrs_change_requests";
                        String schemasQuery = "SELECT design_ovid, model_ovid, object_id, schema_ovid, schema_name FROM dmrs_schema_object";
                        try {
                            ReportObject reportObject;
                            stmt = connection.prepareStatement(designsQuery);
                            ResultSet rset = stmt.executeQuery();
                            while (rset.next()) {
                                String designObjOVID = rset.getString(1);
                                if (tempDesignsList.contains(designObjOVID)) continue;
                                RSchemaDesign rSchemaDesign = new RSchemaDesign(rset.getString(2), designObjOVID, rset.getString(4), rset.getString(3));
                                String dComments = rSchemaDesign.getDesignComments() != null && rSchemaDesign.getDesignComments() != "" ? " " + rSchemaDesign.getDesignComments() : "";
                                this.cmbDesignsRSP.addItem(new JComboHtmlItem(rSchemaDesign.getDesignName(), "<html><nobr><b>" + rSchemaDesign.getDesignName() + "</b> " + rSchemaDesign.getDesignDate() + "<i>" + dComments + "</i></nobr></html>", rSchemaDesign));
                                this.cmbDesignsRSPTooltips.add(dComments);
                                tempDesignsList.add(designObjOVID);
                            }
                            this.cmbDesignsRSPRenderer.setTooltips(this.cmbDesignsRSPTooltips);
                            stmt.close();
                            this.modelSchemas = new HashMap();
                            ArrayList<String> tempSchemasList = null;
                            stmt = connection.prepareStatement(modelsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                String modelOVID = rset.getString(1);
                                if (!tempModelsList.contains(modelOVID)) {
                                    tempSchemasList = new ArrayList<String>();
                                    this.modelSchemas.put(modelOVID, tempSchemasList);
                                    RSchemaModel rSchemaModel = new RSchemaModel(rset.getString(2), rset.getString(3), modelOVID, rset.getString(4));
                                    this.allRSModelsList.add(rSchemaModel);
                                    tempModelsList.add(modelOVID);
                                }
                                tempSchemasList.add(rset.getString(5));
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(subviewsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                String subviewObjOVID = rset.getString(1);
                                if (tempSubviewsList.contains(subviewObjOVID)) continue;
                                RSchemaSubView rSchemaSubView = new RSchemaSubView(rset.getString(2), rset.getString(3), subviewObjOVID);
                                if (rset.getString(4).equals("MainView")) continue;
                                this.allRSSubViewsList.add(rSchemaSubView);
                                tempSubviewsList.add(subviewObjOVID);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(objectsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                reportObject = new ReportObject("", rset.getString(2), rset.getString(8), rset.getString(3), rset.getString(4), rset.getString(6), rset.getString(5), rset.getString(1), true, rset.getString(7));
                                this.allRSObjectsList.add(reportObject);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(additionalObjectsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                reportObject = new ReportObject("", rset.getString(1), rset.getString(1), rset.getString(2), rset.getString(3), rset.getString(5), rset.getString(4), "", true, rset.getString(6));
                                this.allRSObjectsList.add(reportObject);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(domainsQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                reportObject = new ReportObject("", rset.getString(1), rset.getString(1), rset.getString(2), rset.getString(3), rset.getString(4), "", "", true, "");
                                this.allRSObjectsList.add(reportObject);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(crQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                                reportObject = new ReportObject("", rset.getString(1), rset.getString(1), rset.getString(2), rset.getString(3), rset.getString(4), "", "", true, "");
                                this.allRSObjectsList.add(reportObject);
                            }
                            stmt.close();
                            stmt = connection.prepareStatement(schemasQuery);
                            rset = stmt.executeQuery();
                            while (rset.next()) {
                            }
                            this.cmbDesignsRSP.addItemListener(this.rsDesignsComboListener);
                        }
                        catch (SQLException e) {
                            LOGGER.error("Reports generation dialog loadDesigns()", e);
                        }
                        break block26;
                    }
                    MessageDialogs.showMessage(Messages.getString("ReportsGenerationDialog.ThereIsNoReportingSchema"));
                }
                catch (Exception e) {
                    LOGGER.error("Reports generation dialog loadDesigns()", e);
                    MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"), true);
                }
            }
            catch (Exception e) {
                LOGGER.error("Reports generation dialog loadDesigns()", e);
                MessageDialogs.showErrorMessage(Messages.getString("SelectDesignsDialog.UnableToLoadDesigns"), true);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("Reports generation dialog loadDesigns()", e);
                    }
                }
            }
        }
    }

    public String getSelectedGlossaryOVID() {
        return this.selectedGlossaryOVID;
    }

    public void setSelectedGlossaryOVID(String selectedGlossaryOVID) {
        this.selectedGlossaryOVID = selectedGlossaryOVID;
    }

    private int getStoredPackageReportCode() {
        try {
            String reportType = (String)this.cmbReports.getSelectedItem();
            ArrayList<String> objList = new ArrayList<String>(Arrays.asList((String[])this.objects.getArray()));
            if (reportType.equalsIgnoreCase("Tables")) {
                if (objList.size() == 1) {
                    return 1;
                }
                return 2;
            }
            if (reportType.equalsIgnoreCase("Entities")) {
                if (objList.size() == 1) {
                    return 3;
                }
                return 4;
            }
            if (reportType.equalsIgnoreCase("Domains")) {
                return 5;
            }
            if (reportType.equalsIgnoreCase("Glossaries")) {
                return 6;
            }
            if (reportType.equalsIgnoreCase("Structured Types")) {
                if (objList.size() == 1) {
                    return 7;
                }
                return 8;
            }
            if (reportType.equalsIgnoreCase("Collection Types")) {
                if (objList.size() == 1) {
                    return 9;
                }
                return 10;
            }
            if (reportType.equalsIgnoreCase("Distinct Types")) {
                if (objList.size() == 1) {
                    return 11;
                }
                return 12;
            }
            if (reportType.equalsIgnoreCase("Change Requests")) {
                return 13;
            }
            if (reportType.equalsIgnoreCase("Measurements")) {
                return 14;
            }
        }
        catch (Exception e) {
            LOGGER.error("Reports generation dialog getStoredPackageReportCode()", e);
            return 0;
        }
        return 0;
    }

    private void loadCustomReportTemplates() {
        if (!ctrLoaded) {
            this.customReportTemplatesPersistence.loadCustomReportTemplates(this.appView);
            ctrLoaded = true;
        }
    }

    private void initBlankCRTSearchableProperties() {
        List allSearchableProperties = ReportUtils.getSearchablePropertyDescriptions(this.clazz, this.metaDataManager);
        blankCRT.getReportSections().clear();
        ArrayList<ReportColumn> tempList = new ArrayList<ReportColumn>();
        for (ClassDescription.PropertyDescription pd : allSearchableProperties) {
            ReportColumn po = new ReportColumn(pd.name, ReportUtils.getDisplayName(pd.name), 0.0, "", "", ReportConstants.isPropertyMassUpdatable(pd, this.currentModel), false, false);
            tempList.add(po);
        }
        Collections.sort(tempList, new ReportUtils.ColumnsComparator());
        ClassDescription cd = this.metaDataManager.getClassDescription(this.clazz.getName());
        ReportSection rs = new ReportSection(cd, 0, "");
        rs.setCustomName(this.clazz.getName());
        rs.getReportColumns().addAll(tempList);
        blankCRT.getReportSections().add(rs);
    }

    static /* synthetic */ JCheckBox access$4700(ReportsGenerationDialog x0) {
        return x0.chbClearLMDiagrams;
    }

    static /* synthetic */ Glossary access$4800(ReportsGenerationDialog x0) {
        return x0.getGlossaryFile();
    }

    static /* synthetic */ JComboBox access$4900(ReportsGenerationDialog x0) {
        return x0.cmbStandardReportConfigurationsLDP;
    }

    static /* synthetic */ StandardReportConfiguration access$5000() {
        return blankSR;
    }

    static /* synthetic */ List access$5100(ReportsGenerationDialog x0, DesignPart x1, List x2) {
        return x0.getDesignObjectsForObjectsIDs(x1, x2);
    }

    static /* synthetic */ HashMap access$5200(ReportsGenerationDialog x0, DesignPart x1, StandardReportConfiguration x2) {
        return x0.getSubViewsMap(x1, x2);
    }

    static /* synthetic */ boolean access$5300(ReportsGenerationDialog x0) {
        return x0.initConnection();
    }

    static /* synthetic */ Array access$5402(ReportsGenerationDialog x0, Array x1) {
        x0.objects = x1;
        return x0.objects;
    }

    static /* synthetic */ Connection access$5500(ReportsGenerationDialog x0) {
        return x0.connection;
    }

    static /* synthetic */ ReportsGenerationDialog access$5600(ReportsGenerationDialog x0) {
        return x0.rgd;
    }

    static /* synthetic */ void access$5700(ReportsGenerationDialog x0) {
        x0.initReportParams();
    }

    static /* synthetic */ int access$5800(ReportsGenerationDialog x0) {
        return x0.getStoredPackageReportCode();
    }

    static /* synthetic */ JTextField access$5900(ReportsGenerationDialog x0) {
        return x0.txtReportsDir;
    }

    static /* synthetic */ String access$6000(ReportsGenerationDialog x0) {
        return x0.reportFileName;
    }

    static /* synthetic */ Array access$5400(ReportsGenerationDialog x0) {
        return x0.objects;
    }

    static /* synthetic */ String access$6100(ReportsGenerationDialog x0) {
        return x0.reportsPath;
    }

    static /* synthetic */ InputStream access$6202(ReportsGenerationDialog x0, InputStream x1) {
        x0.bfileBinaryStream = x1;
        return x0.bfileBinaryStream;
    }

    static /* synthetic */ InputStream access$6200(ReportsGenerationDialog x0) {
        return x0.bfileBinaryStream;
    }

    static /* synthetic */ JCheckBox access$6300(ReportsGenerationDialog x0) {
        return x0.chbClearRSDiagrams;
    }

    static /* synthetic */ File access$6400(ReportsGenerationDialog x0) {
        return x0.xsltFile;
    }

    static /* synthetic */ HashMap access$6500(ReportsGenerationDialog x0) {
        return x0.modelSchemas;
    }

    static /* synthetic */ Settings access$6600(ReportsGenerationDialog x0) {
        return x0.settings;
    }

    static /* synthetic */ String access$6700(ReportsGenerationDialog x0) {
        return x0.tocTagName;
    }

    static /* synthetic */ String access$6002(ReportsGenerationDialog x0, String x1) {
        x0.reportFileName = x1;
        return x0.reportFileName;
    }

    static {
        LOGGER = new Logger(ReportsGenerationDialog.class);
    }

    private class CustomReportsAction
    implements ActionListener {
        private CustomReportsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List currentObjectsList = new ArrayList();
            DesignPart model = null;
            if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                model = (DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem();
                currentObjectsList = ReportsGenerationDialog.this.getLDObjects();
            } else if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 1) {
                currentObjectsList = ReportsGenerationDialog.this.getRSObjects();
            }
            CustomReportsTemplatesDialog dialog = new CustomReportsTemplatesDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.clazz, ReportsGenerationDialog.this, ReportsGenerationDialog.this.customReportTemplatesPersistence, null, model, ReportsGenerationDialog.this.clazz, currentObjectsList);
            dialog.showDialog();
        }
    }

    public class ReportObject
    implements Comparable {
        private String objectUniqueIdentifier = "";
        private String objectType = "";
        private String objectName = "";
        private String objectLongName = "";
        private String modelOVID = "";
        private String designOVID = "";
        private String subviewUniqueIdentifier = "";
        private boolean inReport = true;
        private String diagramType;
        private Object object;

        private ReportObject(Object object, String objectName, String objectLongName, String objectUniqueIdentifier, String objectType, String designOVID, String modelOVID, String subviewUniqueIdentifier, boolean inReport, String diagramType) {
            this.object = object;
            this.objectUniqueIdentifier = objectUniqueIdentifier;
            this.objectType = objectType;
            this.objectName = objectName;
            this.objectLongName = objectLongName;
            this.designOVID = designOVID;
            this.modelOVID = modelOVID;
            this.subviewUniqueIdentifier = subviewUniqueIdentifier;
            this.inReport = inReport;
            this.diagramType = diagramType;
        }

        public String getObjectUniqueIdentifier() {
            return this.objectUniqueIdentifier;
        }

        public boolean isInReport() {
            return this.inReport;
        }

        public void setInReport(boolean inReport) {
            this.inReport = inReport;
        }

        public String getSubviewUniqueIdentifier() {
            return this.subviewUniqueIdentifier;
        }

        public void setSubviewUniqueIdentifier(String subviewUniqueIdentifier) {
            this.subviewUniqueIdentifier = subviewUniqueIdentifier;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getObjectLongName() {
            return this.objectLongName;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public Object getObject() {
            return this.object;
        }

        public String getDiagramType() {
            return this.diagramType;
        }

        public int compareTo(Object o) {
            return this.getObjectName().compareToIgnoreCase(((ReportObject)o).getObjectName());
        }
    }

    class RSchemaSubView
    implements Comparable {
        private String name;
        private String modelOVID;
        private String objectOVID;

        private RSchemaSubView(String name, String modelOVID, String objectOVID) {
            this.name = name;
            this.modelOVID = modelOVID;
            this.objectOVID = objectOVID;
        }

        public String getName() {
            return this.name;
        }

        public String getModelOVID() {
            return this.modelOVID;
        }

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((RSchemaSubView)o).getName());
        }
    }

    class RSchemaModel
    implements Comparable {
        private String name;
        private String type;
        private String objectOVID;
        private String designOVID;

        private RSchemaModel(String name, String type, String objectOVID, String designOVID) {
            this.name = name;
            this.type = type;
            this.objectOVID = objectOVID;
            this.designOVID = designOVID;
        }

        public String getType() {
            return this.type;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public String getName() {
            return this.name;
        }

        public String getObjectOVID() {
            return this.objectOVID;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((RSchemaModel)o).getName());
        }
    }

    class CmbModelsRSPRenderer
    extends JLabel
    implements ListCellRenderer {
        CmbModelsRSPRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (value != null) {
                text = ((RSchemaModel)value).getName();
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setText(text);
            this.setOpaque(true);
            return this;
        }
    }

    private class RSchemaDesign {
        private String designName;
        private String designOVID;
        private String designDate;
        private String designComments;

        RSchemaDesign(String name, String designOVID, String designDate, String designComments) {
            this.designName = name;
            this.designOVID = designOVID;
            this.designDate = designDate;
            this.designComments = designComments;
        }

        public String getDesignName() {
            return this.designName;
        }

        public String getDesignOVID() {
            return this.designOVID;
        }

        public String getDesignDate() {
            return this.designDate;
        }

        public String getDesignComments() {
            return this.designComments;
        }
    }

    class CmbDesignsRSPRenderer
    extends JLabel
    implements ListCellRenderer {
        ArrayList tooltips;

        CmbDesignsRSPRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            if (value instanceof JComboHtmlItem) {
                this.setText(((JComboHtmlItem)value).getHtmlText());
            } else {
                this.setText((String)value);
            }
            return this;
        }

        public void setTooltips(ArrayList tooltips) {
            this.tooltips = tooltips;
        }
    }

    private class RSDesignsComboListener
    implements ItemListener {
        private RSDesignsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadModels();
            }
        }
    }

    private class RSReportConfigurationsComboListener
    implements ItemListener {
        private RSReportConfigurationsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adjustSettings(false);
            }
        }
    }

    private class LDReportConfigurationsComboListener
    implements ItemListener {
        private LDReportConfigurationsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adjustSettings(false);
            }
        }
    }

    private class ReportsComboListener
    implements ItemListener {
        private ReportsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.adjustSettings(true);
                ReportsGenerationDialog.this.reloadSelectableData();
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                    if (ReportsGenerationDialog.this.templatesTabbedPane.getSelectedComponent() == ReportsGenerationDialog.this.customReportsTemplatesPanel) {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(false);
                    } else {
                        ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                    }
                } else {
                    ReportsGenerationDialog.this.btnGenerate.setEnabled(true);
                }
            }
        }
    }

    private class RSModelsComboListener
    implements ItemListener {
        private RSModelsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadReportConfigurations(false);
            }
        }
    }

    private class LDModelsComboListener
    implements ItemListener {
        private LDModelsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadReportConfigurations(true);
            }
        }
    }

    private class LDDesignsComboListener
    implements ItemListener {
        private LDDesignsComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ReportsGenerationDialog.this.reloadModels();
            }
        }
    }

    class StandardReportRenderer
    extends JLabel
    implements ListCellRenderer {
        StandardReportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            StandardReportConfiguration r = (StandardReportConfiguration)value;
            if (r != null) {
                this.setText(r.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ShowStandardReportConfigurationsAction
    implements ActionListener {
        private ShowStandardReportConfigurationsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List currentObjectsList = new ArrayList();
            if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0) {
                currentObjectsList = ReportsGenerationDialog.this.getLDObjects();
                ReportsGenerationDialog.this.extraParams.put("design_id", ((Design)ReportsGenerationDialog.this.cmbDesignsLDP.getSelectedItem()).getObjectID());
                ReportsGenerationDialog.this.extraParams.put("model_id", ((DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem()).getObjectID());
                ReportsGenerationDialog.this.extraParams.put("subviews", ((DesignPart)ReportsGenerationDialog.this.cmbModelsLDP.getSelectedItem()).getDesignSubviews());
            } else if (ReportsGenerationDialog.this.tpane.getSelectedIndex() == 1) {
                currentObjectsList = ReportsGenerationDialog.this.getRSObjects();
                ReportsGenerationDialog.this.extraParams.put("design_id", ((RSchemaDesign)((JComboHtmlItem)ReportsGenerationDialog.this.cmbDesignsRSP.getSelectedItem()).getObject()).getDesignOVID());
                ReportsGenerationDialog.this.extraParams.put("model_id", ((RSchemaModel)ReportsGenerationDialog.this.cmbModelsRSP.getSelectedItem()).getObjectOVID());
                ReportsGenerationDialog.this.extraParams.put("subviews", ReportsGenerationDialog.this.getRSSubViews());
            }
            ReportsGenerationDialog.this.extraParams.put("srp_persistence", ReportsGenerationDialog.this.srp);
            ReportsGenerationDialog.this.extraParams.put("parent", ReportsGenerationDialog.this);
            ReportsGenerationDialog.this.extraParams.put("objects_list", currentObjectsList);
            ReportsGenerationDialog.this.extraParams.put("loaded_designs", ReportsGenerationDialog.this.tpane.getSelectedIndex() == 0);
            StandardReportsConfigurationDialog moDialog = new StandardReportsConfigurationDialog(ReportsGenerationDialog.this.appView, ReportsGenerationDialog.this.clazz, ReportsGenerationDialog.this.extraParams);
            moDialog.showDialog();
        }
    }

    private class ReloadDesignsAndModelsAction
    implements ActionListener {
        private ReloadDesignsAndModelsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ReportsGenerationDialog.this.loadDesigns(DatabaseConnections.getInstance().getConnection(ReportsGenerationDialog.this.getSelectedConnectionProperties()));
                ReportsGenerationDialog.this.reloadModels();
                ReportsGenerationDialog.this.reloadReportConfigurations(false);
                if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Tables") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Table Views")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(true);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entities") || ((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Entity Views")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(true);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Domains")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Glossaries")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Structured Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Distinct Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Collection Types")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Change Requests")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                } else if (((String)ReportsGenerationDialog.this.cmbReports.getSelectedItem()).equalsIgnoreCase("Measurements")) {
                    ReportsGenerationDialog.this.cmbDesignsRSP.setEnabled(true);
                    ReportsGenerationDialog.this.cmbModelsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.cmbStandardReportConfigurationsRSP.setEnabled(false);
                    ReportsGenerationDialog.this.btnStandardReportConfigurationsRSP.setEnabled(false);
                }
            }
            catch (ConnectionException e1) {
                LOGGER.error("Exception ReportsGenerationDialog.ReloadDesignsAndModelsAction ", e1);
            }
        }
    }

    private class TestAction
    implements ActionListener {
        private TestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FCPConnectionDialog.testConnection(ReportsGenerationDialog.this.getSelectedConnectionProperties());
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Properties cd = ReportsGenerationDialog.this.getSelectedConnectionProperties();
            if (cd != null) {
                try {
                    String connName = ConnectionInfo.getConnectionName(cd);
                    int result = JOptionPane.showConfirmDialog(ReportsGenerationDialog.this, MessageFormat.format(Messages.getString("ReportsGenerationDialog.SureToDelete"), connName), Messages.getString("ReportsGenerationDialog.SelectOption"), 0);
                    if (result == 0) {
                        DatabaseConnections.getInstance().removeConnection(connName);
                        ReportsGenerationDialog.this.updateConnections();
                        ReportsGenerationDialog.this.tbConnections.clearSelection();
                        ReportsGenerationDialog.this.btnTest.setEnabled(false);
                        ReportsGenerationDialog.this.btnProps.setEnabled(false);
                        ReportsGenerationDialog.this.btnRemove.setEnabled(false);
                    }
                }
                catch (ConnectionException e1) {
                    LOGGER.error("Unable to delete connection", e1);
                    MessageDialogs.showMessage(ApplicationView.frame, "Unable to delete connection");
                }
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FCPConnectionDialog.showConnectionDialog(true);
                ReportsGenerationDialog.this.updateConnections();
            }
            catch (Exception e1) {
                LOGGER.error(e1);
            }
        }
    }
}

