/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.connection;

import com.jcraft.jsch.JSchException;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import oracle.dbtools.crest.util.connection.ConnectionUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.JDBCProxyUtil;
import oracle.dbtools.raptor.utils.WindowsOSUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;

public class DMOracleConnectionCreator
extends OracleConnectionCreator {
    private boolean useJDBCProxy = true;
    public static final String EXPORT_PASSWORD_CHECKSUM = "ExportKeyChecksum";
    private static final Logger LOGGER = Logger.getLogger(DMOracleConnectionCreator.class.getName());
    private static String CANCEL_CONNECTION = "RaptorConnectionCreator.cancel_connection";

    public void setUseJDBCProxy(boolean useJDBCProxy) {
        this.useJDBCProxy = useJDBCProxy;
    }

    public boolean isUseJDBCProxy() {
        return this.useJDBCProxy;
    }

    public boolean shouldPromptForPassword(Properties props) {
        return true;
    }

    public Connection getConnection(Properties origProps) throws SQLException {
        Connection conn = null;
        Properties props = origProps;
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)props);
        Connections.populateConnectionInfo((Properties)connProps);
        OracleConnectionProcessor processor = OracleConnectionType.getConnectionProcessor((String)connProps.getProperty("OracleConnectionType"));
        processor.validateProperties(connProps);
        connProps = this.updateForSSH(connProps);
        DBConfig config = DBConfig.getInstance();
        Boolean useThick = config.getBoolean("USE_THICK_DRIVER");
        String jdbcURL = connProps.getProperty("customUrl");
        if (Connections.isOCIDriverAvailable() && useThick.booleanValue() && ConnectionUtils.scrubOraDriverType(jdbcURL).equalsIgnoreCase("thin")) {
            connProps.setProperty("customUrl", ConnectionUtils.getOCIUrl(connProps));
        }
        conn = useThick == false && Boolean.parseBoolean(props.getProperty("KERBEROS_AUTHENTICATION")) ? this.getKerberosConnection(props, connProps, config) : this.getConnectionImpl(connProps);
        if (Boolean.parseBoolean(connProps.getProperty("IS_PROXY"))) {
            this.openProxySession(conn, connProps);
        }
        return conn;
    }

    private Connection getKerberosConnection(Properties origProps, Properties connProps, DBConfig config) throws SQLException, ConnectionCanceledException {
        Connection conn = null;
        String username = origProps.getProperty("user");
        String password = origProps.getProperty("password");
        String kerberosConf = config.getString("KERBEROS_CONFIG");
        connProps.setProperty("customUrl", ConnectionUtils.getThinUrl(connProps));
        if (kerberosConf != null && new File(kerberosConf).exists()) {
            System.setProperty("java.security.krb5.conf", kerberosConf);
        } else {
            System.clearProperty("java.security.krb5.conf");
        }
        connProps.setProperty("user", "");
        connProps.setProperty("password", "");
        String kerberosCache = config.getString("KERBEROS_CACHE");
        if (username == null || username.equals("")) {
            connProps.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
            connProps.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
            if (kerberosCache != null && !kerberosCache.equals("")) {
                connProps.setProperty("oracle.net.kerberos5_cc_name", kerberosCache);
            }
            conn = this.getConnectionImpl(connProps);
        } else {
            boolean retLogin;
            Subject specificSubject = new Subject();
            final String grabPassword = password;
            final Properties passProps = new Properties();
            passProps.putAll((Map<?, ?>)origProps);
            Krb5LoginModule krb5Module = new Krb5LoginModule();
            HashMap sharedState = new HashMap();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("doNotPrompt", "false");
            if (kerberosCache != null && !kerberosCache.equals("")) {
                options.put("useTicketCache", "true");
                options.put("ticketCache", kerberosCache);
            } else {
                options.put("useTicketCache", "false");
            }
            options.put("principal", username);
            krb5Module.initialize(specificSubject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callbacks[i];
                            if (grabPassword == null || grabPassword.equals("")) {
                                Properties connProps3 = new Properties();
                                connProps3.putAll((Map<?, ?>)passProps);
                                String lString = null;
                                lString = DMOracleConnectionCreator.this.getPassword(connProps3, passProps);
                                passProps.setProperty("password", lString);
                                if (lString == null) {
                                    pc.setPassword(null);
                                    continue;
                                }
                                pc.setPassword(lString.toCharArray());
                                continue;
                            }
                            pc.setPassword(grabPassword.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i], CreateDialogArb.getString((String)"UNRECOGNISED_CALLBACK"));
                    }
                }
            }, sharedState, options);
            try {
                retLogin = krb5Module.login();
                krb5Module.commit();
            }
            catch (LoginException e) {
                String amICancel = passProps.getProperty(CANCEL_CONNECTION);
                if (amICancel != null && amICancel.equals("true")) {
                    throw new ConnectionCanceledException();
                }
                throw new SQLException(e.getLocalizedMessage());
            }
            if (!retLogin) {
                throw new SQLException(CreateDialogArb.getString((String)"KERBEROS_CREDENTIALS"));
            }
            connProps.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
            if (kerberosCache != null && !kerberosCache.equals("")) {
                connProps.setProperty("oracle.net.kerberos5_cc_name", kerberosCache);
            }
            OracleDriver driver = new OracleDriver();
            Properties connPropsl = new Properties();
            connPropsl.putAll((Map<?, ?>)connProps);
            final Properties connPropsf = connPropsl;
            try {
                String pass2;
                conn = Subject.doAs(specificSubject, new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws SQLException {
                        return DMOracleConnectionCreator.this.getConnectionImpl(connPropsf);
                    }
                });
                if (conn != null && ModelUtil.hasLength((String)(pass2 = passProps.getProperty("password"))) && !ModelUtil.hasLength((String)password)) {
                    origProps.setProperty("password", pass2);
                }
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return conn;
    }

    protected boolean allowNullPassword() {
        return true;
    }

    private static void updateProperty(Properties origProps, Properties newProps, String key) {
        String value = origProps.getProperty(key);
        if (value != null) {
            newProps.setProperty(key, value);
        }
    }

    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        String[] KerberorProperties;
        super.setCustomProperties(connProps, jdbcProps);
        String driverType = ConnectionUtils.scrubOraDriverType(connProps.getProperty("customUrl"));
        if (Boolean.parseBoolean(connProps.getProperty("OS_AUTHENTICATION")) && PlatformUtils.isWindows() && driverType.equalsIgnoreCase("thin")) {
            jdbcProps.setProperty("v$session.osuser", WindowsOSUtils.getUserWithDomain());
        }
        DMOracleConnectionCreator.updateProperty(connProps, jdbcProps, "OCINewPassword");
        DMOracleConnectionCreator.updateProperty(connProps, jdbcProps, "oracle.jdbc.newPassword");
        for (String prop : KerberorProperties = new String[]{"oracle.net.authentication_services", "oracle.net.kerberos5_cc_name", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "access.alternate.url"}) {
            String got = null;
            got = connProps.getProperty(prop);
            if (got == null) continue;
            jdbcProps.setProperty(prop, got);
        }
        String machine = System.getProperty("jdbc.machine");
        if (machine == null) {
            jdbcProps.remove("v$session.machine");
        } else {
            String val = jdbcProps.getProperty("v$session.machine");
            if (val != null && val.length() > 60) {
                jdbcProps.setProperty("v$session.machine", val.substring(0, 60));
            }
        }
        OracleConnectionProcessor processor = OracleConnectionType.getConnectionProcessor((String)connProps.getProperty("OracleConnectionType"));
        jdbcProps.putAll((Map<?, ?>)processor.finalizeProperties(connProps));
    }

    private void openProxySession(Connection conn, Properties props) throws SQLException {
        String proxyType = props.getProperty("PROXY_TYPE");
        Properties proxyProps = new Properties();
        if (proxyType.equals("USER NAME")) {
            String proxyUser = props.getProperty("PROXY_USER_NAME");
            String proxyPasswd = props.getProperty("PROXY_USER_PASSWORD");
            proxyProps.put("PROXY_USER_NAME", proxyUser);
            if (proxyPasswd != null && proxyPasswd.length() > 0) {
                proxyProps.put("PROXY_USER_PASSWORD", proxyPasswd);
            }
            ((OracleConnection)conn).openProxySession(1, proxyProps);
        } else if (proxyType.equals("DISTINGUISHED NAME")) {
            proxyProps.put("PROXY_USER_NAME", props.getProperty("PROXY_USER_NAME"));
            proxyProps.put("PROXY_DISTINGUISHED_NAME", props.getProperty("PROXY_DISTINGUISHED_NAME"));
            ((OracleConnection)conn).openProxySession(2, proxyProps);
        }
    }

    String getPassword(Properties inprops, Properties passProps) throws IOException {
        String outString = null;
        Properties cloneProps = new Properties();
        cloneProps.putAll((Map<?, ?>)inprops);
        passProps.remove(CANCEL_CONNECTION);
        try {
            ConnectionInfoPanel.promptForConnection((Properties)cloneProps);
            outString = cloneProps.getProperty("password") == null ? "" : cloneProps.getProperty("password");
        }
        catch (ConnectionCanceledException e) {
            passProps.setProperty(CANCEL_CONNECTION, Boolean.toString(true));
            throw new IOException(e.getLocalizedMessage());
        }
        return outString;
    }

    public boolean shouldEncrypt(String propName) {
        boolean encrypt = false;
        if (EXPORT_PASSWORD_CHECKSUM.equals(propName)) {
            encrypt = true;
        } else if ("PROXY_USER_PASSWORD".equals(propName)) {
            encrypt = true;
        } else {
            for (OracleConnectionProcessor processor : OracleConnectionType.getConnectionProcessors()) {
                if (!processor.shouldEncrypt(propName)) continue;
                encrypt = true;
                break;
            }
        }
        return encrypt || super.shouldEncrypt(propName);
    }

    private Connection getConnectionImpl(Properties props) throws SQLException {
        Connection connection = super.getConnection(props);
        if (this.isUseJDBCProxy()) {
            try {
                Connection proxyConnection = JDBCProxyUtil.getInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).jdbcProxyFor(connection, props);
                if (proxyConnection != null) {
                    connection = proxyConnection;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return connection;
    }

    private Properties updateForSSH(Properties props) throws SQLException {
        Properties newProps = props;
        String sshHost = props.getProperty("SshHost.NAME");
        if (sshHost != null) {
            String tunnelName = props.getProperty("SshTunnel.NAME");
            Client client = Client.getInstance();
            Store store = client.getStore();
            TunnelDescriptor desc = store.getTunnelDescriptor(sshHost, tunnelName);
            if (desc == null) {
                throw new SQLException("Bad SSH details");
            }
            try {
                Tunnel tunnel = client.openTunnel(desc);
                int port = tunnel.getPort();
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)props);
                newProps.setProperty("hostname", "localhost");
                newProps.setProperty("port", Integer.toString(port));
                newProps.setProperty("customUrl", this.getConnectionURL(newProps));
            }
            catch (JSchException e) {
                throw new SQLException(e);
            }
        }
        return newProps;
    }
}

