/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.ddlsourceeditor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ddl.FindDialog;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public class DDLSourceEditor {
    private BasicEditorPane m_editor;
    private FindDialog findDialog;
    public FindHighlightPlugin hlPlugin;
    private JPanel leftMargin;

    public DDLSourceEditor(JPanel leftMargin) {
        this.leftMargin = leftMargin;
    }

    public BasicEditorPane getEditor() {
        if (this.m_editor == null) {
            this.m_editor = new BasicEditorPane();
            this.m_editor.setContentType(CodeEditorConstants.TYPE_SQL);
            this.m_editor.setLanguageSupport(".sql");
            this.m_editor.putBooleanProperty("show-line-numbers", true);
            this.m_editor.setVisible(true);
            this.m_editor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
            this.hlPlugin = new FindHighlightPlugin();
            MouseAdapter doubleClickHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    DDLSourceEditor.this.hlPlugin.findText(DDLSourceEditor.this.m_editor.getSelectedText(), 0, true, false, true, true, true);
                }
            };
            this.m_editor.addMouseListener((MouseListener)doubleClickHandler);
            this.m_editor.installPlugin((EditorPlugin)this.hlPlugin);
            StatusBarPlugin statusBar = new StatusBarPlugin(this.m_editor.getFont());
            this.m_editor.installPlugin((EditorPlugin)statusBar);
            EditorStatusBar m_statusBar = new EditorStatusBar();
            this.m_editor.putProperty("finder", (Object)this.hlPlugin);
            this.m_editor.putBooleanProperty("language-support", true);
            this.m_editor.putBooleanProperty("brace-matching-auto", true);
            this.m_editor.putBooleanProperty("code-folding-enabled", true);
            this.m_editor.putBooleanProperty("use-auto-indent", true);
            this.m_editor.putBooleanProperty("use-smart-indent", true);
            this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this.m_editor.installPlugin((EditorPlugin)m_statusBar);
            LineGutterPlugin sqlGutter = new LineGutterPlugin();
            FileOverviewMargin m_fileOverviewMargin = new FileOverviewMargin();
            this.m_editor.installPlugin((EditorPlugin)sqlGutter);
            WorksheetFoldingPlugin m_foldingPlugin = new WorksheetFoldingPlugin();
            this.m_editor.installPlugin((EditorPlugin)m_foldingPlugin);
            HighlightEditorPlugin highlighteditorplugin = new HighlightEditorPlugin();
            m_foldingPlugin.parser.addParserEventListener((ParserEventListener)highlighteditorplugin);
            CodeFoldingMargin codeFoldingMargin = m_foldingPlugin.getCodeFoldingMargin();
            this.leftMargin.add((Component)codeFoldingMargin, "East");
            this.leftMargin.add((Component)sqlGutter, "Center");
            this.m_editor.installPlugin((EditorPlugin)m_fileOverviewMargin);
            this.m_editor.setEditable(true);
        }
        return this.m_editor;
    }

    public BasicEditorPane getEditorPane() {
        return this.getEditor();
    }

    public FindDialog getFindDialog(Frame dialog) {
        String text = "";
        boolean matchCase = false;
        boolean matchWord = false;
        boolean wrapAround = false;
        boolean highlightAll = false;
        boolean searchUp = false;
        boolean searchDown = true;
        if (this.findDialog != null) {
            text = this.findDialog.getFindDataString();
            matchCase = this.findDialog.getMatchCase();
            matchWord = this.findDialog.getMatchWord();
            wrapAround = this.findDialog.getWrapAround();
            highlightAll = this.findDialog.getHighlightAll();
            searchUp = this.findDialog.getSearchUp();
            searchDown = this.findDialog.getSearchDown();
            this.findDialog.dispose();
        }
        this.findDialog = new FindDialog(dialog);
        this.findDialog.setFindDataString(text);
        this.findDialog.setMatchCase(matchCase);
        this.findDialog.setMatchWord(matchWord);
        this.findDialog.setWrapAround(wrapAround);
        this.findDialog.setHighlightAll(highlightAll);
        this.findDialog.setSearchUp(searchUp);
        this.findDialog.setSearchDown(searchDown);
        this.findDialog.setFindNextButtonState();
        return this.findDialog;
    }
}

