/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.options.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;

public class OracleTableTemplateDialog
extends CustomDialog {
    private JDialog dialog;
    protected JPanel general;
    private JButton bnOK;
    private JButton bnCancel;
    private JComboBox cbTemporary;
    private JComboBox cbPreserveRows;
    private JTextField tfTableSpace;
    private JComboBox cbOrganization;
    private JComboBox cbLogging;
    private JTextField tfSegment;
    private JComboBox cbCache;
    private JComboBox cbMonitoring;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JTextField tfRejectLimit;
    private JComboBox cbRowDependency;
    private JComboBox cbPartitioned;
    private JComboBox cbRowMovement;
    private JComboBox cbDataCompression;
    private Dimension dim = new Dimension(150, 20);
    private OracleTableTemplate ott;

    public OracleTableTemplateDialog(ApplicationView appView, OracleTableTemplate ott) {
        super(appView);
        this.ott = ott;
        this.general = new JPanel(new SpringLayout());
        this.general.setPreferredSize(new Dimension(280, 470));
        this.general.setBorder(BorderFactory.createEtchedBorder());
        this.initGeneralView();
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.add((Component)this.general, "Center");
        this.add((Component)pnButtons, "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("OracleTableTemplateDialog.OracleTableTemplate"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void showDialog() {
        this.initOptions();
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void initGeneralView() {
        this.initTemporary();
        this.initPreserveRows();
        this.initTableSpace();
        this.initOrganization();
        this.initLogging();
        this.initSegment();
        this.initCache();
        this.initMonitoring();
        this.initParallel();
        this.initDegree();
        this.initRowDependency();
        this.initPartitioned();
        this.initPartRowMovement();
        this.initDataCompression();
        this.initRejectlimit();
    }

    protected SpringLayout getGeneralLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    protected void setLabelConstraints(JLabel label, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(label);
        labelCons.setX(Spring.constant(10));
        labelCons.setY(Spring.constant(y));
    }

    protected void setObjectConstraints(Component c, int x, int y) {
        SpringLayout.Constraints labelCons = this.getGeneralLayout().getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    private void initTemporary() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Temporary"));
        this.general.add(label);
        this.cbTemporary = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbTemporary.addActionListener(new TemporaryListener());
        this.cbTemporary.setPreferredSize(this.dim);
        this.general.add(this.cbTemporary);
        this.setLabelConstraints(label, 20);
        this.setObjectConstraints(this.cbTemporary, 120, 20);
    }

    private void initPreserveRows() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.PreserveRows"));
        this.general.add(label);
        this.cbPreserveRows = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbPreserveRows.setPreferredSize(this.dim);
        this.general.add(this.cbPreserveRows);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbPreserveRows, 120, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.TableSpace"));
        this.general.add(label);
        this.tfTableSpace = new JTextField();
        this.tfTableSpace.setPreferredSize(this.dim);
        this.general.add(this.tfTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfTableSpace, 120, 80);
    }

    private void initOrganization() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Organization"));
        this.general.add(label);
        this.cbOrganization = new JComboBox<String>(TableProxyOracle.getOrganizationChoices());
        this.cbOrganization.addActionListener(new OrganizationListener());
        this.cbOrganization.setPreferredSize(this.dim);
        this.general.add(this.cbOrganization);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbOrganization, 120, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(AbstractPropertyDialog.EMPTY_YES_NO);
        this.cbLogging.setPreferredSize(this.dim);
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 120, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Segment"));
        this.general.add(label);
        this.tfSegment = new JTextField();
        this.tfSegment.setPreferredSize(this.dim);
        this.general.add(this.tfSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfSegment, 120, 170);
    }

    private void initCache() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbCache.setPreferredSize(this.dim);
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbCache, 120, 200);
    }

    private void initMonitoring() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Monitoring"));
        this.general.add(label);
        this.cbMonitoring = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbMonitoring.setPreferredSize(this.dim);
        this.general.add(this.cbMonitoring);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbMonitoring, 120, 230);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbParallel.setPreferredSize(this.dim);
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbParallel, 120, 260);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Degree"));
        this.general.add(label);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.dim);
        this.general.add(this.tfDegree);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfDegree, 120, 290);
    }

    private void initRowDependency() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.RowDependency"));
        this.general.add(label);
        this.cbRowDependency = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbRowDependency.setPreferredSize(this.dim);
        this.general.add(this.cbRowDependency);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbRowDependency, 120, 320);
    }

    private void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbPartitioned.setPreferredSize(this.dim);
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbPartitioned, 120, 350);
    }

    private void initPartRowMovement() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.13"));
        this.general.add(label);
        this.cbRowMovement = new JComboBox<String>(TableProxyOracle.getParttitionedRowMovementChoices());
        this.cbRowMovement.setPreferredSize(this.dim);
        this.general.add(this.cbRowMovement);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbRowMovement, 120, 380);
    }

    private void initDataCompression() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.DataCompression"));
        this.general.add(label);
        this.cbDataCompression = new JComboBox<String>(AbstractPropertyDialog.YES_NO);
        this.cbDataCompression.setPreferredSize(this.dim);
        this.general.add(this.cbDataCompression);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbDataCompression, 120, 410);
    }

    private void initRejectlimit() {
        JLabel label = new JLabel(Messages.getString("OracleTableTemplateDialog.RejectLimit"));
        this.general.add(label);
        this.tfRejectLimit = new JTextField();
        this.tfRejectLimit.setPreferredSize(this.dim);
        this.general.add(this.tfRejectLimit);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.tfRejectLimit, 120, 440);
    }

    private void initOptions() {
        this.cbTemporary.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getTemporary()));
        this.cbPreserveRows.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getPreserveRows()));
        this.tfTableSpace.setText(this.ott.getTableSpace());
        this.cbOrganization.setSelectedItem(this.ott.getOrganization());
        this.cbLogging.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getLogging()));
        this.tfSegment.setText(this.ott.getSegment());
        this.cbCache.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getCache()));
        this.cbMonitoring.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getMonitoring()));
        this.cbParallel.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getParallel()));
        this.tfDegree.setText(this.ott.getDegree());
        this.cbRowDependency.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getRowDependency()));
        this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getPartitioned()));
        this.cbRowMovement.setSelectedItem(this.ott.getRowMovement());
        this.cbDataCompression.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.ott.getDataCompression()));
        this.tfRejectLimit.setText(this.ott.getRejectLimit());
        this.enableControls(this.ott.getTemporary().equalsIgnoreCase("YES"));
    }

    private void enableControls(boolean enable) {
        if (enable) {
            this.cbOrganization.setSelectedItem(TableProxyOracle.getOrganizationChoices()[0]);
            this.cbOrganization.setEnabled(false);
            this.tfSegment.setEnabled(false);
            this.cbPartitioned.setSelectedItem(AbstractPropertyDialog.NO);
            this.cbPartitioned.setEnabled(false);
            this.tfTableSpace.setEnabled(false);
            this.cbLogging.setEnabled(false);
            this.cbMonitoring.setEnabled(false);
            this.cbParallel.setEnabled(false);
            this.tfDegree.setEnabled(false);
            this.tfRejectLimit.setEnabled(false);
        } else {
            this.cbPartitioned.setEnabled(true);
            this.tfTableSpace.setEnabled(true);
            this.cbLogging.setEnabled(true);
            this.cbMonitoring.setEnabled(true);
            this.cbParallel.setEnabled(true);
            this.tfDegree.setEnabled(true);
            this.tfRejectLimit.setEnabled(true);
            this.cbOrganization.setEnabled(true);
            this.tfSegment.setEnabled(true);
        }
    }

    private void setOptions() {
        this.ott.setTemporary(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbTemporary.getSelectedItem()));
        this.ott.setPreserveRows(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbPreserveRows.getSelectedItem()));
        this.ott.setTableSpace(this.tfTableSpace.getText());
        this.ott.setOrganization((String)this.cbOrganization.getSelectedItem());
        this.ott.setLogging(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
        this.ott.setSegment(this.tfSegment.getText());
        this.ott.setCache(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbCache.getSelectedItem()));
        this.ott.setMonitoring(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbMonitoring.getSelectedItem()));
        this.ott.setParallel(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
        this.ott.setDegree(this.tfDegree.getText());
        this.ott.setRowDependency(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbRowDependency.getSelectedItem()));
        this.ott.setPartitioned(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
        this.ott.setRowMovement((String)this.cbRowMovement.getSelectedItem());
        this.ott.setDataCompression(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbDataCompression.getSelectedItem()));
        this.ott.setRejectLimit(this.tfRejectLimit.getText());
    }

    private Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OracleTableTemplateDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleTableTemplateDialog.this.setOptions();
                OracleTableTemplateDialog.this.close();
            }
        };
        return action;
    }

    private Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("OracleTableTemplateDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleTableTemplateDialog.this.close();
            }
        };
        return action;
    }

    private class OrganizationListener
    implements ActionListener {
        private OrganizationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OracleTableTemplateDialog.this.cbOrganization.getSelectedItem() != null) {
                String organization = (String)OracleTableTemplateDialog.this.cbOrganization.getSelectedItem();
                if (organization.equalsIgnoreCase(TableProxyOracle.getOrganizationChoices()[0])) {
                    OracleTableTemplateDialog.this.cbCache.setEnabled(true);
                } else {
                    OracleTableTemplateDialog.this.cbCache.setEnabled(false);
                }
            }
        }
    }

    private class TemporaryListener
    implements ActionListener {
        private TemporaryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OracleTableTemplateDialog.this.enableControls(((String)OracleTableTemplateDialog.this.cbTemporary.getSelectedItem()).equals(AbstractPropertyDialog.YES));
        }
    }
}

