/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.xmlmeta;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.util.xmlmeta.XMConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClassToXML
implements XMConstants {
    private Class designClass;
    private Class dpClass;
    private Class midoClass;
    private Class doClass = null;
    private Class soClass = null;
    private List<Class> classList;
    private List ignoreList;
    private List otherClasses = new ArrayList();
    private FileFilter classFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".class");
        }
    };

    public ClassToXML() {
        this.classList = new ArrayList<Class>();
        this.ignoreList = new ArrayList();
        this.ignoreList.add("MDConfiguration");
        this.ignoreList.add("MDPreferences");
        this.ignoreList.add("oracle.dbtools.crest.model.persistence");
        this.ignoreList.add("oracle.dbtools.crest.model.datatype");
        this.ignoreList.add("oracle.dbtools.crest.model.designrules");
        this.ignoreList.add("oracle.dbtools.crest.model.placeholder");
        this.ignoreList.add("oracle.dbtools.crest.model.propertyholder");
        this.ignoreList.add("oracle.dbtools.crest.model.reference");
        this.ignoreList.add("oracle.dbtools.crest.model.xtdmapping");
        this.ignoreList.add("oracle.dbtools.crest.model.design.compare");
        this.ignoreList.add("oracle.dbtools.crest.model.design.constraint");
        this.ignoreList.add("oracle.dbtools.crest.model.design.engineering");
        this.ignoreList.add("oracle.dbtools.crest.model.design.glossary");
        this.ignoreList.add("oracle.dbtools.crest.model.design.impact");
        this.ignoreList.add("oracle.dbtools.crest.model.design.undo");
        try {
            this.designClass = Class.forName("oracle.dbtools.crest.model.design.Design");
            this.dpClass = Class.forName("oracle.dbtools.crest.model.design.DesignPart");
            this.midoClass = Class.forName("oracle.dbtools.crest.model.ModelIDObject");
            this.doClass = Class.forName("oracle.dbtools.crest.model.design.DesignObject");
            this.soClass = Class.forName("oracle.dbtools.crest.model.design.storage.StorageObject");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void execute() {
        try {
            try {
                this.otherClasses.add(Class.forName("oracle.dbtools.crest.model.design.ContainedObjectWithDomain"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (Class cl : this.otherClasses) {
                this.generateXMLOther(cl);
            }
            System.out.println("DONE!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void listClasses(ClassLoader classLoader, String pkg) {
        if (this.ignoreList.contains(pkg)) {
            return;
        }
        try {
            String path = pkg.replace('.', '/');
            URL resource = classLoader.getResource(path);
            File directory = new File(resource.getFile());
            if (directory.exists()) {
                File[] files = directory.listFiles(this.classFilter);
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.listClasses(classLoader, pkg + "." + files[i].getName());
                        continue;
                    }
                    String fileName = files[i].getName();
                    if (this.ignoreList.contains(fileName = fileName.substring(0, fileName.length() - 6)) || fileName.indexOf(36) > -1) continue;
                    this.classList.add(Class.forName(pkg + '.' + fileName));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isDesign(Class cl) {
        return this.designClass != null && this.designClass.isAssignableFrom(cl);
    }

    private boolean isDesignPart(Class cl) {
        return this.dpClass != null && this.dpClass.isAssignableFrom(cl);
    }

    private boolean isModelIDObject(Class cl) {
        return this.midoClass != null && this.midoClass.equals(cl);
    }

    private boolean isDesignObject(Class cl) {
        return this.doClass != null && this.doClass.isAssignableFrom(cl);
    }

    private boolean isStorageObject(Class cl) {
        return this.soClass != null && this.soClass.isAssignableFrom(cl);
    }

    private void generateXMLFor(Class cl) {
        try {
            if (this.isDesign(cl) || this.isDesignPart(cl) || this.isModelIDObject(cl) || this.isDesignObject(cl) || this.isStorageObject(cl)) {
                Method[] methods = cl.getDeclaredMethods();
                Method[] scMethods = cl.getSuperclass().getMethods();
                TreeMap setters = new TreeMap();
                TreeMap getters = new TreeMap();
                TreeMap isers = new TreeMap();
                for (int i = 0; i < methods.length; ++i) {
                    if (!this.isAccepted(methods[i], scMethods)) continue;
                    if (methods[i].getName().startsWith("set")) {
                        this.addToMap(methods[i], setters, 3);
                        continue;
                    }
                    if (methods[i].getName().startsWith("get")) {
                        this.addToMap(methods[i], getters, 3);
                        continue;
                    }
                    if (!methods[i].getName().startsWith("is")) continue;
                    this.addToMap(methods[i], isers, 2);
                }
                this.buildXML(cl, getters, isers, setters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateXMLOther(Class cl) {
        try {
            Method[] methods = cl.getDeclaredMethods();
            Method[] scMethods = cl.getSuperclass().getMethods();
            TreeMap setters = new TreeMap();
            TreeMap getters = new TreeMap();
            TreeMap isers = new TreeMap();
            for (int i = 0; i < methods.length; ++i) {
                if (!this.isAccepted(methods[i], scMethods)) continue;
                if (methods[i].getName().startsWith("set")) {
                    this.addToMap(methods[i], setters, 3);
                    continue;
                }
                if (methods[i].getName().startsWith("get")) {
                    this.addToMap(methods[i], getters, 3);
                    continue;
                }
                if (!methods[i].getName().startsWith("is")) continue;
                this.addToMap(methods[i], isers, 2);
            }
            this.buildXML(cl, getters, isers, setters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToMap(Method method, Map map, int prefixLength) {
        String name = method.getName().substring(prefixLength);
        map.put(name, method);
    }

    private String getDataType(String type) {
        String dt = type.trim();
        if (dt.endsWith(";")) {
            dt = dt.substring(0, dt.length() - 1);
        }
        if (dt.startsWith("class ")) {
            return dt.substring(6).trim();
        }
        return dt;
    }

    private String isReffered(String dataType) {
        if (dataType.startsWith("oracle.dbtools.crest") || dataType.startsWith("[Loracle.dbtools.crest")) {
            return "true";
        }
        return "false";
    }

    private String lowerFirstChar(String name) {
        String result = name.replace(name.charAt(0), name.toLowerCase().charAt(0));
        return result.replace(result.charAt(1), result.toLowerCase().charAt(1));
    }

    private void buildXML(Class cl, Map getters, Map isers, Map setters) {
        try {
            Element elm;
            String dataType;
            String lowerName;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            String clname = cl.getName();
            boolean inner = false;
            if (clname.indexOf(36) > -1) {
                clname = clname.replace('$', '.');
                inner = true;
            }
            Element rootElement = doc.createElement(clname);
            doc.appendChild(rootElement);
            rootElement.setAttribute("parentClass", cl.getSuperclass().getName());
            if (inner) {
                rootElement.setAttribute("innerClass", "true");
            }
            for (String name : setters.keySet()) {
                lowerName = this.lowerFirstChar(name);
                Method setter = (Method)setters.get(name);
                Method getter = null;
                if (getters.containsKey(name)) {
                    getter = (Method)getters.get(name);
                } else if (isers.containsKey(name)) {
                    getter = (Method)isers.get(name);
                }
                if (getter == null || setter == null) continue;
                Class<?> returnType = getter.getReturnType();
                String dataType2 = this.getDataType(returnType.toString());
                Element elm2 = doc.createElement("property");
                rootElement.appendChild(elm2);
                elm2.setAttribute("name", lowerName);
                elm2.setAttribute("dataType", dataType2);
                elm2.setAttribute("defaultValue", "");
                elm2.setAttribute("xmlName", lowerName);
                elm2.setAttribute("xmlType", "element");
                elm2.setAttribute("getter", getter.getName());
                elm2.setAttribute("setter", setter.getName());
                elm2.setAttribute("reffered", this.isReffered(dataType2));
                isers.remove(name);
                getters.remove(name);
            }
            for (String name : isers.keySet()) {
                lowerName = this.lowerFirstChar(name);
                Method iser = (Method)isers.get(name);
                dataType = this.getDataType(iser.getReturnType().toString().toString());
                elm = doc.createElement("roproperty");
                rootElement.appendChild(elm);
                elm.setAttribute("name", lowerName);
                elm.setAttribute("dataType", dataType);
                elm.setAttribute("getter", iser.getName());
            }
            for (String name : getters.keySet()) {
                lowerName = this.lowerFirstChar(name);
                Method getter = (Method)getters.get(name);
                dataType = this.getDataType(getter.getReturnType().toString().toString());
                elm = doc.createElement("roproperty");
                rootElement.appendChild(elm);
                elm.setAttribute("name", lowerName);
                elm.setAttribute("dataType", dataType);
                elm.setAttribute("getter", getter.getName());
            }
            this.saveXML(doc, cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveXML(Document doc, Class cl) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            String fileName = cl.getName();
            fileName = fileName.replace('.', '/');
            String path = fileName.substring(0, fileName.lastIndexOf(47));
            String rootPath = System.getProperty("user.dir");
            File fPath = new File(rootPath, "xmlmeta/" + path);
            if (!fPath.exists()) {
                fPath.mkdirs();
            }
            File file = new File(rootPath, "xmlmeta/" + fileName + ".xml");
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isAccepted(Method method, Method[] scMethods) {
        boolean result = this.isPublicNonStaticMethod(method) && (this.hasSingleArgument(method) || this.hasNoArgument(method) && !this.hasVoidReturn(method)) && this.isNewMethod(method, scMethods);
        return result;
    }

    private boolean isNewMethod(Method method, Method[] scMethods) {
        for (int i = 0; i < scMethods.length; ++i) {
            if (!scMethods[i].getName().equalsIgnoreCase(method.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isPublicNonStaticMethod(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    private boolean hasSingleArgument(Method method) {
        return method.getParameterTypes().length == 1;
    }

    private boolean hasNoArgument(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private boolean hasVoidReturn(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    public static void main(String[] args) {
        ClassToXML class2xml = new ClassToXML();
        class2xml.execute();
    }
}

