/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.net.ConnectException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.DMSQLServerConnectionPanel;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;

public class DMSQLServerConnectionCreator
extends CustomConnectionCreator {
    private static boolean canHaveNullPassword = false;

    protected boolean allowNullPassword() {
        return canHaveNullPassword;
    }

    public Connection getConnection(Properties props) throws SQLException {
        props.setProperty("NoPasswordConnection", "TRUE");
        canHaveNullPassword = true;
        try {
            Connection conn;
            block26: {
                SQLException ex;
                Class<?> cls;
                ClassLoader cl;
                String username = props.getProperty("user");
                String password = props.getProperty("password");
                if (!this.hasLength(password) && !this.allowNullPassword()) {
                    throw new SQLException(this.getBundle().getString("ERROR_MISSING_PASS"), "");
                }
                String url = props.getProperty("customUrl");
                if (!this.hasLength(url)) {
                    url = this.getConnectionURL(props);
                }
                Driver driver = null;
                boolean driverFound = false;
                try {
                    cl = RaptorClassLoader.findClassLoader((String)"net.sourceforge.jtds.jdbc.Driver");
                    cls = Class.forName("net.sourceforge.jtds.jdbc.Driver", true, cl);
                    driver = (Driver)cls.newInstance();
                    driverFound = true;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (ClassNotFoundException td) {
                }
                catch (Throwable t) {
                    SQLException ex2 = new SQLException(t.getLocalizedMessage());
                    ex2.initCause(t);
                    throw ex2;
                }
                if (!driverFound) {
                    try {
                        cl = RaptorClassLoader.findClassLoader((String)"com.microsoft.jdbc.sqlserver.SQLServerDriver");
                        cls = Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver", true, cl);
                        driver = (Driver)cls.newInstance();
                        driverFound = true;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (ClassNotFoundException td) {
                    }
                    catch (Throwable t) {
                        ex = new SQLException(t.getLocalizedMessage());
                        ex.initCause(t);
                        throw ex;
                    }
                }
                if (!driverFound) {
                    try {
                        cl = RaptorClassLoader.findClassLoader((String)"com.microsoft.sqlserver.jdbc.SQLServerDriver");
                        cls = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver", true, cl);
                        driver = (Driver)cls.newInstance();
                        driverFound = true;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (ClassNotFoundException cne) {
                        throw new SQLException(this.getBundle().getString("ERROR_DRIVER_CLASS_NOT_FOUND"));
                    }
                    catch (Throwable t) {
                        ex = new SQLException(t.getLocalizedMessage());
                        ex.initCause(t);
                        throw ex;
                    }
                }
                Properties jdbcProps = new Properties();
                String role = props.getProperty("role");
                if (this.hasLength(role)) {
                    jdbcProps.put("internal_logon", role);
                }
                if (this.hasLength(username)) {
                    jdbcProps.put("user", username);
                }
                if (this.hasLength(password)) {
                    jdbcProps.put("password", password);
                }
                this.setCustomProperties(props, jdbcProps);
                conn = null;
                try {
                    conn = driver.connect(url, jdbcProps);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new SQLException(e.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    if (!(driver instanceof OracleDriver)) break block26;
                    throw new SQLException(this.getBundle().getString("ERROR_UNSUPPORTED_ORACLE_VERSION"));
                }
            }
            if (conn == null) {
                throw new SQLException(this.getBundle().getString("ERROR_INVALID_URL"));
            }
            return conn;
        }
        catch (SQLException ex) {
            if (ex.getCause() instanceof ConnectException) {
                throw new SQLException(ConnectionDialogArb.format((String)"SQL_SERVER_CONNECTION_ERROR", (Object[])new Object[]{props.getProperty("hostname")}), ex.getSQLState(), ex.getErrorCode());
            }
            throw ex;
        }
    }

    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        super.setCustomProperties(connProps, jdbcProps);
        String isDefault = connProps.getProperty(DMSQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD);
        if (isDefault != null && isDefault.equals(Boolean.TRUE.toString())) {
            jdbcProps.setProperty("password", "");
        }
    }
}

