/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.e1pdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudResources;
import oracle.dbtools.raptor.cloud.connection.ui.OSSPanel;
import oracle.dbtools.raptor.cloud.e1pdb.CloudConfigurationException;
import oracle.dbtools.raptor.cloud.e1pdb.CloudProcessor;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Logger;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.ui.RichHintLabel;

public class CloudPanel
implements OracleConnectionTypePanel {
    private static final OracleConnectionType CLOUD_TYPE = OracleConnectionType.findType((String)"CLOUD");
    private static final String ACTION_ID = "display-jce-instructions";
    private Container mPanel;
    private URLFileChooser.URLFileChooserPanel mChooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)CloudResources.getString("LABEL_CONFIG_FILE"), (boolean)false);
    private JComboBox<String> mService = new JComboBox();
    private JCheckBox mUseProxy = new JCheckBox();
    private JTextField mProxyHost = new JTextField();
    private JTextField mProxyPort = new JTextField(5);
    private JButton mOSSConfigBtn = new JButton();
    private Properties mOSSConfig = new Properties();

    public void generateProperties(Properties properties) {
        String string;
        File file = this.mChooser.getSelectedFile();
        if (file != null) {
            properties.setProperty("sqldev.cloud.configfile", file.getAbsolutePath());
        }
        if ((string = (String)this.mService.getSelectedItem()) != null) {
            properties.setProperty("customUrl", string);
        }
        properties.setProperty("OracleConnectionType", CLOUD_TYPE.name());
        properties.putAll((Map<?, ?>)this.mOSSConfig);
        properties.setProperty("sqldev.cloud.useproxy", Boolean.toString(this.mUseProxy.isSelected()));
        properties.setProperty("sqldev.cloud.proxy.host", this.mProxyHost.getText());
        properties.setProperty("sqldev.cloud.proxy.port", this.mProxyPort.getText());
    }

    public void updatePrompts(Properties properties) {
        Object object;
        String string = properties.getProperty("sqldev.cloud.configfile");
        if (string != null) {
            object = new File(string);
            this.mChooser.setSelectedFile((File)object);
        }
        object = properties.getProperty("customUrl");
        this.mService.setSelectedItem(object);
        this.mOSSConfig.clear();
        for (String string2 : OSSPanel.SUPPORTED_KEYS) {
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            this.mOSSConfig.setProperty(string2, string3);
        }
        boolean bl = Boolean.valueOf(properties.getProperty("sqldev.cloud.useproxy"));
        this.mUseProxy.setSelected(bl);
        String string4 = properties.getProperty("sqldev.cloud.proxy.host");
        this.mProxyHost.setText(string4);
        String string5 = properties.getProperty("sqldev.cloud.proxy.port");
        this.mProxyPort.setText(string5);
    }

    public void clear() {
        this.mChooser.setSelectedURL(null);
        this.mOSSConfig.clear();
        this.mUseProxy.setSelected(false);
        this.mProxyHost.setText("");
        this.mProxyPort.setText("");
    }

    public void setDefaultPrompts() {
        this.clear();
    }

    public Component getPanel() {
        if (this.mPanel == null) {
            this.mPanel = this.createUI();
        }
        return this.mPanel;
    }

    public OracleConnectionType getConnectionType() {
        return CLOUD_TYPE;
    }

    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
    }

    private void updateServiceList(File file) {
        String string = (String)this.mService.getSelectedItem();
        try {
            Collection<Object> collection = Collections.emptyList();
            CloudProcessor.Config config = CloudProcessor.getCloudConfigForZip(file);
            if (config != null) {
                collection = config.getConnectionNames();
                collection = new TreeSet<Object>(collection);
            }
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(collection.toArray(new String[0]));
            this.mService.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(string) >= 0) {
                this.mService.setSelectedItem(string);
            }
        }
        catch (CloudConfigurationException cloudConfigurationException) {
            Logger.warn(CloudProcessor.class, (Throwable)cloudConfigurationException);
        }
    }

    private Container createUI() {
        boolean bl = CloudProcessor.testJCE();
        JPanel jPanel = LayoutControl.GBC.createPanel();
        if (bl) {
            this.mChooser.clearChooseableURLFilters();
            this.mChooser.addChooseableURLFilter(CloudProcessor.ZIPFILE_FILE);
            this.mChooser.setSelectionScope(0);
            this.mChooser.setSelectionMode(0);
            this.mChooser.setShowJarsAsDirs(false);
            this.mChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = CloudPanel.this.mChooser.getSelectedFile();
                    CloudPanel.this.updateServiceList(file);
                }
            });
            int n = 0;
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mChooser, (String)CloudResources.getString("LABEL_CONFIG_FILE"));
            jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel.add((Component)this.mChooser, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, this.mService, (String)CloudResources.getString("LABEL_SERVICE"));
            jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel.add(this.mService, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
            ResourceUtils.resButton((AbstractButton)this.mUseProxy, (String)CloudResources.getString("LABEL_USE_PROXY"));
            this.mUseProxy.addItemListener(itemEvent -> this.updateProxyState(this.mUseProxy.isSelected()));
            this.updateProxyState(this.mUseProxy.isSelected());
            jPanel.add((Component)this.mUseProxy, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
            JPanel jPanel2 = LayoutControl.GBC.createPanel();
            jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mProxyHost, (String)CloudResources.getString("LABEL_PROXY_HOST"));
            jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel2.add((Component)this.mProxyHost, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mProxyPort, (String)CloudResources.getString("LABEL_PROXY_PORT"));
            jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
            jPanel2.add((Component)this.mProxyPort, LayoutControl.GBC.gbc((int)3, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
            jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            ResourceUtils.resButton((AbstractButton)this.mOSSConfigBtn, (String)CloudResources.getString("LABEL_OSS_CONFIGURE_BUTTON"));
            this.mOSSConfigBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Namespace namespace = OSSPanel.createNamespace((Properties)CloudPanel.this.mOSSConfig);
                    OSSPanel oSSPanel = new OSSPanel();
                    TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)CloudPanel.this.mOSSConfigBtn, CloudResources.getString("TITLE_OSS_CONFIGURE"), (Traversable)oSSPanel, namespace);
                    tDialogLauncher.setPackDialog(true);
                    tDialogLauncher.initDialog().setInitialFocus(oSSPanel.getInitialFocusComponent());
                    if (tDialogLauncher.showDialog()) {
                        CloudPanel.this.mOSSConfig.clear();
                        CloudPanel.this.mOSSConfig.putAll((Map<?, ?>)OSSPanel.createProperties((Namespace)namespace));
                    }
                }
            });
            jPanel.add((Component)this.mOSSConfigBtn, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
        } else {
            RichHintLabel richHintLabel = new RichHintLabel();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<b>").append(System.getProperty("java.home")).append("</b>");
            String string = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append("<a href=\"http:").append(ACTION_ID).append("\">").append(CloudResources.getString("JCE_INSTALL_LOCATION")).append("</a>");
            String string2 = stringBuilder.toString();
            richHintLabel.setHtmlText(CloudResources.format("MSG_MISSING_JCE_CONFIG", string, string2));
            richHintLabel.registerAction(ACTION_ID, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        URL uRL = URLFactory.newURL((String)CloudResources.getString("JCE_INSTALL_LOCATION"));
                        if (uRL != null) {
                            BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                            browserRunner.runBrowserOnURL(uRL, null, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            jPanel.add((Component)richHintLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.FIRST_LINE_START));
        }
        return jPanel;
    }

    private void updateProxyState(boolean bl) {
        this.mProxyHost.setEnabled(bl);
        this.mProxyPort.setEnabled(bl);
    }
}

