/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.sql.Connection;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class ConnectionInfo
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.jdeveloper.db.ConnectionInfo";
    private static final String STORE_NAME_KEY = "StoreName";
    private static final String CONN_NAME_KEY = "ConnectionName";

    public ConnectionInfo(String string, String string2) {
        this(HashStructure.newInstance());
        this.setStoreName(string);
        this.setConnectionName(string2);
    }

    public ConnectionInfo(String string) {
        this(HashStructure.newInstance());
        this.setQualifiedName(string);
    }

    private ConnectionInfo(HashStructure hashStructure) {
        super(hashStructure);
    }

    public String getStoreName() {
        return this._hash.getString(STORE_NAME_KEY);
    }

    public void setStoreName(String string) {
        this._hash.putString(STORE_NAME_KEY, string);
    }

    public String getConnectionName() {
        return this._hash.getString(CONN_NAME_KEY);
    }

    public void setConnectionName(String string) {
        this._hash.putString(CONN_NAME_KEY, string);
    }

    public String getQualifiedName() {
        String string = this.getStoreName();
        String string2 = this.getConnectionName();
        return DatabaseFactory.encodeIdentifier((String)string, (String)string2);
    }

    public void setQualifiedName(String string) {
        if (string == null) {
            this.setStoreName(null);
            this.setConnectionName(null);
        } else {
            String[] stringArray = DatabaseFactory.decodeIdentifier((String)string);
            this.setStoreName(stringArray[0]);
            this.setConnectionName(stringArray[1]);
        }
    }

    public DBObjectProviderID getProviderID() {
        return new DBObjectProviderID("db", (Object)this.getQualifiedName());
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean isValid() {
        return this.getReferenceable() != null;
    }

    public DatabaseProvider getReferenceable() {
        return DatabaseConnectionStores.getReferenceable(this.getStoreName(), this.getConnectionName());
    }

    public Connection getConnection() throws ConnectionException {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
        if (databaseConnections != null) {
            return databaseConnections.getConnection(this.getConnectionName());
        }
        return null;
    }

    public Database getDatabase() throws DBException {
        DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
        if (databaseConnections != null) {
            return databaseConnections.getDatabase(this.getConnectionName());
        }
        return null;
    }

    public static ConnectionInfo getConnectionInfo(PropertyStorage propertyStorage) {
        return ConnectionInfo.getConnectionInfo(propertyStorage, DATA_KEY);
    }

    public static ConnectionInfo getConnectionInfo(PropertyStorage propertyStorage, String string) {
        HashStructure hashStructure = propertyStorage == null ? HashStructure.newInstance() : propertyStorage.getProperties();
        return new ConnectionInfo(hashStructure.getOrCreateHashStructure(string));
    }
}

