/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.awt.Window;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionEditorLauncher;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.StoreContext;

public class DatabaseActions
implements Controller {
    private static final String NEW_CONNECTION_ID = "oracle.jdeveloper.db.NewConnection";
    private static final String DISONNECT_ID = "oracle.jdeveloper.db.DisconnectConnection";
    public static final String EDIT_CONNECTION = "ConnectionName";
    public static final String CONNECTION_STORE = "ConnectionStore";

    protected DatabaseActions() {
    }

    public static IdeAction getConnectionEditorAction() {
        return IdeAction.find((String)NEW_CONNECTION_ID);
    }

    public static IdeAction getDisconnectAction() {
        return IdeAction.find((String)DISONNECT_ID);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DatabaseActions.getConnectionEditorAction().getCommandId()) {
            String string = (String)ideAction.getValue(EDIT_CONNECTION);
            String string2 = (String)ideAction.getValue(CONNECTION_STORE);
            this.handleConnectionEditor(string2, string, context);
            return true;
        }
        if (n == DatabaseActions.getDisconnectAction().getCommandId()) {
            this.handleDisconnect(context);
            return true;
        }
        return false;
    }

    protected boolean handleDisconnect(Context context) {
        String string;
        boolean bl = false;
        DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
        DatabaseConnections databaseConnections = databaseConnectionStores.getCurrentStore(context);
        if (databaseConnections != null && (string = databaseConnectionStores.getCurrentConnection(context)) != null) {
            try {
                databaseConnections.disconnect(string);
                bl = true;
            }
            catch (ConnectionException connectionException) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)connectionException);
            }
        }
        return bl;
    }

    protected void handleConnectionEditor(String string, String string2, Context context) {
        Object object;
        DatabaseConnections databaseConnections;
        if (!ModelUtil.hasLength((String)string) && (databaseConnections = ((DatabaseConnectionStores)(object = DatabaseConnectionStores.getInstance())).getCurrentStore(context)) != null) {
            string = databaseConnections.getStoreName();
        }
        object = DatabaseConnectionEditor.createLauncher();
        ((DatabaseConnectionEditorLauncher)object).setEnsureVisible(true);
        if (StoreContext.getContext().isGlobalContext(context)) {
            ((DatabaseConnectionEditorLauncher)object).setStoreChoice(DatabaseConnectionEditorLauncher.StoreChoice.ALL);
        }
        ((DatabaseConnectionEditorLauncher)object).launchEditor(string, string2);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == DatabaseActions.getConnectionEditorAction().getCommandId()) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == DatabaseActions.getDisconnectAction().getCommandId()) {
            boolean bl;
            DatabaseConnectionStores databaseConnectionStores = DatabaseConnectionStores.getInstance();
            Element element = context.getElement();
            boolean bl2 = bl = databaseConnectionStores.getCurrentConnection(context) != null;
            if (bl && element instanceof Node) {
                bl = ((Node)element).isOpen();
            }
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }
}

