/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.migration;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.db.adapter.CMHelper;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class CMConnectionsReader
extends DefaultHandler
implements LexicalHandler {
    public static final String DEFAULT_FILE = "connections.xml";
    public static final String DEFAULT_PROPERTIES_FILE = "connections.properties";
    public static final String CONNECTION_TAG = "connection";
    private static final String PWD_PROP = "PWD";
    private static final String ORMI_PWD_PROP = "ORMI-PWD";
    public static final String PASSWORD = "password";
    public static final String ORMI_PASSWD = "ormi-password";
    public static final String CONNECTION_NAME = "ConnectionName";
    public static final String CONNECTION_TYPE = "ConnectionType";
    private final String m_fName;
    private final boolean m_isAbsolutePath;
    private List<Properties> m_list = null;
    private Properties m_curDesc = null;
    private String m_curKey;
    private StringBuffer m_curValue;
    private String m_cdata;

    public CMConnectionsReader() {
        this("/connections.xml", false);
    }

    public CMConnectionsReader(String string, boolean bl) {
        this.m_fName = string;
        this.m_isAbsolutePath = bl;
    }

    private final Logger getLogger() {
        return DBLog.getAndInitialiseLogger((String)"oracle.jdeveloper.db.migration");
    }

    private void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.getLogger().fine("Failed to close file: " + iOException.getMessage());
            }
        }
    }

    public final Map<String, Referenceable> getMigratedConnections() {
        HashMap<String, Referenceable> hashMap = new HashMap<String, Referenceable>();
        try {
            List<Properties> list = this.read();
            if (list != null) {
                for (Properties properties : list) {
                    String string;
                    if (properties == null || !ModelUtil.hasLength((String)(string = properties.getProperty(CONNECTION_NAME)))) continue;
                    try {
                        Referenceable referenceable = CMHelper.createReferenceFromDescriptor((Properties)properties);
                        if (referenceable == null) continue;
                        hashMap.put(string, referenceable);
                    }
                    catch (Exception exception) {
                        this.getLogger().log(Level.WARNING, "Couldn't migrate connection " + string, exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().log(Level.WARNING, "Couldn't migrate connections.", exception);
        }
        return hashMap;
    }

    public final List<Properties> read() {
        return this.read(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Properties> read(boolean bl) {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        this.m_list = null;
        InputStream inputStream = null;
        try {
            InputStream inputStream2 = inputStream = this.m_isAbsolutePath ? new FileInputStream(this.m_fName) : CMConnectionsReader.getInputStream(this.getClass(), this.m_fName);
            if (inputStream != null) {
                object2 = null;
                try {
                    object2 = new SAXParser();
                    object2.setContentHandler((ContentHandler)this);
                    object2.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                    object2.parse(inputStream);
                }
                catch (SAXException sAXException) {
                }
                finally {
                    if (object2 != null) {
                        object2.reset();
                        object2 = null;
                    }
                }
            }
            this.close(inputStream);
        }
        catch (IOException iOException) {
            try {
                this.getLogger().fine("Failed to read " + this.m_fName + " : " + iOException.getMessage());
                this.close(inputStream);
            }
            catch (Throwable throwable) {
                this.close(inputStream);
                throw throwable;
            }
        }
        if (this.m_list == null || this.m_list.size() == 0) {
            this.m_list = this.readPCS();
        } else {
            object2 = this.readPCS();
            Iterator<Object> iterator2 = iterator = object2 != null ? object2.iterator() : Collections.EMPTY_LIST.iterator();
            while (iterator.hasNext()) {
                object = (Properties)iterator.next();
                if (this.listContains(((Properties)object).getProperty(CONNECTION_NAME))) continue;
                this.m_list.add((Properties)object);
            }
        }
        if (bl && this.m_list != null) {
            object2 = Arrays.asList("JDBC", "OTHER_JDBC", "JDBC_ODBC", "ORACLE_LITE");
            iterator = this.m_list.iterator();
            while (iterator.hasNext()) {
                object = ((Properties)iterator.next()).getProperty(CONNECTION_TYPE);
                if (object2.contains(object)) continue;
                iterator.remove();
            }
        }
        return this.m_list;
    }

    private static InputStream getInputStream(Class clazz, String string) {
        InputStream inputStream;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : null;
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(string);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Properties> readPCS() {
        Object object;
        List<Properties> list = null;
        InputStream inputStream = null;
        try {
            InputStream inputStream2 = inputStream = this.m_isAbsolutePath ? new FileInputStream(this.m_fName) : CMConnectionsReader.getInputStream(this.getClass(), this.m_fName);
            if (inputStream != null) {
                object = new Properties();
                ((Properties)object).load(inputStream);
                list = this.loadConnectionDescriptorsFromProperties((Properties)object);
            }
            this.close(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.close(inputStream);
        }
        catch (IOException iOException) {
            try {
                this.getLogger().fine("Failed to read " + this.m_fName + " : " + iOException.getMessage());
                this.close(inputStream);
            }
            catch (Throwable throwable) {
                this.close(inputStream);
                throw throwable;
            }
        }
        if (!(list != null && list.size() != 0 || this.m_isAbsolutePath)) {
            object = null;
            try {
                object = CMConnectionsReader.getInputStream(this.getClass(), "/connections.properties");
                if (object != null) {
                    Properties properties = new Properties();
                    properties.load((InputStream)object);
                    list = this.loadConnectionDescriptorsFromProperties(properties);
                }
            }
            catch (IOException iOException) {
                list = null;
                this.getLogger().fine("Failed to read connections.properties : " + iOException.getMessage());
            }
            finally {
                this.close((InputStream)object);
            }
        }
        return list;
    }

    private final List<Properties> loadConnectionDescriptorsFromProperties(Properties properties) throws IOException {
        ArrayList<Properties> arrayList = null;
        String string = properties.getProperty("CM_NumConnections");
        if (null != string) {
            int n = Integer.parseInt(string);
            arrayList = new ArrayList<Properties>(n);
            for (int i = 1; i <= n; ++i) {
                String string2 = properties.getProperty("CM_Connection" + i);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.replace(',', '\n').getBytes());
                Properties properties2 = new Properties();
                properties2.load(byteArrayInputStream);
                arrayList.add(properties2);
            }
        }
        return arrayList;
    }

    private final boolean listContains(String string) {
        for (Properties properties : this.m_list) {
            if (!properties.getProperty(CONNECTION_NAME).equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startDocument() {
        if (this.m_list == null) {
            this.m_list = new ArrayList<Properties>(10);
        } else {
            this.m_list.clear();
        }
    }

    @Override
    public void endDocument() {
        this.m_curKey = null;
        this.m_curValue = null;
        this.m_curDesc = null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals(CONNECTION_TAG)) {
            this.m_curDesc = new Properties();
            this.m_curKey = null;
            this.m_curValue = null;
            this.m_cdata = null;
        } else if (this.m_curDesc != null) {
            this.m_curKey = string2;
            this.m_curValue = new StringBuffer();
            this.m_cdata = null;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string2.equals(CONNECTION_TAG)) {
            if (this.m_curDesc != null && this.m_curDesc.getProperty(CONNECTION_NAME) != null) {
                this.m_list.add(this.m_curDesc);
            }
            this.m_curDesc = null;
        } else if (this.m_curDesc != null && this.m_curKey != null) {
            String string4 = this.m_curValue.toString();
            if (CONNECTION_TYPE.equals(this.m_curKey) && "IAS".equals(this.m_curValue.toString())) {
                string4 = "OC4J";
            } else if ("IAS_HOME".equals(this.m_curKey)) {
                this.m_curKey = "OC4J_HOME";
            } else if ("PASSWORD".equals(this.m_curKey)) {
                if (this.m_curDesc.getProperty(PASSWORD) != null) {
                    this.m_curKey = null;
                }
            } else if (PWD_PROP.equals(this.m_curKey) || ORMI_PWD_PROP.equals(this.m_curKey)) {
                string4 = null;
                String string5 = this.m_curKey = PWD_PROP.equals(this.m_curKey) ? PASSWORD : ORMI_PASSWD;
                if (this.m_cdata != null) {
                    try {
                        string4 = DatabaseProviderHelper.comingIn((String)this.m_cdata);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.m_curKey != null) {
                this.m_curDesc.put(this.m_curKey, string4);
            }
        }
        this.m_curKey = null;
        this.m_curValue = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.m_curKey != null) {
            this.m_curValue.append(cArray, n, n2);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_cdata = this.m_curValue.toString();
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_curValue.setLength(0);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }
}

